#define ICONV_INTERNAL
#include <iconv.h>

static const iconv_ccs_convtable_7bit to_ucs_21 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x4E42, 0x4E5C, 0x51F5, 0x531A, 0x5382, 0x4E07, 0x4E0C,
	0x4E47, 0x4E8D, 0x56D7, 0x5C6E, 0x5F73, 0x4E0F, 0x5187, 0x4E0E,
	0x4E2E, 0x4E93, 0x4EC2, 0x4EC9, 0x4EC8, 0x5198, 0x52FC, 0x536C,
	0x53B9, 0x5720, 0x5903, 0x592C, 0x5C10, 0x5DFF, 0x65E1, 0x6BB3,
	0x6BCC, 0x6C14, 0x723F, 0x4E31, 0x4E3C, 0x4EE8, 0x4EDC, 0x4EE9,
	0x4EE1, 0x4EDD, 0x4EDA, 0x520C, 0x5209, 0x531C, 0x534C, 0x5722,
	0x5723, 0x5917, 0x592F, 0x5B81, 0x5B84, 0x5C12, 0x5C3B, 0x5C74,
	0x5C73, 0x5E04, 0x5E80, 0x5E82, 0x5FC9, 0x6209, 0x6250, 0x6C15,
	0x6C36, 0x6C43, 0x6C3F, 0x6C3B, 0x72AE, 0x72B0, 0x738A, 0x79B8,
	0x808A, 0x961E, 0x4F0E, 0x4F18, 0x4F2C, 0x4EF5, 0x4F14, 0x4EF1,
	0x4F00, 0x4EF7, 0x4F08, 0x4F1D, 0x4F02, 0x4F05, 0x4F22, 0x4F13,
	0x4F04, 0x4EF4, 0x4F12, 0x51B1, 0x5213, 0x5210, 0x52A6, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_22 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5322, 0x531F, 0x534D, 0x538A, 0x5407, 0x56E1, 0x56DF,
	0x572E, 0x572A, 0x5734, 0x593C, 0x5980, 0x597C, 0x5985, 0x597B,
	0x597E, 0x5977, 0x597F, 0x5B56, 0x5C15, 0x5C25, 0x5C7C, 0x5C7A,
	0x5C7B, 0x5C7E, 0x5DDF, 0x5E75, 0x5E84, 0x5F02, 0x5F1A, 0x5F74,
	0x5FD5, 0x5FD4, 0x5FCF, 0x625C, 0x625E, 0x6264, 0x6261, 0x6266,
	0x6262, 0x6259, 0x6260, 0x625A, 0x6265, 0x6537, 0x65EF, 0x65EE,
	0x673E, 0x6739, 0x6738, 0x673B, 0x673A, 0x673F, 0x673C, 0x6733,
	0x6C18, 0x6C46, 0x6C52, 0x6C5C, 0x6C4F, 0x6C4A, 0x6C54, 0x6C4B,
	0x6C4C, 0x7071, 0x725E, 0x72B4, 0x72B5, 0x738E, 0x752A, 0x767F,
	0x7A75, 0x7F51, 0x8278, 0x827C, 0x8280, 0x827D, 0x827F, 0x864D,
	0x897E, 0x9099, 0x9097, 0x9098, 0x909B, 0x9094, 0x9622, 0x9624,
	0x9620, 0x9623, 0x4F56, 0x4F3B, 0x4F62, 0x4F49, 0x4F53, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_23 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x4F64, 0x4F3E, 0x4F67, 0x4F52, 0x4F5F, 0x4F41, 0x4F58,
	0x4F2D, 0x4F33, 0x4F3F, 0x4F61, 0x518F, 0x51B9, 0x521C, 0x521E,
	0x5221, 0x52AD, 0x52AE, 0x5309, 0x5363, 0x5372, 0x538E, 0x538F,
	0x5430, 0x5437, 0x542A, 0x5454, 0x5445, 0x5419, 0x541C, 0x5425,
	0x5418, 0x543D, 0x544F, 0x5441, 0x5428, 0x5424, 0x5447, 0x56EE,
	0x56E7, 0x56E5, 0x5741, 0x5745, 0x574C, 0x5749, 0x574B, 0x5752,
	0x5906, 0x5940, 0x59A6, 0x5998, 0x59A0, 0x5997, 0x598E, 0x59A2,
	0x5990, 0x598F, 0x59A7, 0x59A1, 0x5B8E, 0x5B92, 0x5C28, 0x5C2A,
	0x5C8D, 0x5C8F, 0x5C88, 0x5C8B, 0x5C89, 0x5C92, 0x5C8A, 0x5C86,
	0x5C93, 0x5C95, 0x5DE0, 0x5E0A, 0x5E0E, 0x5E8B, 0x5E89, 0x5E8C,
	0x5E88, 0x5E8D, 0x5F05, 0x5F1D, 0x5F78, 0x5F76, 0x5FD2, 0x5FD1,
	0x5FD0, 0x5FED, 0x5FE8, 0x5FEE, 0x5FF3, 0x5FE1, 0x5FE4, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_24 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5FE3, 0x5FFA, 0x5FEF, 0x5FF7, 0x5FFB, 0x6000, 0x5FF4,
	0x623A, 0x6283, 0x628C, 0x628E, 0x628F, 0x6294, 0x6287, 0x6271,
	0x627B, 0x627A, 0x6270, 0x6281, 0x6288, 0x6277, 0x627D, 0x6272,
	0x6274, 0x65F0, 0x65F4, 0x65F3, 0x65F2, 0x65F5, 0x6745, 0x6747,
	0x6759, 0x6755, 0x674C, 0x6748, 0x675D, 0x674D, 0x675A, 0x674B,
	0x6BD0, 0x6C19, 0x6C1A, 0x6C78, 0x6C67, 0x6C6B, 0x6C84, 0x6C8B,
	0x6C8F, 0x6C71, 0x6C6F, 0x6C69, 0x6C9A, 0x6C6D, 0x6C87, 0x6C95,
	0x6C9C, 0x6C66, 0x6C73, 0x6C65, 0x6C7B, 0x6C8E, 0x7074, 0x707A,
	0x7263, 0x72BF, 0x72BD, 0x72C3, 0x72C6, 0x72C1, 0x72BA, 0x72C5,
	0x7395, 0x7397, 0x7393, 0x7394, 0x7392, 0x753A, 0x7539, 0x7594,
	0x7595, 0x7681, 0x793D, 0x8034, 0x8095, 0x8099, 0x8090, 0x8092,
	0x809C, 0x8290, 0x828F, 0x8285, 0x828E, 0x8291, 0x8293, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_25 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x828A, 0x8283, 0x8284, 0x8C78, 0x8FC9, 0x8FBF, 0x909F,
	0x90A1, 0x90A5, 0x909E, 0x90A7, 0x90A0, 0x9630, 0x9628, 0x962F,
	0x962D, 0x4E33, 0x4F98, 0x4F7C, 0x4F85, 0x4F7D, 0x4F80, 0x4F87,
	0x4F76, 0x4F74, 0x4F89, 0x4F84, 0x4F77, 0x4F4C, 0x4F97, 0x4F6A,
	0x4F9A, 0x4F79, 0x4F81, 0x4F78, 0x4F90, 0x4F9C, 0x4F94, 0x4F9E,
	0x4F92, 0x4F82, 0x4F95, 0x4F6B, 0x4F6E, 0x519E, 0x51BC, 0x51BE,
	0x5235, 0x5232, 0x5233, 0x5246, 0x5231, 0x52BC, 0x530A, 0x530B,
	0x533C, 0x5392, 0x5394, 0x5487, 0x547F, 0x5481, 0x5491, 0x5482,
	0x5488, 0x546B, 0x547A, 0x547E, 0x5465, 0x546C, 0x5474, 0x5466,
	0x548D, 0x546F, 0x5461, 0x5460, 0x5498, 0x5463, 0x5467, 0x5464,
	0x56F7, 0x56F9, 0x576F, 0x5772, 0x576D, 0x576B, 0x5771, 0x5770,
	0x5776, 0x5780, 0x5775, 0x577B, 0x5773, 0x5774, 0x5762, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_26 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5768, 0x577D, 0x590C, 0x5945, 0x59B5, 0x59BA, 0x59CF,
	0x59CE, 0x59B2, 0x59CC, 0x59C1, 0x59B6, 0x59BC, 0x59C3, 0x59D6,
	0x59B1, 0x59BD, 0x59C0, 0x59C8, 0x59B4, 0x59C7, 0x5B62, 0x5B65,
	0x5B93, 0x5B95, 0x5C44, 0x5C47, 0x5CAE, 0x5CA4, 0x5CA0, 0x5CB5,
	0x5CAF, 0x5CA8, 0x5CAC, 0x5C9F, 0x5CA3, 0x5CAD, 0x5CA2, 0x5CAA,
	0x5CA7, 0x5C9D, 0x5CA5, 0x5CB6, 0x5CB0, 0x5CA6, 0x5E17, 0x5E14,
	0x5E19, 0x5F28, 0x5F22, 0x5F23, 0x5F24, 0x5F54, 0x5F82, 0x5F7E,
	0x5F7D, 0x5FDE, 0x5FE5, 0x602D, 0x6026, 0x6019, 0x6032, 0x600B,
	0x6034, 0x600A, 0x6017, 0x6033, 0x601A, 0x601E, 0x602C, 0x6022,
	0x600D, 0x6010, 0x602E, 0x6013, 0x6011, 0x600C, 0x6009, 0x601C,
	0x6214, 0x623D, 0x62AD, 0x62B4, 0x62D1, 0x62BE, 0x62AA, 0x62B6,
	0x62CA, 0x62AE, 0x62B3, 0x62AF, 0x62BB, 0x62A9, 0x62B0, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_27 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x62B8, 0x653D, 0x65A8, 0x65BB, 0x6609, 0x65FC, 0x6604,
	0x6612, 0x6608, 0x65FB, 0x6603, 0x660B, 0x660D, 0x6605, 0x65FD,
	0x6611, 0x6610, 0x66F6, 0x670A, 0x6785, 0x676C, 0x678E, 0x6792,
	0x6776, 0x677B, 0x6798, 0x6786, 0x6784, 0x6774, 0x678D, 0x678C,
	0x677A, 0x679F, 0x6791, 0x6799, 0x6783, 0x677D, 0x6781, 0x6778,
	0x6779, 0x6794, 0x6B25, 0x6B80, 0x6B7E, 0x6BDE, 0x6C1D, 0x6C93,
	0x6CEC, 0x6CEB, 0x6CEE, 0x6CD9, 0x6CB6, 0x6CD4, 0x6CAD, 0x6CE7,
	0x6CB7, 0x6CD0, 0x6CC2, 0x6CBA, 0x6CC3, 0x6CC6, 0x6CED, 0x6CF2,
	0x6CD2, 0x6CDD, 0x6CB4, 0x6C8A, 0x6C9D, 0x6C80, 0x6CDE, 0x6CC0,
	0x6D30, 0x6CCD, 0x6CC7, 0x6CB0, 0x6CF9, 0x6CCF, 0x6CE9, 0x6CD1,
	0x7094, 0x7098, 0x7085, 0x7093, 0x7086, 0x7084, 0x7091, 0x7096,
	0x7082, 0x709A, 0x7083, 0x726A, 0x72D6, 0x72CB, 0x72D8, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_28 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x72C9, 0x72DC, 0x72D2, 0x72D4, 0x72DA, 0x72CC, 0x72D1,
	0x73A4, 0x73A1, 0x73AD, 0x73A6, 0x73A2, 0x73A0, 0x73AC, 0x739D,
	0x74DD, 0x74E8, 0x753F, 0x7540, 0x753E, 0x758C, 0x7598, 0x76AF,
	0x76F3, 0x76F1, 0x76F0, 0x76F5, 0x77F8, 0x77FC, 0x77F9, 0x77FB,
	0x77FA, 0x77F7, 0x7942, 0x793F, 0x79C5, 0x7A78, 0x7A7B, 0x7AFB,
	0x7C75, 0x7CFD, 0x8035, 0x808F, 0x80AE, 0x80A3, 0x80B8, 0x80B5,
	0x80AD, 0x8220, 0x82A0, 0x82C0, 0x82AB, 0x829A, 0x8298, 0x829B,
	0x82B5, 0x82A7, 0x82AE, 0x82BC, 0x829E, 0x82BA, 0x82B4, 0x82A8,
	0x82A1, 0x82A9, 0x82C2, 0x82A4, 0x82C3, 0x82B6, 0x82A2, 0x8670,
	0x866F, 0x866D, 0x866E, 0x8C56, 0x8FD2, 0x8FCB, 0x8FD3, 0x8FCD,
	0x8FD6, 0x8FD5, 0x8FD7, 0x90B2, 0x90B4, 0x90AF, 0x90B3, 0x90B0,
	0x9639, 0x963D, 0x963C, 0x963A, 0x9643, 0x4FCD, 0x4FC5, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_29 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x4FD3, 0x4FB2, 0x4FC9, 0x4FCB, 0x4FC1, 0x4FD4, 0x4FDC,
	0x4FD9, 0x4FBB, 0x4FB3, 0x4FDB, 0x4FC7, 0x4FD6, 0x4FBA, 0x4FC0,
	0x4FB9, 0x4FEC, 0x5244, 0x5249, 0x52C0, 0x52C2, 0x533D, 0x537C,
	0x5397, 0x5396, 0x5399, 0x5398, 0x54BA, 0x54A1, 0x54AD, 0x54A5,
	0x54CF, 0x54C3, 0x830D, 0x54B7, 0x54AE, 0x54D6, 0x54B6, 0x54C5,
	0x54C6, 0x54A0, 0x5470, 0x54BC, 0x54A2, 0x54BE, 0x5472, 0x54DE,
	0x54B0, 0x57B5, 0x579E, 0x579F, 0x57A4, 0x578C, 0x5797, 0x579D,
	0x579B, 0x5794, 0x5798, 0x578F, 0x5799, 0x57A5, 0x579A, 0x5795,
	0x58F4, 0x590D, 0x5953, 0x59E1, 0x59DE, 0x59EE, 0x5A00, 0x59F1,
	0x59DD, 0x59FA, 0x59FD, 0x59FC, 0x59F6, 0x59E4, 0x59F2, 0x59F7,
	0x59DB, 0x59E9, 0x59F3, 0x59F5, 0x59E0, 0x59FE, 0x59F4, 0x59ED,
	0x5BA8, 0x5C4C, 0x5CD0, 0x5CD8, 0x5CCC, 0x5CD7, 0x5CCB, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_2A = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5CDB, 0x5CDE, 0x5CDA, 0x5CC9, 0x5CC7, 0x5CCA, 0x5CD6,
	0x5CD3, 0x5CD4, 0x5CCF, 0x5CC8, 0x5CC6, 0x5CCE, 0x5CDF, 0x5CF8,
	0x5DF9, 0x5E21, 0x5E22, 0x5E23, 0x5E20, 0x5E24, 0x5EB0, 0x5EA4,
	0x5EA2, 0x5E9B, 0x5EA3, 0x5EA5, 0x5F07, 0x5F2E, 0x5F56, 0x5F86,
	0x6037, 0x6039, 0x6054, 0x6072, 0x605E, 0x6045, 0x6053, 0x6047,
	0x6049, 0x605B, 0x604C, 0x6040, 0x6042, 0x605F, 0x6024, 0x6044,
	0x6058, 0x6066, 0x606E, 0x6242, 0x6243, 0x62CF, 0x630D, 0x630B,
	0x62F5, 0x630E, 0x6303, 0x62EB, 0x62F9, 0x630F, 0x630C, 0x62F8,
	0x62F6, 0x6300, 0x6313, 0x6314, 0x62FA, 0x6315, 0x62FB, 0x62F0,
	0x6541, 0x6543, 0x65AA, 0x65BF, 0x6636, 0x6621, 0x6632, 0x6635,
	0x661C, 0x6626, 0x6622, 0x6633, 0x662B, 0x663A, 0x661D, 0x6634,
	0x6639, 0x662E, 0x670F, 0x6710, 0x67C1, 0x67F2, 0x67C8, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_2B = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x67BA, 0x67DC, 0x67BB, 0x67F8, 0x67D8, 0x67C0, 0x67B7,
	0x67C5, 0x67EB, 0x67E4, 0x67DF, 0x67B5, 0x67CD, 0x67B3, 0x67F7,
	0x67F6, 0x67EE, 0x67E3, 0x67C2, 0x67B9, 0x67CE, 0x67E7, 0x67F0,
	0x67B2, 0x67FC, 0x67C6, 0x67ED, 0x67CC, 0x67AE, 0x67E6, 0x67DB,
	0x67FA, 0x67C9, 0x67CA, 0x67C3, 0x67EA, 0x67CB, 0x6B28, 0x6B82,
	0x6B84, 0x6BB6, 0x6BD6, 0x6BD8, 0x6BE0, 0x6C20, 0x6C21, 0x6D28,
	0x6D34, 0x6D2D, 0x6D1F, 0x6D3C, 0x6D3F, 0x6D12, 0x6D0A, 0x6CDA,
	0x6D33, 0x6D04, 0x6D19, 0x6D3A, 0x6D1A, 0x6D11, 0x6D00, 0x6D1D,
	0x6D42, 0x6D01, 0x6D18, 0x6D37, 0x6D03, 0x6D0F, 0x6D40, 0x6D07,
	0x6D20, 0x6D2C, 0x6D08, 0x6D22, 0x6D09, 0x6D10, 0x70B7, 0x709F,
	0x70BE, 0x70B1, 0x70B0, 0x70A1, 0x70B4, 0x70B5, 0x70A9, 0x7241,
	0x7249, 0x724A, 0x726C, 0x7270, 0x7273, 0x726E, 0x72CA, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_2C = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x72E4, 0x72E8, 0x72EB, 0x72DF, 0x72EA, 0x72E6, 0x72E3,
	0x7385, 0x73CC, 0x73C2, 0x73C8, 0x73C5, 0x73B9, 0x73B6, 0x73B5,
	0x73B4, 0x73EB, 0x73BF, 0x73C7, 0x73BE, 0x73C3, 0x73C6, 0x73B8,
	0x73CB, 0x74EC, 0x74EE, 0x752E, 0x7547, 0x7548, 0x75A7, 0x75AA,
	0x7679, 0x76C4, 0x7708, 0x7703, 0x7704, 0x7705, 0x770A, 0x76F7,
	0x76FB, 0x76FA, 0x77E7, 0x77E8, 0x7806, 0x7811, 0x7812, 0x7805,
	0x7810, 0x780F, 0x780E, 0x7809, 0x7803, 0x7813, 0x794A, 0x794C,
	0x794B, 0x7945, 0x7944, 0x79D5, 0x79CD, 0x79CF, 0x79D6, 0x79CE,
	0x7A80, 0x7A7E, 0x7AD1, 0x7B00, 0x7B01, 0x7C7A, 0x7C78, 0x7C79,
	0x7C7F, 0x7C80, 0x7C81, 0x7D03, 0x7D08, 0x7D01, 0x7F58, 0x7F91,
	0x7F8D, 0x7FBE, 0x8007, 0x800E, 0x800F, 0x8014, 0x8037, 0x80D8,
	0x80C7, 0x80E0, 0x80D1, 0x80C8, 0x80C2, 0x80D0, 0x80C5, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_2D = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x80E3, 0x80D9, 0x80DC, 0x80CA, 0x80D5, 0x80C9, 0x80CF,
	0x80D7, 0x80E6, 0x80CD, 0x81FF, 0x8221, 0x8294, 0x82D9, 0x82FE,
	0x82F9, 0x8307, 0x82E8, 0x8300, 0x82D5, 0x833A, 0x82EB, 0x82D6,
	0x82F4, 0x82EC, 0x82E1, 0x82F2, 0x82F5, 0x830C, 0x82FB, 0x82F6,
	0x82F0, 0x82EA, 0x82E4, 0x82E0, 0x82FA, 0x82F3, 0x82ED, 0x8677,
	0x8674, 0x867C, 0x8673, 0x8841, 0x884E, 0x8867, 0x886A, 0x8869,
	0x89D3, 0x8A04, 0x8A07, 0x8D72, 0x8FE3, 0x8FE1, 0x8FEE, 0x8FE0,
	0x90F1, 0x90BD, 0x90BF, 0x90D5, 0x90C5, 0x90BE, 0x90C7, 0x90CB,
	0x90C8, 0x91D4, 0x91D3, 0x9654, 0x964F, 0x9651, 0x9653, 0x964A,
	0x964E, 0x501E, 0x5005, 0x5007, 0x5013, 0x5022, 0x5030, 0x501B,
	0x4FF5, 0x4FF4, 0x5033, 0x5037, 0x502C, 0x4FF6, 0x4FF7, 0x5017,
	0x501C, 0x5020, 0x5027, 0x5035, 0x502F, 0x5031, 0x500E, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_2E = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x515A, 0x5194, 0x5193, 0x51CA, 0x51C4, 0x51C5, 0x51C8,
	0x51CE, 0x5261, 0x525A, 0x5252, 0x525E, 0x525F, 0x5255, 0x5262,
	0x52CD, 0x530E, 0x539E, 0x5526, 0x54E2, 0x5517, 0x5512, 0x54E7,
	0x54F3, 0x54E4, 0x551A, 0x54FF, 0x5504, 0x5508, 0x54EB, 0x5511,
	0x5505, 0x54F1, 0x550A, 0x54FB, 0x54F7, 0x54F8, 0x54E0, 0x550E,
	0x5503, 0x550B, 0x5701, 0x5702, 0x57CC, 0x5832, 0x57D5, 0x57D2,
	0x57BA, 0x57C6, 0x57BD, 0x57BC, 0x57B8, 0x57B6, 0x57BF, 0x57C7,
	0x57D0, 0x57B9, 0x57C1, 0x590E, 0x594A, 0x5A19, 0x5A16, 0x5A2D,
	0x5A2E, 0x5A15, 0x5A0F, 0x5A17, 0x5A0A, 0x5A1E, 0x5A33, 0x5B6C,
	0x5BA7, 0x5BAD, 0x5BAC, 0x5C03, 0x5C56, 0x5C54, 0x5CEC, 0x5CFF,
	0x5CEE, 0x5CF1, 0x5CF7, 0x5D00, 0x5CF9, 0x5E29, 0x5E28, 0x5EA8,
	0x5EAE, 0x5EAA, 0x5EAC, 0x5F33, 0x5F30, 0x5F67, 0x605D, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_2F = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x605A, 0x6067, 0x6041, 0x60A2, 0x6088, 0x6080, 0x6092,
	0x6081, 0x609D, 0x6083, 0x6095, 0x609B, 0x6097, 0x6087, 0x609C,
	0x608E, 0x6219, 0x6246, 0x62F2, 0x6310, 0x6356, 0x632C, 0x6344,
	0x6345, 0x6336, 0x6343, 0x63E4, 0x6339, 0x634B, 0x634A, 0x633C,
	0x6329, 0x6341, 0x6334, 0x6358, 0x6354, 0x6359, 0x632D, 0x6347,
	0x6333, 0x635A, 0x6351, 0x6338, 0x6357, 0x6340, 0x6348, 0x654A,
	0x6546, 0x65C6, 0x65C3, 0x65C4, 0x65C2, 0x664A, 0x665F, 0x6647,
	0x6651, 0x6712, 0x6713, 0x681F, 0x681A, 0x6849, 0x6832, 0x6833,
	0x683B, 0x684B, 0x684F, 0x6816, 0x6831, 0x681C, 0x6835, 0x682B,
	0x682D, 0x682F, 0x684E, 0x6844, 0x6834, 0x681D, 0x6812, 0x6814,
	0x6826, 0x6828, 0x682E, 0x684D, 0x683A, 0x6825, 0x6820, 0x6B2C,
	0x6B2F, 0x6B2D, 0x6B31, 0x6B34, 0x6B6D, 0x8082, 0x6B88, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_30 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x6BE6, 0x6BE4, 0x6BE8, 0x6BE3, 0x6BE2, 0x6BE7, 0x6C25,
	0x6D7A, 0x6D63, 0x6D64, 0x6D76, 0x6D0D, 0x6D61, 0x6D92, 0x6D58,
	0x6D62, 0x6D6D, 0x6D6F, 0x6D91, 0x6D8D, 0x6DEF, 0x6D7F, 0x6D86,
	0x6D5E, 0x6D67, 0x6D60, 0x6D97, 0x6D70, 0x6D7C, 0x6D5F, 0x6D82,
	0x6D98, 0x6D2F, 0x6D68, 0x6D8B, 0x6D7E, 0x6D80, 0x6D84, 0x6D16,
	0x6D83, 0x6D7B, 0x6D7D, 0x6D75, 0x6D90, 0x70DC, 0x70D3, 0x70D1,
	0x70DD, 0x70CB, 0x7F39, 0x70E2, 0x70D7, 0x70D2, 0x70DE, 0x70E0,
	0x70D4, 0x70CD, 0x70C5, 0x70C6, 0x70C7, 0x70DA, 0x70CE, 0x70E1,
	0x7242, 0x7278, 0x7277, 0x7276, 0x7300, 0x72FA, 0x72F4, 0x72FE,
	0x72F6, 0x72F3, 0x72FB, 0x7301, 0x73D3, 0x73D9, 0x73E5, 0x73D6,
	0x73BC, 0x73E7, 0x73E3, 0x73E9, 0x73DC, 0x73D2, 0x73DB, 0x73D4,
	0x73DD, 0x73DA, 0x73D7, 0x73D8, 0x73E8, 0x74DE, 0x74DF, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_31 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x74F4, 0x74F5, 0x7521, 0x755B, 0x755F, 0x75B0, 0x75C1,
	0x75BB, 0x75C4, 0x75C0, 0x75BF, 0x75B6, 0x75BA, 0x768A, 0x76C9,
	0x771D, 0x771B, 0x7710, 0x7713, 0x7712, 0x7723, 0x7711, 0x7715,
	0x7719, 0x771A, 0x7722, 0x7727, 0x7823, 0x782C, 0x7822, 0x7835,
	0x782F, 0x7828, 0x782E, 0x782B, 0x7821, 0x7829, 0x7833, 0x782A,
	0x7831, 0x7954, 0x795B, 0x794F, 0x795C, 0x7953, 0x7952, 0x7951,
	0x79EB, 0x79EC, 0x79E0, 0x79EE, 0x79ED, 0x79EA, 0x79DC, 0x79DE,
	0x79DD, 0x7A86, 0x7A89, 0x7A85, 0x7A8B, 0x7A8C, 0x7A8A, 0x7A87,
	0x7AD8, 0x7B10, 0x7B04, 0x7B13, 0x7B05, 0x7B0F, 0x7B08, 0x7B0A,
	0x7B0E, 0x7B09, 0x7B12, 0x7C84, 0x7C91, 0x7C8A, 0x7C8C, 0x7C88,
	0x7C8D, 0x7C85, 0x7D1E, 0x7D1D, 0x7D11, 0x7D0E, 0x7D18, 0x7D16,
	0x7D13, 0x7D1F, 0x7D12, 0x7D0F, 0x7D0C, 0x7F5C, 0x7F61, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_32 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x7F5E, 0x7F60, 0x7F5D, 0x7F5B, 0x7F96, 0x7F92, 0x7FC3,
	0x7FC2, 0x7FC0, 0x8016, 0x803E, 0x8039, 0x80FA, 0x80F2, 0x80F9,
	0x80F5, 0x8101, 0x80FB, 0x8100, 0x8201, 0x822F, 0x8225, 0x8333,
	0x832D, 0x8344, 0x8319, 0x8351, 0x8325, 0x8356, 0x833F, 0x8341,
	0x8326, 0x831C, 0x8322, 0x8342, 0x834E, 0x831B, 0x832A, 0x8308,
	0x833C, 0x834D, 0x8316, 0x8324, 0x8320, 0x8337, 0x832F, 0x8329,
	0x8347, 0x8345, 0x834C, 0x8353, 0x831E, 0x832C, 0x834B, 0x8327,
	0x8348, 0x8653, 0x8652, 0x86A2, 0x86A8, 0x8696, 0x868D, 0x8691,
	0x869E, 0x8687, 0x8697, 0x8686, 0x868B, 0x869A, 0x8685, 0x86A5,
	0x8699, 0x86A1, 0x86A7, 0x8695, 0x8698, 0x868E, 0x869D, 0x8690,
	0x8694, 0x8843, 0x8844, 0x886D, 0x8875, 0x8876, 0x8872, 0x8880,
	0x8871, 0x887F, 0x886F, 0x8883, 0x887E, 0x8874, 0x887C, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_33 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x8A12, 0x8C47, 0x8C57, 0x8C7B, 0x8CA4, 0x8CA3, 0x8D76,
	0x8D78, 0x8DB5, 0x8DB7, 0x8DB6, 0x8ED1, 0x8ED3, 0x8FFE, 0x8FF5,
	0x9002, 0x8FFF, 0x8FFB, 0x9004, 0x8FFC, 0x8FF6, 0x90D6, 0x90E0,
	0x90D9, 0x90DA, 0x90E3, 0x90DF, 0x90E5, 0x90D8, 0x90DB, 0x90D7,
	0x90DC, 0x90E4, 0x9150, 0x914E, 0x914F, 0x91D5, 0x91E2, 0x91DA,
	0x965C, 0x965F, 0x96BC, 0x98E3, 0x9ADF, 0x9B2F, 0x4E7F, 0x5070,
	0x506A, 0x5061, 0x505E, 0x5060, 0x5053, 0x504B, 0x505D, 0x5072,
	0x5048, 0x504D, 0x5041, 0x505B, 0x504A, 0x5062, 0x5015, 0x5045,
	0x505F, 0x5069, 0x506B, 0x5063, 0x5064, 0x5046, 0x5040, 0x506E,
	0x5073, 0x5057, 0x5051, 0x51D0, 0x526B, 0x526D, 0x526C, 0x526E,
	0x52D6, 0x52D3, 0x532D, 0x539C, 0x5575, 0x5576, 0x553C, 0x554D,
	0x5550, 0x5534, 0x552A, 0x5551, 0x5562, 0x5536, 0x5535, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_34 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5530, 0x5552, 0x5545, 0x550C, 0x5532, 0x5565, 0x554E,
	0x5539, 0x5548, 0x552D, 0x553B, 0x5540, 0x554B, 0x570A, 0x5707,
	0x57FB, 0x5814, 0x57E2, 0x57F6, 0x57DC, 0x57F4, 0x5800, 0x57ED,
	0x57FD, 0x5808, 0x57F8, 0x580B, 0x57F3, 0x57CF, 0x5807, 0x57EE,
	0x57E3, 0x57F2, 0x57E5, 0x57EC, 0x57E1, 0x580E, 0x57FC, 0x5810,
	0x57E7, 0x5801, 0x580C, 0x57F1, 0x57E9, 0x57F0, 0x580D, 0x5804,
	0x595C, 0x5A60, 0x5A58, 0x5A55, 0x5A67, 0x5A5E, 0x5A38, 0x5A35,
	0x5A6D, 0x5A50, 0x5A5F, 0x5A65, 0x5A6C, 0x5A53, 0x5A64, 0x5A57,
	0x5A43, 0x5A5D, 0x5A52, 0x5A44, 0x5A5B, 0x5A48, 0x5A8E, 0x5A3E,
	0x5A4D, 0x5A39, 0x5A4C, 0x5A70, 0x5A69, 0x5A47, 0x5A51, 0x5A56,
	0x5A42, 0x5A5C, 0x5B72, 0x5B6E, 0x5BC1, 0x5BC0, 0x5C59, 0x5D1E,
	0x5D0B, 0x5D1D, 0x5D1A, 0x5D20, 0x5D0C, 0x5D28, 0x5D0D, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_35 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5D26, 0x5D25, 0x5D0F, 0x5D30, 0x5D12, 0x5D23, 0x5D1F,
	0x5D2E, 0x5E3E, 0x5E34, 0x5EB1, 0x5EB4, 0x5EB9, 0x5EB2, 0x5EB3,
	0x5F36, 0x5F38, 0x5F9B, 0x5F96, 0x5F9F, 0x608A, 0x6090, 0x6086,
	0x60BE, 0x60B0, 0x60BA, 0x60D3, 0x60D4, 0x60CF, 0x60E4, 0x60D9,
	0x60DD, 0x60C8, 0x60B1, 0x60DB, 0x60B7, 0x60CA, 0x60BF, 0x60C3,
	0x60CD, 0x60C0, 0x6332, 0x6365, 0x638A, 0x6382, 0x637D, 0x63BD,
	0x639E, 0x63AD, 0x639D, 0x6397, 0x63AB, 0x638E, 0x636F, 0x6387,
	0x6390, 0x636E, 0x63AF, 0x6375, 0x639C, 0x636D, 0x63AE, 0x637C,
	0x63A4, 0x633B, 0x639F, 0x6378, 0x6385, 0x6381, 0x6391, 0x638D,
	0x6370, 0x6553, 0x65CD, 0x6665, 0x6661, 0x665B, 0x6659, 0x665C,
	0x6662, 0x6718, 0x6879, 0x6887, 0x6890, 0x689C, 0x686D, 0x686E,
	0x68AE, 0x68AB, 0x6956, 0x686F, 0x68A3, 0x68AC, 0x68A9, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_36 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x6875, 0x6874, 0x68B2, 0x688F, 0x6877, 0x6892, 0x687C,
	0x686B, 0x6872, 0x68AA, 0x6880, 0x6871, 0x687E, 0x689B, 0x6896,
	0x688B, 0x68A0, 0x6889, 0x68A4, 0x6878, 0x687B, 0x6891, 0x688C,
	0x688A, 0x687D, 0x6B36, 0x6B33, 0x6B37, 0x6B38, 0x6B91, 0x6B8F,
	0x6B8D, 0x6B8E, 0x6B8C, 0x6C2A, 0x6DC0, 0x6DAB, 0x6DB4, 0x6DB3,
	0x6E74, 0x6DAC, 0x6DE9, 0x6DE2, 0x6DB7, 0x6DF6, 0x6DD4, 0x6E00,
	0x6DC8, 0x6DE0, 0x6DDF, 0x6DD6, 0x6DBE, 0x6DE5, 0x6DDC, 0x6DDD,
	0x6DDB, 0x6DF4, 0x6DCA, 0x6DBD, 0x6DED, 0x6DF0, 0x6DBA, 0x6DD5,
	0x6DC2, 0x6DCF, 0x6DC9, 0x6DD0, 0x6DF2, 0x6DD3, 0x6DFD, 0x6DD7,
	0x6DCD, 0x6DE3, 0x6DBB, 0x70FA, 0x710D, 0x70F7, 0x7117, 0x70F4,
	0x710C, 0x70F0, 0x7104, 0x70F3, 0x7110, 0x70FC, 0x70FF, 0x7106,
	0x7113, 0x7100, 0x70F8, 0x70F6, 0x710B, 0x7102, 0x710E, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_37 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x727E, 0x727B, 0x727C, 0x727F, 0x731D, 0x7317, 0x7307,
	0x7311, 0x7318, 0x730A, 0x7308, 0x72FF, 0x730F, 0x731E, 0x7388,
	0x73F6, 0x73F8, 0x73F5, 0x7404, 0x7401, 0x73FD, 0x7407, 0x7400,
	0x73FA, 0x73FC, 0x73FF, 0x740C, 0x740B, 0x73F4, 0x7408, 0x7564,
	0x7563, 0x75CE, 0x75D2, 0x75CF, 0x75CB, 0x75CC, 0x75D1, 0x75D0,
	0x768F, 0x7689, 0x76D3, 0x7739, 0x772F, 0x772D, 0x7731, 0x7732,
	0x7734, 0x7733, 0x773D, 0x7725, 0x773B, 0x7735, 0x7848, 0x7852,
	0x7849, 0x784D, 0x784A, 0x784C, 0x7826, 0x7845, 0x7850, 0x7964,
	0x7967, 0x7969, 0x796A, 0x7963, 0x796B, 0x7961, 0x79BB, 0x79FA,
	0x79F8, 0x79F6, 0x79F7, 0x7A8F, 0x7A94, 0x7A90, 0x7B35, 0x7B3B,
	0x7B34, 0x7B25, 0x7B30, 0x7B22, 0x7B24, 0x7B33, 0x7B18, 0x7B2A,
	0x7B1D, 0x7B31, 0x7B2B, 0x7B2D, 0x7B2F, 0x7B32, 0x7B38, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_38 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x7B1A, 0x7B23, 0x7C94, 0x7C98, 0x7C96, 0x7CA3, 0x7D35,
	0x7D3D, 0x7D38, 0x7D36, 0x7D3A, 0x7D45, 0x7D2C, 0x7D29, 0x7D41,
	0x7D47, 0x7D3E, 0x7D3F, 0x7D4A, 0x7D3B, 0x7D28, 0x7F63, 0x7F95,
	0x7F9C, 0x7F9D, 0x7F9B, 0x7FCA, 0x7FCB, 0x7FCD, 0x7FD0, 0x7FD1,
	0x7FC7, 0x7FCF, 0x7FC9, 0x801F, 0x801E, 0x801B, 0x8047, 0x8043,
	0x8048, 0x8118, 0x8125, 0x8119, 0x811B, 0x812D, 0x811F, 0x812C,
	0x811E, 0x8121, 0x8115, 0x8127, 0x811D, 0x8122, 0x8211, 0x8238,
	0x8233, 0x823A, 0x8234, 0x8232, 0x8274, 0x8390, 0x83A3, 0x83A8,
	0x838D, 0x837A, 0x8373, 0x83A4, 0x8374, 0x838F, 0x8381, 0x8395,
	0x8399, 0x8375, 0x8394, 0x83A9, 0x837D, 0x8383, 0x838C, 0x839D,
	0x839B, 0x83AA, 0x838B, 0x837E, 0x83A5, 0x83AF, 0x8388, 0x8397,
	0x83B0, 0x837F, 0x83A6, 0x8387, 0x83AE, 0x8376, 0x8659, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_39 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x8656, 0x86BF, 0x86B7, 0x86C2, 0x86C1, 0x86C5, 0x86BA,
	0x86B0, 0x86C8, 0x86B9, 0x86B3, 0x86B8, 0x86CC, 0x86B4, 0x86BB,
	0x86BC, 0x86C3, 0x86BD, 0x86BE, 0x8852, 0x8889, 0x8895, 0x88A8,
	0x88A2, 0x88AA, 0x889A, 0x8891, 0x88A1, 0x889F, 0x8898, 0x88A7,
	0x8899, 0x889B, 0x8897, 0x88A4, 0x88AC, 0x888C, 0x8893, 0x888E,
	0x8982, 0x89D6, 0x89D9, 0x89D5, 0x8A30, 0x8A27, 0x8A2C, 0x8A1E,
	0x8C39, 0x8C3B, 0x8C5C, 0x8C5D, 0x8C7D, 0x8CA5, 0x8D7D, 0x8D7B,
	0x8D79, 0x8DBC, 0x8DC2, 0x8DB9, 0x8DBF, 0x8DC1, 0x8ED8, 0x8EDE,
	0x8EDD, 0x8EDC, 0x8ED7, 0x8EE0, 0x8EE1, 0x9024, 0x900B, 0x9011,
	0x901C, 0x900C, 0x9021, 0x90EF, 0x90EA, 0x90F0, 0x90F4, 0x90F2,
	0x90F3, 0x90D4, 0x90EB, 0x90EC, 0x90E9, 0x9156, 0x9158, 0x915A,
	0x9153, 0x9155, 0x91EC, 0x91F4, 0x91F1, 0x91F3, 0x91F8, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_3A = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x91E4, 0x91F9, 0x91EA, 0x91EB, 0x91F7, 0x91E8, 0x91EE,
	0x957A, 0x9586, 0x9588, 0x967C, 0x966D, 0x966B, 0x9671, 0x966F,
	0x96BF, 0x976A, 0x9804, 0x98E5, 0x9997, 0x509B, 0x5095, 0x5094,
	0x509E, 0x508B, 0x50A3, 0x5083, 0x508C, 0x508E, 0x509D, 0x5068,
	0x509C, 0x5092, 0x5082, 0x5087, 0x515F, 0x51D4, 0x5312, 0x5311,
	0x53A4, 0x53A7, 0x5591, 0x55A8, 0x55A5, 0x55AD, 0x5577, 0x5645,
	0x55A2, 0x5593, 0x5588, 0x558F, 0x55B5, 0x5581, 0x55A3, 0x5592,
	0x55A4, 0x557D, 0x558C, 0x55A6, 0x557F, 0x5595, 0x55A1, 0x558E,
	0x570C, 0x5829, 0x5837, 0x5819, 0x581E, 0x5827, 0x5823, 0x5828,
	0x57F5, 0x5848, 0x5825, 0x581C, 0x581B, 0x5833, 0x583F, 0x5836,
	0x582E, 0x5839, 0x5838, 0x582D, 0x582C, 0x583B, 0x5961, 0x5AAF,
	0x5A94, 0x5A9F, 0x5A7A, 0x5AA2, 0x5A9E, 0x5A78, 0x5AA6, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_3B = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5A7C, 0x5AA5, 0x5AAC, 0x5A95, 0x5AAE, 0x5A37, 0x5A84,
	0x5A8A, 0x5A97, 0x5A83, 0x5A8B, 0x5AA9, 0x5A7B, 0x5A7D, 0x5A8C,
	0x5A9C, 0x5A8F, 0x5A93, 0x5A9D, 0x5BEA, 0x5BCD, 0x5BCB, 0x5BD4,
	0x5BD1, 0x5BCA, 0x5BCE, 0x5C0C, 0x5C30, 0x5D37, 0x5D43, 0x5D6B,
	0x5D41, 0x5D4B, 0x5D3F, 0x5D35, 0x5D51, 0x5D4E, 0x5D55, 0x5D33,
	0x5D3A, 0x5D52, 0x5D3D, 0x5D31, 0x5D59, 0x5D42, 0x5D39, 0x5D49,
	0x5D38, 0x5D3C, 0x5D32, 0x5D36, 0x5D40, 0x5D45, 0x5E44, 0x5E41,
	0x5F58, 0x5FA6, 0x5FA5, 0x5FAB, 0x60C9, 0x60B9, 0x60CC, 0x60E2,
	0x60CE, 0x60C4, 0x6114, 0x60F2, 0x610A, 0x6116, 0x6105, 0x60F5,
	0x6113, 0x60F8, 0x60FC, 0x60FE, 0x60C1, 0x6103, 0x6118, 0x611D,
	0x6110, 0x60FF, 0x6104, 0x610B, 0x624A, 0x6394, 0x63B1, 0x63B0,
	0x63CE, 0x63E5, 0x63E8, 0x63EF, 0x63C3, 0x649D, 0x63F3, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_3C = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x63CA, 0x63E0, 0x63F6, 0x63D5, 0x63F2, 0x63F5, 0x6461,
	0x63DF, 0x63BE, 0x63DD, 0x63DC, 0x63C4, 0x63D8, 0x63D3, 0x63C2,
	0x63C7, 0x63CC, 0x63CB, 0x63C8, 0x63F0, 0x63D7, 0x63D9, 0x6532,
	0x6567, 0x656A, 0x6564, 0x655C, 0x6568, 0x6565, 0x658C, 0x659D,
	0x659E, 0x65AE, 0x65D0, 0x65D2, 0x667C, 0x666C, 0x667B, 0x6680,
	0x6671, 0x6679, 0x666A, 0x6672, 0x6701, 0x690C, 0x68D3, 0x6904,
	0x68DC, 0x692A, 0x68EC, 0x68EA, 0x68F1, 0x690F, 0x68D6, 0x68F7,
	0x68EB, 0x68E4, 0x68F6, 0x6913, 0x6910, 0x68F3, 0x68E1, 0x6907,
	0x68CC, 0x6908, 0x6970, 0x68B4, 0x6911, 0x68EF, 0x68C6, 0x6914,
	0x68F8, 0x68D0, 0x68FD, 0x68FC, 0x68E8, 0x690B, 0x690A, 0x6917,
	0x68CE, 0x68C8, 0x68DD, 0x68DE, 0x68E6, 0x68F4, 0x68D1, 0x6906,
	0x68D4, 0x68E9, 0x6915, 0x6925, 0x68C7, 0x6B39, 0x6B3B, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_3D = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x6B3F, 0x6B3C, 0x6B94, 0x6B97, 0x6B99, 0x6B95, 0x6BBD,
	0x6BF0, 0x6BF2, 0x6BF3, 0x6C30, 0x6DFC, 0x6E46, 0x6E47, 0x6E1F,
	0x6E49, 0x6E88, 0x6E3C, 0x6E3D, 0x6E45, 0x6E62, 0x6E2B, 0x6E3F,
	0x6E41, 0x6E5D, 0x6E73, 0x6E1C, 0x6E33, 0x6E4B, 0x6E40, 0x6E51,
	0x6E3B, 0x6E03, 0x6E2E, 0x6E5E, 0x6E68, 0x6E5C, 0x6E61, 0x6E31,
	0x6E28, 0x6E60, 0x6E71, 0x6E6B, 0x6E39, 0x6E22, 0x6E30, 0x6E53,
	0x6E65, 0x6E27, 0x6E78, 0x6E64, 0x6E77, 0x6E55, 0x6E79, 0x6E52,
	0x6E66, 0x6E35, 0x6E36, 0x6E5A, 0x7120, 0x711E, 0x712F, 0x70FB,
	0x712E, 0x7131, 0x7123, 0x7125, 0x7122, 0x7132, 0x711F, 0x7128,
	0x713A, 0x711B, 0x724B, 0x725A, 0x7288, 0x7289, 0x7286, 0x7285,
	0x728B, 0x7312, 0x730B, 0x7330, 0x7322, 0x7331, 0x7333, 0x7327,
	0x7332, 0x732D, 0x7326, 0x7323, 0x7335, 0x730C, 0x742E, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_3E = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x742C, 0x7430, 0x742B, 0x7416, 0x741A, 0x7421, 0x742D,
	0x7431, 0x7424, 0x7423, 0x741D, 0x7429, 0x7420, 0x7432, 0x74FB,
	0x752F, 0x756F, 0x756C, 0x75E7, 0x75DA, 0x75E1, 0x75E6, 0x75DD,
	0x75DF, 0x75E4, 0x75D7, 0x7695, 0x7692, 0x76DA, 0x7746, 0x7747,
	0x7744, 0x774D, 0x7745, 0x774A, 0x774E, 0x774B, 0x774C, 0x77DE,
	0x77EC, 0x7860, 0x7864, 0x7865, 0x785C, 0x786D, 0x7871, 0x786A,
	0x786E, 0x7870, 0x7869, 0x7868, 0x785E, 0x7862, 0x7974, 0x7973,
	0x7972, 0x7970, 0x7A02, 0x7A0A, 0x7A03, 0x7A0C, 0x7A04, 0x7A99,
	0x7AE6, 0x7AE4, 0x7B4A, 0x7B47, 0x7B44, 0x7B48, 0x7B4C, 0x7B4E,
	0x7B40, 0x7B58, 0x7B45, 0x7CA2, 0x7C9E, 0x7CA8, 0x7CA1, 0x7D58,
	0x7D6F, 0x7D63, 0x7D53, 0x7D56, 0x7D67, 0x7D6A, 0x7D4F, 0x7D6D,
	0x7D5C, 0x7D6B, 0x7D52, 0x7D54, 0x7D69, 0x7D51, 0x7D5F, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_3F = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x7D4E, 0x7F3E, 0x7F3F, 0x7F65, 0x7F66, 0x7FA2, 0x7FA0,
	0x7FA1, 0x7FD7, 0x8051, 0x804F, 0x8050, 0x80FE, 0x80D4, 0x8143,
	0x814A, 0x8152, 0x814F, 0x8147, 0x813D, 0x814D, 0x813A, 0x81E6,
	0x81EE, 0x81F7, 0x81F8, 0x81F9, 0x8204, 0x823C, 0x823D, 0x823F,
	0x8275, 0x833B, 0x83CF, 0x83F9, 0x8423, 0x83C0, 0x83E8, 0x8412,
	0x83E7, 0x83E4, 0x83FC, 0x83F6, 0x8410, 0x83C6, 0x83C8, 0x83EB,
	0x83E3, 0x83BF, 0x8401, 0x83DD, 0x83E5, 0x83D8, 0x83FF, 0x83E1,
	0x83CB, 0x83CE, 0x83D6, 0x83F5, 0x83C9, 0x8409, 0x840F, 0x83DE,
	0x8411, 0x8406, 0x83C2, 0x83F3, 0x83D5, 0x83FA, 0x83C7, 0x83D1,
	0x83EA, 0x8413, 0x839A, 0x83C3, 0x83EC, 0x83EE, 0x83C4, 0x83FB,
	0x83D7, 0x83E2, 0x841B, 0x83DB, 0x83FE, 0x86D8, 0x86E2, 0x86E6,
	0x86D3, 0x86E3, 0x86DA, 0x86EA, 0x86DD, 0x86EB, 0x86DC, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_40 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x86EC, 0x86E9, 0x86D7, 0x86E8, 0x86D1, 0x8848, 0x8856,
	0x8855, 0x88BA, 0x88D7, 0x88B9, 0x88B8, 0x88C0, 0x88BE, 0x88B6,
	0x88BC, 0x88B7, 0x88BD, 0x88B2, 0x8901, 0x88C9, 0x8995, 0x8998,
	0x8997, 0x89DD, 0x89DA, 0x89DB, 0x8A4E, 0x8A4D, 0x8A39, 0x8A59,
	0x8A40, 0x8A57, 0x8A58, 0x8A44, 0x8A45, 0x8A52, 0x8A48, 0x8A51,
	0x8A4A, 0x8A4C, 0x8A4F, 0x8C5F, 0x8C81, 0x8C80, 0x8CBA, 0x8CBE,
	0x8CB0, 0x8CB9, 0x8CB5, 0x8D84, 0x8D80, 0x8D89, 0x8DD8, 0x8DD3,
	0x8DCD, 0x8DC7, 0x8DD6, 0x8DDC, 0x8DCF, 0x8DD5, 0x8DD9, 0x8DC8,
	0x8DD7, 0x8DC5, 0x8EEF, 0x8EF7, 0x8EFA, 0x8EF9, 0x8EE6, 0x8EEE,
	0x8EE5, 0x8EF5, 0x8EE7, 0x8EE8, 0x8EF6, 0x8EEB, 0x8EF1, 0x8EEC,
	0x8EF4, 0x8EE9, 0x902D, 0x9034, 0x902F, 0x9106, 0x912C, 0x9104,
	0x90FF, 0x90FC, 0x9108, 0x90F9, 0x90FB, 0x9101, 0x9100, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_41 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x9107, 0x9105, 0x9103, 0x9161, 0x9164, 0x915F, 0x9162,
	0x9160, 0x9201, 0x920A, 0x9225, 0x9203, 0x921A, 0x9226, 0x920F,
	0x920C, 0x9200, 0x9212, 0x91FF, 0x91FD, 0x9206, 0x9204, 0x9227,
	0x9202, 0x921C, 0x9224, 0x9219, 0x9217, 0x9205, 0x9216, 0x957B,
	0x958D, 0x958C, 0x9590, 0x9687, 0x967E, 0x9688, 0x9689, 0x9683,
	0x9680, 0x96C2, 0x96C8, 0x96C3, 0x96F1, 0x96F0, 0x976C, 0x9770,
	0x976E, 0x9807, 0x98A9, 0x98EB, 0x9CE6, 0x9EF9, 0x4E83, 0x4E84,
	0x4EB6, 0x50BD, 0x50BF, 0x50C6, 0x50AE, 0x50C4, 0x50CA, 0x50B4,
	0x50C8, 0x50C2, 0x50B0, 0x50C1, 0x50BA, 0x50B1, 0x50CB, 0x50C9,
	0x50B6, 0x50B8, 0x51D7, 0x527A, 0x5278, 0x527B, 0x527C, 0x55C3,
	0x55DB, 0x55CC, 0x55D0, 0x55CB, 0x55CA, 0x55DD, 0x55C0, 0x55D4,
	0x55C4, 0x55E9, 0x55BF, 0x55D2, 0x558D, 0x55CF, 0x55D5, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_42 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x55E2, 0x55D6, 0x55C8, 0x55F2, 0x55CD, 0x55D9, 0x55C2,
	0x5714, 0x5853, 0x5868, 0x5864, 0x584F, 0x584D, 0x5849, 0x586F,
	0x5855, 0x584E, 0x585D, 0x5859, 0x5865, 0x585B, 0x583D, 0x5863,
	0x5871, 0x58FC, 0x5AC7, 0x5AC4, 0x5ACB, 0x5ABA, 0x5AB8, 0x5AB1,
	0x5AB5, 0x5AB0, 0x5ABF, 0x5AC8, 0x5ABB, 0x5AC6, 0x5AB7, 0x5AC0,
	0x5ACA, 0x5AB4, 0x5AB6, 0x5ACD, 0x5AB9, 0x5A90, 0x5BD6, 0x5BD8,
	0x5BD9, 0x5C1F, 0x5C33, 0x5D71, 0x5D63, 0x5D4A, 0x5D65, 0x5D72,
	0x5D6C, 0x5D5E, 0x5D68, 0x5D67, 0x5D62, 0x5DF0, 0x5E4F, 0x5E4E,
	0x5E4A, 0x5E4D, 0x5E4B, 0x5EC5, 0x5ECC, 0x5EC6, 0x5ECB, 0x5EC7,
	0x5F40, 0x5FAF, 0x5FAD, 0x60F7, 0x6149, 0x614A, 0x612B, 0x6145,
	0x6136, 0x6132, 0x612E, 0x6146, 0x612F, 0x614F, 0x6129, 0x6140,
	0x6220, 0x9168, 0x6223, 0x6225, 0x6224, 0x63C5, 0x63F1, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_43 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x63EB, 0x6410, 0x6412, 0x6409, 0x6420, 0x6424, 0x6433,
	0x6443, 0x641F, 0x6415, 0x6418, 0x6439, 0x6437, 0x6422, 0x6423,
	0x640C, 0x6426, 0x6430, 0x6428, 0x6441, 0x6435, 0x642F, 0x640A,
	0x641A, 0x6440, 0x6425, 0x6427, 0x640B, 0x63E7, 0x641B, 0x642E,
	0x6421, 0x640E, 0x656F, 0x6592, 0x65D3, 0x6686, 0x668C, 0x6695,
	0x6690, 0x668B, 0x668A, 0x6699, 0x6694, 0x6678, 0x6720, 0x6966,
	0x695F, 0x6938, 0x694E, 0x6962, 0x6971, 0x693F, 0x6945, 0x696A,
	0x6939, 0x6942, 0x6957, 0x6959, 0x697A, 0x6948, 0x6949, 0x6935,
	0x696C, 0x6933, 0x693D, 0x6965, 0x68F0, 0x6978, 0x6934, 0x6969,
	0x6940, 0x696F, 0x6944, 0x6976, 0x6958, 0x6941, 0x6974, 0x694C,
	0x693B, 0x694B, 0x6937, 0x695C, 0x694F, 0x6951, 0x6932, 0x6952,
	0x692F, 0x697B, 0x693C, 0x6B46, 0x6B45, 0x6B43, 0x6B42, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_44 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x6B48, 0x6B41, 0x6B9B, 0x6BFB, 0x6BFC, 0x6BF9, 0x6BF7,
	0x6BF8, 0x6E9B, 0x6ED6, 0x6EC8, 0x6E8F, 0x6EC0, 0x6E9F, 0x6E93,
	0x6E94, 0x6EA0, 0x6EB1, 0x6EB9, 0x6EC6, 0x6ED2, 0x6EBD, 0x6EC1,
	0x6E9E, 0x6EC9, 0x6EB7, 0x6EB0, 0x6ECD, 0x6EA6, 0x6ECF, 0x6EB2,
	0x6EBE, 0x6EC3, 0x6EDC, 0x6ED8, 0x6E99, 0x6E92, 0x6E8E, 0x6E8D,
	0x6EA4, 0x6EA1, 0x6EBF, 0x6EB3, 0x6ED0, 0x6ECA, 0x6E97, 0x6EAE,
	0x6EA3, 0x7147, 0x7154, 0x7152, 0x7163, 0x7160, 0x7141, 0x715D,
	0x7162, 0x7172, 0x7178, 0x716A, 0x7161, 0x7142, 0x7158, 0x7143,
	0x714B, 0x7170, 0x715F, 0x7150, 0x7153, 0x7144, 0x714D, 0x715A,
	0x724F, 0x728D, 0x728C, 0x7291, 0x7290, 0x728E, 0x733C, 0x7342,
	0x733B, 0x733A, 0x7340, 0x734A, 0x7349, 0x7444, 0x744A, 0x744B,
	0x7452, 0x7451, 0x7457, 0x7440, 0x744F, 0x7450, 0x744E, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_45 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x7442, 0x7446, 0x744D, 0x7454, 0x74E1, 0x74FF, 0x74FE,
	0x74FD, 0x751D, 0x7579, 0x7577, 0x6983, 0x75EF, 0x760F, 0x7603,
	0x75F7, 0x75FE, 0x75FC, 0x75F9, 0x75F8, 0x7610, 0x75FB, 0x75F6,
	0x75ED, 0x75F5, 0x75FD, 0x7699, 0x76B5, 0x76DD, 0x7755, 0x775F,
	0x7760, 0x7752, 0x7756, 0x775A, 0x7769, 0x7767, 0x7754, 0x7759,
	0x776D, 0x77E0, 0x7887, 0x789A, 0x7894, 0x788F, 0x7884, 0x7895,
	0x7885, 0x7886, 0x78A1, 0x7883, 0x7879, 0x7899, 0x7880, 0x7896,
	0x787B, 0x797C, 0x7982, 0x797D, 0x7979, 0x7A11, 0x7A18, 0x7A19,
	0x7A12, 0x7A17, 0x7A15, 0x7A22, 0x7A13, 0x7A1B, 0x7A10, 0x7AA3,
	0x7AA2, 0x7A9E, 0x7AEB, 0x7B66, 0x7B64, 0x7B6D, 0x7B74, 0x7B69,
	0x7B72, 0x7B65, 0x7B73, 0x7B71, 0x7B70, 0x7B61, 0x7B78, 0x7B76,
	0x7B63, 0x7CB2, 0x7CB4, 0x7CAF, 0x7D88, 0x7D86, 0x7D80, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_46 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x7D8D, 0x7D7F, 0x7D85, 0x7D7A, 0x7D8E, 0x7D7B, 0x7D83,
	0x7D7C, 0x7D8C, 0x7D94, 0x7D84, 0x7D7D, 0x7D92, 0x7F6D, 0x7F6B,
	0x7F67, 0x7F68, 0x7F6C, 0x7FA6, 0x7FA5, 0x7FA7, 0x7FDB, 0x7FDC,
	0x8021, 0x8164, 0x8160, 0x8177, 0x815C, 0x8169, 0x815B, 0x8162,
	0x8172, 0x6721, 0x815E, 0x8176, 0x8167, 0x816F, 0x8144, 0x8161,
	0x821D, 0x8249, 0x8244, 0x8240, 0x8242, 0x8245, 0x84F1, 0x843F,
	0x8456, 0x8476, 0x8479, 0x848F, 0x848D, 0x8465, 0x8451, 0x8440,
	0x8486, 0x8467, 0x8430, 0x844D, 0x847D, 0x845A, 0x8459, 0x8474,
	0x8473, 0x845D, 0x8507, 0x845E, 0x8437, 0x843A, 0x8434, 0x847A,
	0x8443, 0x8478, 0x8432, 0x8445, 0x8429, 0x83D9, 0x844B, 0x842F,
	0x8442, 0x842D, 0x845F, 0x8470, 0x8439, 0x844E, 0x844C, 0x8452,
	0x846F, 0x84C5, 0x848E, 0x843B, 0x8447, 0x8436, 0x8433, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_47 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x8468, 0x847E, 0x8444, 0x842B, 0x8460, 0x8454, 0x846E,
	0x8450, 0x870B, 0x8704, 0x86F7, 0x870C, 0x86FA, 0x86D6, 0x86F5,
	0x874D, 0x86F8, 0x870E, 0x8709, 0x8701, 0x86F6, 0x870D, 0x8705,
	0x88D6, 0x88CB, 0x88CD, 0x88CE, 0x88DE, 0x88DB, 0x88DA, 0x88CC,
	0x88D0, 0x8985, 0x899B, 0x89DF, 0x89E5, 0x89E4, 0x89E1, 0x89E0,
	0x89E2, 0x89DC, 0x89E6, 0x8A76, 0x8A86, 0x8A7F, 0x8A61, 0x8A3F,
	0x8A77, 0x8A82, 0x8A84, 0x8A75, 0x8A83, 0x8A81, 0x8A74, 0x8A7A,
	0x8C3C, 0x8C4B, 0x8C4A, 0x8C65, 0x8C64, 0x8C66, 0x8C86, 0x8C84,
	0x8C85, 0x8CCC, 0x8D68, 0x8D69, 0x8D91, 0x8D8C, 0x8D8E, 0x8D8F,
	0x8D8D, 0x8D93, 0x8D94, 0x8D90, 0x8D92, 0x8DF0, 0x8DE0, 0x8DEC,
	0x8DF1, 0x8DEE, 0x8DD0, 0x8DE9, 0x8DE3, 0x8DE2, 0x8DE7, 0x8DF2,
	0x8DEB, 0x8DF4, 0x8F06, 0x8EFF, 0x8F01, 0x8F00, 0x8F05, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_48 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x8F07, 0x8F08, 0x8F02, 0x8F0B, 0x9052, 0x903F, 0x9044,
	0x9049, 0x903D, 0x9110, 0x910D, 0x910F, 0x9111, 0x9116, 0x9114,
	0x910B, 0x910E, 0x916E, 0x916F, 0x9248, 0x9252, 0x9230, 0x923A,
	0x9266, 0x9233, 0x9265, 0x925E, 0x9283, 0x922E, 0x924A, 0x9246,
	0x926D, 0x926C, 0x924F, 0x9260, 0x9267, 0x926F, 0x9236, 0x9261,
	0x9270, 0x9231, 0x9254, 0x9263, 0x9250, 0x9272, 0x924E, 0x9253,
	0x924C, 0x9256, 0x9232, 0x959F, 0x959C, 0x959E, 0x959B, 0x9692,
	0x9693, 0x9691, 0x9697, 0x96CE, 0x96FA, 0x96FD, 0x96F8, 0x96F5,
	0x9773, 0x9777, 0x9778, 0x9772, 0x980F, 0x980D, 0x980E, 0x98AC,
	0x98F6, 0x98F9, 0x99AF, 0x99B2, 0x99B0, 0x99B5, 0x9AAD, 0x9AAB,
	0x9B5B, 0x9CEA, 0x9CED, 0x9CE7, 0x9E80, 0x9EFD, 0x50E6, 0x50D4,
	0x50D7, 0x50E8, 0x50F3, 0x50DB, 0x50EA, 0x50DD, 0x50E4, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_49 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x50D3, 0x50EC, 0x50F0, 0x50EF, 0x50E3, 0x50E0, 0x51D8,
	0x5280, 0x5281, 0x52E9, 0x52EB, 0x5330, 0x53AC, 0x5627, 0x5615,
	0x560C, 0x5612, 0x55FC, 0x560F, 0x561C, 0x5601, 0x5613, 0x5602,
	0x55FA, 0x561D, 0x5604, 0x55FF, 0x55F9, 0x5889, 0x587C, 0x5890,
	0x5898, 0x5886, 0x5881, 0x587F, 0x5874, 0x588B, 0x587A, 0x5887,
	0x5891, 0x588E, 0x5876, 0x5882, 0x5888, 0x587B, 0x5894, 0x588F,
	0x58FE, 0x596B, 0x5ADC, 0x5AEE, 0x5AE5, 0x5AD5, 0x5AEA, 0x5ADA,
	0x5AED, 0x5AEB, 0x5AF3, 0x5AE2, 0x5AE0, 0x5ADB, 0x5AEC, 0x5ADE,
	0x5ADD, 0x5AD9, 0x5AE8, 0x5ADF, 0x5B77, 0x5BE0, 0x5BE3, 0x5C63,
	0x5D82, 0x5D80, 0x5D7D, 0x5D86, 0x5D7A, 0x5D81, 0x5D77, 0x5D8A,
	0x5D89, 0x5D88, 0x5D7E, 0x5D7C, 0x5D8D, 0x5D79, 0x5D7F, 0x5E58,
	0x5E59, 0x5E53, 0x5ED8, 0x5ED1, 0x5ED7, 0x5ECE, 0x5EDC, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_4A = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5ED5, 0x5ED9, 0x5ED2, 0x5ED4, 0x5F44, 0x5F43, 0x5F6F,
	0x5FB6, 0x612C, 0x6128, 0x6141, 0x615E, 0x6171, 0x6173, 0x6152,
	0x6153, 0x6172, 0x616C, 0x6180, 0x6174, 0x6154, 0x617A, 0x615B,
	0x6165, 0x613B, 0x616A, 0x6161, 0x6156, 0x6229, 0x6227, 0x622B,
	0x642B, 0x644D, 0x645B, 0x645D, 0x6474, 0x6476, 0x6472, 0x6473,
	0x647D, 0x6475, 0x6466, 0x64A6, 0x644E, 0x6482, 0x645E, 0x645C,
	0x644B, 0x6453, 0x6460, 0x6450, 0x647F, 0x643F, 0x646C, 0x646B,
	0x6459, 0x6465, 0x6477, 0x6573, 0x65A0, 0x66A1, 0x66A0, 0x669F,
	0x6705, 0x6704, 0x6722, 0x69B1, 0x69B6, 0x69C9, 0x69A0, 0x69CE,
	0x6996, 0x69B0, 0x69AC, 0x69BC, 0x6991, 0x6999, 0x698E, 0x69A7,
	0x698D, 0x69A9, 0x69BE, 0x69AF, 0x69BF, 0x69C4, 0x69BD, 0x69A4,
	0x69D4, 0x69B9, 0x69CA, 0x699A, 0x69CF, 0x69B3, 0x6993, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_4B = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x69AA, 0x69A1, 0x699E, 0x69D9, 0x6997, 0x6990, 0x69C2,
	0x69B5, 0x69A5, 0x69C6, 0x6B4A, 0x6B4D, 0x6B4B, 0x6B9E, 0x6B9F,
	0x6BA0, 0x6BC3, 0x6BC4, 0x6BFE, 0x6ECE, 0x6EF5, 0x6EF1, 0x6F03,
	0x6F25, 0x6EF8, 0x6F37, 0x6EFB, 0x6F2E, 0x6F09, 0x6F4E, 0x6F19,
	0x6F1A, 0x6F27, 0x6F18, 0x6F3B, 0x6F12, 0x6EED, 0x6F0A, 0x6F36,
	0x6F73, 0x6EF9, 0x6EEE, 0x6F2D, 0x6F40, 0x6F30, 0x6F3C, 0x6F35,
	0x6EEB, 0x6F07, 0x6F0E, 0x6F43, 0x6F05, 0x6EFD, 0x6EF6, 0x6F39,
	0x6F1C, 0x6EFC, 0x6F3A, 0x6F1F, 0x6F0D, 0x6F1E, 0x6F08, 0x6F21,
	0x7187, 0x7190, 0x7189, 0x7180, 0x7185, 0x7182, 0x718F, 0x717B,
	0x7186, 0x7181, 0x7197, 0x7244, 0x7253, 0x7297, 0x7295, 0x7293,
	0x7343, 0x734D, 0x7351, 0x734C, 0x7462, 0x7473, 0x7471, 0x7475,
	0x7472, 0x7467, 0x746E, 0x7500, 0x7502, 0x7503, 0x757D, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_4C = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x7590, 0x7616, 0x7608, 0x760C, 0x7615, 0x7611, 0x760A,
	0x7614, 0x76B8, 0x7781, 0x777C, 0x7785, 0x7782, 0x776E, 0x7780,
	0x776F, 0x777E, 0x7783, 0x78B2, 0x78AA, 0x78B4, 0x78AD, 0x78A8,
	0x787E, 0x78AB, 0x789E, 0x78A5, 0x78A0, 0x78AC, 0x78A2, 0x78A4,
	0x7998, 0x798A, 0x798B, 0x7996, 0x7995, 0x7994, 0x7993, 0x7997,
	0x7988, 0x7992, 0x7990, 0x7A2B, 0x7A4A, 0x7A30, 0x7A2F, 0x7A28,
	0x7A26, 0x7AA8, 0x7AAB, 0x7AAC, 0x7AEE, 0x7B88, 0x7B9C, 0x7B8A,
	0x7B91, 0x7B90, 0x7B96, 0x7B8D, 0x7B8C, 0x7B9B, 0x7B8E, 0x7B85,
	0x7B98, 0x5284, 0x7B99, 0x7BA4, 0x7B82, 0x7CBB, 0x7CBF, 0x7CBC,
	0x7CBA, 0x7DA7, 0x7DB7, 0x7DC2, 0x7DA3, 0x7DAA, 0x7DC1, 0x7DC0,
	0x7DC5, 0x7D9D, 0x7DCE, 0x7DC4, 0x7DC6, 0x7DCB, 0x7DCC, 0x7DAF,
	0x7DB9, 0x7D96, 0x7DBC, 0x7D9F, 0x7DA6, 0x7DAE, 0x7DA9, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_4D = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x7DA1, 0x7DC9, 0x7F73, 0x7FE2, 0x7FE3, 0x7FE5, 0x7FDE,
	0x8024, 0x805D, 0x805C, 0x8189, 0x8186, 0x8183, 0x8187, 0x818D,
	0x818C, 0x818B, 0x8215, 0x8497, 0x84A4, 0x84A1, 0x849F, 0x84BA,
	0x84CE, 0x84C2, 0x84AC, 0x84AE, 0x84AB, 0x84B9, 0x84B4, 0x84C1,
	0x84CD, 0x84AA, 0x849A, 0x84B1, 0x84D0, 0x849D, 0x84A7, 0x84BB,
	0x84A2, 0x8494, 0x84C7, 0x84CC, 0x849B, 0x84A9, 0x84AF, 0x84A8,
	0x84D6, 0x8498, 0x84B6, 0x84CF, 0x84A0, 0x84D7, 0x84D4, 0x84D2,
	0x84DB, 0x84B0, 0x8491, 0x8661, 0x8733, 0x8723, 0x8728, 0x876B,
	0x8740, 0x872E, 0x871E, 0x8721, 0x8719, 0x871B, 0x8743, 0x872C,
	0x8741, 0x873E, 0x8746, 0x8720, 0x8732, 0x872A, 0x872D, 0x873C,
	0x8712, 0x873A, 0x8731, 0x8735, 0x8742, 0x8726, 0x8727, 0x8738,
	0x8724, 0x871A, 0x8730, 0x8711, 0x88F7, 0x88E7, 0x88F1, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_4E = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x88F2, 0x88FA, 0x88FE, 0x88EE, 0x88FC, 0x88F6, 0x88FB,
	0x88F0, 0x88EC, 0x88EB, 0x899D, 0x89A1, 0x899F, 0x899E, 0x89E9,
	0x89EB, 0x89E8, 0x8AAB, 0x8A99, 0x8A8B, 0x8A92, 0x8A8F, 0x8A96,
	0x8C3D, 0x8C68, 0x8C69, 0x8CD5, 0x8CCF, 0x8CD7, 0x8D96, 0x8E09,
	0x8E02, 0x8DFF, 0x8E0D, 0x8DFD, 0x8E0A, 0x8E03, 0x8E07, 0x8E06,
	0x8E05, 0x8DFE, 0x8E00, 0x8E04, 0x8F10, 0x8F11, 0x8F0E, 0x8F0D,
	0x9123, 0x911C, 0x9120, 0x9122, 0x911F, 0x911D, 0x911A, 0x9124,
	0x9121, 0x911B, 0x917A, 0x9172, 0x9179, 0x9173, 0x92A5, 0x92A4,
	0x9276, 0x929B, 0x927A, 0x92A0, 0x9294, 0x92AA, 0x928D, 0x92A6,
	0x929A, 0x92AB, 0x9279, 0x9297, 0x927F, 0x92A3, 0x92EE, 0x928E,
	0x9282, 0x9295, 0x92A2, 0x927D, 0x9288, 0x92A1, 0x928A, 0x9286,
	0x928C, 0x9299, 0x92A7, 0x927E, 0x9287, 0x92A9, 0x929D, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_4F = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x928B, 0x922D, 0x969E, 0x96A1, 0x96FF, 0x9758, 0x977D,
	0x977A, 0x977E, 0x9783, 0x9780, 0x9782, 0x977B, 0x9784, 0x9781,
	0x977F, 0x97CE, 0x97CD, 0x9816, 0x98AD, 0x98AE, 0x9902, 0x9900,
	0x9907, 0x999D, 0x999C, 0x99C3, 0x99B9, 0x99BB, 0x99BA, 0x99C2,
	0x99BD, 0x99C7, 0x9AB1, 0x9AE3, 0x9AE7, 0x9B3E, 0x9B3F, 0x9B60,
	0x9B61, 0x9B5F, 0x9CF1, 0x9CF2, 0x9CF5, 0x9EA7, 0x50FF, 0x5103,
	0x5130, 0x50F8, 0x5106, 0x5107, 0x50F6, 0x50FE, 0x510B, 0x510C,
	0x50FD, 0x510A, 0x528B, 0x528C, 0x52F1, 0x52EF, 0x5648, 0x5642,
	0x564C, 0x5635, 0x5641, 0x564A, 0x5649, 0x5646, 0x5658, 0x565A,
	0x5640, 0x5633, 0x563D, 0x562C, 0x563E, 0x5638, 0x562A, 0x563A,
	0x571A, 0x58AB, 0x589D, 0x58B1, 0x58A0, 0x58A3, 0x58AF, 0x58AC,
	0x58A5, 0x58A1, 0x58FF, 0x5AFF, 0x5AF4, 0x5AFD, 0x5AF7, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_50 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5AF6, 0x5B03, 0x5AF8, 0x5B02, 0x5AF9, 0x5B01, 0x5B07,
	0x5B05, 0x5B0F, 0x5C67, 0x5D99, 0x5D97, 0x5D9F, 0x5D92, 0x5DA2,
	0x5D93, 0x5D95, 0x5DA0, 0x5D9C, 0x5DA1, 0x5D9A, 0x5D9E, 0x5E69,
	0x5E5D, 0x5E60, 0x5E5C, 0x7DF3, 0x5EDB, 0x5EDE, 0x5EE1, 0x5F49,
	0x5FB2, 0x618B, 0x6183, 0x6179, 0x61B1, 0x61B0, 0x61A2, 0x6189,
	0x619B, 0x6193, 0x61AF, 0x61AD, 0x619F, 0x6192, 0x61AA, 0x61A1,
	0x618D, 0x6166, 0x61B3, 0x622D, 0x646E, 0x6470, 0x6496, 0x64A0,
	0x6485, 0x6497, 0x649C, 0x648F, 0x648B, 0x648A, 0x648C, 0x64A3,
	0x649F, 0x6468, 0x64B1, 0x6498, 0x6576, 0x657A, 0x6579, 0x657B,
	0x65B2, 0x65B3, 0x66B5, 0x66B0, 0x66A9, 0x66B2, 0x66B7, 0x66AA,
	0x66AF, 0x6A00, 0x6A06, 0x6A17, 0x69E5, 0x69F8, 0x6A15, 0x69F1,
	0x69E4, 0x6A20, 0x69FF, 0x69EC, 0x69E2, 0x6A1B, 0x6A1D, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_51 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x69FE, 0x6A27, 0x69F2, 0x69EE, 0x6A14, 0x69F7, 0x69E7,
	0x6A40, 0x6A08, 0x69E6, 0x69FB, 0x6A0D, 0x69FC, 0x69EB, 0x6A09,
	0x6A04, 0x6A18, 0x6A25, 0x6A0F, 0x69F6, 0x6A26, 0x6A07, 0x69F4,
	0x6A16, 0x6B51, 0x6BA5, 0x6BA3, 0x6BA2, 0x6BA6, 0x6C01, 0x6C00,
	0x6BFF, 0x6C02, 0x6F41, 0x6F26, 0x6F7E, 0x6F87, 0x6FC6, 0x6F92,
	0x6F8D, 0x6F89, 0x6F8C, 0x6F62, 0x6F4F, 0x6F85, 0x6F5A, 0x6F96,
	0x6F76, 0x6F6C, 0x6F82, 0x6F55, 0x6F72, 0x6F52, 0x6F50, 0x6F57,
	0x6F94, 0x6F93, 0x6F5D, 0x6F00, 0x6F61, 0x6F6B, 0x6F7D, 0x6F67,
	0x6F90, 0x6F53, 0x6F8B, 0x6F69, 0x6F7F, 0x6F95, 0x6F63, 0x6F77,
	0x6F6A, 0x6F7B, 0x71B2, 0x71AF, 0x719B, 0x71B0, 0x71A0, 0x719A,
	0x71A9, 0x71B5, 0x719D, 0x71A5, 0x719E, 0x71A4, 0x71A1, 0x71AA,
	0x719C, 0x71A7, 0x71B3, 0x7298, 0x729A, 0x7358, 0x7352, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_52 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x735E, 0x735F, 0x7360, 0x735D, 0x735B, 0x7361, 0x735A,
	0x7359, 0x7362, 0x7487, 0x7489, 0x748A, 0x7486, 0x7481, 0x747D,
	0x7485, 0x7488, 0x747C, 0x7479, 0x7508, 0x7507, 0x757E, 0x7625,
	0x761E, 0x7619, 0x761D, 0x761C, 0x7623, 0x761A, 0x7628, 0x761B,
	0x769C, 0x769D, 0x769E, 0x769B, 0x778D, 0x778F, 0x7789, 0x7788,
	0x78CD, 0x78BB, 0x78CF, 0x78CC, 0x78D1, 0x78CE, 0x78D4, 0x78C8,
	0x78C3, 0x78C4, 0x78C9, 0x799A, 0x79A1, 0x79A0, 0x799C, 0x79A2,
	0x799B, 0x6B76, 0x7A39, 0x7AB2, 0x7AB4, 0x7AB3, 0x7BB7, 0x7BCB,
	0x7BBE, 0x7BAC, 0x7BCE, 0x7BAF, 0x7BB9, 0x7BCA, 0x7BB5, 0x7CC5,
	0x7CC8, 0x7CCC, 0x7CCB, 0x7DF7, 0x7DDB, 0x7DEA, 0x7DE7, 0x7DD7,
	0x7DE1, 0x7E03, 0x7DFA, 0x7DE6, 0x7DF6, 0x7DF1, 0x7DF0, 0x7DEE,
	0x7DDF, 0x7F76, 0x7FAC, 0x7FB0, 0x7FAD, 0x7FED, 0x7FEB, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_53 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x7FEA, 0x7FEC, 0x7FE6, 0x7FE8, 0x8064, 0x8067, 0x81A3,
	0x819F, 0x819E, 0x8195, 0x81A2, 0x8199, 0x8197, 0x8216, 0x824F,
	0x8253, 0x8252, 0x8250, 0x824E, 0x8251, 0x8524, 0x853B, 0x850F,
	0x8500, 0x8529, 0x850E, 0x8509, 0x850D, 0x851F, 0x850A, 0x8527,
	0x851C, 0x84FB, 0x852B, 0x84FA, 0x8508, 0x850C, 0x84F4, 0x852A,
	0x84F2, 0x8515, 0x84F7, 0x84EB, 0x84F3, 0x84FC, 0x8512, 0x84EA,
	0x84E9, 0x8516, 0x84FE, 0x8528, 0x851D, 0x852E, 0x8502, 0x84FD,
	0x851E, 0x84F6, 0x8531, 0x8526, 0x84E7, 0x84E8, 0x84F0, 0x84EF,
	0x84F9, 0x8518, 0x8520, 0x8530, 0x850B, 0x8519, 0x852F, 0x8662,
	0x8756, 0x8763, 0x8764, 0x8777, 0x87E1, 0x8773, 0x8758, 0x8754,
	0x875B, 0x8752, 0x8761, 0x875A, 0x8751, 0x875E, 0x876D, 0x876A,
	0x8750, 0x874E, 0x875F, 0x875D, 0x876F, 0x876C, 0x877A, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_54 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x876E, 0x875C, 0x8765, 0x874F, 0x877B, 0x8775, 0x8762,
	0x8767, 0x8769, 0x885A, 0x8905, 0x890C, 0x8914, 0x890B, 0x8917,
	0x8918, 0x8919, 0x8906, 0x8916, 0x8911, 0x890E, 0x8909, 0x89A2,
	0x89A4, 0x89A3, 0x89ED, 0x89F0, 0x89EC, 0x8ACF, 0x8AC6, 0x8AB8,
	0x8AD3, 0x8AD1, 0x8AD4, 0x8AD5, 0x8ABB, 0x8AD7, 0x8ABE, 0x8AC0,
	0x8AC5, 0x8AD8, 0x8AC3, 0x8ABA, 0x8ABD, 0x8AD9, 0x8C3E, 0x8C4D,
	0x8C8F, 0x8CE5, 0x8CDF, 0x8CD9, 0x8CE8, 0x8CDA, 0x8CDD, 0x8CE7,
	0x8DA0, 0x8D9C, 0x8DA1, 0x8D9B, 0x8E20, 0x8E23, 0x8E25, 0x8E24,
	0x8E2E, 0x8E15, 0x8E1B, 0x8E16, 0x8E11, 0x8E19, 0x8E26, 0x8E27,
	0x8E14, 0x8E12, 0x8E18, 0x8E13, 0x8E1C, 0x8E17, 0x8E1A, 0x8F2C,
	0x8F24, 0x8F18, 0x8F1A, 0x8F20, 0x8F23, 0x8F16, 0x8F17, 0x9073,
	0x9070, 0x906F, 0x9067, 0x906B, 0x912F, 0x912B, 0x9129, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_55 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x912A, 0x9132, 0x9126, 0x912E, 0x9185, 0x9186, 0x918A,
	0x9181, 0x9182, 0x9184, 0x9180, 0x92D0, 0x92C3, 0x92C4, 0x92C0,
	0x92D9, 0x92B6, 0x92CF, 0x92F1, 0x92DF, 0x92D8, 0x92E9, 0x92D7,
	0x92DD, 0x92CC, 0x92EF, 0x92C2, 0x92E8, 0x92CA, 0x92C8, 0x92CE,
	0x92E6, 0x92CD, 0x92D5, 0x92C9, 0x92E0, 0x92DE, 0x92E7, 0x92D1,
	0x92D3, 0x92B5, 0x92E1, 0x9325, 0x92C6, 0x92B4, 0x957C, 0x95AC,
	0x95AB, 0x95AE, 0x95B0, 0x96A4, 0x96A2, 0x96D3, 0x9705, 0x9708,
	0x9702, 0x975A, 0x978A, 0x978E, 0x9788, 0x97D0, 0x97CF, 0x981E,
	0x981D, 0x9826, 0x9829, 0x9828, 0x9820, 0x981B, 0x9827, 0x98B2,
	0x9908, 0x98FA, 0x9911, 0x9914, 0x9916, 0x9917, 0x9915, 0x99DC,
	0x99CD, 0x99CF, 0x99D3, 0x99D4, 0x99CE, 0x99C9, 0x99D6, 0x99D8,
	0x99CB, 0x99D7, 0x99CC, 0x9AB3, 0x9AEC, 0x9AEB, 0x9AF3, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_56 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x9AF2, 0x9AF1, 0x9B46, 0x9B43, 0x9B67, 0x9B74, 0x9B71,
	0x9B66, 0x9B76, 0x9B75, 0x9B70, 0x9B68, 0x9B64, 0x9B6C, 0x9CFC,
	0x9CFA, 0x9CFD, 0x9CFF, 0x9CF7, 0x9D07, 0x9D00, 0x9CF9, 0x9CFB,
	0x9D08, 0x9D05, 0x9D04, 0x9E83, 0x9ED3, 0x9F0F, 0x9F10, 0x511C,
	0x5113, 0x5117, 0x511A, 0x5111, 0x51DE, 0x5334, 0x53E1, 0x5670,
	0x5660, 0x566E, 0x5673, 0x5666, 0x5663, 0x566D, 0x5672, 0x565E,
	0x5677, 0x571C, 0x571B, 0x58C8, 0x58BD, 0x58C9, 0x58BF, 0x58BA,
	0x58C2, 0x58BC, 0x58C6, 0x5B17, 0x5B19, 0x5B1B, 0x5B21, 0x5B14,
	0x5B13, 0x5B10, 0x5B16, 0x5B28, 0x5B1A, 0x5B20, 0x5B1E, 0x5BEF,
	0x5DAC, 0x5DB1, 0x5DA9, 0x5DA7, 0x5DB5, 0x5DB0, 0x5DAE, 0x5DAA,
	0x5DA8, 0x5DB2, 0x5DAD, 0x5DAF, 0x5DB4, 0x5E67, 0x5E68, 0x5E66,
	0x5E6F, 0x5EE9, 0x5EE7, 0x5EE6, 0x5EE8, 0x5EE5, 0x5F4B, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_57 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5FBC, 0x5FBB, 0x619D, 0x61A8, 0x6196, 0x61C5, 0x61B4,
	0x61C6, 0x61C1, 0x61CC, 0x61BA, 0x61BF, 0x61B8, 0x618C, 0x64D7,
	0x64D6, 0x64D0, 0x64CF, 0x64C9, 0x64BD, 0x6489, 0x64C3, 0x64DB,
	0x64F3, 0x64D9, 0x6533, 0x657F, 0x657C, 0x65A2, 0x66C8, 0x66BE,
	0x66C0, 0x66CA, 0x66CB, 0x66CF, 0x66BD, 0x66BB, 0x66BA, 0x66CC,
	0x6723, 0x6A34, 0x6A66, 0x6A49, 0x6A67, 0x6A32, 0x6A68, 0x6A3E,
	0x6A5D, 0x6A6D, 0x6A76, 0x6A5B, 0x6A51, 0x6A28, 0x6A5A, 0x6A3B,
	0x6A3F, 0x6A41, 0x6A6A, 0x6A64, 0x6A50, 0x6A4F, 0x6A54, 0x6A6F,
	0x6A69, 0x6A60, 0x6A3C, 0x6A5E, 0x6A56, 0x6A55, 0x6A4D, 0x6A4E,
	0x6A46, 0x6B55, 0x6B54, 0x6B56, 0x6BA7, 0x6BAA, 0x6BAB, 0x6BC8,
	0x6BC7, 0x6C04, 0x6C03, 0x6C06, 0x6FAD, 0x6FCB, 0x6FA3, 0x6FC7,
	0x6FBC, 0x6FCE, 0x6FC8, 0x6F5E, 0x6FC4, 0x6FBD, 0x6F9E, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_58 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x6FCA, 0x6FA8, 0x7004, 0x6FA5, 0x6FAE, 0x6FBA, 0x6FAC,
	0x6FAA, 0x6FCF, 0x6FBF, 0x6FB8, 0x6FA2, 0x6FC9, 0x6FAB, 0x6FCD,
	0x6FAF, 0x6FB2, 0x6FB0, 0x71C5, 0x71C2, 0x71BF, 0x71B8, 0x71D6,
	0x71C0, 0x71C1, 0x71CB, 0x71D4, 0x71CA, 0x71C7, 0x71CF, 0x71BD,
	0x71D8, 0x71BC, 0x71C6, 0x71DA, 0x71DB, 0x729D, 0x729E, 0x7369,
	0x7366, 0x7367, 0x736C, 0x7365, 0x736B, 0x736A, 0x747F, 0x749A,
	0x74A0, 0x7494, 0x7492, 0x7495, 0x74A1, 0x750B, 0x7580, 0x762F,
	0x762D, 0x7631, 0x763D, 0x7633, 0x763C, 0x7635, 0x7632, 0x7630,
	0x76BB, 0x76E6, 0x779A, 0x779D, 0x77A1, 0x779C, 0x779B, 0x77A2,
	0x77A3, 0x7795, 0x7799, 0x7797, 0x78DD, 0x78E9, 0x78E5, 0x78EA,
	0x78DE, 0x78E3, 0x78DB, 0x78E1, 0x78E2, 0x78ED, 0x78DF, 0x78E0,
	0x79A4, 0x7A44, 0x7A48, 0x7A47, 0x7AB6, 0x7AB8, 0x7AB5, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_59 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x7AB1, 0x7AB7, 0x7BDE, 0x7BE3, 0x7BE7, 0x7BDD, 0x7BD5,
	0x7BE5, 0x7BDA, 0x7BE8, 0x7BF9, 0x7BD4, 0x7BEA, 0x7BE2, 0x7BDC,
	0x7BEB, 0x7BD8, 0x7BDF, 0x7CD2, 0x7CD4, 0x7CD7, 0x7CD0, 0x7CD1,
	0x7E12, 0x7E21, 0x7E17, 0x7E0C, 0x7E1F, 0x7E20, 0x7E13, 0x7E0E,
	0x7E1C, 0x7E15, 0x7E1A, 0x7E22, 0x7E0B, 0x7E0F, 0x7E16, 0x7E0D,
	0x7E14, 0x7E25, 0x7E24, 0x7F43, 0x7F7B, 0x7F7C, 0x7F7A, 0x7FB1,
	0x7FEF, 0x802A, 0x8029, 0x806C, 0x81B1, 0x81A6, 0x81AE, 0x81B9,
	0x81B5, 0x81AB, 0x81B0, 0x81AC, 0x81B4, 0x81B2, 0x81B7, 0x81A7,
	0x81F2, 0x8255, 0x8256, 0x8257, 0x8556, 0x8545, 0x856B, 0x854D,
	0x8553, 0x8561, 0x8558, 0x8540, 0x8546, 0x8564, 0x8541, 0x8562,
	0x8544, 0x8551, 0x8547, 0x8563, 0x853E, 0x855B, 0x8571, 0x854E,
	0x856E, 0x8575, 0x8555, 0x8567, 0x8560, 0x858C, 0x8566, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_5A = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x855D, 0x8554, 0x8565, 0x856C, 0x8663, 0x8665, 0x8664,
	0x87A4, 0x879B, 0x878F, 0x8797, 0x8793, 0x8792, 0x8788, 0x8781,
	0x8796, 0x8798, 0x8779, 0x8787, 0x87A3, 0x8785, 0x8790, 0x8791,
	0x879D, 0x8784, 0x8794, 0x879C, 0x879A, 0x8789, 0x891E, 0x8926,
	0x8930, 0x892D, 0x892E, 0x8927, 0x8931, 0x8922, 0x8929, 0x8923,
	0x892F, 0x892C, 0x891F, 0x89F1, 0x8AE0, 0x8AE2, 0x8AF2, 0x8AF4,
	0x8AF5, 0x8ADD, 0x8B14, 0x8AE4, 0x8ADF, 0x8AF0, 0x8AC8, 0x8ADE,
	0x8AE1, 0x8AE8, 0x8AFF, 0x8AEF, 0x8AFB, 0x8C91, 0x8C92, 0x8C90,
	0x8CF5, 0x8CEE, 0x8CF1, 0x8CF0, 0x8CF3, 0x8D6C, 0x8D6E, 0x8DA5,
	0x8DA7, 0x8E33, 0x8E3E, 0x8E38, 0x8E40, 0x8E45, 0x8E36, 0x8E3C,
	0x8E3D, 0x8E41, 0x8E30, 0x8E3F, 0x8EBD, 0x8F36, 0x8F2E, 0x8F35,
	0x8F32, 0x8F39, 0x8F37, 0x8F34, 0x9076, 0x9079, 0x907B, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_5B = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x9086, 0x90FA, 0x9133, 0x9135, 0x9136, 0x9193, 0x9190,
	0x9191, 0x918D, 0x918F, 0x9327, 0x931E, 0x9308, 0x931F, 0x9306,
	0x930F, 0x937A, 0x9338, 0x933C, 0x931B, 0x9323, 0x9312, 0x9301,
	0x9346, 0x932D, 0x930E, 0x930D, 0x92CB, 0x931D, 0x92FA, 0x9313,
	0x92F9, 0x92F7, 0x9334, 0x9302, 0x9324, 0x92FF, 0x9329, 0x9339,
	0x9335, 0x932A, 0x9314, 0x930C, 0x930B, 0x92FE, 0x9309, 0x9300,
	0x92FB, 0x9316, 0x95BC, 0x95CD, 0x95BE, 0x95B9, 0x95BA, 0x95B6,
	0x95BF, 0x95B5, 0x95BD, 0x96A9, 0x96D4, 0x970B, 0x9712, 0x9710,
	0x9799, 0x9797, 0x9794, 0x97F0, 0x97F8, 0x9835, 0x982F, 0x9832,
	0x9924, 0x991F, 0x9927, 0x9929, 0x999E, 0x99EE, 0x99EC, 0x99E5,
	0x99E4, 0x99F0, 0x99E3, 0x99EA, 0x99E9, 0x99E7, 0x9AB9, 0x9ABF,
	0x9AB4, 0x9ABB, 0x9AF6, 0x9AFA, 0x9AF9, 0x9AF7, 0x9B33, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_5C = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x9B80, 0x9B85, 0x9B87, 0x9B7C, 0x9B7E, 0x9B7B, 0x9B82,
	0x9B93, 0x9B92, 0x9B90, 0x9B7A, 0x9B95, 0x9B7D, 0x9B88, 0x9D25,
	0x9D17, 0x9D20, 0x9D1E, 0x9D14, 0x9D29, 0x9D1D, 0x9D18, 0x9D22,
	0x9D10, 0x9D19, 0x9D1F, 0x9E88, 0x9E86, 0x9E87, 0x9EAE, 0x9EAD,
	0x9ED5, 0x9ED6, 0x9EFA, 0x9F12, 0x9F3D, 0x5126, 0x5125, 0x5122,
	0x5124, 0x5120, 0x5129, 0x52F4, 0x5693, 0x568C, 0x568D, 0x5686,
	0x5684, 0x5683, 0x567E, 0x5682, 0x567F, 0x5681, 0x58D6, 0x58D4,
	0x58CF, 0x58D2, 0x5B2D, 0x5B25, 0x5B32, 0x5B23, 0x5B2C, 0x5B27,
	0x5B26, 0x5B2F, 0x5B2E, 0x5B7B, 0x5BF1, 0x5BF2, 0x5DB7, 0x5E6C,
	0x5E6A, 0x5FBE, 0x61C3, 0x61B5, 0x61BC, 0x61E7, 0x61E0, 0x61E5,
	0x61E4, 0x61E8, 0x61DE, 0x64EF, 0x64E9, 0x64E3, 0x64EB, 0x64E4,
	0x64E8, 0x6581, 0x6580, 0x65B6, 0x65DA, 0x66D2, 0x6A8D, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_5D = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x6A96, 0x6A81, 0x6AA5, 0x6A89, 0x6A9F, 0x6A9B, 0x6AA1,
	0x6A9E, 0x6A87, 0x6A93, 0x6A8E, 0x6A95, 0x6A83, 0x6AA8, 0x6AA4,
	0x6A91, 0x6A7F, 0x6AA6, 0x6A9A, 0x6A85, 0x6A8C, 0x6A92, 0x6B5B,
	0x6BAD, 0x6C09, 0x6FCC, 0x6FA9, 0x6FF4, 0x6FD4, 0x6FE3, 0x6FDC,
	0x6FED, 0x6FE7, 0x6FE6, 0x6FDE, 0x6FF2, 0x6FDD, 0x6FE2, 0x6FE8,
	0x71E1, 0x71F1, 0x71E8, 0x71F2, 0x71E4, 0x71F0, 0x71E2, 0x7373,
	0x736E, 0x736F, 0x7497, 0x74B2, 0x74AB, 0x7490, 0x74AA, 0x74AD,
	0x74B1, 0x74A5, 0x74AF, 0x7510, 0x7511, 0x7512, 0x750F, 0x7584,
	0x7643, 0x7648, 0x7649, 0x7647, 0x76A4, 0x76E9, 0x77B5, 0x77AB,
	0x77B2, 0x77B7, 0x77B6, 0x77B4, 0x77B1, 0x77A8, 0x77F0, 0x78F3,
	0x78FD, 0x7902, 0x78FB, 0x78FC, 0x78FF, 0x78F2, 0x7905, 0x78F9,
	0x78FE, 0x7904, 0x79AB, 0x79A8, 0x7A5C, 0x7A5B, 0x7A56, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_5E = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x7A58, 0x7A54, 0x7A5A, 0x7ABE, 0x7AC0, 0x7AC1, 0x7C05,
	0x7C0F, 0x7BF2, 0x7C00, 0x7BFF, 0x7BFB, 0x7C0E, 0x7BF4, 0x7C0B,
	0x7BF3, 0x7C02, 0x7C09, 0x7C03, 0x7C01, 0x7BF8, 0x7BFD, 0x7C06,
	0x7BF0, 0x7BF1, 0x7C10, 0x7C0A, 0x7CE8, 0x7E2D, 0x7E3C, 0x7E42,
	0x7E33, 0x9848, 0x7E38, 0x7E2A, 0x7E49, 0x7E40, 0x7E47, 0x7E29,
	0x7E4C, 0x7E30, 0x7E3B, 0x7E36, 0x7E44, 0x7E3A, 0x7F45, 0x7F7F,
	0x7F7E, 0x7F7D, 0x7FF4, 0x7FF2, 0x802C, 0x81BB, 0x81C4, 0x81CC,
	0x81CA, 0x81C5, 0x81C7, 0x81BC, 0x81E9, 0x825B, 0x825A, 0x825C,
	0x8583, 0x8580, 0x858F, 0x85A7, 0x8595, 0x85A0, 0x858B, 0x85A3,
	0x857B, 0x85A4, 0x859A, 0x859E, 0x8577, 0x857C, 0x8589, 0x85A1,
	0x857A, 0x8578, 0x8557, 0x858E, 0x8596, 0x8586, 0x858D, 0x8599,
	0x859D, 0x8581, 0x85A2, 0x8582, 0x8588, 0x8585, 0x8579, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_5F = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x8576, 0x8598, 0x8590, 0x859F, 0x8668, 0x87BE, 0x87AA,
	0x87AD, 0x87C5, 0x87B0, 0x87AC, 0x87B9, 0x87B5, 0x87BC, 0x87AE,
	0x87C9, 0x87C3, 0x87C2, 0x87CC, 0x87B7, 0x87AF, 0x87C4, 0x87CA,
	0x87B4, 0x87B6, 0x87BF, 0x87B8, 0x87BD, 0x87DE, 0x87B2, 0x8935,
	0x8933, 0x893C, 0x893E, 0x8941, 0x8952, 0x8937, 0x8942, 0x89AD,
	0x89AF, 0x89AE, 0x89F2, 0x89F3, 0x8B1E, 0x8B18, 0x8B16, 0x8B11,
	0x8B05, 0x8B0B, 0x8B22, 0x8B0F, 0x8B12, 0x8B15, 0x8B07, 0x8B0D,
	0x8B08, 0x8B06, 0x8B1C, 0x8B13, 0x8B1A, 0x8C4F, 0x8C70, 0x8C72,
	0x8C71, 0x8C6F, 0x8C95, 0x8C94, 0x8CF9, 0x8D6F, 0x8E4E, 0x8E4D,
	0x8E53, 0x8E50, 0x8E4C, 0x8E47, 0x8F43, 0x8F40, 0x9085, 0x907E,
	0x9138, 0x919A, 0x91A2, 0x919B, 0x9199, 0x919F, 0x91A1, 0x919D,
	0x91A0, 0x93A1, 0x9383, 0x93AF, 0x9364, 0x9356, 0x9347, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_60 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x937C, 0x9358, 0x935C, 0x9376, 0x9349, 0x9350, 0x9351,
	0x9360, 0x936D, 0x938F, 0x934C, 0x936A, 0x9379, 0x9357, 0x9355,
	0x9352, 0x934F, 0x9371, 0x9377, 0x937B, 0x9361, 0x935E, 0x9363,
	0x9367, 0x934E, 0x9359, 0x95C7, 0x95C0, 0x95C9, 0x95C3, 0x95C5,
	0x95B7, 0x96AE, 0x96B0, 0x96AC, 0x9720, 0x971F, 0x9718, 0x971D,
	0x9719, 0x979A, 0x97A1, 0x979C, 0x979E, 0x979D, 0x97D5, 0x97D4,
	0x97F1, 0x9841, 0x9844, 0x984A, 0x9849, 0x9845, 0x9843, 0x9925,
	0x992B, 0x992C, 0x992A, 0x9933, 0x9932, 0x992F, 0x992D, 0x9931,
	0x9930, 0x9998, 0x99A3, 0x99A1, 0x9A02, 0x99FA, 0x99F4, 0x99F7,
	0x99F9, 0x99F8, 0x99F6, 0x99FB, 0x99FD, 0x99FE, 0x99FC, 0x9A03,
	0x9ABE, 0x9AFE, 0x9AFD, 0x9B01, 0x9AFC, 0x9B48, 0x9B9A, 0x9BA8,
	0x9B9E, 0x9B9B, 0x9BA6, 0x9BA1, 0x9BA5, 0x9BA4, 0x9B86, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_61 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x9BA2, 0x9BA0, 0x9BAF, 0x9D33, 0x9D41, 0x9D67, 0x9D36,
	0x9D2E, 0x9D2F, 0x9D31, 0x9D38, 0x9D30, 0x9D45, 0x9D42, 0x9D43,
	0x9D3E, 0x9D37, 0x9D40, 0x9D3D, 0x7FF5, 0x9D2D, 0x9E8A, 0x9E89,
	0x9E8D, 0x9EB0, 0x9EC8, 0x9EDA, 0x9EFB, 0x9EFF, 0x9F24, 0x9F23,
	0x9F22, 0x9F54, 0x9FA0, 0x5131, 0x512D, 0x512E, 0x5698, 0x569C,
	0x5697, 0x569A, 0x569D, 0x5699, 0x5970, 0x5B3C, 0x5C69, 0x5C6A,
	0x5DC0, 0x5E6D, 0x5E6E, 0x61D8, 0x61DF, 0x61ED, 0x61EE, 0x61F1,
	0x61EA, 0x61F0, 0x61EB, 0x61D6, 0x61E9, 0x64FF, 0x6504, 0x64FD,
	0x64F8, 0x6501, 0x6503, 0x64FC, 0x6594, 0x65DB, 0x66DA, 0x66DB,
	0x66D8, 0x6AC5, 0x6AB9, 0x6ABD, 0x6AE1, 0x6AC6, 0x6ABA, 0x6AB6,
	0x6AB7, 0x6AC7, 0x6AB4, 0x6AAD, 0x6B5E, 0x6BC9, 0x6C0B, 0x7007,
	0x700C, 0x700D, 0x7001, 0x7005, 0x7014, 0x700E, 0x6FFF, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_62 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x7000, 0x6FFB, 0x7026, 0x6FFC, 0x6FF7, 0x700A, 0x7201,
	0x71FF, 0x71F9, 0x7203, 0x71FD, 0x7376, 0x74B8, 0x74C0, 0x74B5,
	0x74C1, 0x74BE, 0x74B6, 0x74BB, 0x74C2, 0x7514, 0x7513, 0x765C,
	0x7664, 0x7659, 0x7650, 0x7653, 0x7657, 0x765A, 0x76A6, 0x76BD,
	0x76EC, 0x77C2, 0x77BA, 0x790C, 0x7913, 0x7914, 0x7909, 0x7910,
	0x7912, 0x7911, 0x79AD, 0x79AC, 0x7A5F, 0x7C1C, 0x7C29, 0x7C19,
	0x7C20, 0x7C1F, 0x7C2D, 0x7C1D, 0x7C26, 0x7C28, 0x7C22, 0x7C25,
	0x7C30, 0x7E5C, 0x7E50, 0x7E56, 0x7E63, 0x7E58, 0x7E62, 0x7E5F,
	0x7E51, 0x7E60, 0x7E57, 0x7E53, 0x7FB5, 0x7FB3, 0x7FF7, 0x7FF8,
	0x8075, 0x81D1, 0x81D2, 0x81D0, 0x825F, 0x825E, 0x85B4, 0x85C6,
	0x85C0, 0x85C3, 0x85C2, 0x85B3, 0x85B5, 0x85BD, 0x85C7, 0x85C4,
	0x85BF, 0x85CB, 0x85CE, 0x85C8, 0x85C5, 0x85B1, 0x85B6, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_63 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x85D2, 0x8624, 0x85B8, 0x85B7, 0x85BE, 0x8669, 0x87E7,
	0x87E6, 0x87E2, 0x87DB, 0x87EB, 0x87EA, 0x87E5, 0x87DF, 0x87F3,
	0x87E4, 0x87D4, 0x87DC, 0x87D3, 0x87ED, 0x87D8, 0x87E3, 0x87D7,
	0x87D9, 0x8801, 0x87F4, 0x87E8, 0x87DD, 0x8953, 0x894B, 0x894F,
	0x894C, 0x8946, 0x8950, 0x8951, 0x8949, 0x8B2A, 0x8B27, 0x8B23,
	0x8B33, 0x8B30, 0x8B35, 0x8B47, 0x8B2F, 0x8B3C, 0x8B3E, 0x8B31,
	0x8B25, 0x8B37, 0x8B26, 0x8B36, 0x8B2E, 0x8B24, 0x8B3B, 0x8B3D,
	0x8B3A, 0x8C42, 0x8C75, 0x8C99, 0x8C98, 0x8C97, 0x8CFE, 0x8D04,
	0x8D02, 0x8D00, 0x8E5C, 0x8E62, 0x8E60, 0x8E57, 0x8E56, 0x8E5E,
	0x8E65, 0x8E67, 0x8E5B, 0x8E5A, 0x8E61, 0x8E5D, 0x8E69, 0x8E54,
	0x8F46, 0x8F47, 0x8F48, 0x8F4B, 0x9128, 0x913A, 0x913B, 0x913E,
	0x91A8, 0x91A5, 0x91A7, 0x91AF, 0x91AA, 0x93B5, 0x938C, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_64 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x9392, 0x93B7, 0x939B, 0x939D, 0x9389, 0x93A7, 0x938E,
	0x93AA, 0x939E, 0x93A6, 0x9395, 0x9388, 0x9399, 0x939F, 0x9380,
	0x938D, 0x93B1, 0x9391, 0x93B2, 0x93A4, 0x93A8, 0x93B4, 0x93A3,
	0x95D2, 0x95D3, 0x95D1, 0x96B3, 0x96D7, 0x96DA, 0x5DC2, 0x96DF,
	0x96D8, 0x96DD, 0x9723, 0x9722, 0x9725, 0x97AC, 0x97AE, 0x97A8,
	0x97AB, 0x97A4, 0x97AA, 0x97A2, 0x97A5, 0x97D7, 0x97D9, 0x97D6,
	0x97D8, 0x97FA, 0x9850, 0x9851, 0x9852, 0x98B8, 0x9941, 0x993C,
	0x993A, 0x9A0F, 0x9A0B, 0x9A09, 0x9A0D, 0x9A04, 0x9A11, 0x9A0A,
	0x9A05, 0x9A07, 0x9A06, 0x9AC0, 0x9ADC, 0x9B08, 0x9B04, 0x9B05,
	0x9B29, 0x9B35, 0x9B4A, 0x9B4C, 0x9B4B, 0x9BC7, 0x9BC6, 0x9BC3,
	0x9BBF, 0x9BC1, 0x9BB5, 0x9BB8, 0x9BD3, 0x9BB6, 0x9BC4, 0x9BB9,
	0x9BBD, 0x9D5C, 0x9D53, 0x9D4F, 0x9D4A, 0x9D5B, 0x9D4B, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_65 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x9D59, 0x9D56, 0x9D4C, 0x9D57, 0x9D52, 0x9D54, 0x9D5F,
	0x9D58, 0x9D5A, 0x9E8E, 0x9E8C, 0x9EDF, 0x9F01, 0x9F00, 0x9F16,
	0x9F25, 0x9F2B, 0x9F2A, 0x9F29, 0x9F28, 0x9F4C, 0x9F55, 0x5134,
	0x5135, 0x5296, 0x52F7, 0x53B4, 0x56AB, 0x56AD, 0x56A6, 0x56A7,
	0x56AA, 0x56AC, 0x58DA, 0x58DD, 0x58DB, 0x5912, 0x5B3D, 0x5B3E,
	0x5B3F, 0x5DC3, 0x5E70, 0x5FBF, 0x61FB, 0x6507, 0x6510, 0x650D,
	0x6509, 0x650C, 0x650E, 0x6584, 0x65DE, 0x65DD, 0x66DE, 0x6AE7,
	0x6AE0, 0x6ACC, 0x6AD1, 0x6AD9, 0x6ACB, 0x6ADF, 0x6ADC, 0x6AD0,
	0x6AEB, 0x6ACF, 0x6ACD, 0x6ADE, 0x6B60, 0x6BB0, 0x6C0C, 0x7019,
	0x7027, 0x7020, 0x7016, 0x702B, 0x7021, 0x7022, 0x7023, 0x7029,
	0x7017, 0x7024, 0x701C, 0x720C, 0x720A, 0x7207, 0x7202, 0x7205,
	0x72A5, 0x72A6, 0x72A4, 0x72A3, 0x72A1, 0x74CB, 0x74C5, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_66 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x74B7, 0x74C3, 0x7516, 0x7660, 0x77C9, 0x77CA, 0x77C4,
	0x77F1, 0x791D, 0x791B, 0x7921, 0x791C, 0x7917, 0x791E, 0x79B0,
	0x7A67, 0x7A68, 0x7C33, 0x7C3C, 0x7C39, 0x7C2C, 0x7C3B, 0x7CEC,
	0x7CEA, 0x7E76, 0x7E75, 0x7E78, 0x7E70, 0x7E77, 0x7E6F, 0x7E7A,
	0x7E72, 0x7E74, 0x7E68, 0x7F4B, 0x7F4A, 0x7F83, 0x7F86, 0x7FB7,
	0x7FFD, 0x7FFE, 0x8078, 0x81D7, 0x81D5, 0x820B, 0x8264, 0x8261,
	0x8263, 0x85EB, 0x85F1, 0x85ED, 0x85D9, 0x85E1, 0x85E8, 0x85DA,
	0x85D7, 0x85EC, 0x85F2, 0x85F8, 0x85D8, 0x85DF, 0x85E3, 0x85DC,
	0x85D1, 0x85F0, 0x85E6, 0x85EF, 0x85DE, 0x85E2, 0x8800, 0x87FA,
	0x8803, 0x87F6, 0x87F7, 0x8809, 0x880C, 0x880B, 0x8806, 0x87FC,
	0x8808, 0x87FF, 0x880A, 0x8802, 0x8962, 0x895A, 0x895B, 0x8957,
	0x8961, 0x895C, 0x8958, 0x895D, 0x8959, 0x8988, 0x89B7, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_67 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x89B6, 0x89F6, 0x8B50, 0x8B48, 0x8B4A, 0x8B40, 0x8B53,
	0x8B56, 0x8B54, 0x8B4B, 0x8B55, 0x8B51, 0x8B42, 0x8B52, 0x8B57,
	0x8C43, 0x8C77, 0x8C76, 0x8C9A, 0x8D06, 0x8D07, 0x8D09, 0x8DAC,
	0x8DAA, 0x8DAD, 0x8DAB, 0x8E6D, 0x8E78, 0x8E73, 0x8E6A, 0x8E6F,
	0x8E7B, 0x8EC2, 0x8F52, 0x8F51, 0x8F4F, 0x8F50, 0x8F53, 0x8FB4,
	0x9140, 0x913F, 0x91B0, 0x91AD, 0x93DE, 0x93C7, 0x93CF, 0x93C2,
	0x93DA, 0x93D0, 0x93F9, 0x93EC, 0x93CC, 0x93D9, 0x93A9, 0x93E6,
	0x93CA, 0x93D4, 0x93EE, 0x93E3, 0x93D5, 0x93C4, 0x93CE, 0x93C0,
	0x93D2, 0x93A5, 0x93E7, 0x957D, 0x95DA, 0x95DB, 0x96E1, 0x9729,
	0x972B, 0x972C, 0x9728, 0x9726, 0x97B3, 0x97B7, 0x97B6, 0x97DD,
	0x97DE, 0x97DF, 0x985C, 0x9859, 0x985D, 0x9857, 0x98BF, 0x98BD,
	0x98BB, 0x98BE, 0x9948, 0x9947, 0x9943, 0x99A6, 0x99A7, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_68 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x9A1A, 0x9A15, 0x9A25, 0x9A1D, 0x9A24, 0x9A1B, 0x9A22,
	0x9A20, 0x9A27, 0x9A23, 0x9A1E, 0x9A1C, 0x9A14, 0x9AC2, 0x9B0B,
	0x9B0A, 0x9B0E, 0x9B0C, 0x9B37, 0x9BEA, 0x9BEB, 0x9BE0, 0x9BDE,
	0x9BE4, 0x9BE6, 0x9BE2, 0x9BF0, 0x9BD4, 0x9BD7, 0x9BEC, 0x9BDC,
	0x9BD9, 0x9BE5, 0x9BD5, 0x9BE1, 0x9BDA, 0x9D77, 0x9D81, 0x9D8A,
	0x9D84, 0x9D88, 0x9D71, 0x9D80, 0x9D78, 0x9D86, 0x9D8B, 0x9D8C,
	0x9D7D, 0x9D6B, 0x9D74, 0x9D75, 0x9D70, 0x9D69, 0x9D85, 0x9D73,
	0x9D7B, 0x9D82, 0x9D6F, 0x9D79, 0x9D7F, 0x9D87, 0x9D68, 0x9E94,
	0x9E91, 0x9EC0, 0x9EFC, 0x9F2D, 0x9F40, 0x9F41, 0x9F4D, 0x9F56,
	0x9F57, 0x9F58, 0x5337, 0x56B2, 0x56B5, 0x56B3, 0x58E3, 0x5B45,
	0x5DC6, 0x5DC7, 0x5EEE, 0x5EEF, 0x5FC0, 0x5FC1, 0x61F9, 0x6517,
	0x6516, 0x6515, 0x6513, 0x65DF, 0x66E8, 0x66E3, 0x66E4, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_69 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x6AF3, 0x6AF0, 0x6AEA, 0x6AE8, 0x6AF9, 0x6AF1, 0x6AEE,
	0x6AEF, 0x703C, 0x7035, 0x702F, 0x7037, 0x7034, 0x7031, 0x7042,
	0x7038, 0x703F, 0x703A, 0x7039, 0x702A, 0x7040, 0x703B, 0x7033,
	0x7041, 0x7213, 0x7214, 0x72A8, 0x737D, 0x737C, 0x74BA, 0x76AB,
	0x76AA, 0x76BE, 0x76ED, 0x77CC, 0x77CE, 0x77CF, 0x77CD, 0x77F2,
	0x7925, 0x7923, 0x7927, 0x7928, 0x7924, 0x7929, 0x79B2, 0x7A6E,
	0x7A6C, 0x7A6D, 0x7AF7, 0x7C49, 0x7C48, 0x7C4A, 0x7C47, 0x7C45,
	0x7CEE, 0x7E7B, 0x7E7E, 0x7E81, 0x7E80, 0x7FBA, 0x7FFF, 0x8079,
	0x81DB, 0x81D9, 0x8268, 0x8269, 0x8622, 0x85FF, 0x8601, 0x85FE,
	0x861B, 0x8600, 0x85F6, 0x8604, 0x8609, 0x8605, 0x860C, 0x85FD,
	0x8819, 0x8810, 0x8811, 0x8817, 0x8813, 0x8816, 0x8963, 0x8966,
	0x89B9, 0x89F7, 0x8B60, 0x8B6A, 0x8B5D, 0x8B68, 0x8B63, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_6A = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x8B65, 0x8B67, 0x8B6D, 0x8DAE, 0x8E86, 0x8E88, 0x8E84,
	0x8F59, 0x8F56, 0x8F57, 0x8F55, 0x8F58, 0x8F5A, 0x908D, 0x9143,
	0x9141, 0x91B7, 0x91B5, 0x91B2, 0x91B3, 0x940B, 0x9413, 0x93FB,
	0x9420, 0x940F, 0x9414, 0x93FE, 0x9415, 0x9410, 0x9428, 0x9419,
	0x940D, 0x93F5, 0x9400, 0x93F7, 0x9407, 0x940E, 0x9416, 0x9412,
	0x93FA, 0x9409, 0x93F8, 0x943C, 0x940A, 0x93FF, 0x93FC, 0x940C,
	0x93F6, 0x9411, 0x9406, 0x95DE, 0x95E0, 0x95DF, 0x972E, 0x972F,
	0x97B9, 0x97BB, 0x97FD, 0x97FE, 0x9860, 0x9862, 0x9863, 0x985F,
	0x98C1, 0x98C2, 0x9950, 0x994E, 0x9959, 0x994C, 0x994B, 0x9953,
	0x9A32, 0x9A34, 0x9A31, 0x9A2C, 0x9A2A, 0x9A36, 0x9A29, 0x9A2E,
	0x9A38, 0x9A2D, 0x9AC7, 0x9ACA, 0x9AC6, 0x9B10, 0x9B12, 0x9B11,
	0x9C0B, 0x9C08, 0x9BF7, 0x9C05, 0x9C12, 0x9BF8, 0x9C40, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_6B = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x9C07, 0x9C0E, 0x9C06, 0x9C17, 0x9C14, 0x9C09, 0x9D9F,
	0x9D99, 0x9DA4, 0x9D9D, 0x9D92, 0x9D98, 0x9D90, 0x9D9B, 0x9DA0,
	0x9D94, 0x9D9C, 0x9DAA, 0x9D97, 0x9DA1, 0x9D9A, 0x9DA2, 0x9DA8,
	0x9D9E, 0x9DA3, 0x9DBF, 0x9DA9, 0x9D96, 0x9DA6, 0x9DA7, 0x9E99,
	0x9E9B, 0x9E9A, 0x9EE5, 0x9EE4, 0x9EE7, 0x9EE6, 0x9F30, 0x9F2E,
	0x9F5B, 0x9F60, 0x9F5E, 0x9F5D, 0x9F59, 0x9F91, 0x513A, 0x5139,
	0x5298, 0x5297, 0x56C3, 0x56BD, 0x56BE, 0x5B48, 0x5B47, 0x5DCB,
	0x5DCF, 0x5EF1, 0x61FD, 0x651B, 0x6B02, 0x6AFC, 0x6B03, 0x6AF8,
	0x6B00, 0x7043, 0x7044, 0x704A, 0x7048, 0x7049, 0x7045, 0x7046,
	0x721D, 0x721A, 0x7219, 0x737E, 0x7517, 0x766A, 0x77D0, 0x792D,
	0x7931, 0x792F, 0x7C54, 0x7C53, 0x7CF2, 0x7E8A, 0x7E87, 0x7E88,
	0x7E8B, 0x7E86, 0x7E8D, 0x7F4D, 0x7FBB, 0x8030, 0x81DD, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_6C = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x8618, 0x862A, 0x8626, 0x861F, 0x8623, 0x861C, 0x8619,
	0x8627, 0x862E, 0x8621, 0x8620, 0x8629, 0x861E, 0x8625, 0x8829,
	0x881D, 0x881B, 0x8820, 0x8824, 0x881C, 0x882B, 0x884A, 0x896D,
	0x8969, 0x896E, 0x896B, 0x89FA, 0x8B79, 0x8B78, 0x8B45, 0x8B7A,
	0x8B7B, 0x8D10, 0x8D14, 0x8DAF, 0x8E8E, 0x8E8C, 0x8F5E, 0x8F5B,
	0x8F5D, 0x9146, 0x9144, 0x9145, 0x91B9, 0x943F, 0x943B, 0x9436,
	0x9429, 0x943D, 0x9430, 0x9439, 0x942A, 0x9437, 0x942C, 0x9440,
	0x9431, 0x95E5, 0x95E4, 0x95E3, 0x9735, 0x973A, 0x97BF, 0x97E1,
	0x9864, 0x98C9, 0x98C6, 0x98C0, 0x9958, 0x9956, 0x9A39, 0x9A3D,
	0x9A46, 0x9A44, 0x9A42, 0x9A41, 0x9A3A, 0x9A3F, 0x9ACD, 0x9B15,
	0x9B17, 0x9B18, 0x9B16, 0x9B3A, 0x9B52, 0x9C2B, 0x9C1D, 0x9C1C,
	0x9C2C, 0x9C23, 0x9C28, 0x9C29, 0x9C24, 0x9C21, 0x9DB7, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_6D = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x9DB6, 0x9DBC, 0x9DC1, 0x9DC7, 0x9DCA, 0x9DCF, 0x9DBE,
	0x9DC5, 0x9DC3, 0x9DBB, 0x9DB5, 0x9DCE, 0x9DB9, 0x9DBA, 0x9DAC,
	0x9DC8, 0x9DB1, 0x9DAD, 0x9DCC, 0x9DB3, 0x9DCD, 0x9DB2, 0x9E7A,
	0x9E9C, 0x9EEB, 0x9EEE, 0x9EED, 0x9F1B, 0x9F18, 0x9F1A, 0x9F31,
	0x9F4E, 0x9F65, 0x9F64, 0x9F92, 0x4EB9, 0x56C6, 0x56C5, 0x56CB,
	0x5971, 0x5B4B, 0x5B4C, 0x5DD5, 0x5DD1, 0x5EF2, 0x6521, 0x6520,
	0x6526, 0x6522, 0x6B0B, 0x6B08, 0x6B09, 0x6C0D, 0x7055, 0x7056,
	0x7057, 0x7052, 0x721E, 0x721F, 0x72A9, 0x737F, 0x74D8, 0x74D5,
	0x74D9, 0x74D7, 0x766D, 0x76AD, 0x7935, 0x79B4, 0x7A70, 0x7A71,
	0x7C57, 0x7C5C, 0x7C59, 0x7C5B, 0x7C5A, 0x7CF4, 0x7CF1, 0x7E91,
	0x7F4F, 0x7F87, 0x81DE, 0x826B, 0x8634, 0x8635, 0x8633, 0x862C,
	0x8632, 0x8636, 0x882C, 0x8828, 0x8826, 0x882A, 0x8825, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_6E = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x8971, 0x89BF, 0x89BE, 0x89FB, 0x8B7E, 0x8B84, 0x8B82,
	0x8B86, 0x8B85, 0x8B7F, 0x8D15, 0x8E95, 0x8E94, 0x8E9A, 0x8E92,
	0x8E90, 0x8E96, 0x8E97, 0x8F60, 0x8F62, 0x9147, 0x944C, 0x9450,
	0x944A, 0x944B, 0x944F, 0x9447, 0x9445, 0x9448, 0x9449, 0x9446,
	0x973F, 0x97E3, 0x986A, 0x9869, 0x98CB, 0x9954, 0x995B, 0x9A4E,
	0x9A53, 0x9A54, 0x9A4C, 0x9A4F, 0x9A48, 0x9A4A, 0x9A49, 0x9A52,
	0x9A50, 0x9AD0, 0x9B19, 0x9B2B, 0x9B3B, 0x9B56, 0x9B55, 0x9C46,
	0x9C48, 0x9C3F, 0x9C44, 0x9C39, 0x9C33, 0x9C41, 0x9C3C, 0x9C37,
	0x9C34, 0x9C32, 0x9C3D, 0x9C36, 0x9DDB, 0x9DD2, 0x9DDE, 0x9DDA,
	0x9DCB, 0x9DD0, 0x9DDC, 0x9DD1, 0x9DDF, 0x9DE9, 0x9DD9, 0x9DD8,
	0x9DD6, 0x9DF5, 0x9DD5, 0x9DDD, 0x9EB6, 0x9EF0, 0x9F35, 0x9F33,
	0x9F32, 0x9F42, 0x9F6B, 0x9F95, 0x9FA2, 0x513D, 0x5299, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_6F = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x58E8, 0x58E7, 0x5972, 0x5B4D, 0x5DD8, 0x882F, 0x5F4F,
	0x6201, 0x6203, 0x6204, 0x6529, 0x6525, 0x6596, 0x66EB, 0x6B11,
	0x6B12, 0x6B0F, 0x6BCA, 0x705B, 0x705A, 0x7222, 0x7382, 0x7381,
	0x7383, 0x7670, 0x77D4, 0x7C67, 0x7C66, 0x7E95, 0x826C, 0x863A,
	0x8640, 0x8639, 0x863C, 0x8631, 0x863B, 0x863E, 0x8830, 0x8832,
	0x882E, 0x8833, 0x8976, 0x8974, 0x8973, 0x89FE, 0x8B8C, 0x8B8E,
	0x8B8B, 0x8B88, 0x8C45, 0x8D19, 0x8E98, 0x8F64, 0x8F63, 0x91BC,
	0x9462, 0x9455, 0x945D, 0x9457, 0x945E, 0x97C4, 0x97C5, 0x9800,
	0x9A56, 0x9A59, 0x9B1E, 0x9B1F, 0x9B20, 0x9C52, 0x9C58, 0x9C50,
	0x9C4A, 0x9C4D, 0x9C4B, 0x9C55, 0x9C59, 0x9C4C, 0x9C4E, 0x9DFB,
	0x9DF7, 0x9DEF, 0x9DE3, 0x9DEB, 0x9DF8, 0x9DE4, 0x9DF6, 0x9DE1,
	0x9DEE, 0x9DE6, 0x9DF2, 0x9DF0, 0x9DE2, 0x9DEC, 0x9DF4, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_70 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x9DF3, 0x9DE8, 0x9DED, 0x9EC2, 0x9ED0, 0x9EF2, 0x9EF3,
	0x9F06, 0x9F1C, 0x9F38, 0x9F37, 0x9F36, 0x9F43, 0x9F4F, 0x9F71,
	0x9F70, 0x9F6E, 0x9F6F, 0x56D3, 0x56CD, 0x5B4E, 0x5C6D, 0x652D,
	0x66ED, 0x66EE, 0x6B13, 0x705F, 0x7061, 0x705D, 0x7060, 0x7223,
	0x74DB, 0x74E5, 0x77D5, 0x7938, 0x79B7, 0x79B6, 0x7C6A, 0x7E97,
	0x7F89, 0x826D, 0x8643, 0x8838, 0x8837, 0x8835, 0x884B, 0x8B94,
	0x8B95, 0x8E9E, 0x8E9F, 0x8EA0, 0x8E9D, 0x91BE, 0x91BD, 0x91C2,
	0x946B, 0x9468, 0x9469, 0x96E5, 0x9746, 0x9743, 0x9747, 0x97C7,
	0x97E5, 0x9A5E, 0x9AD5, 0x9B59, 0x9C63, 0x9C67, 0x9C66, 0x9C62,
	0x9C5E, 0x9C60, 0x9E02, 0x9DFE, 0x9E07, 0x9E03, 0x9E06, 0x9E05,
	0x9E00, 0x9E01, 0x9E09, 0x9DFF, 0x9DFD, 0x9E04, 0x9EA0, 0x9F1E,
	0x9F46, 0x9F74, 0x9F75, 0x9F76, 0x56D4, 0x652E, 0x65B8, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_71 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x6B18, 0x6B19, 0x6B17, 0x6B1A, 0x7062, 0x7226, 0x72AA,
	0x77D8, 0x77D9, 0x7939, 0x7C69, 0x7C6B, 0x7CF6, 0x7E9A, 0x7E98,
	0x7E9B, 0x7E99, 0x81E0, 0x81E1, 0x8646, 0x8647, 0x8648, 0x8979,
	0x897A, 0x897C, 0x897B, 0x89FF, 0x8B98, 0x8B99, 0x8EA5, 0x8EA4,
	0x8EA3, 0x946E, 0x946D, 0x946F, 0x9471, 0x9473, 0x9749, 0x9872,
	0x995F, 0x9C68, 0x9C6E, 0x9C6D, 0x9E0B, 0x9E0D, 0x9E10, 0x9E0F,
	0x9E12, 0x9E11, 0x9EA1, 0x9EF5, 0x9F09, 0x9F47, 0x9F78, 0x9F7B,
	0x9F7A, 0x9F79, 0x571E, 0x7066, 0x7C6F, 0x883C, 0x8DB2, 0x8EA6,
	0x91C3, 0x9474, 0x9478, 0x9476, 0x9475, 0x9A60, 0x9B2E, 0x9C74,
	0x9C73, 0x9C71, 0x9C75, 0x9E14, 0x9E13, 0x9EF6, 0x9F0A, 0x9FA4,
	0x7068, 0x7065, 0x7CF7, 0x866A, 0x883E, 0x883D, 0x883F, 0x8B9E,
	0x8C9C, 0x8EA9, 0x8EC9, 0x974B, 0x9873, 0x9874, 0x98CC, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_72 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x9961, 0x99AB, 0x9A64, 0x9A66, 0x9A67, 0x9B24, 0x9E15,
	0x9E17, 0x9F48, 0x6207, 0x6B1E, 0x7227, 0x864C, 0x8EA8, 0x9482,
	0x9480, 0x9481, 0x9A69, 0x9A68, 0x9E19, 0x864B, 0x8B9F, 0x9483,
	0x9C79, 0x9EB7, 0x7675, 0x9A6B, 0x9C7A, 0x9E1D, 0x7069, 0x706A,
	0x7229, 0x9EA4, 0x9F7E, 0x9F49, 0x9F98, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_14bit to_ucs = { {
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	NULL, &to_ucs_21, &to_ucs_22, &to_ucs_23, &to_ucs_24, &to_ucs_25, &to_ucs_26, &to_ucs_27,
	&to_ucs_28, &to_ucs_29, &to_ucs_2A, &to_ucs_2B, &to_ucs_2C, &to_ucs_2D, &to_ucs_2E, &to_ucs_2F,
	&to_ucs_30, &to_ucs_31, &to_ucs_32, &to_ucs_33, &to_ucs_34, &to_ucs_35, &to_ucs_36, &to_ucs_37,
	&to_ucs_38, &to_ucs_39, &to_ucs_3A, &to_ucs_3B, &to_ucs_3C, &to_ucs_3D, &to_ucs_3E, &to_ucs_3F,
	&to_ucs_40, &to_ucs_41, &to_ucs_42, &to_ucs_43, &to_ucs_44, &to_ucs_45, &to_ucs_46, &to_ucs_47,
	&to_ucs_48, &to_ucs_49, &to_ucs_4A, &to_ucs_4B, &to_ucs_4C, &to_ucs_4D, &to_ucs_4E, &to_ucs_4F,
	&to_ucs_50, &to_ucs_51, &to_ucs_52, &to_ucs_53, &to_ucs_54, &to_ucs_55, &to_ucs_56, &to_ucs_57,
	&to_ucs_58, &to_ucs_59, &to_ucs_5A, &to_ucs_5B, &to_ucs_5C, &to_ucs_5D, &to_ucs_5E, &to_ucs_5F,
	&to_ucs_60, &to_ucs_61, &to_ucs_62, &to_ucs_63, &to_ucs_64, &to_ucs_65, &to_ucs_66, &to_ucs_67,
	&to_ucs_68, &to_ucs_69, &to_ucs_6A, &to_ucs_6B, &to_ucs_6C, &to_ucs_6D, &to_ucs_6E, &to_ucs_6F,
	&to_ucs_70, &to_ucs_71, &to_ucs_72, NULL, NULL, NULL, NULL, NULL,
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL
} };

static const iconv_ccs_convtable_8bit from_ucs_4E = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2126,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2127, 0xFFFE, 0x212F, 0x212D,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2130, 0xFFFE,
	0xFFFE, 0x2143, 0xFFFE, 0x2531, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2144, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x2121, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2128,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2122, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x334E,
	0xFFFE, 0xFFFE, 0xFFFE, 0x4156, 0x4157, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2129, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x2131, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4158, 0xFFFE,
	0xFFFE, 0x6D44, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x2132, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x2134, 0x2133, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x214A, 0xFFFE, 0x2146, 0x2149, 0xFFFE, 0xFFFE,
	0xFFFE, 0x2148, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x2145, 0x2147, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x216F, 0xFFFE, 0xFFFE, 0x2179, 0x216D, 0xFFFE, 0x2171,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_4F = { {
	0x2170, 0xFFFE, 0x2174, 0xFFFE, 0x2178, 0x2175, 0xFFFE, 0xFFFE,
	0x2172, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x216A, 0xFFFE,
	0xFFFE, 0xFFFE, 0x217A, 0x2177, 0x216E, 0xFFFE, 0xFFFE, 0xFFFE,
	0x216B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2173, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x2176, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x216C, 0x2328, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x2329, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x227B, 0xFFFE, 0xFFFE, 0x2322, 0x232A,
	0xFFFE, 0x2326, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x227D, 0xFFFE, 0xFFFE, 0x253D, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x2324, 0x227E, 0xFFFE, 0xFFFE, 0x227A, 0xFFFE,
	0x2327, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2325,
	0xFFFE, 0x232B, 0x227C, 0xFFFE, 0x2321, 0xFFFE, 0xFFFE, 0x2323,
	0xFFFE, 0xFFFE, 0x253F, 0x254B, 0xFFFE, 0xFFFE, 0x254C, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2539, 0xFFFE, 0x2538, 0x253C,
	0x2543, 0x2541, 0xFFFE, 0xFFFE, 0x2533, 0x2535, 0xFFFE, 0xFFFE,
	0x2536, 0x2542, 0x2549, 0xFFFE, 0x253B, 0x2534, 0xFFFE, 0x2537,
	0xFFFE, 0x253A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x2544, 0xFFFE, 0x2548, 0xFFFE, 0x2546, 0x254A, 0xFFFE, 0x253E,
	0x2532, 0xFFFE, 0x2540, 0xFFFE, 0x2545, 0xFFFE, 0x2547, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x2922, 0x292A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x2930, 0x292E, 0x2929, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x292F, 0x2925, 0xFFFE, 0xFFFE, 0xFFFE, 0x287E, 0xFFFE, 0x292C,
	0xFFFE, 0x2923, 0xFFFE, 0x2924, 0xFFFE, 0x287D, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x2921, 0x2926, 0xFFFE, 0x292D, 0xFFFE,
	0xFFFE, 0x2928, 0xFFFE, 0x292B, 0x2927, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2931, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2D71, 0x2D70, 0x2D75, 0x2D76,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_50 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2D6A, 0xFFFE, 0x2D6B,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2D7E, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x2D6C, 0xFFFE, 0x335E, 0xFFFE, 0x2D77,
	0xFFFE, 0xFFFE, 0xFFFE, 0x2D6F, 0x2D78, 0xFFFE, 0x2D69, 0xFFFE,
	0x2D79, 0xFFFE, 0x2D6D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2D7A,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2D74, 0xFFFE, 0xFFFE, 0x2D7C,
	0x2D6E, 0x2D7D, 0xFFFE, 0x2D72, 0xFFFE, 0x2D7B, 0xFFFE, 0x2D73,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x3366, 0x335A, 0xFFFE, 0xFFFE, 0xFFFE, 0x335F, 0x3365, 0xFFFE,
	0x3358, 0xFFFE, 0x335C, 0x3355, 0xFFFE, 0x3359, 0xFFFE, 0xFFFE,
	0xFFFE, 0x336A, 0xFFFE, 0x3354, 0xFFFE, 0xFFFE, 0xFFFE, 0x3369,
	0xFFFE, 0xFFFE, 0xFFFE, 0x335B, 0xFFFE, 0x3356, 0x3352, 0x3360,
	0x3353, 0x3351, 0x335D, 0x3363, 0x3364, 0xFFFE, 0xFFFE, 0xFFFE,
	0x3A3F, 0x3361, 0x3350, 0x3362, 0xFFFE, 0xFFFE, 0x3367, 0xFFFE,
	0x334F, 0xFFFE, 0x3357, 0x3368, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x3A42, 0x3A3B, 0xFFFE, 0xFFFE, 0xFFFE, 0x3A43,
	0xFFFE, 0xFFFE, 0xFFFE, 0x3A39, 0x3A3C, 0xFFFE, 0x3A3D, 0xFFFE,
	0xFFFE, 0xFFFE, 0x3A41, 0xFFFE, 0x3A37, 0x3A36, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x3A35, 0x3A40, 0x3A3E, 0x3A38, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x3A3A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x415C, 0xFFFE,
	0x4162, 0x4165, 0xFFFE, 0xFFFE, 0x415F, 0xFFFE, 0x4168, 0xFFFE,
	0x4169, 0xFFFE, 0x4164, 0xFFFE, 0xFFFE, 0x4159, 0xFFFE, 0x415A,
	0xFFFE, 0x4163, 0x4161, 0xFFFE, 0x415D, 0xFFFE, 0x415B, 0xFFFE,
	0x4160, 0x4167, 0x415E, 0x4166, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x4921, 0x4877, 0xFFFE, 0xFFFE, 0x4878,
	0xFFFE, 0xFFFE, 0xFFFE, 0x487B, 0xFFFE, 0x487D, 0xFFFE, 0xFFFE,
	0x4926, 0xFFFE, 0xFFFE, 0x4925, 0x487E, 0xFFFE, 0x4876, 0xFFFE,
	0x4879, 0xFFFE, 0x487C, 0xFFFE, 0x4922, 0xFFFE, 0xFFFE, 0x4924,
	0x4923, 0xFFFE, 0xFFFE, 0x487A, 0xFFFE, 0xFFFE, 0x4F54, 0xFFFE,
	0x4F51, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4F58, 0x4F55, 0x4F4E
} };

static const iconv_ccs_convtable_8bit from_ucs_51 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0x4F4F, 0xFFFE, 0xFFFE, 0x4F52, 0x4F53,
	0xFFFE, 0xFFFE, 0x4F59, 0x4F56, 0x4F57, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5643, 0xFFFE, 0x5640, 0xFFFE, 0xFFFE, 0xFFFE, 0x5641,
	0xFFFE, 0xFFFE, 0x5642, 0xFFFE, 0x563F, 0xFFFE, 0xFFFE, 0xFFFE,
	0x5C49, 0xFFFE, 0x5C47, 0xFFFE, 0x5C48, 0x5C46, 0x5C45, 0xFFFE,
	0xFFFE, 0x5C4A, 0xFFFE, 0xFFFE, 0xFFFE, 0x6144, 0x6145, 0xFFFE,
	0x4F50, 0x6143, 0xFFFE, 0xFFFE, 0x6537, 0x6538, 0xFFFE, 0xFFFE,
	0xFFFE, 0x6B4F, 0x6B4E, 0xFFFE, 0xFFFE, 0x6E7D, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x2E21, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3A44,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x212E,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x232C,
	0xFFFE, 0xFFFE, 0xFFFE, 0x2E23, 0x2E22, 0xFFFE, 0xFFFE, 0xFFFE,
	0x2135, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x254D, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x217B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x232D, 0xFFFE, 0xFFFE, 0x254E, 0xFFFE, 0x254F, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2E25, 0x2E26, 0xFFFE, 0xFFFE,
	0x2E27, 0xFFFE, 0x2E24, 0xFFFE, 0xFFFE, 0xFFFE, 0x2E28, 0xFFFE,
	0x336B, 0xFFFE, 0xFFFE, 0xFFFE, 0x3A45, 0xFFFE, 0xFFFE, 0x416A,
	0x4927, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5644, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2123, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_52 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x214C, 0xFFFE, 0xFFFE, 0x214B, 0xFFFE, 0xFFFE, 0xFFFE,
	0x217D, 0xFFFE, 0xFFFE, 0x217C, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x232E, 0xFFFE, 0x232F, 0xFFFE,
	0xFFFE, 0x2330, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x2554, 0x2551, 0x2552, 0xFFFE, 0x2550, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2932, 0xFFFE, 0x2553, 0xFFFE,
	0xFFFE, 0x2933, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x2E2B, 0xFFFE, 0xFFFE, 0x2E2E, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x2E2A, 0xFFFE, 0xFFFE, 0xFFFE, 0x2E2C, 0x2E2D,
	0xFFFE, 0x2E29, 0x2E2F, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x336C, 0x336E, 0x336D, 0x336F, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x416C, 0xFFFE, 0x416B, 0x416D, 0x416E, 0xFFFE, 0xFFFE, 0xFFFE,
	0x4928, 0x4929, 0xFFFE, 0xFFFE, 0x4C61, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x4F5A, 0x4F5B, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6539, 0x6B51,
	0x6B50, 0x6E7E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x217E, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2331, 0x2332, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2555, 0xFFFE, 0xFFFE, 0xFFFE,
	0x2934, 0xFFFE, 0x2935, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2E30, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x3371, 0xFFFE, 0xFFFE, 0x3370, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x492A, 0xFFFE, 0x492B, 0xFFFE, 0xFFFE, 0xFFFE, 0x4F5D,
	0xFFFE, 0x4F5C, 0xFFFE, 0xFFFE, 0x5C4B, 0xFFFE, 0xFFFE, 0x653A,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2136, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_53 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x2333, 0x2556, 0x2557, 0xFFFE, 0xFFFE, 0x2E31, 0xFFFE,
	0xFFFE, 0x3A47, 0x3A46, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x2124, 0xFFFE, 0x214D, 0xFFFE, 0xFFFE, 0x2222,
	0xFFFE, 0xFFFE, 0x2221, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3372, 0xFFFE, 0xFFFE,
	0x492C, 0xFFFE, 0xFFFE, 0xFFFE, 0x5645, 0xFFFE, 0xFFFE, 0x686A,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2558, 0x2936, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x214E, 0x2223, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x2334, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2137, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x2335, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2937, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x2125, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x2224, 0xFFFE, 0xFFFE, 0xFFFE, 0x2336, 0x2337,
	0xFFFE, 0xFFFE, 0x2559, 0xFFFE, 0x255A, 0xFFFE, 0x2939, 0x2938,
	0x293B, 0x293A, 0xFFFE, 0xFFFE, 0x3373, 0xFFFE, 0x2E32, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3A48, 0xFFFE, 0xFFFE, 0x3A49,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x492D, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x653B, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x2138, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5646, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_54 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2225,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x2340, 0x233D, 0xFFFE, 0xFFFE, 0x233E, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2345, 0x233F, 0xFFFE, 0xFFFE,
	0x2344, 0xFFFE, 0x233A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x2338, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2339,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2341, 0xFFFE, 0xFFFE,
	0xFFFE, 0x2343, 0xFFFE, 0xFFFE, 0xFFFE, 0x233C, 0xFFFE, 0x2346,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2342,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x233B, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x256B, 0x256A, 0xFFFE, 0x256D, 0x256F, 0x2564, 0x2567, 0x256E,
	0xFFFE, 0xFFFE, 0xFFFE, 0x2561, 0x2565, 0xFFFE, 0xFFFE, 0x2569,
	0x294A, 0xFFFE, 0x294E, 0xFFFE, 0x2566, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x2562, 0xFFFE, 0xFFFE, 0xFFFE, 0x2563, 0x255C,
	0xFFFE, 0x255D, 0x255F, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x255B,
	0x2560, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2568, 0xFFFE, 0xFFFE,
	0xFFFE, 0x255E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x256C, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x2949, 0x293D, 0x294C, 0xFFFE, 0xFFFE, 0x293F, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x293E, 0x2944, 0xFFFE,
	0x2950, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2946, 0x2943,
	0xFFFE, 0xFFFE, 0x293C, 0xFFFE, 0x294B, 0xFFFE, 0x294D, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x2941, 0xFFFE, 0x2947, 0x2948, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2940,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2945, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x294F, 0xFFFE,
	0x2E46, 0xFFFE, 0x2E34, 0xFFFE, 0x2E39, 0xFFFE, 0xFFFE, 0x2E37,
	0xFFFE, 0xFFFE, 0xFFFE, 0x2E3E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x2E41, 0xFFFE, 0x2E38, 0xFFFE, 0xFFFE, 0xFFFE, 0x2E44,
	0x2E45, 0xFFFE, 0xFFFE, 0x2E43, 0xFFFE, 0xFFFE, 0xFFFE, 0x2E3B
} };

static const iconv_ccs_convtable_8bit from_ucs_55 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0x2E48, 0x2E3C, 0x2E40, 0xFFFE, 0xFFFE,
	0x2E3D, 0xFFFE, 0x2E42, 0x2E49, 0x3424, 0xFFFE, 0x2E47, 0xFFFE,
	0xFFFE, 0x2E3F, 0x2E36, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2E35,
	0xFFFE, 0xFFFE, 0x2E3A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2E33, 0xFFFE,
	0xFFFE, 0xFFFE, 0x337A, 0xFFFE, 0xFFFE, 0x342A, 0xFFFE, 0xFFFE,
	0x3421, 0xFFFE, 0x3425, 0xFFFE, 0x3379, 0x337E, 0x337D, 0xFFFE,
	0xFFFE, 0x3428, 0xFFFE, 0x342B, 0x3376, 0xFFFE, 0xFFFE, 0xFFFE,
	0x342C, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3423, 0xFFFE, 0xFFFE,
	0x3429, 0xFFFE, 0xFFFE, 0x342D, 0xFFFE, 0x3377, 0x3427, 0xFFFE,
	0x3378, 0x337B, 0x3422, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x337C, 0xFFFE, 0xFFFE, 0x3426, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3374, 0x3375, 0x3A4E,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3A59, 0xFFFE, 0x3A5C,
	0xFFFE, 0x3A55, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x3A52, 0xFFFE, 0xFFFE, 0xFFFE, 0x3A5A, 0x417C, 0x3A5F, 0x3A53,
	0xFFFE, 0x3A4A, 0x3A57, 0x3A51, 0xFFFE, 0x3A5D, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x3A5E, 0x3A50, 0x3A56, 0x3A58, 0x3A4C, 0x3A5B, 0xFFFE,
	0x3A4B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3A4D, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3A54, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x417A,
	0x4176, 0xFFFE, 0x4227, 0x416F, 0x4178, 0xFFFE, 0xFFFE, 0xFFFE,
	0x4223, 0xFFFE, 0x4174, 0x4173, 0x4171, 0x4225, 0xFFFE, 0x417D,
	0x4172, 0xFFFE, 0x417B, 0xFFFE, 0x4177, 0x417E, 0x4222, 0xFFFE,
	0xFFFE, 0x4226, 0xFFFE, 0x4170, 0xFFFE, 0x4175, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x4221, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x4179, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x4224, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x493C, 0x4938, 0xFFFE, 0x4932, 0xFFFE, 0xFFFE, 0x493B
} };

static const iconv_ccs_convtable_8bit from_ucs_56 = { {
	0xFFFE, 0x4935, 0x4937, 0xFFFE, 0x493A, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4930, 0xFFFE, 0xFFFE, 0x4933,
	0xFFFE, 0xFFFE, 0x4931, 0x4936, 0xFFFE, 0x492F, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4934, 0x4939, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x492E,
	0xFFFE, 0xFFFE, 0x4F6E, 0xFFFE, 0x4F6B, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x4F69, 0xFFFE, 0x4F61, 0xFFFE, 0xFFFE,
	0x4F6D, 0xFFFE, 0x4F6F, 0xFFFE, 0xFFFE, 0x4F6A, 0x4F6C, 0xFFFE,
	0x4F68, 0x4F62, 0x4F5F, 0xFFFE, 0xFFFE, 0x3A4F, 0x4F65, 0xFFFE,
	0x4F5E, 0x4F64, 0x4F63, 0xFFFE, 0x4F60, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x4F66, 0xFFFE, 0x4F67, 0xFFFE, 0xFFFE, 0xFFFE, 0x564F, 0xFFFE,
	0x5648, 0xFFFE, 0xFFFE, 0x564C, 0xFFFE, 0xFFFE, 0x564B, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x564D, 0x5649, 0xFFFE,
	0x5647, 0xFFFE, 0x564E, 0x564A, 0xFFFE, 0xFFFE, 0xFFFE, 0x5650,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5C52, 0x5C54,
	0xFFFE, 0x5C55, 0x5C53, 0x5C51, 0x5C50, 0xFFFE, 0x5C4F, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5C4D, 0x5C4E, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x5C4C, 0xFFFE, 0xFFFE, 0xFFFE, 0x6148,
	0x6146, 0x614B, 0x6149, 0xFFFE, 0x6147, 0x614A, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x653E, 0x653F,
	0xFFFE, 0xFFFE, 0x6540, 0x653C, 0x6541, 0x653D, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x686B, 0x686D, 0xFFFE, 0x686C, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6B53, 0x6B54, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x6B52, 0xFFFE, 0x6D46, 0x6D45, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x6D47, 0xFFFE, 0x7034, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x7033, 0x707C, 0xFFFE, 0xFFFE, 0x212A,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2227,
	0xFFFE, 0x2226, 0xFFFE, 0xFFFE, 0xFFFE, 0x2349, 0xFFFE, 0x2348,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2347, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2570,
	0xFFFE, 0x2571, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_57 = { {
	0xFFFE, 0x2E4A, 0x2E4B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x342F,
	0xFFFE, 0xFFFE, 0x342E, 0xFFFE, 0x3A60, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4228, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x4F70, 0x5652, 0x5651, 0xFFFE, 0x715A, 0xFFFE,
	0x2139, 0xFFFE, 0x214F, 0x2150, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x2229, 0xFFFE, 0xFFFE, 0xFFFE, 0x2228, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x222A, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x234A, 0xFFFE, 0xFFFE, 0xFFFE, 0x234B, 0xFFFE, 0xFFFE,
	0xFFFE, 0x234D, 0xFFFE, 0x234E, 0x234C, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x234F, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x257E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x2621, 0xFFFE, 0xFFFE, 0x2575, 0xFFFE, 0x2574, 0xFFFE, 0x2572,
	0x2577, 0x2576, 0x2573, 0x257C, 0x257D, 0x257A, 0x2578, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x257B, 0xFFFE, 0x2622, 0xFFFE, 0xFFFE,
	0x2579, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2955, 0xFFFE, 0xFFFE, 0x295B,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2959, 0x295F, 0xFFFE, 0x2956,
	0x295A, 0x295C, 0x295E, 0x2958, 0xFFFE, 0x2957, 0x2952, 0x2953,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2954, 0x295D, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2951, 0x2E55, 0xFFFE,
	0x2E54, 0x2E59, 0x2E50, 0xFFFE, 0x2E53, 0x2E52, 0xFFFE, 0x2E56,
	0xFFFE, 0x2E5A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2E51, 0x2E57,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2E4C, 0xFFFE, 0xFFFE, 0x343D,
	0x2E58, 0xFFFE, 0x2E4F, 0xFFFE, 0xFFFE, 0x2E4E, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3434, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x3444, 0x3432, 0x3440, 0xFFFE, 0x3442, 0xFFFE, 0x3448,
	0xFFFE, 0x344C, 0xFFFE, 0xFFFE, 0x3443, 0x3437, 0x343F, 0xFFFE,
	0x344D, 0x344B, 0x3441, 0x343C, 0x3435, 0x3A68, 0x3433, 0xFFFE,
	0x343A, 0xFFFE, 0xFFFE, 0x3430, 0x3446, 0x3438, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_58 = { {
	0x3436, 0x3449, 0xFFFE, 0xFFFE, 0x344F, 0xFFFE, 0xFFFE, 0x343E,
	0x3439, 0xFFFE, 0xFFFE, 0x343B, 0x344A, 0x344E, 0x3445, 0xFFFE,
	0x3447, 0xFFFE, 0xFFFE, 0xFFFE, 0x3431, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x3A63, 0xFFFE, 0x3A6C, 0x3A6B, 0xFFFE, 0x3A64, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x3A66, 0xFFFE, 0x3A6A, 0xFFFE, 0x3A65,
	0x3A67, 0x3A61, 0xFFFE, 0xFFFE, 0x3A74, 0x3A73, 0x3A70, 0xFFFE,
	0xFFFE, 0xFFFE, 0x2E4D, 0x3A6D, 0xFFFE, 0xFFFE, 0x3A6F, 0x3A62,
	0x3A72, 0x3A71, 0xFFFE, 0x3A75, 0xFFFE, 0x4236, 0xFFFE, 0x3A6E,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x3A69, 0x422E, 0xFFFE, 0xFFFE, 0xFFFE, 0x422D, 0x4231, 0x422C,
	0xFFFE, 0xFFFE, 0xFFFE, 0x4229, 0xFFFE, 0x4230, 0xFFFE, 0xFFFE,
	0xFFFE, 0x4233, 0xFFFE, 0x4235, 0xFFFE, 0x4232, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x4237, 0x422B, 0x4234, 0xFFFE, 0xFFFE,
	0x422A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x422F,
	0xFFFE, 0x4238, 0xFFFE, 0xFFFE, 0x4944, 0xFFFE, 0x494A, 0xFFFE,
	0xFFFE, 0xFFFE, 0x4946, 0x494D, 0x493E, 0xFFFE, 0xFFFE, 0x4943,
	0xFFFE, 0x4942, 0x494B, 0xFFFE, 0xFFFE, 0xFFFE, 0x4941, 0x4947,
	0x494C, 0x493D, 0xFFFE, 0x4945, 0xFFFE, 0xFFFE, 0x4949, 0x494F,
	0x493F, 0x4948, 0xFFFE, 0xFFFE, 0x494E, 0xFFFE, 0xFFFE, 0xFFFE,
	0x4940, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4F72, 0xFFFE, 0xFFFE,
	0x4F74, 0x4F79, 0xFFFE, 0x4F75, 0xFFFE, 0x4F78, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x4F71, 0x4F77, 0xFFFE, 0xFFFE, 0x4F76,
	0xFFFE, 0x4F73, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x5657, 0xFFFE, 0x5659, 0x5654, 0xFFFE, 0x5656,
	0xFFFE, 0xFFFE, 0x5658, 0xFFFE, 0xFFFE, 0xFFFE, 0x565A, 0xFFFE,
	0x5653, 0x5655, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5C58,
	0xFFFE, 0xFFFE, 0x5C59, 0xFFFE, 0x5C57, 0xFFFE, 0x5C56, 0xFFFE,
	0xFFFE, 0xFFFE, 0x6542, 0x6544, 0xFFFE, 0x6543, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x686E, 0xFFFE, 0xFFFE, 0xFFFE, 0x6F22,
	0x6F21, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2960, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4239, 0xFFFE, 0x4950, 0x4F7A
} };

static const iconv_ccs_convtable_8bit from_ucs_59 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0x213A, 0xFFFE, 0xFFFE, 0x2350, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2623, 0x2961, 0x2E5B, 0xFFFE,
	0xFFFE, 0xFFFE, 0x6545, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2151,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x213B, 0xFFFE, 0xFFFE, 0x2152,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x222B, 0xFFFE, 0xFFFE, 0xFFFE,
	0x2351, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2624, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x2E5C, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x2962, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3450, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x3A76, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x4951, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x614C, 0x6D48, 0x6F23, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2231,
	0xFFFE, 0xFFFE, 0xFFFE, 0x222F, 0x222D, 0xFFFE, 0x2230, 0x2232,
	0x222C, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x222E, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2356, 0x2359,
	0x2358, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2355,
	0x2353, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x2354, 0x235B, 0x2357, 0xFFFE, 0xFFFE, 0xFFFE, 0x2352, 0x235A,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x2630, 0x2629, 0xFFFE, 0x2634, 0x2625, 0x262C, 0xFFFE,
	0xFFFE, 0xFFFE, 0x2626, 0xFFFE, 0x262D, 0x2631, 0xFFFE, 0xFFFE,
	0x2632, 0x262B, 0xFFFE, 0x262E, 0xFFFE, 0xFFFE, 0xFFFE, 0x2635,
	0x2633, 0xFFFE, 0xFFFE, 0xFFFE, 0x262A, 0xFFFE, 0x2628, 0x2627,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x262F, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x2970, 0xFFFE, 0x2968, 0x2964, 0xFFFE,
	0x2974, 0x2963, 0xFFFE, 0xFFFE, 0x296D, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x2971, 0xFFFE, 0xFFFE, 0xFFFE, 0x2977, 0x2965, 0xFFFE,
	0xFFFE, 0x2967, 0x296E, 0x2972, 0x2976, 0x2973, 0x296C, 0x296F,
	0xFFFE, 0xFFFE, 0x2969, 0xFFFE, 0x296B, 0x296A, 0x2975, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_5A = { {
	0x2966, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x2E64, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2E62,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2E61, 0x2E5E, 0x2E63,
	0xFFFE, 0x2E5D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2E65, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2E5F, 0x2E60, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x2E66, 0xFFFE, 0x3457, 0xFFFE, 0x3B26,
	0x3456, 0x3469, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3467, 0xFFFE,
	0xFFFE, 0xFFFE, 0x3470, 0x3460, 0x3463, 0xFFFE, 0xFFFE, 0x346D,
	0x3465, 0xFFFE, 0xFFFE, 0xFFFE, 0x346A, 0x3468, 0xFFFE, 0xFFFE,
	0x3459, 0x346E, 0x3462, 0x345D, 0xFFFE, 0x3453, 0x346F, 0x345F,
	0x3452, 0xFFFE, 0xFFFE, 0x3464, 0x3471, 0x3461, 0x3455, 0x345A,
	0x3451, 0xFFFE, 0xFFFE, 0xFFFE, 0x345E, 0x345B, 0xFFFE, 0x3454,
	0xFFFE, 0x346C, 0xFFFE, 0xFFFE, 0x345C, 0x3458, 0xFFFE, 0xFFFE,
	0x346B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x3A7D, 0xFFFE, 0x3A7A, 0x3B2D, 0x3B21, 0x3B2E, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x3B2A, 0x3B27, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x3B28, 0x3B2B, 0x3B2F, 0xFFFE, 0x3466, 0x3B31,
	0x424D, 0xFFFE, 0xFFFE, 0x3B32, 0x3A78, 0x3B24, 0xFFFE, 0x3B29,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3B30, 0x3B33, 0x3A7C, 0x3A79,
	0xFFFE, 0xFFFE, 0x3A7B, 0xFFFE, 0xFFFE, 0x3B22, 0x3A7E, 0xFFFE,
	0xFFFE, 0x3B2C, 0xFFFE, 0xFFFE, 0x3B23, 0xFFFE, 0x3B25, 0x3A77,
	0x4241, 0x423F, 0xFFFE, 0xFFFE, 0x4249, 0x4240, 0x424A, 0x4246,
	0x423E, 0x424C, 0x423D, 0x4244, 0xFFFE, 0xFFFE, 0xFFFE, 0x4242,
	0x4247, 0xFFFE, 0xFFFE, 0xFFFE, 0x423B, 0xFFFE, 0x4245, 0x423A,
	0x4243, 0xFFFE, 0x4248, 0x423C, 0xFFFE, 0x424B, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4955, 0xFFFE, 0xFFFE,
	0xFFFE, 0x4961, 0x4957, 0x495D, 0x4952, 0x4960, 0x495F, 0x4963,
	0x495C, 0xFFFE, 0x495B, 0xFFFE, 0xFFFE, 0x4954, 0xFFFE, 0xFFFE,
	0x4962, 0xFFFE, 0x4956, 0x4959, 0x495E, 0x4958, 0x4953, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x495A, 0x4F7C, 0xFFFE, 0x5021, 0x4F7E,
	0x5023, 0x5025, 0xFFFE, 0xFFFE, 0xFFFE, 0x4F7D, 0xFFFE, 0x4F7B
} };

static const iconv_ccs_convtable_8bit from_ucs_5B = { {
	0xFFFE, 0x5026, 0x5024, 0x5022, 0xFFFE, 0x5028, 0xFFFE, 0x5027,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5029,
	0x5661, 0xFFFE, 0xFFFE, 0x5660, 0x565F, 0xFFFE, 0x5662, 0x565B,
	0xFFFE, 0x565C, 0x5664, 0x565D, 0xFFFE, 0xFFFE, 0x5666, 0xFFFE,
	0x5665, 0x565E, 0xFFFE, 0x5C5D, 0xFFFE, 0x5C5B, 0x5C60, 0x5C5F,
	0x5663, 0xFFFE, 0xFFFE, 0xFFFE, 0x5C5E, 0x5C5A, 0x5C62, 0x5C61,
	0xFFFE, 0xFFFE, 0x5C5C, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x614D, 0x6546, 0x6547, 0x6548,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x686F, 0xFFFE, 0x6B56,
	0x6B55, 0xFFFE, 0xFFFE, 0x6D49, 0x6D4A, 0x6F24, 0x7035, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2233, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x2636, 0xFFFE, 0xFFFE, 0x2637, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2E67, 0xFFFE, 0x3473, 0xFFFE,
	0xFFFE, 0xFFFE, 0x3472, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4964,
	0xFFFE, 0xFFFE, 0xFFFE, 0x5C63, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x2153, 0xFFFE, 0xFFFE, 0x2154, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x235C, 0xFFFE,
	0xFFFE, 0xFFFE, 0x235D, 0x2638, 0xFFFE, 0x2639, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2E68,
	0x2978, 0xFFFE, 0xFFFE, 0xFFFE, 0x2E6A, 0x2E69, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x3475, 0x3474, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x3B39, 0x3B36, 0xFFFE, 0x3B35, 0x3B3A, 0xFFFE,
	0xFFFE, 0x3B38, 0xFFFE, 0xFFFE, 0x3B37, 0xFFFE, 0x424E, 0xFFFE,
	0x424F, 0x4250, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x4965, 0xFFFE, 0xFFFE, 0x4966, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x3B34, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5667,
	0xFFFE, 0x5C64, 0x5C65, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_5C = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0x2E6B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3B3B, 0xFFFE, 0xFFFE, 0xFFFE,
	0x213C, 0xFFFE, 0x2155, 0xFFFE, 0xFFFE, 0x2234, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4251,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2235, 0xFFFE, 0xFFFE,
	0x235E, 0xFFFE, 0x235F, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x3B3C, 0xFFFE, 0xFFFE, 0x4252, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x2156, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x263A, 0xFFFE, 0xFFFE, 0x263B,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2979, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2E6D, 0xFFFE, 0x2E6C, 0xFFFE,
	0xFFFE, 0x3476, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x4967, 0xFFFE, 0xFFFE, 0xFFFE, 0x502A,
	0xFFFE, 0x614E, 0x614F, 0xFFFE, 0xFFFE, 0x7036, 0x212B, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x2158, 0x2157, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x2237, 0x2238, 0x2236, 0xFFFE, 0x2239, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2367, 0xFFFE,
	0x2362, 0x2364, 0x2366, 0x2363, 0xFFFE, 0x2360, 0xFFFE, 0x2361,
	0xFFFE, 0xFFFE, 0x2365, 0x2368, 0xFFFE, 0x2369, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2649, 0xFFFE, 0x2643,
	0x263E, 0xFFFE, 0x2646, 0x2644, 0x263D, 0x264A, 0x264D, 0x2648,
	0x2641, 0xFFFE, 0x2647, 0xFFFE, 0x2642, 0x2645, 0x263C, 0x2640,
	0x264C, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x263F, 0x264B, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2A2C, 0x2A25,
	0x2A2B, 0x2A24, 0x2A26, 0x297E, 0x297C, 0xFFFE, 0x2A2D, 0x2A2A,
	0x297A, 0xFFFE, 0xFFFE, 0x2A28, 0x2A29, 0xFFFE, 0x2A27, 0x297D,
	0x297B, 0xFFFE, 0x2A23, 0x2A21, 0xFFFE, 0xFFFE, 0x2A22, 0x2A2E,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2E6E, 0xFFFE, 0x2E70, 0xFFFE,
	0xFFFE, 0x2E71, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2E72,
	0x2A2F, 0x2E74, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2E6F
} };

static const iconv_ccs_convtable_8bit from_ucs_5D = { {
	0x2E73, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x3478, 0x347C, 0x347E, 0xFFFE, 0x3523,
	0xFFFE, 0xFFFE, 0x3525, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x347A, 0xFFFE, 0xFFFE, 0x3479, 0x3477, 0x3527,
	0x347B, 0xFFFE, 0xFFFE, 0x3526, 0xFFFE, 0x3522, 0x3521, 0xFFFE,
	0x347D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3528, 0xFFFE,
	0x3524, 0x3B4B, 0x3B52, 0x3B47, 0xFFFE, 0x3B43, 0x3B53, 0x3B3D,
	0x3B50, 0x3B4E, 0x3B48, 0xFFFE, 0x3B51, 0x3B4A, 0xFFFE, 0x3B42,
	0x3B54, 0x3B40, 0x3B4D, 0x3B3E, 0xFFFE, 0x3B55, 0xFFFE, 0xFFFE,
	0xFFFE, 0x3B4F, 0x4255, 0x3B41, 0xFFFE, 0xFFFE, 0x3B45, 0xFFFE,
	0xFFFE, 0x3B44, 0x3B49, 0xFFFE, 0xFFFE, 0x3B46, 0xFFFE, 0xFFFE,
	0xFFFE, 0x3B4C, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4259, 0xFFFE,
	0xFFFE, 0xFFFE, 0x425C, 0x4254, 0xFFFE, 0x4256, 0xFFFE, 0x425B,
	0x425A, 0xFFFE, 0xFFFE, 0x3B3F, 0x4258, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x4253, 0x4257, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x496E,
	0xFFFE, 0x4975, 0x496C, 0xFFFE, 0x4973, 0x496A, 0x4972, 0x4976,
	0x4969, 0x496D, 0x4968, 0xFFFE, 0xFFFE, 0xFFFE, 0x496B, 0xFFFE,
	0x4971, 0x4970, 0x496F, 0xFFFE, 0xFFFE, 0x4974, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x502E, 0x5030, 0xFFFE, 0x5031, 0xFFFE, 0x502C,
	0xFFFE, 0x502B, 0x5035, 0xFFFE, 0x5033, 0xFFFE, 0x5036, 0x502D,
	0x5032, 0x5034, 0x502F, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x566B,
	0x5670, 0x566A, 0x566F, 0xFFFE, 0x5668, 0x5672, 0x566E, 0x5673,
	0x566D, 0x5669, 0x5671, 0xFFFE, 0x5674, 0x566C, 0xFFFE, 0x5C66,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x6150, 0xFFFE, 0x643E, 0x6549, 0xFFFE, 0xFFFE, 0x6870, 0x6871,
	0xFFFE, 0xFFFE, 0xFFFE, 0x6B57, 0xFFFE, 0xFFFE, 0xFFFE, 0x6B58,
	0xFFFE, 0x6D4C, 0xFFFE, 0xFFFE, 0xFFFE, 0x6D4B, 0xFFFE, 0xFFFE,
	0x6F25, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x223A,
	0x236A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x425D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x2A30, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x213D
} };

static const iconv_ccs_convtable_8bit from_ucs_5E = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2159, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x236B, 0xFFFE, 0xFFFE, 0xFFFE, 0x236C, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x264F, 0xFFFE, 0xFFFE, 0x264E,
	0xFFFE, 0x2650, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x2A34, 0x2A31, 0x2A32, 0x2A33, 0x2A35, 0xFFFE, 0xFFFE, 0xFFFE,
	0x2E76, 0x2E75, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x352A, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3529, 0xFFFE,
	0xFFFE, 0x3B57, 0xFFFE, 0xFFFE, 0x3B56, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x4260, 0x4262, 0xFFFE, 0x4261, 0x425F, 0x425E,
	0xFFFE, 0xFFFE, 0xFFFE, 0x4979, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x4977, 0x4978, 0xFFFE, 0xFFFE, 0x503A, 0x5038, 0xFFFE, 0xFFFE,
	0x5039, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5677, 0x5675,
	0x5676, 0x5037, 0x5C68, 0xFFFE, 0x5C67, 0x6151, 0x6152, 0x5678,
	0x654A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x223B, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x215A, 0xFFFE, 0x215B, 0xFFFE, 0x223C, 0xFFFE, 0xFFFE, 0xFFFE,
	0x2370, 0x236E, 0xFFFE, 0x236D, 0x236F, 0x2371, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x2A39, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x2A38, 0x2A3A, 0x2A37, 0x2A3B, 0xFFFE, 0xFFFE,
	0x2E77, 0xFFFE, 0x2E79, 0xFFFE, 0x2E7A, 0xFFFE, 0x2E78, 0xFFFE,
	0x2A36, 0x352B, 0x352E, 0x352F, 0x352C, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x352D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4263, 0x4265, 0x4267,
	0xFFFE, 0xFFFE, 0xFFFE, 0x4266, 0x4264, 0xFFFE, 0x497D, 0xFFFE,
	0xFFFE, 0x497B, 0x4A23, 0xFFFE, 0x4A24, 0x4A21, 0xFFFE, 0x497C,
	0x497A, 0x4A22, 0xFFFE, 0x503C, 0x497E, 0xFFFE, 0x503D, 0xFFFE,
	0xFFFE, 0x503E, 0xFFFE, 0xFFFE, 0xFFFE, 0x567D, 0x567B, 0x567A,
	0x567C, 0x5679, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6872, 0x6873,
	0xFFFE, 0x6B59, 0x6D4D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_5F = { {
	0xFFFE, 0xFFFE, 0x223D, 0xFFFE, 0xFFFE, 0x2372, 0xFFFE, 0x2A3C,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x223E, 0xFFFE, 0xFFFE, 0x2373, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x2652, 0x2653, 0x2654, 0xFFFE, 0xFFFE, 0xFFFE,
	0x2651, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2A3D, 0xFFFE,
	0x2E7C, 0xFFFE, 0xFFFE, 0x2E7B, 0xFFFE, 0xFFFE, 0x3530, 0xFFFE,
	0x3531, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x4268, 0xFFFE, 0xFFFE, 0x4A26, 0x4A25, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x503F, 0xFFFE, 0x567E, 0xFFFE, 0xFFFE, 0xFFFE, 0x6F27,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2655, 0xFFFE, 0x2A3E, 0xFFFE,
	0x3B58, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2E7D,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4A27,
	0xFFFE, 0xFFFE, 0xFFFE, 0x212C, 0x223F, 0xFFFE, 0x2375, 0xFFFE,
	0x2374, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2658, 0x2657, 0xFFFE,
	0xFFFE, 0xFFFE, 0x2656, 0xFFFE, 0xFFFE, 0xFFFE, 0x2A3F, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3533, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x3532, 0xFFFE, 0xFFFE, 0xFFFE, 0x3534,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3B5A, 0x3B59, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x3B5B, 0xFFFE, 0x426A, 0xFFFE, 0x4269,
	0xFFFE, 0xFFFE, 0x5040, 0xFFFE, 0xFFFE, 0xFFFE, 0x4A28, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x5722, 0x5721, 0xFFFE, 0x5C69, 0x654B,
	0x6874, 0x6875, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x215C, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2242,
	0x2378, 0x2377, 0x2376, 0xFFFE, 0x2241, 0x2240, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2659, 0xFFFE,
	0xFFFE, 0x237D, 0xFFFE, 0x2421, 0x237E, 0x265A, 0xFFFE, 0xFFFE,
	0x237A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2379, 0x237B, 0x2423,
	0xFFFE, 0xFFFE, 0xFFFE, 0x237C, 0x2427, 0xFFFE, 0xFFFE, 0x2424,
	0xFFFE, 0xFFFE, 0x2422, 0x2425, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_60 = { {
	0x2426, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x266E, 0x2661, 0x265F, 0x266D, 0x2668, 0xFFFE, 0xFFFE,
	0x2669, 0x266C, 0xFFFE, 0x266B, 0xFFFE, 0xFFFE, 0xFFFE, 0x2662,
	0xFFFE, 0x265D, 0x2664, 0xFFFE, 0x266F, 0xFFFE, 0x2665, 0xFFFE,
	0xFFFE, 0xFFFE, 0x2667, 0xFFFE, 0x2A4E, 0xFFFE, 0x265C, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2666, 0x265B, 0x266A, 0xFFFE,
	0xFFFE, 0xFFFE, 0x265E, 0x2663, 0x2660, 0xFFFE, 0xFFFE, 0x2A40,
	0xFFFE, 0x2A41, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x2A4B, 0x2F23, 0x2A4C, 0xFFFE, 0x2A4F, 0x2A45, 0xFFFE, 0x2A47,
	0xFFFE, 0x2A48, 0xFFFE, 0xFFFE, 0x2A4A, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x2A46, 0x2A42, 0xFFFE, 0xFFFE, 0xFFFE,
	0x2A50, 0xFFFE, 0x2F21, 0x2A49, 0xFFFE, 0x2E7E, 0x2A44, 0x2A4D,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2A51, 0x2F22,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2A52, 0xFFFE,
	0xFFFE, 0xFFFE, 0x2A43, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x2F26, 0x2F28, 0xFFFE, 0x2F2A, 0xFFFE, 0xFFFE, 0x3537, 0x2F2E,
	0x2F25, 0xFFFE, 0x3535, 0xFFFE, 0xFFFE, 0xFFFE, 0x2F30, 0xFFFE,
	0x3536, 0xFFFE, 0x2F27, 0xFFFE, 0xFFFE, 0x2F2B, 0xFFFE, 0x2F2D,
	0xFFFE, 0xFFFE, 0xFFFE, 0x2F2C, 0x2F2F, 0x2F29, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x2F24, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x3539, 0x3542, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3544,
	0xFFFE, 0x3B5D, 0x353A, 0xFFFE, 0xFFFE, 0xFFFE, 0x3538, 0x3546,
	0x3549, 0x3B6C, 0xFFFE, 0x3547, 0x3B61, 0xFFFE, 0xFFFE, 0xFFFE,
	0x3541, 0x3B5C, 0x3545, 0xFFFE, 0x3B5E, 0x3548, 0x3B60, 0x353D,
	0xFFFE, 0xFFFE, 0xFFFE, 0x353B, 0x353C, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x353F, 0xFFFE, 0x3543, 0xFFFE, 0x3540, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x3B5F, 0xFFFE, 0x353E, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x3B63, 0xFFFE, 0xFFFE, 0x3B67, 0xFFFE, 0x426B,
	0x3B69, 0xFFFE, 0xFFFE, 0xFFFE, 0x3B6A, 0xFFFE, 0x3B6B, 0x3B71
} };

static const iconv_ccs_convtable_8bit from_ucs_61 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0x3B6D, 0x3B72, 0x3B66, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x3B64, 0x3B73, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x3B70, 0xFFFE, 0xFFFE, 0x3B68, 0x3B62, 0xFFFE, 0x3B65, 0xFFFE,
	0x3B6E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3B6F, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x4A2A, 0x4276, 0xFFFE, 0x426E, 0x4A29, 0xFFFE, 0x4272, 0x4274,
	0xFFFE, 0xFFFE, 0x4271, 0xFFFE, 0xFFFE, 0xFFFE, 0x4270, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x4A39, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x4277, 0x4A2B, 0xFFFE, 0xFFFE, 0xFFFE, 0x426F, 0x4273, 0xFFFE,
	0xFFFE, 0x426C, 0x426D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4275,
	0xFFFE, 0xFFFE, 0x4A2F, 0x4A30, 0x4A35, 0xFFFE, 0x4A3C, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x4A37, 0xFFFE, 0xFFFE, 0x4A2C, 0xFFFE,
	0xFFFE, 0x4A3B, 0xFFFE, 0xFFFE, 0xFFFE, 0x4A38, 0x5051, 0xFFFE,
	0xFFFE, 0xFFFE, 0x4A3A, 0xFFFE, 0x4A32, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x4A2D, 0x4A31, 0x4A2E, 0x4A34, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5043, 0x4A36, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x4A33, 0xFFFE, 0xFFFE, 0x5042, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5047, 0xFFFE, 0x5041, 0x572E, 0x5050, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x504D, 0x5049, 0xFFFE, 0xFFFE, 0x5725, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x5048, 0xFFFE, 0x5723, 0xFFFE, 0x504C,
	0xFFFE, 0x504F, 0x5046, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x5724, 0xFFFE, 0x504E, 0xFFFE, 0xFFFE, 0x504B, 0xFFFE, 0x504A,
	0x5045, 0x5044, 0xFFFE, 0x5052, 0x5727, 0x5C6B, 0xFFFE, 0xFFFE,
	0x572D, 0xFFFE, 0x572B, 0xFFFE, 0x5C6C, 0xFFFE, 0xFFFE, 0x572C,
	0xFFFE, 0x5729, 0xFFFE, 0x5C6A, 0xFFFE, 0x5726, 0x5728, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x572A, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x615B, 0xFFFE,
	0x6153, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5C72, 0x6154,
	0x5C6E, 0xFFFE, 0xFFFE, 0xFFFE, 0x5C70, 0x5C6F, 0xFFFE, 0x5C6D,
	0x5C71, 0x615C, 0x6158, 0x615A, 0xFFFE, 0x6155, 0x6156, 0xFFFE,
	0x6159, 0x6157, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x6876, 0xFFFE, 0x654C, 0xFFFE, 0x6B5A, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_62 = { {
	0xFFFE, 0x6F28, 0xFFFE, 0x6F29, 0x6F2A, 0xFFFE, 0xFFFE, 0x722A,
	0xFFFE, 0x215D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2670, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x2F31, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x4278, 0xFFFE, 0xFFFE, 0x427A, 0x427C, 0x427B, 0xFFFE, 0x4A3E,
	0xFFFE, 0x4A3D, 0xFFFE, 0x4A3F, 0xFFFE, 0x5053, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x2428, 0xFFFE, 0xFFFE, 0x2671, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x2A53, 0x2A54, 0xFFFE, 0xFFFE, 0x2F32, 0xFFFE,
	0xFFFE, 0xFFFE, 0x3B74, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x215E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x2249, 0x224B, 0xFFFE, 0x2243, 0xFFFE, 0x2244, 0xFFFE,
	0x224A, 0x2246, 0x2248, 0xFFFE, 0x2245, 0x224C, 0x2247, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x2432, 0x242F, 0x2437, 0xFFFE, 0x2438, 0xFFFE, 0xFFFE, 0x2435,
	0xFFFE, 0xFFFE, 0x2431, 0x2430, 0xFFFE, 0x2436, 0xFFFE, 0xFFFE,
	0xFFFE, 0x2433, 0xFFFE, 0x2429, 0xFFFE, 0xFFFE, 0xFFFE, 0x242E,
	0x2434, 0xFFFE, 0xFFFE, 0xFFFE, 0x242A, 0xFFFE, 0x242B, 0x242C,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x242D, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x267D, 0x2676, 0xFFFE, 0xFFFE, 0x2672, 0x2679, 0x267B,
	0x267E, 0xFFFE, 0xFFFE, 0x267A, 0x2673, 0xFFFE, 0x2677, 0xFFFE,
	0x2721, 0xFFFE, 0xFFFE, 0x267C, 0xFFFE, 0xFFFE, 0x2675, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x2678, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2A55,
	0xFFFE, 0x2674, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x2A5B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x2A67, 0xFFFE, 0x2F33, 0xFFFE, 0xFFFE, 0x2A58, 0x2A60, 0xFFFE,
	0x2A5F, 0x2A5C, 0x2A64, 0x2A66, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_63 = { {
	0x2A61, 0xFFFE, 0xFFFE, 0x2A5A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x2A57, 0x2A5E, 0x2A56, 0x2A59, 0x2A5D,
	0x2F34, 0xFFFE, 0xFFFE, 0x2A62, 0x2A63, 0x2A65, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x2F40, 0xFFFE, 0xFFFE, 0x2F36, 0x2F46, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x354A, 0x2F48, 0x2F42, 0xFFFE, 0x2F39, 0xFFFE,
	0x2F4B, 0x2F3C, 0xFFFE, 0x3561, 0x2F3F, 0xFFFE, 0xFFFE, 0xFFFE,
	0x2F4D, 0x2F41, 0xFFFE, 0x2F3A, 0x2F37, 0x2F38, 0xFFFE, 0x2F47,
	0x2F4E, 0xFFFE, 0x2F3E, 0x2F3D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x2F4A, 0xFFFE, 0xFFFE, 0x2F44, 0xFFFE, 0x2F35, 0x2F4C,
	0x2F43, 0x2F45, 0x2F49, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x354B, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x355D, 0x3559, 0x3556,
	0x3568, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x355B, 0xFFFE, 0xFFFE,
	0x3563, 0xFFFE, 0xFFFE, 0xFFFE, 0x355F, 0x354E, 0xFFFE, 0xFFFE,
	0xFFFE, 0x3565, 0x354D, 0xFFFE, 0xFFFE, 0x3564, 0xFFFE, 0x3557,
	0xFFFE, 0xFFFE, 0x354C, 0xFFFE, 0xFFFE, 0x3567, 0x3555, 0xFFFE,
	0x3558, 0x3566, 0xFFFE, 0xFFFE, 0x3B75, 0xFFFE, 0xFFFE, 0x3553,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x355C, 0x3552, 0x3550, 0x3562,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3560, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x3554, 0xFFFE, 0x3551, 0x355E, 0x355A,
	0x3B77, 0x3B76, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x354F, 0x3C29, 0xFFFE,
	0xFFFE, 0xFFFE, 0x3C2F, 0x3B7C, 0x3C2C, 0x427D, 0xFFFE, 0x3C30,
	0x3C33, 0xFFFE, 0x3C21, 0x3C32, 0x3C31, 0xFFFE, 0x3B78, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x3C2E, 0xFFFE, 0x3C24, 0xFFFE, 0x3C35,
	0x3C2D, 0x3C36, 0xFFFE, 0xFFFE, 0x3C2B, 0x3C2A, 0xFFFE, 0x3C28,
	0x3C22, 0xFFFE, 0xFFFE, 0xFFFE, 0x2F3B, 0x3B79, 0xFFFE, 0x433D,
	0x3B7A, 0xFFFE, 0xFFFE, 0x4321, 0xFFFE, 0xFFFE, 0xFFFE, 0x3B7B,
	0x3C34, 0x427E, 0x3C25, 0x3B7E, 0xFFFE, 0x3C26, 0x3C23, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_64 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x4324, 0x4337, 0x433C, 0x4330, 0xFFFE, 0x4341, 0xFFFE,
	0x4322, 0xFFFE, 0x4323, 0xFFFE, 0xFFFE, 0x432A, 0xFFFE, 0xFFFE,
	0x432B, 0xFFFE, 0x4338, 0x433E, 0xFFFE, 0xFFFE, 0xFFFE, 0x4329,
	0x4325, 0x4340, 0x432E, 0x432F, 0x4326, 0x433A, 0x4331, 0x433B,
	0x4333, 0xFFFE, 0xFFFE, 0x4A40, 0xFFFE, 0xFFFE, 0x433F, 0x4336,
	0x4332, 0xFFFE, 0xFFFE, 0x4327, 0xFFFE, 0x4335, 0xFFFE, 0x432D,
	0xFFFE, 0x432C, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4A55,
	0x4339, 0x4334, 0xFFFE, 0x4328, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x4A50, 0xFFFE, 0x4A41, 0x4A4C, 0xFFFE,
	0x4A53, 0xFFFE, 0xFFFE, 0x4A51, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x4A58, 0xFFFE, 0x4A42, 0x4A4F, 0x4A43, 0x4A4E, 0xFFFE,
	0x4A52, 0x3C27, 0xFFFE, 0xFFFE, 0xFFFE, 0x4A59, 0x4A4A, 0xFFFE,
	0x5061, 0xFFFE, 0xFFFE, 0x4A57, 0x4A56, 0xFFFE, 0x5054, 0xFFFE,
	0x5055, 0xFFFE, 0x4A46, 0x4A47, 0x4A44, 0x4A49, 0x4A45, 0x4A5A,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4A48, 0xFFFE, 0x4A54,
	0xFFFE, 0xFFFE, 0x4A4D, 0xFFFE, 0xFFFE, 0x5058, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5735, 0x505D, 0x505C, 0x505E, 0xFFFE, 0xFFFE, 0x505B,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5056, 0x5059,
	0x5063, 0xFFFE, 0xFFFE, 0xFFFE, 0x505A, 0x3B7D, 0xFFFE, 0x5060,
	0x5057, 0xFFFE, 0xFFFE, 0x505F, 0xFFFE, 0xFFFE, 0x4A4B, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5062, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5734, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x5736, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5733, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5732,
	0x5731, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5730, 0x572F,
	0xFFFE, 0x5739, 0xFFFE, 0x5737, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x5C75, 0x5C77, 0xFFFE, 0xFFFE, 0xFFFE,
	0x5C78, 0x5C74, 0xFFFE, 0x5C76, 0xFFFE, 0xFFFE, 0xFFFE, 0x5C73,
	0xFFFE, 0xFFFE, 0xFFFE, 0x5738, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x6160, 0xFFFE, 0xFFFE, 0xFFFE, 0x6163, 0x615F, 0xFFFE, 0x615D
} };

static const iconv_ccs_convtable_8bit from_ucs_65 = { {
	0xFFFE, 0x6161, 0xFFFE, 0x6162, 0x615E, 0xFFFE, 0xFFFE, 0x654D,
	0xFFFE, 0x6550, 0xFFFE, 0xFFFE, 0x6551, 0x654F, 0x6552, 0xFFFE,
	0x654E, 0xFFFE, 0xFFFE, 0x687A, 0xFFFE, 0x6879, 0x6878, 0x6877,
	0xFFFE, 0xFFFE, 0xFFFE, 0x6B5B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x6D4F, 0x6D4E, 0x6D51, 0xFFFE, 0xFFFE, 0x6F2C, 0x6D50, 0xFFFE,
	0xFFFE, 0x6F2B, 0xFFFE, 0xFFFE, 0xFFFE, 0x7037, 0x707D, 0xFFFE,
	0xFFFE, 0xFFFE, 0x3C37, 0x573A, 0xFFFE, 0xFFFE, 0xFFFE, 0x224D,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2722, 0xFFFE, 0xFFFE,
	0xFFFE, 0x2A68, 0xFFFE, 0x2A69, 0xFFFE, 0xFFFE, 0x2F50, 0xFFFE,
	0xFFFE, 0xFFFE, 0x2F4F, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x3569, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3C3B, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3C3A, 0x3C3D, 0xFFFE, 0x3C38,
	0x3C3C, 0xFFFE, 0x3C39, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4342,
	0xFFFE, 0xFFFE, 0xFFFE, 0x4A5B, 0xFFFE, 0xFFFE, 0x5064, 0xFFFE,
	0xFFFE, 0x5066, 0x5065, 0x5067, 0x573C, 0xFFFE, 0xFFFE, 0x573B,
	0x5C7A, 0x5C79, 0xFFFE, 0xFFFE, 0x6553, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3C3E, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x4343, 0xFFFE, 0x6164, 0xFFFE, 0x6F2D, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3C3F, 0x3C40, 0xFFFE,
	0x4A5C, 0xFFFE, 0x573D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x2723, 0xFFFE, 0x2A6A, 0xFFFE, 0xFFFE, 0xFFFE, 0x3C41, 0xFFFE,
	0xFFFE, 0xFFFE, 0x5068, 0x5069, 0xFFFE, 0xFFFE, 0x5C7B, 0xFFFE,
	0x707E, 0xFFFE, 0xFFFE, 0x2724, 0xFFFE, 0xFFFE, 0xFFFE, 0x2A6B,
	0xFFFE, 0xFFFE, 0x2F54, 0x2F52, 0x2F53, 0xFFFE, 0x2F51, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x356A, 0xFFFE, 0xFFFE,
	0x3C42, 0xFFFE, 0x3C43, 0x4344, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x5C7C, 0x6165, 0xFFFE, 0x6555, 0x6554, 0x687B,
	0xFFFE, 0x213E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x224F, 0x224E,
	0x2439, 0xFFFE, 0x243C, 0x243B, 0x243A, 0x243D, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x272A, 0x2726, 0x272F, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_66 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0x272B, 0x2727, 0x272E, 0xFFFE, 0xFFFE,
	0x2729, 0x2725, 0xFFFE, 0x272C, 0xFFFE, 0x272D, 0xFFFE, 0xFFFE,
	0x2731, 0x2730, 0x2728, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2A70, 0x2A76, 0xFFFE, 0xFFFE,
	0xFFFE, 0x2A6D, 0x2A72, 0xFFFE, 0xFFFE, 0xFFFE, 0x2A71, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x2A74, 0xFFFE, 0xFFFE, 0x2A79, 0xFFFE,
	0xFFFE, 0xFFFE, 0x2A6E, 0x2A73, 0x2A77, 0x2A6F, 0x2A6C, 0xFFFE,
	0xFFFE, 0x2A78, 0x2A75, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2F57,
	0xFFFE, 0xFFFE, 0x2F55, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x2F58, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x356E, 0xFFFE, 0x356D, 0x356F, 0xFFFE, 0xFFFE, 0x2F56,
	0xFFFE, 0x356C, 0x3570, 0xFFFE, 0xFFFE, 0x356B, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x3C4A, 0xFFFE, 0x3C45, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x3C48, 0x3C4B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x434D, 0x3C49, 0xFFFE, 0x3C46, 0x3C44, 0xFFFE, 0xFFFE, 0xFFFE,
	0x3C47, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4345, 0xFFFE,
	0xFFFE, 0xFFFE, 0x434A, 0x4349, 0x4346, 0xFFFE, 0xFFFE, 0xFFFE,
	0x4348, 0xFFFE, 0xFFFE, 0xFFFE, 0x434C, 0x4347, 0xFFFE, 0xFFFE,
	0xFFFE, 0x434B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4A5F,
	0x4A5E, 0x4A5D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x506C, 0x506F, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5070,
	0x506B, 0xFFFE, 0x506D, 0xFFFE, 0xFFFE, 0x506A, 0xFFFE, 0x506E,
	0xFFFE, 0xFFFE, 0x5746, 0x5745, 0xFFFE, 0x5744, 0x573F, 0xFFFE,
	0x5740, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x573E, 0xFFFE, 0x5741, 0x5742, 0x5747, 0xFFFE, 0xFFFE, 0x5743,
	0xFFFE, 0xFFFE, 0x5C7D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x6168, 0xFFFE, 0x6166, 0x6167, 0xFFFE, 0xFFFE, 0x6556, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x687D, 0x687E, 0xFFFE, 0xFFFE, 0xFFFE,
	0x687C, 0xFFFE, 0xFFFE, 0x6F2E, 0xFFFE, 0x7038, 0x7039, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2732, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_67 = { {
	0xFFFE, 0x3C4C, 0xFFFE, 0xFFFE, 0x4A61, 0x4A60, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x2733, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2A7A,
	0x2A7B, 0xFFFE, 0x2F59, 0x2F5A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x3571, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x434E, 0x4641, 0x4A62, 0x5748, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x2257, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x2252, 0x2251, 0x2254, 0x2253, 0x2256, 0xFFFE, 0x2250, 0x2255,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x243E, 0xFFFE, 0x243F,
	0x2443, 0xFFFE, 0xFFFE, 0x2447, 0x2442, 0x2445, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2441, 0xFFFE, 0xFFFE,
	0xFFFE, 0x2440, 0x2446, 0xFFFE, 0xFFFE, 0x2444, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2735, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x273D, 0xFFFE, 0x2738, 0xFFFE,
	0x2747, 0x2748, 0x2740, 0x2739, 0xFFFE, 0x2745, 0xFFFE, 0xFFFE,
	0xFFFE, 0x2746, 0xFFFE, 0x2744, 0x273C, 0x2734, 0x273B, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x273F, 0x273E, 0x2736, 0xFFFE,
	0xFFFE, 0x2742, 0x2737, 0xFFFE, 0x2749, 0xFFFE, 0xFFFE, 0xFFFE,
	0x273A, 0x2743, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2741,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2B3D, 0xFFFE,
	0xFFFE, 0xFFFE, 0x2B38, 0x2B2E, 0xFFFE, 0x2B2C, 0xFFFE, 0x2B27,
	0xFFFE, 0x2B34, 0x2B21, 0x2B23, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x2B26, 0x2A7C, 0x2B33, 0x2B43, 0xFFFE, 0x2B28, 0x2B3A, 0xFFFE,
	0x2A7E, 0x2B41, 0x2B42, 0x2B45, 0x2B3C, 0x2B2D, 0x2B35, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x2B25, 0xFFFE, 0xFFFE, 0x2B3F, 0x2B22, 0xFFFE, 0xFFFE, 0x2B2B,
	0xFFFE, 0xFFFE, 0xFFFE, 0x2B32, 0x2B2A, 0xFFFE, 0x2B3E, 0x2B36,
	0xFFFE, 0xFFFE, 0x2B44, 0x2B29, 0xFFFE, 0x2B3B, 0x2B31, 0xFFFE,
	0x2B37, 0xFFFE, 0x2A7D, 0xFFFE, 0xFFFE, 0xFFFE, 0x2B30, 0x2B2F,
	0x2B24, 0xFFFE, 0x2B40, 0xFFFE, 0x2B39, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_68 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x2F6E, 0xFFFE, 0x2F6F, 0xFFFE, 0x2F63, 0xFFFE,
	0xFFFE, 0xFFFE, 0x2F5C, 0xFFFE, 0x2F65, 0x2F6D, 0xFFFE, 0x2F5B,
	0x2F76, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2F75, 0x2F70, 0xFFFE,
	0x2F71, 0xFFFE, 0xFFFE, 0x2F67, 0xFFFE, 0x2F68, 0x2F72, 0x2F69,
	0xFFFE, 0x2F64, 0x2F5E, 0x2F5F, 0x2F6C, 0x2F66, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x2F74, 0x2F60, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2F6B, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x2F5D, 0xFFFE, 0x2F61, 0xFFFE, 0x2F73, 0x2F6A, 0x2F62,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x3628, 0xFFFE, 0x3576, 0x3577, 0x357B,
	0xFFFE, 0x362C, 0x3629, 0xFFFE, 0x3622, 0x3621, 0xFFFE, 0x3625,
	0x3634, 0x3572, 0xFFFE, 0x3635, 0x3627, 0x3639, 0x362D, 0xFFFE,
	0x362B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3573,
	0xFFFE, 0x3632, 0x3638, 0x3630, 0x3637, 0xFFFE, 0xFFFE, 0x3624,
	0x3574, 0x3636, 0x3626, 0xFFFE, 0xFFFE, 0xFFFE, 0x362F, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x362E, 0x3575, 0xFFFE, 0xFFFE, 0xFFFE,
	0x3631, 0xFFFE, 0xFFFE, 0x357C, 0x3633, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x357E, 0x362A, 0x3579, 0x357D, 0xFFFE, 0x3578, 0xFFFE,
	0xFFFE, 0xFFFE, 0x3623, 0xFFFE, 0x3C63, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3C66, 0x3C7C,
	0x3C71, 0xFFFE, 0xFFFE, 0xFFFE, 0x3C60, 0xFFFE, 0x3C70, 0xFFFE,
	0x3C69, 0x3C76, 0xFFFE, 0x3C4E, 0x3C78, 0xFFFE, 0x3C56, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3C50, 0x3C72, 0x3C73, 0xFFFE,
	0xFFFE, 0x3C5E, 0xFFFE, 0xFFFE, 0x3C59, 0xFFFE, 0x3C74, 0xFFFE,
	0x3C6C, 0x3C79, 0x3C53, 0x3C58, 0x3C52, 0xFFFE, 0xFFFE, 0x3C65,
	0x4364, 0x3C54, 0xFFFE, 0x3C5D, 0x3C75, 0xFFFE, 0x3C5A, 0x3C57,
	0x3C68, 0xFFFE, 0xFFFE, 0xFFFE, 0x3C6B, 0x3C6A, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_69 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3C4F, 0xFFFE, 0x3C77, 0x3C5F,
	0x3C61, 0xFFFE, 0x3C6E, 0x3C6D, 0x3C4D, 0xFFFE, 0xFFFE, 0x3C55,
	0x3C5C, 0x3C64, 0xFFFE, 0x3C5B, 0x3C67, 0x3C7A, 0xFFFE, 0x3C6F,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3C7B, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x3C51, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4378,
	0xFFFE, 0xFFFE, 0x4376, 0x4361, 0x4366, 0x435F, 0xFFFE, 0x4372,
	0x4351, 0x4358, 0xFFFE, 0x4370, 0x437A, 0x4362, 0xFFFE, 0x4355,
	0x4368, 0x436D, 0x4359, 0xFFFE, 0x436A, 0x4356, 0xFFFE, 0xFFFE,
	0x435D, 0x435E, 0xFFFE, 0x4371, 0x436F, 0xFFFE, 0x4352, 0x4374,
	0xFFFE, 0x4375, 0x4377, 0xFFFE, 0xFFFE, 0xFFFE, 0x357A, 0x435A,
	0x436C, 0x435B, 0xFFFE, 0xFFFE, 0x4373, 0xFFFE, 0xFFFE, 0x4350,
	0xFFFE, 0xFFFE, 0x4353, 0xFFFE, 0xFFFE, 0x4363, 0x434F, 0xFFFE,
	0xFFFE, 0x4367, 0x4357, 0xFFFE, 0x4360, 0xFFFE, 0xFFFE, 0x4369,
	0x3C62, 0x4354, 0xFFFE, 0xFFFE, 0x436E, 0xFFFE, 0x436B, 0xFFFE,
	0x4365, 0xFFFE, 0x435C, 0x4379, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x452C, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4A70, 0x4A6E, 0xFFFE,
	0x4B26, 0x4A6C, 0xFFFE, 0x4A7E, 0xFFFE, 0xFFFE, 0x4A68, 0x4B25,
	0xFFFE, 0x4A6D, 0x4A7B, 0xFFFE, 0xFFFE, 0xFFFE, 0x4B23, 0xFFFE,
	0x4A66, 0x4B22, 0xFFFE, 0xFFFE, 0x4A77, 0x4B29, 0xFFFE, 0x4A6F,
	0xFFFE, 0x4A71, 0x4B21, 0xFFFE, 0x4A6A, 0xFFFE, 0xFFFE, 0x4A73,
	0x4A69, 0x4A63, 0xFFFE, 0x4A7D, 0xFFFE, 0x4B28, 0x4A64, 0xFFFE,
	0xFFFE, 0x4A79, 0xFFFE, 0xFFFE, 0x4A6B, 0x4A76, 0x4A72, 0x4A74,
	0xFFFE, 0xFFFE, 0x4B27, 0xFFFE, 0x4A75, 0xFFFE, 0x4B2A, 0xFFFE,
	0xFFFE, 0x4A65, 0x4A7A, 0xFFFE, 0xFFFE, 0xFFFE, 0x4A67, 0x4A7C,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4A78, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x4B24, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x507C, 0xFFFE, 0x5078, 0x5074, 0x512A, 0x5127,
	0xFFFE, 0xFFFE, 0xFFFE, 0x512E, 0x507B, 0xFFFE, 0x5124, 0xFFFE,
	0xFFFE, 0x5077, 0x5123, 0xFFFE, 0x5137, 0xFFFE, 0x5134, 0x5126,
	0x5075, 0xFFFE, 0xFFFE, 0x512B, 0x512D, 0xFFFE, 0x5121, 0x507A
} };

static const iconv_ccs_convtable_8bit from_ucs_6A = { {
	0x5071, 0xFFFE, 0xFFFE, 0xFFFE, 0x5130, 0xFFFE, 0x5072, 0x5136,
	0x5129, 0x512F, 0xFFFE, 0xFFFE, 0xFFFE, 0x512C, 0xFFFE, 0x5133,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5125, 0x5076, 0x5138, 0x5073,
	0x5131, 0xFFFE, 0xFFFE, 0x507D, 0xFFFE, 0x507E, 0xFFFE, 0xFFFE,
	0x5079, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5132, 0x5135, 0x5122,
	0x5755, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x574D, 0xFFFE, 0x5749, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x5757, 0x5762, 0xFFFE, 0x574F, 0x5758,
	0x5128, 0x5759, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5768, 0xFFFE,
	0xFFFE, 0x574B, 0xFFFE, 0xFFFE, 0xFFFE, 0x5766, 0x5767, 0x575D,
	0x575C, 0x5754, 0xFFFE, 0xFFFE, 0x575E, 0x5765, 0x5764, 0xFFFE,
	0xFFFE, 0xFFFE, 0x5756, 0x5753, 0xFFFE, 0x5750, 0x5763, 0xFFFE,
	0x5761, 0xFFFE, 0xFFFE, 0xFFFE, 0x575B, 0xFFFE, 0x574A, 0x574C,
	0x574E, 0x5760, 0x575A, 0xFFFE, 0xFFFE, 0x5751, 0xFFFE, 0x575F,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5752, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5D31,
	0xFFFE, 0x5D22, 0xFFFE, 0x5D2D, 0xFFFE, 0x5D34, 0xFFFE, 0x5D29,
	0xFFFE, 0x5D24, 0xFFFE, 0xFFFE, 0x5D35, 0x5C7E, 0x5D2B, 0xFFFE,
	0xFFFE, 0x5D30, 0x5D36, 0x5D2A, 0xFFFE, 0x5D2C, 0x5D21, 0xFFFE,
	0xFFFE, 0xFFFE, 0x5D33, 0x5D26, 0xFFFE, 0xFFFE, 0x5D28, 0x5D25,
	0xFFFE, 0x5D27, 0xFFFE, 0xFFFE, 0x5D2F, 0x5D23, 0x5D32, 0xFFFE,
	0x5D2E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6173, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6172, 0xFFFE, 0x616F, 0x6170,
	0xFFFE, 0x616A, 0x616E, 0xFFFE, 0xFFFE, 0x616B, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6169, 0x616D, 0x6171,
	0xFFFE, 0xFFFE, 0xFFFE, 0x655C, 0x6559, 0x6562, 0xFFFE, 0x6561,
	0x655F, 0x655A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x655B, 0xFFFE, 0xFFFE, 0x655E, 0xFFFE, 0x6563, 0x655D,
	0x6558, 0x616C, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6557,
	0x6924, 0xFFFE, 0x6923, 0x6560, 0xFFFE, 0xFFFE, 0x6927, 0x6928,
	0x6922, 0x6926, 0xFFFE, 0x6921, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x6B5F, 0x6925, 0xFFFE, 0xFFFE, 0x6B5D, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_6B = { {
	0x6B60, 0xFFFE, 0x6B5C, 0x6B5E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x6D53, 0x6D54, 0xFFFE, 0x6D52, 0xFFFE, 0xFFFE, 0xFFFE, 0x6F31,
	0xFFFE, 0x6F2F, 0x6F30, 0x703A, 0xFFFE, 0xFFFE, 0xFFFE, 0x7123,
	0x7121, 0x7122, 0x7124, 0xFFFE, 0xFFFE, 0xFFFE, 0x722B, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x274A, 0xFFFE, 0xFFFE,
	0x2B46, 0xFFFE, 0xFFFE, 0xFFFE, 0x2F77, 0x2F79, 0xFFFE, 0x2F78,
	0xFFFE, 0x2F7A, 0xFFFE, 0x363B, 0x2F7B, 0xFFFE, 0x363A, 0x363C,
	0x363D, 0x3C7D, 0xFFFE, 0x3C7E, 0x3D22, 0xFFFE, 0xFFFE, 0x3D21,
	0xFFFE, 0x4422, 0x437E, 0x437D, 0xFFFE, 0x437C, 0x437B, 0xFFFE,
	0x4421, 0xFFFE, 0x4B2B, 0x4B2D, 0xFFFE, 0x4B2C, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5139, 0xFFFE, 0xFFFE, 0x576A, 0x5769, 0x576B, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x5D37, 0xFFFE, 0xFFFE, 0x6174, 0xFFFE,
	0x6564, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2F7C, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5259, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x274C, 0xFFFE,
	0x274B, 0xFFFE, 0x2B47, 0xFFFE, 0x2B48, 0xFFFE, 0xFFFE, 0xFFFE,
	0x2F7E, 0xFFFE, 0xFFFE, 0xFFFE, 0x3642, 0x3640, 0x3641, 0x363F,
	0xFFFE, 0x363E, 0xFFFE, 0xFFFE, 0x3D23, 0x3D26, 0xFFFE, 0x3D24,
	0xFFFE, 0x3D25, 0xFFFE, 0x4423, 0xFFFE, 0xFFFE, 0x4B2E, 0x4B2F,
	0x4B30, 0xFFFE, 0x513C, 0x513B, 0xFFFE, 0x513A, 0x513D, 0x576C,
	0xFFFE, 0xFFFE, 0x576D, 0x576E, 0xFFFE, 0x5D38, 0xFFFE, 0xFFFE,
	0x6565, 0xFFFE, 0xFFFE, 0x213F, 0xFFFE, 0xFFFE, 0x2B49, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3D27, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x4B31, 0x4B32, 0xFFFE, 0xFFFE, 0x5770,
	0x576F, 0x6175, 0x6F32, 0xFFFE, 0x2140, 0xFFFE, 0xFFFE, 0xFFFE,
	0x2448, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2B4A, 0xFFFE,
	0x2B4B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x274D, 0xFFFE,
	0x2B4C, 0xFFFE, 0x3025, 0x3024, 0x3022, 0xFFFE, 0x3021, 0x3026,
	0x3023, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x3D28, 0xFFFE, 0x3D29, 0x3D2A, 0xFFFE, 0xFFFE, 0xFFFE, 0x4427,
	0x4428, 0x4426, 0xFFFE, 0x4424, 0x4425, 0xFFFE, 0x4B33, 0x5140
} };

static const iconv_ccs_convtable_8bit from_ucs_6C = { {
	0x513F, 0x513E, 0x5141, 0x5772, 0x5771, 0xFFFE, 0x5773, 0xFFFE,
	0xFFFE, 0x5D39, 0xFFFE, 0x6176, 0x6566, 0x6D55, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2141, 0x215F, 0xFFFE, 0xFFFE,
	0x2258, 0x2449, 0x244A, 0xFFFE, 0xFFFE, 0x274E, 0xFFFE, 0xFFFE,
	0x2B4D, 0x2B4E, 0xFFFE, 0xFFFE, 0xFFFE, 0x3027, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x3643, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x3D2B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2160, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x2163, 0xFFFE, 0xFFFE, 0xFFFE, 0x2162,
	0xFFFE, 0xFFFE, 0xFFFE, 0x2161, 0xFFFE, 0xFFFE, 0x2259, 0xFFFE,
	0xFFFE, 0xFFFE, 0x225D, 0x225F, 0x2260, 0xFFFE, 0xFFFE, 0x225C,
	0xFFFE, 0xFFFE, 0x225A, 0xFFFE, 0x225E, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x225B, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x245B, 0x2459, 0x244C,
	0xFFFE, 0x2453, 0xFFFE, 0x244D, 0xFFFE, 0x2455, 0xFFFE, 0x2452,
	0xFFFE, 0x2451, 0xFFFE, 0x245A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x244B, 0xFFFE, 0xFFFE, 0x245C, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x2765, 0xFFFE, 0xFFFE, 0xFFFE, 0x244E, 0xFFFE, 0xFFFE, 0x2456,
	0xFFFE, 0xFFFE, 0x2763, 0x244F, 0xFFFE, 0xFFFE, 0x245D, 0x2450,
	0xFFFE, 0xFFFE, 0xFFFE, 0x274F, 0xFFFE, 0x2457, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x2454, 0xFFFE, 0x2458, 0x2764, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2756, 0xFFFE, 0xFFFE,
	0x276B, 0xFFFE, 0xFFFE, 0xFFFE, 0x2762, 0xFFFE, 0x2754, 0x2758,
	0xFFFE, 0xFFFE, 0x275B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x2767, 0xFFFE, 0x275A, 0x275C, 0xFFFE, 0xFFFE, 0x275D, 0x276A,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2769, 0xFFFE, 0x276D,
	0x2759, 0x276F, 0x2760, 0xFFFE, 0x2755, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x2753, 0x2B57, 0xFFFE, 0xFFFE, 0x2761, 0x2766, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2757,
	0xFFFE, 0x276E, 0xFFFE, 0x2751, 0x2750, 0x275E, 0x2752, 0xFFFE,
	0xFFFE, 0xFFFE, 0x275F, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x276C, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_6D = { {
	0x2B5E, 0x2B61, 0xFFFE, 0x2B64, 0x2B59, 0xFFFE, 0xFFFE, 0x2B67,
	0x2B6A, 0x2B6C, 0x2B56, 0xFFFE, 0xFFFE, 0x302C, 0xFFFE, 0x2B65,
	0x2B6D, 0x2B5D, 0x2B55, 0xFFFE, 0xFFFE, 0xFFFE, 0x3047, 0xFFFE,
	0x2B62, 0x2B5A, 0x2B5C, 0xFFFE, 0xFFFE, 0x2B5F, 0xFFFE, 0x2B52,
	0x2B68, 0xFFFE, 0x2B6B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x2B4F, 0xFFFE, 0xFFFE, 0xFFFE, 0x2B69, 0x2B51, 0xFFFE, 0x3041,
	0x2768, 0xFFFE, 0xFFFE, 0x2B58, 0x2B50, 0xFFFE, 0xFFFE, 0x2B63,
	0xFFFE, 0xFFFE, 0x2B5B, 0xFFFE, 0x2B53, 0xFFFE, 0xFFFE, 0x2B54,
	0x2B66, 0xFFFE, 0x2B60, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x302F, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3038, 0x303E,
	0x303A, 0x302D, 0x3030, 0x3029, 0x302A, 0xFFFE, 0xFFFE, 0x3039,
	0x3042, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3031, 0xFFFE, 0x3032,
	0x303C, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x304B, 0x302B, 0xFFFE,
	0xFFFE, 0xFFFE, 0x3028, 0x3049, 0x303D, 0x304A, 0x3044, 0x3036,
	0x3045, 0xFFFE, 0x303F, 0x3048, 0x3046, 0xFFFE, 0x3037, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x3043, 0xFFFE, 0x3034, 0xFFFE, 0xFFFE,
	0x304C, 0x3033, 0x302E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x303B,
	0x3040, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x3645, 0x3649, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x3647, 0x3646, 0xFFFE, 0xFFFE, 0x364C,
	0xFFFE, 0xFFFE, 0x365E, 0x366A, 0xFFFE, 0x365B, 0x3654, 0xFFFE,
	0x3644, 0xFFFE, 0x3660, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x3650, 0x3662, 0x365A, 0xFFFE, 0xFFFE, 0x3668, 0xFFFE, 0x3661,
	0x3663, 0xFFFE, 0xFFFE, 0x3665, 0x364E, 0x365F, 0x3653, 0x3667,
	0xFFFE, 0xFFFE, 0xFFFE, 0x3658, 0x3656, 0x3657, 0xFFFE, 0x3652,
	0x3651, 0xFFFE, 0x364B, 0x3669, 0xFFFE, 0x3655, 0xFFFE, 0xFFFE,
	0xFFFE, 0x364A, 0xFFFE, 0xFFFE, 0xFFFE, 0x365C, 0xFFFE, 0x3035,
	0x365D, 0xFFFE, 0x3664, 0xFFFE, 0x3659, 0xFFFE, 0x364D, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3D2C, 0x3666, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_6E = { {
	0x364F, 0xFFFE, 0xFFFE, 0x3D41, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3D3B, 0xFFFE, 0xFFFE, 0x3D2F,
	0xFFFE, 0xFFFE, 0x3D4D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3D51,
	0x3D48, 0xFFFE, 0xFFFE, 0x3D36, 0xFFFE, 0xFFFE, 0x3D42, 0xFFFE,
	0x3D4E, 0x3D47, 0xFFFE, 0x3D3C, 0xFFFE, 0x3D59, 0x3D5A, 0xFFFE,
	0xFFFE, 0x3D4C, 0xFFFE, 0x3D40, 0x3D32, 0x3D33, 0xFFFE, 0x3D37,
	0x3D3E, 0x3D38, 0xFFFE, 0xFFFE, 0xFFFE, 0x3D34, 0x3D2D, 0x3D2E,
	0xFFFE, 0x3D30, 0xFFFE, 0x3D3D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x3D3F, 0x3D57, 0x3D4F, 0xFFFE, 0x3D55, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x3D5B, 0xFFFE, 0x3D45, 0x3D39, 0x3D43, 0xFFFE,
	0x3D49, 0x3D46, 0x3D35, 0xFFFE, 0x3D53, 0x3D50, 0x3D58, 0xFFFE,
	0x3D44, 0xFFFE, 0xFFFE, 0x3D4B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x3D4A, 0xFFFE, 0x3D3A, 0x3648, 0xFFFE, 0xFFFE, 0x3D54,
	0x3D52, 0x3D56, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x3D31, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4447, 0x4446, 0x442C,
	0xFFFE, 0xFFFE, 0x4445, 0x442F, 0x4430, 0xFFFE, 0xFFFE, 0x444E,
	0xFFFE, 0x4444, 0xFFFE, 0x4429, 0xFFFE, 0xFFFE, 0x4438, 0x442E,
	0x4431, 0x4449, 0xFFFE, 0x4450, 0x4448, 0xFFFE, 0x443D, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x444F, 0xFFFE,
	0x443B, 0x4432, 0x443F, 0x444B, 0xFFFE, 0xFFFE, 0xFFFE, 0x443A,
	0xFFFE, 0x4433, 0xFFFE, 0xFFFE, 0xFFFE, 0x4436, 0x4440, 0x444A,
	0x442D, 0x4437, 0xFFFE, 0x4441, 0xFFFE, 0xFFFE, 0x4434, 0xFFFE,
	0x442B, 0x4439, 0x444D, 0xFFFE, 0xFFFE, 0x443C, 0x4B34, 0x443E,
	0x444C, 0xFFFE, 0x4435, 0xFFFE, 0xFFFE, 0xFFFE, 0x442A, 0xFFFE,
	0x4443, 0xFFFE, 0xFFFE, 0xFFFE, 0x4442, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x4B50, 0xFFFE, 0x4B45, 0x4B4A, 0xFFFE,
	0xFFFE, 0x4B36, 0xFFFE, 0xFFFE, 0xFFFE, 0x4B35, 0x4B56, 0xFFFE,
	0x4B39, 0x4B49, 0xFFFE, 0x4B3B, 0x4B59, 0x4B55, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_6F = { {
	0x515B, 0xFFFE, 0xFFFE, 0x4B37, 0xFFFE, 0x4B54, 0xFFFE, 0x4B51,
	0x4B5E, 0x4B3D, 0x4B46, 0xFFFE, 0xFFFE, 0x4B5C, 0x4B52, 0xFFFE,
	0xFFFE, 0xFFFE, 0x4B44, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x4B42, 0x4B3F, 0x4B40, 0xFFFE, 0x4B58, 0xFFFE, 0x4B5D, 0x4B5B,
	0xFFFE, 0x4B5F, 0xFFFE, 0xFFFE, 0xFFFE, 0x4B38, 0x5143, 0x4B41,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4B4B, 0x4B3C, 0xFFFE,
	0x4B4D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4B4F, 0x4B47, 0x4B3A,
	0xFFFE, 0x4B57, 0x4B5A, 0x4B43, 0x4B4E, 0xFFFE, 0xFFFE, 0xFFFE,
	0x4B4C, 0x5142, 0xFFFE, 0x4B53, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4B3E, 0x514C,
	0x5156, 0xFFFE, 0x5155, 0x5161, 0xFFFE, 0x5153, 0xFFFE, 0x5157,
	0xFFFE, 0xFFFE, 0x514E, 0xFFFE, 0xFFFE, 0x515A, 0x577B, 0xFFFE,
	0xFFFE, 0x515C, 0x514B, 0x5166, 0xFFFE, 0xFFFE, 0xFFFE, 0x515F,
	0xFFFE, 0x5163, 0x5168, 0x515D, 0x5151, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x5154, 0x4B48, 0xFFFE, 0xFFFE, 0x5150, 0x5167,
	0xFFFE, 0xFFFE, 0xFFFE, 0x5169, 0xFFFE, 0x515E, 0x5144, 0x5164,
	0xFFFE, 0xFFFE, 0x5152, 0xFFFE, 0xFFFE, 0x514D, 0xFFFE, 0x5145,
	0xFFFE, 0x5149, 0xFFFE, 0x5162, 0x514A, 0x5148, 0xFFFE, 0xFFFE,
	0x5160, 0xFFFE, 0x5147, 0x5159, 0x5158, 0x5165, 0x514F, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x577E, 0xFFFE,
	0xFFFE, 0xFFFE, 0x582C, 0x5776, 0xFFFE, 0x5824, 0xFFFE, 0xFFFE,
	0x5822, 0x5D3B, 0x5828, 0x582E, 0x5827, 0x5774, 0x5825, 0x5830,
	0x5832, 0xFFFE, 0x5831, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x582B, 0xFFFE, 0x5826, 0xFFFE, 0x5778, 0x577D, 0xFFFE, 0x582A,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x577C, 0xFFFE, 0x5146, 0x5777,
	0x577A, 0x582D, 0x5821, 0x5775, 0x5D3A, 0x582F, 0x5779, 0x5829,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5D3D, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5D3F, 0x5D45, 0x5D43, 0xFFFE,
	0xFFFE, 0xFFFE, 0x5D46, 0x5D3E, 0xFFFE, 0xFFFE, 0x5D42, 0x5D41,
	0x5D47, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5D40, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x5D44, 0xFFFE, 0x5D3C, 0xFFFE, 0xFFFE, 0x6225,
	0xFFFE, 0xFFFE, 0xFFFE, 0x6222, 0x6224, 0xFFFE, 0xFFFE, 0x617E
} };

static const iconv_ccs_convtable_8bit from_ucs_70 = { {
	0x6221, 0x617A, 0xFFFE, 0xFFFE, 0x5823, 0x617B, 0xFFFE, 0x6177,
	0xFFFE, 0xFFFE, 0x6226, 0xFFFE, 0x6178, 0x6179, 0x617D, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x617C, 0xFFFE, 0x656A, 0x6570,
	0xFFFE, 0x6567, 0xFFFE, 0xFFFE, 0x6572, 0xFFFE, 0xFFFE, 0xFFFE,
	0x6569, 0x656C, 0x656D, 0x656E, 0x6571, 0xFFFE, 0x6223, 0x6568,
	0xFFFE, 0x656F, 0x6934, 0x656B, 0xFFFE, 0xFFFE, 0xFFFE, 0x692B,
	0xFFFE, 0x692E, 0xFFFE, 0x6937, 0x692D, 0x692A, 0xFFFE, 0x692C,
	0x6930, 0x6933, 0x6932, 0x6936, 0x6929, 0xFFFE, 0xFFFE, 0x6931,
	0x6935, 0x6938, 0x692F, 0x6B61, 0x6B62, 0x6B66, 0x6B67, 0xFFFE,
	0x6B64, 0x6B65, 0x6B63, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x6D59, 0xFFFE, 0xFFFE, 0x6D56, 0x6D57, 0x6D58,
	0xFFFE, 0xFFFE, 0x6F34, 0x6F33, 0xFFFE, 0x703D, 0xFFFE, 0x703B,
	0x703E, 0x703C, 0x7125, 0xFFFE, 0xFFFE, 0x7171, 0x715B, 0xFFFE,
	0x7170, 0x723E, 0x723F, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x2261, 0xFFFE, 0xFFFE, 0x245E, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x245F, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x2778, 0x277A, 0x2775, 0x2772, 0x2774, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x2776, 0xFFFE, 0x2773, 0x2770, 0xFFFE, 0x2777, 0xFFFE,
	0x2771, 0xFFFE, 0x2779, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2B6F,
	0xFFFE, 0x2B73, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x2B76, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x2B72, 0x2B71, 0xFFFE, 0xFFFE, 0x2B74, 0x2B75, 0xFFFE, 0x2B6E,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2B70, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x305A, 0x305B, 0x305C,
	0xFFFE, 0xFFFE, 0xFFFE, 0x3051, 0xFFFE, 0x3059, 0x305E, 0xFFFE,
	0xFFFE, 0x304F, 0x3055, 0x304E, 0x3058, 0xFFFE, 0xFFFE, 0x3054,
	0xFFFE, 0xFFFE, 0x305D, 0xFFFE, 0x304D, 0x3050, 0x3056, 0xFFFE,
	0x3057, 0x305F, 0x3053, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x3671, 0xFFFE, 0xFFFE, 0x3673, 0x366F, 0xFFFE, 0x367B, 0x366D,
	0x367A, 0xFFFE, 0x366B, 0x3D5F, 0x3675, 0xFFFE, 0xFFFE, 0x3676
} };

static const iconv_ccs_convtable_8bit from_ucs_71 = { {
	0x3679, 0xFFFE, 0x367D, 0xFFFE, 0x3672, 0xFFFE, 0x3677, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x367C, 0x3670, 0x366C, 0x367E, 0xFFFE,
	0x3674, 0xFFFE, 0xFFFE, 0x3678, 0xFFFE, 0xFFFE, 0xFFFE, 0x366E,
	0xFFFE, 0xFFFE, 0xFFFE, 0x3D69, 0xFFFE, 0xFFFE, 0x3D5D, 0x3D66,
	0x3D5C, 0xFFFE, 0x3D64, 0x3D62, 0xFFFE, 0x3D63, 0xFFFE, 0xFFFE,
	0x3D67, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3D60, 0x3D5E,
	0xFFFE, 0x3D61, 0x3D65, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x3D68, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x4456, 0x445D, 0x445F, 0x4465, 0xFFFE, 0xFFFE, 0x4451,
	0xFFFE, 0xFFFE, 0xFFFE, 0x4460, 0xFFFE, 0x4466, 0xFFFE, 0xFFFE,
	0x4463, 0xFFFE, 0x4453, 0x4464, 0x4452, 0xFFFE, 0xFFFE, 0xFFFE,
	0x445E, 0xFFFE, 0x4467, 0xFFFE, 0xFFFE, 0x4457, 0xFFFE, 0x4462,
	0x4455, 0x445C, 0x4458, 0x4454, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x445B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x4461, 0xFFFE, 0x4459, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x445A, 0xFFFE, 0xFFFE, 0x4B67, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x4B63, 0x4B69, 0x4B65, 0xFFFE, 0xFFFE, 0x4B64, 0x4B68, 0x4B60,
	0xFFFE, 0x4B62, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4B66,
	0x4B61, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4B6A,
	0xFFFE, 0xFFFE, 0x516F, 0x516C, 0x5178, 0x5172, 0x5174, 0xFFFE,
	0x516E, 0x5176, 0xFFFE, 0xFFFE, 0x5175, 0x5173, 0xFFFE, 0x5179,
	0xFFFE, 0x5170, 0x5177, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x516B,
	0x516D, 0xFFFE, 0x516A, 0x517A, 0xFFFE, 0x5171, 0xFFFE, 0xFFFE,
	0x5836, 0xFFFE, 0xFFFE, 0xFFFE, 0x5841, 0x583F, 0xFFFE, 0x5835,
	0x5838, 0x5839, 0x5834, 0xFFFE, 0xFFFE, 0x5833, 0x5842, 0x583D,
	0xFFFE, 0xFFFE, 0x583C, 0x583A, 0xFFFE, 0xFFFE, 0xFFFE, 0x583E,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x583B, 0xFFFE, 0x5837, 0xFFFE,
	0x5840, 0xFFFE, 0x5843, 0x5844, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5D48, 0x5D4E, 0xFFFE, 0x5D4C, 0xFFFE, 0xFFFE, 0xFFFE,
	0x5D4A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x5D4D, 0x5D49, 0x5D4B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x6229, 0xFFFE, 0xFFFE, 0xFFFE, 0x622B, 0xFFFE, 0x6228
} };

static const iconv_ccs_convtable_8bit from_ucs_72 = { {
	0xFFFE, 0x6227, 0x6576, 0x622A, 0xFFFE, 0x6577, 0xFFFE, 0x6575,
	0xFFFE, 0xFFFE, 0x6574, 0xFFFE, 0x6573, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x6939, 0x693A, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x6B6A, 0x6B69, 0xFFFE, 0xFFFE, 0x6B68, 0x6D5A, 0x6D5B,
	0xFFFE, 0xFFFE, 0x6F35, 0x703F, 0xFFFE, 0xFFFE, 0x7126, 0x722C,
	0xFFFE, 0x7240, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2142,
	0xFFFE, 0x2B77, 0x3060, 0xFFFE, 0x4B6B, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x2B78, 0x2B79, 0x3D6A, 0xFFFE, 0xFFFE, 0xFFFE, 0x4468,
	0xFFFE, 0xFFFE, 0xFFFE, 0x4B6C, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x3D6B, 0xFFFE, 0xFFFE, 0xFFFE, 0x2262, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x2460, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x277B, 0xFFFE, 0x2B7A, 0xFFFE, 0x2B7D, 0xFFFE,
	0x2B7B, 0xFFFE, 0xFFFE, 0x2B7C, 0xFFFE, 0xFFFE, 0x3063, 0x3062,
	0x3061, 0xFFFE, 0xFFFE, 0x3722, 0x3723, 0xFFFE, 0x3721, 0x3724,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3D6F, 0x3D6E, 0xFFFE,
	0x3D6C, 0x3D6D, 0xFFFE, 0x3D70, 0x446A, 0x4469, 0x446D, 0xFFFE,
	0x446C, 0x446B, 0xFFFE, 0x4B6F, 0xFFFE, 0x4B6E, 0xFFFE, 0x4B6D,
	0x517B, 0xFFFE, 0x517C, 0xFFFE, 0xFFFE, 0x5845, 0x5846, 0xFFFE,
	0xFFFE, 0x657C, 0xFFFE, 0x657B, 0x657A, 0x6578, 0x6579, 0xFFFE,
	0x693B, 0x6D5C, 0x7127, 0xFFFE, 0xFFFE, 0xFFFE, 0x2164, 0xFFFE,
	0x2165, 0xFFFE, 0xFFFE, 0xFFFE, 0x2263, 0x2264, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x2466, 0xFFFE, 0xFFFE, 0x2462, 0xFFFE, 0x2461,
	0xFFFE, 0x2465, 0xFFFE, 0x2463, 0xFFFE, 0x2467, 0x2464, 0xFFFE,
	0xFFFE, 0x2821, 0x2B7E, 0x277D, 0x2826, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x2827, 0x2823, 0xFFFE, 0x2824, 0xFFFE, 0x277C, 0xFFFE,
	0x277E, 0xFFFE, 0x2825, 0xFFFE, 0x2822, 0xFFFE, 0xFFFE, 0x2C24,
	0xFFFE, 0xFFFE, 0xFFFE, 0x2C27, 0x2C21, 0xFFFE, 0x2C26, 0xFFFE,
	0x2C22, 0xFFFE, 0x2C25, 0x2C23, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x3069, 0x3066, 0xFFFE, 0x3068, 0xFFFE,
	0xFFFE, 0xFFFE, 0x3065, 0x306A, 0xFFFE, 0xFFFE, 0x3067, 0x372C
} };

static const iconv_ccs_convtable_8bit from_ucs_73 = { {
	0x3064, 0x306B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3727,
	0x372B, 0xFFFE, 0x372A, 0x3D72, 0x3D7D, 0xFFFE, 0xFFFE, 0x372D,
	0xFFFE, 0x3728, 0x3D71, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3726,
	0x3729, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3725, 0x372E, 0xFFFE,
	0xFFFE, 0xFFFE, 0x3D74, 0x3D7B, 0xFFFE, 0xFFFE, 0x3D7A, 0x3D77,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3D79, 0xFFFE, 0xFFFE,
	0x3D73, 0x3D75, 0x3D78, 0x3D76, 0xFFFE, 0x3D7C, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x4471, 0x4470, 0x446E, 0xFFFE, 0xFFFE, 0xFFFE,
	0x4472, 0xFFFE, 0x446F, 0x4B70, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x4474, 0x4473, 0xFFFE, 0x4B73, 0x4B71, 0xFFFE, 0xFFFE,
	0xFFFE, 0x4B72, 0x517E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x517D, 0x5228, 0x5227, 0x5225, 0xFFFE, 0x5224, 0x5221, 0x5222,
	0x5223, 0x5226, 0x5229, 0xFFFE, 0xFFFE, 0x584B, 0x5848, 0x5849,
	0xFFFE, 0x5847, 0x584D, 0x584C, 0x584A, 0xFFFE, 0x5D50, 0x5D51,
	0xFFFE, 0xFFFE, 0xFFFE, 0x5D4F, 0xFFFE, 0xFFFE, 0x622C, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x693D, 0x693C, 0x6B6B, 0x6D5D,
	0xFFFE, 0x6F37, 0x6F36, 0x6F38, 0xFFFE, 0x2C28, 0xFFFE, 0xFFFE,
	0x372F, 0xFFFE, 0x2166, 0xFFFE, 0xFFFE, 0xFFFE, 0x2265, 0xFFFE,
	0xFFFE, 0xFFFE, 0x246C, 0x246A, 0x246B, 0x2468, 0xFFFE, 0x2469,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x282F, 0xFFFE, 0xFFFE,
	0x282D, 0x2829, 0x282C, 0xFFFE, 0x2828, 0xFFFE, 0x282B, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x282E, 0x282A, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2C30, 0x2C2F, 0x2C2E, 0xFFFE,
	0x2C37, 0x2C2D, 0xFFFE, 0xFFFE, 0x3070, 0xFFFE, 0x2C34, 0x2C32,
	0xFFFE, 0xFFFE, 0x2C2A, 0x2C35, 0xFFFE, 0x2C2C, 0x2C36, 0x2C33,
	0x2C2B, 0xFFFE, 0xFFFE, 0x2C38, 0x2C29, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x3075, 0x306C, 0x3077, 0xFFFE, 0x306F, 0x307A,
	0x307B, 0x306D, 0x3079, 0x3076, 0x3074, 0x3078, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x3072, 0xFFFE, 0x306E, 0xFFFE, 0x3071,
	0x307C, 0x3073, 0xFFFE, 0x2C31, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x373D, 0x3732, 0x3730, 0xFFFE,
	0x3731, 0xFFFE, 0x3738, 0xFFFE, 0x3739, 0x3735, 0xFFFE, 0x373A
} };

static const iconv_ccs_convtable_8bit from_ucs_74 = { {
	0x3737, 0x3734, 0xFFFE, 0xFFFE, 0x3733, 0xFFFE, 0xFFFE, 0x3736,
	0x373E, 0xFFFE, 0xFFFE, 0x373C, 0x373B, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3E24, 0xFFFE,
	0xFFFE, 0xFFFE, 0x3E25, 0xFFFE, 0xFFFE, 0x3E2B, 0xFFFE, 0xFFFE,
	0x3E2D, 0x3E26, 0xFFFE, 0x3E2A, 0x3E29, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x3E2C, 0xFFFE, 0x3E23, 0x3E21, 0x3E27, 0x3D7E, 0xFFFE,
	0x3E22, 0x3E28, 0x3E2E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x447B, 0xFFFE, 0x4521, 0xFFFE, 0x4475, 0xFFFE, 0x4522, 0xFFFE,
	0xFFFE, 0xFFFE, 0x4476, 0x4477, 0xFFFE, 0x4523, 0x447E, 0x447C,
	0x447D, 0x4479, 0x4478, 0xFFFE, 0x4524, 0xFFFE, 0xFFFE, 0x447A,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x4B74, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4B79,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4B7A, 0xFFFE,
	0xFFFE, 0x4B76, 0x4B78, 0x4B75, 0xFFFE, 0x4B77, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5233, 0xFFFE, 0xFFFE, 0x5232, 0x522F, 0xFFFE, 0x584E,
	0xFFFE, 0x522E, 0xFFFE, 0xFFFE, 0xFFFE, 0x5230, 0x522D, 0x522A,
	0x5231, 0x522B, 0x522C, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x5D55, 0xFFFE, 0x5852, 0xFFFE, 0x5851, 0x5853, 0xFFFE, 0x5D52,
	0xFFFE, 0xFFFE, 0x584F, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x5850, 0x5854, 0xFFFE, 0xFFFE, 0xFFFE, 0x5D59, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x5D56, 0x5D54, 0xFFFE, 0x5D57, 0xFFFE, 0x5D5A,
	0xFFFE, 0x5D58, 0x5D53, 0xFFFE, 0xFFFE, 0x622F, 0x6232, 0x6621,
	0x622D, 0xFFFE, 0x693E, 0x6233, 0xFFFE, 0xFFFE, 0x6231, 0xFFFE,
	0x622E, 0x6230, 0x6234, 0x6622, 0xFFFE, 0x657E, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x657D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6D5F, 0xFFFE, 0x6D61,
	0x6D5E, 0x6D60, 0xFFFE, 0x7040, 0xFFFE, 0x2830, 0x307D, 0x307E,
	0xFFFE, 0x4525, 0xFFFE, 0xFFFE, 0xFFFE, 0x7041, 0xFFFE, 0xFFFE,
	0x2831, 0xFFFE, 0xFFFE, 0xFFFE, 0x2C39, 0xFFFE, 0x2C3A, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3121, 0x3122, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x3E2F, 0xFFFE, 0x4528, 0x4527, 0x4526
} };

static const iconv_ccs_convtable_8bit from_ucs_75 = { {
	0x4B7B, 0xFFFE, 0x4B7C, 0x4B7D, 0xFFFE, 0xFFFE, 0xFFFE, 0x5235,
	0x5234, 0xFFFE, 0xFFFE, 0x5855, 0xFFFE, 0xFFFE, 0xFFFE, 0x5D5E,
	0x5D5B, 0x5D5C, 0x5D5D, 0x6236, 0x6235, 0xFFFE, 0x6623, 0x6B6C,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4529, 0xFFFE, 0xFFFE,
	0xFFFE, 0x3123, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x2266, 0xFFFE, 0xFFFE, 0xFFFE, 0x2C3B, 0x3E30,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x246E, 0x246D, 0xFFFE, 0xFFFE, 0xFFFE, 0x2834, 0x2832,
	0x2833, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2C3C,
	0x2C3D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x3124, 0xFFFE, 0xFFFE, 0xFFFE, 0x3125,
	0xFFFE, 0xFFFE, 0xFFFE, 0x3740, 0x373F, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3E32, 0xFFFE, 0xFFFE, 0x3E31,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x452B,
	0xFFFE, 0x452A, 0xFFFE, 0xFFFE, 0xFFFE, 0x4B7E, 0x5236, 0xFFFE,
	0x5856, 0xFFFE, 0xFFFE, 0xFFFE, 0x5D5F, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2835, 0xFFFE, 0xFFFE, 0xFFFE,
	0x4C21, 0xFFFE, 0xFFFE, 0xFFFE, 0x246F, 0x2470, 0xFFFE, 0xFFFE,
	0x2836, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2C3E,
	0xFFFE, 0xFFFE, 0x2C3F, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x3126, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x312C, 0xFFFE,
	0xFFFE, 0xFFFE, 0x312D, 0x3128, 0xFFFE, 0xFFFE, 0xFFFE, 0x312B,
	0x312A, 0x3127, 0xFFFE, 0xFFFE, 0x3129, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x3744, 0x3745, 0xFFFE, 0x3741, 0x3743,
	0x3747, 0x3746, 0x3742, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3E3A,
	0xFFFE, 0xFFFE, 0x3E34, 0xFFFE, 0xFFFE, 0x3E37, 0xFFFE, 0x3E38,
	0xFFFE, 0x3E35, 0xFFFE, 0xFFFE, 0x3E39, 0xFFFE, 0x3E36, 0x3E33,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4538, 0xFFFE, 0x452D,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4539, 0x4537, 0x4530,
	0x4534, 0x4533, 0xFFFE, 0x4536, 0x4532, 0x453A, 0x4531, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_76 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0x452F, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x4C23, 0xFFFE, 0x4C27, 0xFFFE, 0x4C24, 0xFFFE, 0xFFFE, 0x452E,
	0x4535, 0x4C26, 0xFFFE, 0xFFFE, 0x4C28, 0x4C25, 0x4C22, 0xFFFE,
	0xFFFE, 0x5239, 0x523D, 0x523F, 0x523B, 0x523A, 0x5238, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x523C, 0xFFFE, 0x5237, 0xFFFE, 0xFFFE,
	0x523E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5858, 0xFFFE, 0x5857,
	0x585F, 0x5859, 0x585E, 0x585B, 0xFFFE, 0x585D, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x585C, 0x585A, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x5D60, 0xFFFE, 0xFFFE, 0xFFFE, 0x5D63,
	0x5D61, 0x5D62, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x623A, 0xFFFE, 0xFFFE, 0x623B, 0xFFFE, 0xFFFE, 0xFFFE, 0x623C,
	0xFFFE, 0x6239, 0x623D, 0xFFFE, 0x6237, 0xFFFE, 0xFFFE, 0xFFFE,
	0x6624, 0xFFFE, 0xFFFE, 0xFFFE, 0x6238, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x6B6D, 0xFFFE, 0xFFFE, 0x6D62, 0xFFFE, 0xFFFE,
	0x6F39, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x723A, 0xFFFE, 0xFFFE,
	0xFFFE, 0x2C40, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2267,
	0xFFFE, 0x2471, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x3749, 0x312E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3748,
	0xFFFE, 0xFFFE, 0x3E3C, 0xFFFE, 0xFFFE, 0x3E3B, 0xFFFE, 0xFFFE,
	0xFFFE, 0x453B, 0xFFFE, 0x5243, 0x5240, 0x5241, 0x5242, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5D64, 0xFFFE, 0x623E, 0xFFFE,
	0xFFFE, 0xFFFE, 0x6940, 0x693F, 0xFFFE, 0x6D63, 0xFFFE, 0x2837,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x453C, 0xFFFE, 0xFFFE,
	0x4C29, 0xFFFE, 0xFFFE, 0x5860, 0xFFFE, 0x623F, 0x6941, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2C41, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x312F, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x374A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x3E3D, 0xFFFE, 0xFFFE, 0x453D, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5861, 0xFFFE,
	0xFFFE, 0x5D65, 0xFFFE, 0xFFFE, 0x6240, 0x6942, 0xFFFE, 0xFFFE,
	0x283A, 0x2839, 0xFFFE, 0x2838, 0xFFFE, 0x283B, 0xFFFE, 0x2C47,
	0xFFFE, 0xFFFE, 0x2C49, 0x2C48, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_77 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0x2C43, 0x2C44, 0x2C45, 0xFFFE, 0xFFFE,
	0x2C42, 0xFFFE, 0x2C46, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x3132, 0x3136, 0x3134, 0x3133, 0xFFFE, 0x3137, 0xFFFE, 0xFFFE,
	0xFFFE, 0x3138, 0x3139, 0x3131, 0xFFFE, 0x3130, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x313A, 0x3135, 0xFFFE, 0x3753, 0xFFFE, 0x313B,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x374D, 0xFFFE, 0x374C,
	0xFFFE, 0x374E, 0x374F, 0x3751, 0x3750, 0x3755, 0xFFFE, 0xFFFE,
	0xFFFE, 0x374B, 0xFFFE, 0x3754, 0xFFFE, 0x3752, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3E40, 0x3E42, 0x3E3E, 0x3E3F,
	0xFFFE, 0xFFFE, 0x3E43, 0x3E45, 0x3E46, 0x3E41, 0x3E44, 0xFFFE,
	0xFFFE, 0xFFFE, 0x4541, 0xFFFE, 0x4546, 0x453E, 0x4542, 0xFFFE,
	0xFFFE, 0x4547, 0x4543, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x453F,
	0x4540, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4545,
	0xFFFE, 0x4544, 0xFFFE, 0xFFFE, 0xFFFE, 0x4548, 0x4C2E, 0x4C30,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4C2B, 0xFFFE, 0x4C31, 0xFFFE,
	0x4C2F, 0x4C2A, 0x4C2D, 0x4C32, 0xFFFE, 0x4C2C, 0xFFFE, 0xFFFE,
	0x5247, 0x5246, 0xFFFE, 0xFFFE, 0xFFFE, 0x5244, 0xFFFE, 0x5245,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5869, 0xFFFE, 0x586B,
	0xFFFE, 0x586A, 0x5862, 0x5866, 0x5865, 0x5863, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5864, 0x5867, 0x5868, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x5D6D, 0xFFFE, 0xFFFE, 0x5D67, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5D6C, 0x5D68, 0xFFFE, 0x5D6B, 0x5D66, 0x5D6A, 0x5D69,
	0xFFFE, 0xFFFE, 0x6242, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x6241, 0xFFFE, 0x6627, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x6625, 0x6626, 0xFFFE, 0x6943, 0x6946, 0x6944, 0x6945,
	0x6B6E, 0xFFFE, 0xFFFE, 0xFFFE, 0x6F3A, 0x7042, 0xFFFE, 0xFFFE,
	0x7128, 0x7129, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3E47, 0xFFFE,
	0x4549, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2C4A,
	0x2C4B, 0xFFFE, 0xFFFE, 0xFFFE, 0x3E48, 0xFFFE, 0xFFFE, 0xFFFE,
	0x5D6E, 0x6628, 0x6947, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2841,
	0x283C, 0x283E, 0x2840, 0x283F, 0x283D, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_78 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0x2C54, 0xFFFE, 0x2C4F, 0x2C4C, 0xFFFE,
	0xFFFE, 0x2C53, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2C52, 0x2C51,
	0x2C50, 0x2C4D, 0x2C4E, 0x2C55, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x3144, 0x313E, 0x313C, 0xFFFE, 0xFFFE, 0x375C, 0xFFFE,
	0x3141, 0x3145, 0x3147, 0x3143, 0x313D, 0xFFFE, 0x3142, 0x3140,
	0xFFFE, 0x3148, 0xFFFE, 0x3146, 0xFFFE, 0x313F, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x375D, 0xFFFE, 0xFFFE,
	0x3756, 0x3758, 0x375A, 0xFFFE, 0x375B, 0x3759, 0xFFFE, 0xFFFE,
	0x375E, 0xFFFE, 0x3757, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3E4C, 0xFFFE, 0x3E54, 0xFFFE,
	0x3E49, 0xFFFE, 0x3E55, 0xFFFE, 0x3E4A, 0x3E4B, 0xFFFE, 0xFFFE,
	0x3E53, 0x3E52, 0x3E4F, 0xFFFE, 0xFFFE, 0x3E4D, 0x3E50, 0xFFFE,
	0x3E51, 0x3E4E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x4554, 0xFFFE, 0x4558, 0xFFFE, 0xFFFE, 0x4C38, 0xFFFE,
	0x4556, 0xFFFE, 0xFFFE, 0x4553, 0x454E, 0x4550, 0x4551, 0x454A,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x454D,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x454C, 0x454F, 0x4557, 0xFFFE,
	0xFFFE, 0x4555, 0x454B, 0xFFFE, 0xFFFE, 0xFFFE, 0x4C3A, 0xFFFE,
	0x4C3C, 0x4552, 0x4C3E, 0xFFFE, 0x4C3F, 0x4C3B, 0xFFFE, 0xFFFE,
	0x4C37, 0xFFFE, 0x4C34, 0x4C39, 0x4C3D, 0x4C36, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x4C33, 0xFFFE, 0x4C35, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x5249, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x5250, 0x5251, 0xFFFE, 0xFFFE, 0xFFFE,
	0x524F, 0x5252, 0xFFFE, 0xFFFE, 0x524B, 0x5248, 0x524D, 0x524A,
	0xFFFE, 0x524C, 0xFFFE, 0xFFFE, 0x524E, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x5872, 0xFFFE, 0x586C, 0x5870, 0x5876,
	0x5877, 0x5873, 0x5874, 0x5871, 0xFFFE, 0x586E, 0xFFFE, 0xFFFE,
	0xFFFE, 0x586D, 0x586F, 0xFFFE, 0xFFFE, 0x5875, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x5D75, 0x5D6F, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5D77, 0xFFFE, 0x5D72, 0x5D73, 0x5D70, 0x5D78, 0x5D74
} };

static const iconv_ccs_convtable_8bit from_ucs_79 = { {
	0xFFFE, 0xFFFE, 0x5D71, 0xFFFE, 0x5D79, 0x5D76, 0xFFFE, 0xFFFE,
	0xFFFE, 0x6246, 0xFFFE, 0xFFFE, 0x6243, 0xFFFE, 0xFFFE, 0xFFFE,
	0x6247, 0x6249, 0x6248, 0x6244, 0x6245, 0xFFFE, 0xFFFE, 0x662D,
	0xFFFE, 0xFFFE, 0xFFFE, 0x662A, 0x662C, 0x6629, 0x662E, 0xFFFE,
	0xFFFE, 0x662B, 0xFFFE, 0x6949, 0x694C, 0x6948, 0xFFFE, 0x694A,
	0x694B, 0x694D, 0xFFFE, 0xFFFE, 0xFFFE, 0x6B6F, 0xFFFE, 0x6B71,
	0xFFFE, 0x6B70, 0xFFFE, 0xFFFE, 0xFFFE, 0x6D64, 0xFFFE, 0xFFFE,
	0x7043, 0x712A, 0xFFFE, 0xFFFE, 0xFFFE, 0x2472, 0xFFFE, 0x2843,
	0xFFFE, 0xFFFE, 0x2842, 0xFFFE, 0x2C5A, 0x2C59, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x2C56, 0x2C58, 0x2C57, 0xFFFE, 0xFFFE, 0x314B,
	0xFFFE, 0x314F, 0x314E, 0x314D, 0x3149, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x314A, 0x314C, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x3765, 0xFFFE, 0x3763, 0x375F, 0xFFFE, 0xFFFE, 0x3760,
	0xFFFE, 0x3761, 0x3762, 0x3764, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x3E59, 0xFFFE, 0x3E58, 0x3E57, 0x3E56, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x455C, 0xFFFE, 0xFFFE, 0x4559, 0x455B, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x455A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x4C48, 0xFFFE, 0x4C41, 0x4C42, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x4C4A, 0xFFFE, 0x4C49, 0x4C46, 0x4C45, 0x4C44, 0x4C43, 0x4C47,
	0x4C40, 0xFFFE, 0x5253, 0x5258, 0x5256, 0xFFFE, 0xFFFE, 0xFFFE,
	0x5255, 0x5254, 0x5257, 0xFFFE, 0x5878, 0xFFFE, 0xFFFE, 0xFFFE,
	0x5D7B, 0xFFFE, 0xFFFE, 0x5D7A, 0x624B, 0x624A, 0xFFFE, 0xFFFE,
	0x662F, 0xFFFE, 0x694E, 0xFFFE, 0x6D65, 0xFFFE, 0x7045, 0x7044,
	0x2167, 0xFFFE, 0xFFFE, 0x3766, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2844, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2C5C, 0x2C5F, 0x2C5D,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2C5B, 0x2C5E, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3156, 0x3158, 0x3157, 0xFFFE,
	0x3152, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x3155, 0x3150, 0x3151, 0x3154, 0x3153, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3769, 0x376A,
	0x3768, 0xFFFE, 0x3767, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_7A = { {
	0xFFFE, 0xFFFE, 0x3E5A, 0x3E5C, 0x3E5E, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x3E5B, 0xFFFE, 0x3E5D, 0xFFFE, 0xFFFE, 0xFFFE,
	0x4566, 0x455D, 0x4560, 0x4564, 0xFFFE, 0x4562, 0xFFFE, 0x4561,
	0x455E, 0x455F, 0xFFFE, 0x4565, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x4563, 0xFFFE, 0xFFFE, 0xFFFE, 0x4C50, 0xFFFE,
	0x4C4F, 0xFFFE, 0xFFFE, 0x4C4B, 0xFFFE, 0xFFFE, 0xFFFE, 0x4C4E,
	0x4C4D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x525A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5879, 0xFFFE, 0xFFFE, 0x587B,
	0x587A, 0xFFFE, 0x4C4C, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5E22, 0xFFFE, 0x5D7E, 0xFFFE,
	0x5E21, 0xFFFE, 0x5E23, 0x5D7D, 0x5D7C, 0xFFFE, 0xFFFE, 0x624C,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6630,
	0x6631, 0xFFFE, 0xFFFE, 0xFFFE, 0x6950, 0x6951, 0x694F, 0xFFFE,
	0x6D66, 0x6D67, 0xFFFE, 0xFFFE, 0xFFFE, 0x2268, 0xFFFE, 0xFFFE,
	0x2845, 0xFFFE, 0xFFFE, 0x2846, 0xFFFE, 0xFFFE, 0x2C61, 0xFFFE,
	0x2C60, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x315B, 0x3159, 0x315F,
	0xFFFE, 0x315A, 0x315E, 0x315C, 0x315D, 0xFFFE, 0xFFFE, 0x376B,
	0x376D, 0xFFFE, 0xFFFE, 0xFFFE, 0x376C, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x3E5F, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4569, 0xFFFE,
	0xFFFE, 0xFFFE, 0x4568, 0x4567, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x4C51, 0xFFFE, 0xFFFE, 0x4C52, 0x4C53, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5921, 0x525B, 0x525D, 0x525C, 0x587E, 0x587C, 0x5922,
	0x587D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5E24, 0xFFFE,
	0x5E25, 0x5E26, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x2C62, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x3160, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3E61, 0xFFFE, 0x3E60, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x456A, 0xFFFE, 0xFFFE, 0x4C54, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6952,
	0xFFFE, 0xFFFE, 0xFFFE, 0x2847, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_7B = { {
	0x2C63, 0x2C64, 0xFFFE, 0xFFFE, 0x3162, 0x3164, 0xFFFE, 0xFFFE,
	0x3166, 0x3169, 0x3167, 0xFFFE, 0xFFFE, 0xFFFE, 0x3168, 0x3165,
	0x3161, 0xFFFE, 0x316A, 0x3163, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x3776, 0xFFFE, 0x3821, 0xFFFE, 0xFFFE, 0x3778, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x3773, 0x3822, 0x3774, 0x3771, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x3777, 0x377A, 0xFFFE, 0x377B, 0xFFFE, 0x377C,
	0x3772, 0x3779, 0x377D, 0x3775, 0x3770, 0x376E, 0xFFFE, 0xFFFE,
	0x377E, 0xFFFE, 0xFFFE, 0x376F, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x3E68, 0xFFFE, 0xFFFE, 0xFFFE, 0x3E64, 0x3E6A, 0xFFFE, 0x3E63,
	0x3E65, 0xFFFE, 0x3E62, 0xFFFE, 0x3E66, 0xFFFE, 0x3E67, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x3E69, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x4575, 0xFFFE, 0x4578, 0x456C, 0x4571, 0x456B, 0xFFFE,
	0xFFFE, 0x456F, 0xFFFE, 0xFFFE, 0xFFFE, 0x456D, 0xFFFE, 0xFFFE,
	0x4574, 0x4573, 0x4570, 0x4572, 0x456E, 0xFFFE, 0x4577, 0xFFFE,
	0x4576, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x4C64, 0xFFFE, 0xFFFE, 0x4C5F, 0xFFFE, 0xFFFE,
	0x4C55, 0xFFFE, 0x4C57, 0xFFFE, 0x4C5C, 0x4C5B, 0x4C5E, 0xFFFE,
	0x4C59, 0x4C58, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4C5A, 0xFFFE,
	0x4C60, 0x4C62, 0xFFFE, 0x4C5D, 0x4C56, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4C63, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5261, 0xFFFE, 0xFFFE, 0x5263,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5266, 0xFFFE, 0x525E,
	0xFFFE, 0x5264, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5260, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x5265, 0x525F, 0xFFFE, 0xFFFE, 0x5262, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x592C, 0x5927, 0xFFFE, 0xFFFE,
	0x5931, 0xFFFE, 0x5929, 0xFFFE, 0x592F, 0x5926, 0x5923, 0x5932,
	0xFFFE, 0xFFFE, 0x592E, 0x5924, 0xFFFE, 0x5928, 0xFFFE, 0x5925,
	0x592A, 0xFFFE, 0x592D, 0x5930, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x5E38, 0x5E39, 0x5E29, 0x5E30, 0x5E2E, 0xFFFE, 0xFFFE, 0xFFFE,
	0x5E35, 0x592B, 0xFFFE, 0x5E2C, 0xFFFE, 0x5E36, 0xFFFE, 0x5E2B
} };

static const iconv_ccs_convtable_8bit from_ucs_7C = { {
	0x5E2A, 0x5E34, 0x5E31, 0x5E33, 0xFFFE, 0x5E27, 0x5E37, 0xFFFE,
	0xFFFE, 0x5E32, 0x5E3B, 0x5E2F, 0xFFFE, 0xFFFE, 0x5E2D, 0x5E28,
	0x5E3A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x624F, 0xFFFE, 0xFFFE, 0x624D, 0x6253, 0xFFFE, 0x6251,
	0x6250, 0xFFFE, 0x6256, 0xFFFE, 0xFFFE, 0x6257, 0x6254, 0xFFFE,
	0x6255, 0x624E, 0xFFFE, 0xFFFE, 0x6635, 0x6252, 0xFFFE, 0xFFFE,
	0x6258, 0xFFFE, 0xFFFE, 0x6632, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x6634, 0xFFFE, 0x6636, 0x6633, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6957, 0xFFFE, 0x6956,
	0x6954, 0x6953, 0x6955, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x6B73, 0x6B72, 0xFFFE, 0xFFFE, 0x6D68,
	0xFFFE, 0x6D6A, 0x6D6C, 0x6D6B, 0x6D69, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6F3C, 0x6F3B,
	0xFFFE, 0x712B, 0x7046, 0x712C, 0xFFFE, 0xFFFE, 0xFFFE, 0x715C,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2848, 0xFFFE, 0xFFFE,
	0x2C66, 0x2C67, 0x2C65, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2C68,
	0x2C69, 0x2C6A, 0xFFFE, 0xFFFE, 0x316B, 0x3171, 0xFFFE, 0xFFFE,
	0x316F, 0xFFFE, 0x316D, 0xFFFE, 0x316E, 0x3170, 0xFFFE, 0xFFFE,
	0xFFFE, 0x316C, 0xFFFE, 0xFFFE, 0x3823, 0xFFFE, 0x3825, 0xFFFE,
	0x3824, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3E6C, 0xFFFE,
	0xFFFE, 0x3E6E, 0x3E6B, 0x3826, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x3E6D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x457B,
	0xFFFE, 0xFFFE, 0x4579, 0xFFFE, 0x457A, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x4C68, 0x4C65, 0x4C67, 0xFFFE, 0xFFFE, 0x4C66,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5267, 0xFFFE, 0xFFFE,
	0x5268, 0xFFFE, 0xFFFE, 0x526A, 0x5269, 0xFFFE, 0xFFFE, 0xFFFE,
	0x5936, 0x5937, 0x5933, 0xFFFE, 0x5934, 0xFFFE, 0xFFFE, 0x5935,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x5E3C, 0xFFFE, 0x6638, 0xFFFE, 0x6637, 0xFFFE, 0x6958, 0xFFFE,
	0xFFFE, 0x6D6E, 0x6B74, 0xFFFE, 0x6D6D, 0xFFFE, 0x712D, 0x7172,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2849, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_7D = { {
	0xFFFE, 0x2C6D, 0xFFFE, 0x2C6B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x2C6C, 0xFFFE, 0xFFFE, 0xFFFE, 0x317C, 0xFFFE, 0x3175, 0x317B,
	0xFFFE, 0x3174, 0x317A, 0x3178, 0xFFFE, 0xFFFE, 0x3177, 0xFFFE,
	0x3176, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3173, 0x3172, 0x3179,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x3835, 0x382E, 0xFFFE, 0xFFFE, 0x382D, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3827, 0x382A, 0xFFFE,
	0x3829, 0xFFFE, 0x382B, 0x3834, 0xFFFE, 0x3828, 0x3831, 0x3832,
	0xFFFE, 0x382F, 0xFFFE, 0xFFFE, 0xFFFE, 0x382C, 0xFFFE, 0x3830,
	0xFFFE, 0xFFFE, 0x3833, 0xFFFE, 0xFFFE, 0xFFFE, 0x3F21, 0x3E76,
	0xFFFE, 0x3E7D, 0x3E7A, 0x3E72, 0x3E7B, 0xFFFE, 0x3E73, 0xFFFE,
	0x3E6F, 0xFFFE, 0xFFFE, 0xFFFE, 0x3E78, 0xFFFE, 0xFFFE, 0x3E7E,
	0xFFFE, 0xFFFE, 0xFFFE, 0x3E71, 0xFFFE, 0xFFFE, 0xFFFE, 0x3E74,
	0xFFFE, 0x3E7C, 0x3E75, 0x3E79, 0xFFFE, 0x3E77, 0xFFFE, 0x3E70,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x4624, 0x4626, 0x4628, 0x462C, 0xFFFE, 0x4622,
	0x457E, 0xFFFE, 0xFFFE, 0x4627, 0x462B, 0x4623, 0x457D, 0xFFFE,
	0x457C, 0xFFFE, 0xFFFE, 0xFFFE, 0x4629, 0x4621, 0x4625, 0xFFFE,
	0xFFFE, 0xFFFE, 0x462D, 0xFFFE, 0x462A, 0xFFFE, 0x4C79, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4C71, 0xFFFE, 0x4C7B,
	0xFFFE, 0x4D21, 0xFFFE, 0x4C6C, 0xFFFE, 0xFFFE, 0x4C7C, 0x4C69,
	0xFFFE, 0x4C7E, 0x4C6D, 0xFFFE, 0xFFFE, 0xFFFE, 0x4C7D, 0x4C77,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4C6A,
	0xFFFE, 0x4C78, 0xFFFE, 0xFFFE, 0x4C7A, 0xFFFE, 0xFFFE, 0xFFFE,
	0x4C6F, 0x4C6E, 0x4C6B, 0xFFFE, 0x4C73, 0x4C70, 0x4C74, 0xFFFE,
	0xFFFE, 0x4D22, 0xFFFE, 0x4C75, 0x4C76, 0xFFFE, 0x4C72, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x526F,
	0xFFFE, 0xFFFE, 0xFFFE, 0x526C, 0xFFFE, 0xFFFE, 0xFFFE, 0x5278,
	0xFFFE, 0x5270, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5273, 0x526E,
	0xFFFE, 0xFFFE, 0x526D, 0xFFFE, 0xFFFE, 0xFFFE, 0x5277, 0xFFFE,
	0x5276, 0x5275, 0xFFFE, 0x503B, 0xFFFE, 0xFFFE, 0x5274, 0x526B,
	0xFFFE, 0xFFFE, 0x5272, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_7E = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0x5271, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x5944, 0x593B, 0x5947, 0x593F, 0x5945,
	0xFFFE, 0xFFFE, 0x5938, 0x593E, 0x5948, 0x5941, 0x5946, 0x593A,
	0xFFFE, 0xFFFE, 0x5942, 0xFFFE, 0x5940, 0xFFFE, 0xFFFE, 0x593C,
	0x593D, 0x5939, 0x5943, 0xFFFE, 0x594A, 0x5949, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5E47, 0x5E43, 0xFFFE, 0xFFFE, 0x5E3D, 0xFFFE, 0xFFFE,
	0x5E49, 0xFFFE, 0xFFFE, 0x5E40, 0xFFFE, 0xFFFE, 0x5E4B, 0xFFFE,
	0x5E42, 0xFFFE, 0x5E4D, 0x5E4A, 0x5E3E, 0xFFFE, 0xFFFE, 0xFFFE,
	0x5E45, 0xFFFE, 0x5E3F, 0xFFFE, 0x5E4C, 0xFFFE, 0xFFFE, 0x5E46,
	0xFFFE, 0x5E44, 0xFFFE, 0xFFFE, 0x5E48, 0xFFFE, 0xFFFE, 0xFFFE,
	0x625A, 0x6260, 0xFFFE, 0x6263, 0xFFFE, 0xFFFE, 0x625B, 0x6262,
	0x625D, 0xFFFE, 0xFFFE, 0xFFFE, 0x6259, 0xFFFE, 0xFFFE, 0x625F,
	0x6261, 0xFFFE, 0x625E, 0x625C, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x6642, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x663E,
	0x663C, 0xFFFE, 0x6640, 0xFFFE, 0x6641, 0x663A, 0x6639, 0x663D,
	0x663B, 0xFFFE, 0x663F, 0x6959, 0xFFFE, 0xFFFE, 0x695A, 0xFFFE,
	0x695C, 0x695B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6B79, 0x6B76,
	0x6B77, 0xFFFE, 0x6B75, 0x6B78, 0xFFFE, 0x6B7A, 0xFFFE, 0xFFFE,
	0xFFFE, 0x6D6F, 0xFFFE, 0xFFFE, 0xFFFE, 0x6F3D, 0xFFFE, 0x7047,
	0x712F, 0x7131, 0x712E, 0x7130, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_7F = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x3052, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3F22, 0x3F23,
	0xFFFE, 0xFFFE, 0xFFFE, 0x594B, 0xFFFE, 0x5E4E, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x6644, 0x6643, 0xFFFE, 0x6B7B, 0xFFFE, 0x6D70,
	0xFFFE, 0x2269, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x2C6E, 0xFFFE, 0xFFFE, 0x3224, 0x317D, 0x3223, 0x3221, 0xFFFE,
	0x3222, 0x317E, 0xFFFE, 0x3836, 0xFFFE, 0x3F24, 0x3F25, 0x4630,
	0x4631, 0xFFFE, 0xFFFE, 0x462F, 0x4632, 0x462E, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x4D23, 0xFFFE, 0xFFFE, 0x5279, 0xFFFE,
	0xFFFE, 0xFFFE, 0x594E, 0x594C, 0x594D, 0x5E51, 0x5E50, 0x5E4F,
	0xFFFE, 0xFFFE, 0xFFFE, 0x6645, 0xFFFE, 0xFFFE, 0x6646, 0x6D71,
	0xFFFE, 0x7048, 0xFFFE, 0xFFFE, 0xFFFE, 0x2C70, 0xFFFE, 0xFFFE,
	0xFFFE, 0x2C6F, 0x3226, 0xFFFE, 0xFFFE, 0x3837, 0x3225, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x383A, 0x3838, 0x3839, 0xFFFE, 0xFFFE,
	0x3F27, 0x3F28, 0x3F26, 0xFFFE, 0xFFFE, 0x4634, 0x4633, 0x4635,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x527A, 0x527C, 0xFFFE, 0xFFFE,
	0x527B, 0x594F, 0xFFFE, 0x6265, 0xFFFE, 0x6264, 0xFFFE, 0x6647,
	0xFFFE, 0xFFFE, 0x695D, 0x6B7C, 0xFFFE, 0xFFFE, 0x2C71, 0xFFFE,
	0x3229, 0xFFFE, 0x3228, 0x3227, 0xFFFE, 0xFFFE, 0xFFFE, 0x3840,
	0xFFFE, 0x3842, 0x383B, 0x383C, 0xFFFE, 0x383D, 0xFFFE, 0x3841,
	0x383E, 0x383F, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3F29,
	0xFFFE, 0xFFFE, 0xFFFE, 0x4636, 0x4637, 0xFFFE, 0x4D27, 0xFFFE,
	0xFFFE, 0xFFFE, 0x4D24, 0x4D25, 0xFFFE, 0x4D26, 0x5323, 0xFFFE,
	0x5324, 0xFFFE, 0x5321, 0x527E, 0x5322, 0x527D, 0xFFFE, 0x5950,
	0xFFFE, 0xFFFE, 0x5E53, 0xFFFE, 0x5E52, 0x6134, 0xFFFE, 0x6266,
	0x6267, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6648, 0x6649, 0x695E
} };

static const iconv_ccs_convtable_8bit from_ucs_80 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2C72,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2C73, 0x2C74,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2C75, 0xFFFE, 0x322A, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x3845, 0xFFFE, 0xFFFE, 0x3844, 0x3843,
	0xFFFE, 0x4638, 0xFFFE, 0xFFFE, 0x4D28, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5952, 0x5951, 0xFFFE, 0x5E54, 0xFFFE, 0xFFFE, 0xFFFE,
	0x6B7D, 0xFFFE, 0xFFFE, 0xFFFE, 0x2473, 0x284A, 0xFFFE, 0x2C76,
	0xFFFE, 0x322C, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x322B, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x3847, 0xFFFE, 0xFFFE, 0xFFFE, 0x3846,
	0x3848, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3F2B,
	0x3F2C, 0x3F2A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4D2A, 0x4D29, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5325, 0xFFFE, 0xFFFE, 0x5326,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5953, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6268, 0xFFFE, 0xFFFE,
	0x664A, 0x695F, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x2F7D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x2168, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x284B,
	0x2476, 0xFFFE, 0x2477, 0xFFFE, 0xFFFE, 0x2474, 0xFFFE, 0xFFFE,
	0xFFFE, 0x2475, 0xFFFE, 0xFFFE, 0x2478, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x284D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2850, 0x284C, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x284F, 0xFFFE, 0xFFFE,
	0x284E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x2C7C, 0xFFFE, 0xFFFE, 0x2C7E, 0xFFFE, 0x2C78,
	0x2C7B, 0x2D26, 0x2D24, 0xFFFE, 0xFFFE, 0x2D2A, 0xFFFE, 0x2D27,
	0x2C7D, 0x2C7A, 0xFFFE, 0xFFFE, 0x3F2E, 0x2D25, 0xFFFE, 0x2D28,
	0x2C77, 0x2D22, 0xFFFE, 0xFFFE, 0x2D23, 0xFFFE, 0xFFFE, 0xFFFE,
	0x2C79, 0xFFFE, 0xFFFE, 0x2D21, 0xFFFE, 0xFFFE, 0x2D29, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x322E, 0xFFFE, 0xFFFE, 0x3230, 0xFFFE, 0xFFFE,
	0xFFFE, 0x322F, 0x322D, 0x3232, 0xFFFE, 0xFFFE, 0x3F2D, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_81 = { {
	0x3233, 0x3231, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3852, 0xFFFE, 0xFFFE,
	0x3849, 0x384B, 0xFFFE, 0x384C, 0xFFFE, 0x3854, 0x3850, 0x384E,
	0xFFFE, 0x3851, 0x3855, 0xFFFE, 0xFFFE, 0x384A, 0xFFFE, 0x3853,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x384F, 0x384D, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x3F36, 0xFFFE, 0xFFFE, 0x3F34, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x3F2F, 0x4646, 0xFFFE, 0xFFFE, 0x3F33,
	0xFFFE, 0xFFFE, 0x3F30, 0xFFFE, 0xFFFE, 0x3F35, 0xFFFE, 0x3F32,
	0xFFFE, 0xFFFE, 0x3F31, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x463E, 0x463C, 0xFFFE, 0x4642, 0xFFFE,
	0x463A, 0x4647, 0x463F, 0xFFFE, 0x4639, 0xFFFE, 0xFFFE, 0x4644,
	0xFFFE, 0x463D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4645,
	0xFFFE, 0xFFFE, 0x4640, 0xFFFE, 0xFFFE, 0xFFFE, 0x4643, 0x463B,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x4D2D, 0xFFFE, 0xFFFE, 0x4D2C, 0x4D2E,
	0xFFFE, 0x4D2B, 0xFFFE, 0x4D31, 0x4D30, 0x4D2F, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x532A, 0xFFFE, 0x532D,
	0xFFFE, 0x532C, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5329, 0x5328,
	0xFFFE, 0xFFFE, 0x532B, 0x5327, 0xFFFE, 0xFFFE, 0x5955, 0x595F,
	0xFFFE, 0xFFFE, 0xFFFE, 0x5959, 0x595B, 0xFFFE, 0x5956, 0xFFFE,
	0x595A, 0x5954, 0x595D, 0xFFFE, 0x595C, 0x5958, 0xFFFE, 0x595E,
	0xFFFE, 0x5957, 0xFFFE, 0x5E55, 0x5E5B, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5E56, 0x5E59, 0xFFFE, 0x5E5A,
	0xFFFE, 0xFFFE, 0x5E58, 0xFFFE, 0x5E57, 0xFFFE, 0xFFFE, 0xFFFE,
	0x626B, 0x6269, 0x626A, 0xFFFE, 0xFFFE, 0x664C, 0xFFFE, 0x664B,
	0xFFFE, 0x6961, 0xFFFE, 0x6960, 0xFFFE, 0x6B7E, 0x6D72, 0xFFFE,
	0x7132, 0x7133, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3F37, 0xFFFE,
	0xFFFE, 0x5E5C, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3F38, 0xFFFE,
	0xFFFE, 0xFFFE, 0x5960, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3F39,
	0x3F3A, 0x3F3B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2D2B
} };

static const iconv_ccs_convtable_8bit from_ucs_82 = { {
	0xFFFE, 0x3234, 0xFFFE, 0xFFFE, 0x3F3C, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x664D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x3856, 0xFFFE, 0xFFFE, 0xFFFE, 0x4D32, 0x532E, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4648, 0xFFFE, 0xFFFE,
	0x2851, 0x2D2C, 0xFFFE, 0xFFFE, 0xFFFE, 0x3236, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3235,
	0xFFFE, 0xFFFE, 0x385B, 0x3858, 0x385A, 0xFFFE, 0xFFFE, 0xFFFE,
	0x3857, 0xFFFE, 0x3859, 0xFFFE, 0x3F3D, 0x3F3E, 0xFFFE, 0x3F3F,
	0x464B, 0xFFFE, 0x464C, 0xFFFE, 0x464A, 0x464D, 0xFFFE, 0xFFFE,
	0xFFFE, 0x4649, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5333, 0x532F,
	0x5332, 0x5334, 0x5331, 0x5330, 0xFFFE, 0x5961, 0x5962, 0x5963,
	0xFFFE, 0xFFFE, 0x5E5E, 0x5E5D, 0x5E5F, 0xFFFE, 0x626D, 0x626C,
	0xFFFE, 0x664F, 0xFFFE, 0x6650, 0x664E, 0xFFFE, 0xFFFE, 0xFFFE,
	0x6962, 0x6963, 0xFFFE, 0x6D73, 0x6F3E, 0x7049, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x385C, 0x3F40, 0xFFFE, 0xFFFE,
	0x226A, 0xFFFE, 0xFFFE, 0xFFFE, 0x226B, 0x226D, 0xFFFE, 0x226E,
	0x226C, 0xFFFE, 0xFFFE, 0x2522, 0x2523, 0x247B, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x2521, 0xFFFE, 0xFFFE, 0xFFFE, 0x247C, 0x247A,
	0x2479, 0x247D, 0xFFFE, 0x247E, 0x2D2D, 0xFFFE, 0xFFFE, 0xFFFE,
	0x2856, 0xFFFE, 0x2855, 0x2857, 0xFFFE, 0xFFFE, 0x285C, 0xFFFE,
	0x2852, 0x2860, 0x2866, 0xFFFE, 0x2863, 0xFFFE, 0xFFFE, 0x2859,
	0x285F, 0x2861, 0xFFFE, 0x2854, 0xFFFE, 0xFFFE, 0x285A, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x285E, 0x2858, 0x2865, 0xFFFE,
	0xFFFE, 0xFFFE, 0x285D, 0xFFFE, 0x285B, 0xFFFE, 0xFFFE, 0xFFFE,
	0x2853, 0xFFFE, 0x2862, 0x2864, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2D34, 0x2D37, 0xFFFE,
	0xFFFE, 0x2D2E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x2D43, 0x2D3A, 0xFFFE, 0xFFFE, 0x2D42, 0xFFFE, 0xFFFE, 0xFFFE,
	0x2D32, 0xFFFE, 0x2D41, 0x2D36, 0x2D39, 0x2D46, 0xFFFE, 0xFFFE,
	0x2D40, 0xFFFE, 0x2D3B, 0x2D45, 0x2D38, 0x2D3C, 0x2D3F, 0xFFFE,
	0xFFFE, 0x2D30, 0x2D44, 0x2D3E, 0xFFFE, 0xFFFE, 0x2D2F, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_83 = { {
	0x2D33, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2D31,
	0x3247, 0xFFFE, 0xFFFE, 0xFFFE, 0x2D3D, 0x2942, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x324A, 0xFFFE,
	0xFFFE, 0x323A, 0xFFFE, 0x3245, 0x3241, 0xFFFE, 0x3254, 0xFFFE,
	0x324C, 0xFFFE, 0x3242, 0xFFFE, 0x324B, 0x323C, 0x3240, 0x3257,
	0xFFFE, 0x324F, 0x3246, 0xFFFE, 0x3255, 0x3238, 0xFFFE, 0x324E,
	0xFFFE, 0xFFFE, 0xFFFE, 0x3237, 0xFFFE, 0xFFFE, 0xFFFE, 0x324D,
	0xFFFE, 0xFFFE, 0x2D35, 0x3F41, 0x3248, 0xFFFE, 0xFFFE, 0x323E,
	0xFFFE, 0x323F, 0x3243, 0xFFFE, 0x3239, 0x3251, 0xFFFE, 0x3250,
	0x3258, 0xFFFE, 0xFFFE, 0x3256, 0x3252, 0x3249, 0x3244, 0xFFFE,
	0xFFFE, 0x323B, 0xFFFE, 0x3253, 0xFFFE, 0xFFFE, 0x323D, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x3862, 0x3864, 0x3869, 0x387D, 0xFFFE,
	0xFFFE, 0xFFFE, 0x3861, 0xFFFE, 0xFFFE, 0x386C, 0x3873, 0x3879,
	0xFFFE, 0x3866, 0xFFFE, 0x386D, 0xFFFE, 0xFFFE, 0xFFFE, 0x387B,
	0x3876, 0xFFFE, 0xFFFE, 0x3872, 0x386E, 0x3860, 0xFFFE, 0x3865,
	0x385D, 0xFFFE, 0xFFFE, 0xFFFE, 0x386A, 0x3867, 0xFFFE, 0x3877,
	0xFFFE, 0x3868, 0x3F6A, 0x3870, 0xFFFE, 0x386F, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x385E, 0x3863, 0x3874, 0x387A, 0xFFFE,
	0x385F, 0x386B, 0x3871, 0xFFFE, 0xFFFE, 0xFFFE, 0x387C, 0x3875,
	0x3878, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3F51,
	0x3F45, 0xFFFE, 0x3F62, 0x3F6B, 0x3F6E, 0xFFFE, 0x3F4D, 0x3F66,
	0x3F4E, 0x3F5C, 0xFFFE, 0x3F58, 0xFFFE, 0xFFFE, 0x3F59, 0x3F42,
	0xFFFE, 0x3F67, 0xFFFE, 0xFFFE, 0xFFFE, 0x3F64, 0x3F5A, 0x3F70,
	0x3F55, 0x466D, 0xFFFE, 0x3F73, 0xFFFE, 0x3F53, 0x3F5F, 0xFFFE,
	0xFFFE, 0x3F57, 0x3F71, 0x3F50, 0x3F49, 0x3F54, 0xFFFE, 0x3F48,
	0x3F46, 0xFFFE, 0x3F68, 0x3F4F, 0x3F6C, 0xFFFE, 0x3F6D, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x3F63, 0xFFFE, 0x3F5B, 0x3F4B, 0xFFFE,
	0xFFFE, 0x3F43, 0x3F65, 0x3F6F, 0x3F4A, 0xFFFE, 0x3F74, 0x3F56
} };

static const iconv_ccs_convtable_8bit from_ucs_84 = { {
	0xFFFE, 0x3F52, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3F61, 0xFFFE,
	0xFFFE, 0x3F5D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3F5E,
	0x3F4C, 0x3F60, 0x3F47, 0x3F69, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x3F72, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x3F44, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x466C, 0xFFFE, 0x4724, 0xFFFE, 0x4671, 0xFFFE, 0x466F,
	0x465A, 0xFFFE, 0x466A, 0x467E, 0x4666, 0xFFFE, 0x467D, 0x4664,
	0xFFFE, 0x4674, 0x4665, 0x467B, 0xFFFE, 0xFFFE, 0xFFFE, 0x464F,
	0x4657, 0xFFFE, 0x4670, 0x4668, 0x4723, 0x466B, 0xFFFE, 0x467C,
	0xFFFE, 0xFFFE, 0xFFFE, 0x466E, 0x4676, 0x465B, 0x4675, 0xFFFE,
	0x4728, 0x4656, 0x4677, 0xFFFE, 0x4726, 0xFFFE, 0x4650, 0xFFFE,
	0xFFFE, 0x465E, 0x465D, 0xFFFE, 0xFFFE, 0x4661, 0x4663, 0x4672,
	0x4725, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4655, 0xFFFE, 0x4659,
	0x4721, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4727, 0x4678,
	0x4673, 0xFFFE, 0xFFFE, 0x4660, 0x465F, 0xFFFE, 0x4651, 0xFFFE,
	0x4669, 0x4652, 0x4667, 0xFFFE, 0xFFFE, 0x465C, 0x4722, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4658, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4654, 0x467A, 0x4653,
	0xFFFE, 0x4D5A, 0xFFFE, 0xFFFE, 0x4D49, 0xFFFE, 0xFFFE, 0x4D33,
	0x4D51, 0xFFFE, 0x4D42, 0x4D4C, 0xFFFE, 0x4D45, 0xFFFE, 0x4D36,
	0x4D54, 0x4D35, 0x4D48, 0xFFFE, 0x4D34, 0xFFFE, 0xFFFE, 0x4D46,
	0x4D4F, 0x4D4D, 0x4D41, 0x4D3C, 0x4D3A, 0xFFFE, 0x4D3B, 0x4D4E,
	0x4D59, 0x4D43, 0xFFFE, 0xFFFE, 0x4D3E, 0xFFFE, 0x4D52, 0xFFFE,
	0xFFFE, 0x4D3D, 0x4D37, 0x4D47, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x4D3F, 0x4D39, 0xFFFE, 0xFFFE, 0x4679, 0xFFFE, 0x4D4A,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4D4B, 0x4D40, 0x4D38, 0x4D53,
	0x4D44, 0xFFFE, 0x4D57, 0xFFFE, 0x4D56, 0xFFFE, 0x4D50, 0x4D55,
	0xFFFE, 0xFFFE, 0xFFFE, 0x4D58, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x535C,
	0x535D, 0x5350, 0x534F, 0x534B, 0xFFFE, 0xFFFE, 0xFFFE, 0x535F,
	0x535E, 0x464E, 0x5348, 0x534C, 0x5346, 0xFFFE, 0x5359, 0x534A,
	0xFFFE, 0x5360, 0x5343, 0x5341, 0x534D, 0x5357, 0x5352, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_85 = { {
	0x5338, 0xFFFE, 0x5356, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4662,
	0x5344, 0x533B, 0x533E, 0x5364, 0x5345, 0x533C, 0x533A, 0x5337,
	0xFFFE, 0xFFFE, 0x534E, 0xFFFE, 0xFFFE, 0x5349, 0x5351, 0xFFFE,
	0x5361, 0x5365, 0xFFFE, 0xFFFE, 0x5340, 0x5354, 0x5358, 0x533D,
	0x5362, 0xFFFE, 0xFFFE, 0xFFFE, 0x5335, 0xFFFE, 0x535B, 0x533F,
	0x5353, 0x5339, 0x5347, 0x5342, 0xFFFE, 0xFFFE, 0x5355, 0x5366,
	0x5363, 0x535A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x5336, 0xFFFE, 0xFFFE, 0x5974, 0xFFFE,
	0x596B, 0x596E, 0xFFFE, 0xFFFE, 0x5970, 0x5965, 0x596C, 0x5972,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5967, 0x5977, 0xFFFE,
	0xFFFE, 0x5971, 0xFFFE, 0x5968, 0x5A22, 0x597A, 0x5964, 0x5E72,
	0x596A, 0xFFFE, 0xFFFE, 0x5975, 0xFFFE, 0x5A21, 0xFFFE, 0xFFFE,
	0x597C, 0x5969, 0x596F, 0x5973, 0x596D, 0x5A23, 0x597E, 0x597B,
	0xFFFE, 0xFFFE, 0xFFFE, 0x5966, 0x5A24, 0xFFFE, 0x5978, 0xFFFE,
	0xFFFE, 0x5976, 0xFFFE, 0xFFFE, 0xFFFE, 0x5979, 0x5F21, 0x5E6C,
	0x5E71, 0x5E7E, 0x5E70, 0x5E68, 0x5E6D, 0xFFFE, 0xFFFE, 0xFFFE,
	0x5E61, 0x5E79, 0x5E7B, 0x5E60, 0xFFFE, 0x5E7D, 0x5E75, 0xFFFE,
	0x5E7C, 0x5E6E, 0xFFFE, 0x5E66, 0x597D, 0x5E76, 0x5E73, 0x5E62,
	0x5F23, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5E64, 0x5E74, 0xFFFE,
	0x5F22, 0x5E77, 0x5E6A, 0xFFFE, 0xFFFE, 0x5E78, 0x5E6B, 0x5F24,
	0x5E65, 0x5E6F, 0x5E7A, 0x5E67, 0x5E69, 0xFFFE, 0xFFFE, 0x5E63,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x627D, 0xFFFE, 0x6273, 0x626E, 0x6274, 0x627E, 0x6324,
	0x6323, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6275, 0x6325, 0x6278,
	0x6270, 0xFFFE, 0x6272, 0x6271, 0x6277, 0x627C, 0x626F, 0x6276,
	0x627B, 0xFFFE, 0xFFFE, 0x6279, 0xFFFE, 0xFFFE, 0x627A, 0xFFFE,
	0xFFFE, 0x6660, 0x6321, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6658,
	0x665C, 0x6654, 0x6657, 0xFFFE, 0x665F, 0xFFFE, 0x6664, 0x665D,
	0xFFFE, 0x6655, 0x6665, 0x665E, 0xFFFE, 0xFFFE, 0x6662, 0xFFFE,
	0x6656, 0xFFFE, 0xFFFE, 0x6651, 0x6659, 0x6653, 0xFFFE, 0x6663,
	0x6661, 0x6652, 0x665A, 0xFFFE, 0xFFFE, 0xFFFE, 0x696A, 0xFFFE,
	0x665B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x696F, 0x6967, 0x6965
} };

static const iconv_ccs_convtable_8bit from_ucs_86 = { {
	0x6969, 0x6966, 0xFFFE, 0xFFFE, 0x696B, 0x696D, 0xFFFE, 0xFFFE,
	0xFFFE, 0x696C, 0xFFFE, 0xFFFE, 0x696E, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x6C21, 0x6C27, 0xFFFE, 0x6968, 0x6C26, 0xFFFE, 0x6C2D, 0x6C24,
	0x6C2B, 0x6C2A, 0x6964, 0x6C25, 0x6322, 0x6C2E, 0x6C23, 0x6C28,
	0xFFFE, 0x6C2C, 0x6C22, 0xFFFE, 0x6D77, 0xFFFE, 0x6C29, 0xFFFE,
	0xFFFE, 0x6F43, 0x6D78, 0x6D76, 0x6D74, 0x6D75, 0x6D79, 0xFFFE,
	0xFFFE, 0x6F41, 0x6F3F, 0x6F44, 0x6F42, 0xFFFE, 0x6F45, 0xFFFE,
	0x6F40, 0xFFFE, 0xFFFE, 0x704A, 0xFFFE, 0xFFFE, 0x7134, 0x7135,
	0x7136, 0xFFFE, 0xFFFE, 0x7235, 0x722D, 0x226F, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x325A, 0x3259, 0xFFFE, 0xFFFE, 0x3921, 0xFFFE,
	0xFFFE, 0x387E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x4D5B, 0x5367, 0x5A25, 0x5A27, 0x5A26, 0xFFFE, 0xFFFE,
	0x5F25, 0x6326, 0x7173, 0xFFFE, 0xFFFE, 0x2869, 0x286A, 0x2868,
	0x2867, 0xFFFE, 0xFFFE, 0x2D4A, 0x2D48, 0xFFFE, 0xFFFE, 0x2D47,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2D49, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3266, 0x3263, 0x3261,
	0xFFFE, 0xFFFE, 0xFFFE, 0x3264, 0xFFFE, 0x325E, 0x326D, 0xFFFE,
	0x326F, 0x325F, 0xFFFE, 0xFFFE, 0x3270, 0x326B, 0x325D, 0x3262,
	0x326C, 0x3268, 0x3265, 0xFFFE, 0xFFFE, 0x326E, 0x3260, 0xFFFE,
	0xFFFE, 0x3269, 0x325B, 0xFFFE, 0xFFFE, 0x3267, 0xFFFE, 0x326A,
	0x325C, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x3928, 0xFFFE, 0xFFFE, 0x392B, 0x392E, 0xFFFE, 0xFFFE, 0x3923,
	0x392C, 0x392A, 0x3927, 0x392F, 0x3930, 0x3932, 0x3933, 0x3922,
	0xFFFE, 0x3925, 0x3924, 0x3931, 0xFFFE, 0x3926, 0xFFFE, 0xFFFE,
	0x3929, 0xFFFE, 0xFFFE, 0xFFFE, 0x392D, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x4025, 0xFFFE, 0x3F78, 0xFFFE, 0xFFFE, 0x472E, 0x4023,
	0x3F75, 0xFFFE, 0x3F7A, 0xFFFE, 0x3F7E, 0x3F7C, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x3F76, 0x3F79, 0xFFFE, 0xFFFE, 0x3F77, 0xFFFE,
	0x4024, 0x4022, 0x3F7B, 0x3F7D, 0x4021, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x472F, 0x4735, 0x472B,
	0x4731, 0xFFFE, 0x472D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_87 = { {
	0xFFFE, 0x4734, 0xFFFE, 0xFFFE, 0x472A, 0x4737, 0xFFFE, 0xFFFE,
	0xFFFE, 0x4733, 0xFFFE, 0x4729, 0x472C, 0x4736, 0x4732, 0xFFFE,
	0xFFFE, 0x4D7B, 0x4D70, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x4D64, 0x4D79, 0x4D65, 0xFFFE, 0xFFFE, 0x4D62, 0xFFFE,
	0x4D6B, 0x4D63, 0xFFFE, 0x4D5D, 0x4D78, 0xFFFE, 0x4D75, 0x4D76,
	0x4D5E, 0xFFFE, 0x4D6D, 0xFFFE, 0x4D67, 0x4D6E, 0x4D61, 0xFFFE,
	0x4D7A, 0x4D72, 0x4D6C, 0x4D5C, 0xFFFE, 0x4D73, 0xFFFE, 0xFFFE,
	0x4D77, 0xFFFE, 0x4D71, 0xFFFE, 0x4D6F, 0xFFFE, 0x4D69, 0xFFFE,
	0x4D60, 0x4D68, 0x4D74, 0x4D66, 0xFFFE, 0xFFFE, 0x4D6A, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4730, 0x5379, 0x5424,
	0x5378, 0x5374, 0x5371, 0xFFFE, 0x536F, 0xFFFE, 0x5368, 0xFFFE,
	0x536E, 0xFFFE, 0x5373, 0x5370, 0x5422, 0x537B, 0x5375, 0x537A,
	0xFFFE, 0x5372, 0x5427, 0x5369, 0x536A, 0x5423, 0xFFFE, 0x5428,
	0xFFFE, 0x5429, 0x5377, 0x4D5F, 0x537D, 0x5376, 0x5421, 0x537C,
	0xFFFE, 0xFFFE, 0xFFFE, 0x536D, 0xFFFE, 0x5426, 0xFFFE, 0x536B,
	0xFFFE, 0x5A32, 0x537E, 0x5425, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5A2F, 0xFFFE, 0xFFFE, 0x5A39, 0x5A35, 0xFFFE, 0x5A33,
	0x5A2E, 0x5A3D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5A2A,
	0x5A36, 0x5A37, 0x5A2D, 0x5A2C, 0x5A3A, 0xFFFE, 0x5A30, 0x5A2B,
	0x5A31, 0xFFFE, 0x5A3C, 0x5A29, 0x5A3B, 0x5A38, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x5A34, 0x5A28, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x5F27, 0xFFFE, 0x5F2B, 0x5F28, 0x5F2F, 0x5F35,
	0x5F2A, 0xFFFE, 0x5F3E, 0xFFFE, 0x5F38, 0x5F2D, 0x5F39, 0x5F34,
	0x5F3B, 0x5F2C, 0xFFFE, 0xFFFE, 0x5F2E, 0x5F3C, 0x5F26, 0x5F3A,
	0xFFFE, 0xFFFE, 0x5F32, 0x5F31, 0x5F36, 0x5F29, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5F30, 0x5F37, 0xFFFE, 0x5F33, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x6333, 0x6331, 0xFFFE, 0xFFFE, 0x6337,
	0x6335, 0x6338, 0xFFFE, 0x632A, 0x6332, 0x633C, 0x5F3D, 0x632E,
	0xFFFE, 0x536C, 0x6329, 0x6336, 0x6330, 0x632D, 0x6328, 0x6327,
	0x633B, 0xFFFE, 0x632C, 0x632B, 0xFFFE, 0x6334, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x632F, 0x633A, 0xFFFE, 0x6669, 0x666A,
	0xFFFE, 0xFFFE, 0x6667, 0xFFFE, 0x666F, 0xFFFE, 0xFFFE, 0x6671
} };

static const iconv_ccs_convtable_8bit from_ucs_88 = { {
	0x6666, 0x6339, 0x6673, 0x6668, 0xFFFE, 0xFFFE, 0x666E, 0xFFFE,
	0x6670, 0x666B, 0x6672, 0x666D, 0x666C, 0xFFFE, 0xFFFE, 0xFFFE,
	0x6971, 0x6972, 0xFFFE, 0x6974, 0xFFFE, 0xFFFE, 0x6975, 0x6973,
	0xFFFE, 0x6970, 0xFFFE, 0x6C31, 0x6C34, 0x6C30, 0xFFFE, 0xFFFE,
	0x6C32, 0xFFFE, 0xFFFE, 0xFFFE, 0x6C33, 0x6D7E, 0x6D7C, 0xFFFE,
	0x6D7B, 0x6C2F, 0x6D7D, 0x6C35, 0x6D7A, 0xFFFE, 0x6F48, 0x6F26,
	0x6F46, 0xFFFE, 0x6F47, 0x6F49, 0xFFFE, 0x704D, 0xFFFE, 0x704C,
	0x704B, 0xFFFE, 0xFFFE, 0xFFFE, 0x715D, 0x7175, 0x7174, 0x7176,
	0xFFFE, 0x2D4B, 0xFFFE, 0x3271, 0x3272, 0xFFFE, 0xFFFE, 0xFFFE,
	0x4026, 0xFFFE, 0x6C36, 0x704E, 0xFFFE, 0xFFFE, 0x2D4C, 0xFFFE,
	0xFFFE, 0xFFFE, 0x3934, 0xFFFE, 0xFFFE, 0x4028, 0x4027, 0xFFFE,
	0xFFFE, 0xFFFE, 0x542A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2D4D,
	0xFFFE, 0x2D4F, 0x2D4E, 0xFFFE, 0xFFFE, 0x3273, 0xFFFE, 0x327A,
	0xFFFE, 0x3278, 0x3276, 0xFFFE, 0x327D, 0x3274, 0x3275, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x327E, 0xFFFE, 0x327C, 0x3279,
	0x3277, 0xFFFE, 0xFFFE, 0x327B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x3935, 0xFFFE, 0xFFFE, 0x3945, 0xFFFE, 0x3947, 0xFFFE,
	0xFFFE, 0x393B, 0xFFFE, 0x3946, 0xFFFE, 0x3936, 0xFFFE, 0x3942,
	0x393E, 0x3940, 0x393A, 0x3941, 0xFFFE, 0xFFFE, 0xFFFE, 0x393D,
	0xFFFE, 0x393C, 0x3938, 0xFFFE, 0x3943, 0xFFFE, 0xFFFE, 0x393F,
	0x3937, 0xFFFE, 0x3939, 0xFFFE, 0x3944, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x4033, 0xFFFE, 0xFFFE, 0xFFFE, 0x402F, 0x4031,
	0x402C, 0x402B, 0x4029, 0xFFFE, 0x4030, 0x4032, 0x402E, 0xFFFE,
	0x402D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x4035, 0xFFFE, 0x4739, 0x473F, 0x473A, 0x473B, 0xFFFE,
	0x4740, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4738, 0x402A,
	0xFFFE, 0xFFFE, 0x473E, 0x473D, 0xFFFE, 0xFFFE, 0x473C, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4D7D,
	0xFFFE, 0xFFFE, 0xFFFE, 0x4E2A, 0x4E29, 0xFFFE, 0x4E24, 0xFFFE,
	0x4E28, 0x4D7E, 0x4E21, 0xFFFE, 0xFFFE, 0xFFFE, 0x4E26, 0x4D7C,
	0xFFFE, 0xFFFE, 0x4E22, 0x4E27, 0x4E25, 0xFFFE, 0x4E23, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_89 = { {
	0xFFFE, 0x4034, 0xFFFE, 0xFFFE, 0xFFFE, 0x542B, 0x5432, 0xFFFE,
	0xFFFE, 0x5436, 0xFFFE, 0x542E, 0x542C, 0xFFFE, 0x5435, 0xFFFE,
	0xFFFE, 0x5434, 0xFFFE, 0xFFFE, 0x542D, 0xFFFE, 0x5433, 0x542F,
	0x5430, 0x5431, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5A3E, 0x5A4A,
	0xFFFE, 0xFFFE, 0x5A45, 0x5A47, 0xFFFE, 0xFFFE, 0x5A3F, 0x5A43,
	0xFFFE, 0x5A46, 0xFFFE, 0xFFFE, 0x5A49, 0x5A41, 0x5A42, 0x5A48,
	0x5A40, 0x5A44, 0xFFFE, 0x5F40, 0xFFFE, 0x5F3F, 0xFFFE, 0x5F45,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5F41, 0xFFFE, 0x5F42, 0xFFFE,
	0xFFFE, 0x5F43, 0x5F46, 0xFFFE, 0xFFFE, 0xFFFE, 0x6341, 0xFFFE,
	0xFFFE, 0x6344, 0xFFFE, 0x633E, 0x6340, 0xFFFE, 0xFFFE, 0x633F,
	0x6342, 0x6343, 0x5F44, 0x633D, 0xFFFE, 0xFFFE, 0xFFFE, 0x6677,
	0x667A, 0x667C, 0x6675, 0x6676, 0x6679, 0x667B, 0xFFFE, 0xFFFE,
	0xFFFE, 0x6678, 0x6674, 0x6976, 0xFFFE, 0xFFFE, 0x6977, 0xFFFE,
	0xFFFE, 0x6C38, 0xFFFE, 0x6C3A, 0xFFFE, 0x6C37, 0x6C39, 0xFFFE,
	0xFFFE, 0x6E21, 0xFFFE, 0x6F4C, 0x6F4B, 0xFFFE, 0x6F4A, 0xFFFE,
	0xFFFE, 0x7137, 0x7138, 0x713A, 0x7139, 0xFFFE, 0x2270, 0xFFFE,
	0xFFFE, 0xFFFE, 0x3948, 0xFFFE, 0xFFFE, 0x4741, 0xFFFE, 0xFFFE,
	0x667D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4036, 0xFFFE, 0x4038,
	0x4037, 0xFFFE, 0xFFFE, 0x4742, 0xFFFE, 0x4E2B, 0x4E2E, 0x4E2D,
	0xFFFE, 0x4E2C, 0x5437, 0x5439, 0x5438, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5F47, 0x5F49, 0x5F48,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6721, 0x667E,
	0xFFFE, 0x6978, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6E23, 0x6E22,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x2D50, 0xFFFE, 0x394B, 0x3949, 0xFFFE,
	0xFFFE, 0x394A, 0x403A, 0x403B, 0x4749, 0x4039, 0xFFFE, 0x4743,
	0x4747, 0x4746, 0x4748, 0xFFFE, 0x4745, 0x4744, 0x474A, 0xFFFE,
	0x4E31, 0x4E2F, 0xFFFE, 0x4E30, 0x543C, 0x543A, 0xFFFE, 0xFFFE,
	0x543B, 0x5A4B, 0x5F4A, 0x5F4B, 0xFFFE, 0xFFFE, 0x6722, 0x6979,
	0xFFFE, 0xFFFE, 0x6C3B, 0x6E24, 0xFFFE, 0xFFFE, 0x6F4D, 0x713B
} };

static const iconv_ccs_convtable_8bit from_ucs_8A = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2D51, 0xFFFE, 0xFFFE, 0x2D52,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x3321, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x394F, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x394D,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x394E, 0xFFFE, 0xFFFE, 0xFFFE,
	0x394C, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x403E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x474F,
	0x4040, 0xFFFE, 0xFFFE, 0xFFFE, 0x4043, 0x4044, 0xFFFE, 0xFFFE,
	0x4046, 0xFFFE, 0x4048, 0xFFFE, 0x4049, 0x403D, 0x403C, 0x404A,
	0xFFFE, 0x4047, 0x4045, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4041,
	0x4042, 0x403F, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x474E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4756, 0x4753, 0x474B, 0x4750,
	0xFFFE, 0xFFFE, 0x4757, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x474D,
	0xFFFE, 0x4755, 0x4751, 0x4754, 0x4752, 0xFFFE, 0x474C, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x4E34, 0xFFFE, 0xFFFE, 0xFFFE, 0x4E36,
	0xFFFE, 0xFFFE, 0x4E35, 0xFFFE, 0xFFFE, 0xFFFE, 0x4E37, 0xFFFE,
	0xFFFE, 0x4E33, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x4E32, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x543F, 0xFFFE, 0x544B, 0x5444, 0xFFFE, 0x544C, 0x5446, 0xFFFE,
	0x5447, 0xFFFE, 0xFFFE, 0x544A, 0xFFFE, 0x5448, 0x543E, 0xFFFE,
	0x5A56, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x543D,
	0xFFFE, 0x5441, 0xFFFE, 0x5440, 0x5442, 0x5443, 0xFFFE, 0x5445,
	0x5449, 0x544D, 0xFFFE, 0xFFFE, 0xFFFE, 0x5A51, 0x5A57, 0x5A54,
	0x5A4C, 0x5A58, 0x5A4D, 0xFFFE, 0x5A53, 0xFFFE, 0xFFFE, 0xFFFE,
	0x5A59, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5A5B,
	0x5A55, 0xFFFE, 0x5A4E, 0xFFFE, 0x5A4F, 0x5A50, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x5A5C, 0xFFFE, 0xFFFE, 0xFFFE, 0x5A5A
} };

static const iconv_ccs_convtable_8bit from_ucs_8B = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5F50, 0x5F59, 0x5F56,
	0x5F58, 0xFFFE, 0xFFFE, 0x5F51, 0xFFFE, 0x5F57, 0xFFFE, 0x5F53,
	0xFFFE, 0x5F4F, 0x5F54, 0x5F5B, 0x5A52, 0x5F55, 0x5F4E, 0xFFFE,
	0x5F4D, 0xFFFE, 0x5F5C, 0xFFFE, 0x5F5A, 0xFFFE, 0x5F4C, 0xFFFE,
	0xFFFE, 0xFFFE, 0x5F52, 0x6347, 0x6355, 0x6350, 0x6352, 0x6346,
	0xFFFE, 0xFFFE, 0x6345, 0xFFFE, 0xFFFE, 0xFFFE, 0x6354, 0x634C,
	0x6349, 0x634F, 0xFFFE, 0x6348, 0xFFFE, 0x634A, 0x6353, 0x6351,
	0xFFFE, 0xFFFE, 0x6358, 0x6356, 0x634D, 0x6357, 0x634E, 0xFFFE,
	0x6726, 0xFFFE, 0x672D, 0xFFFE, 0xFFFE, 0x6C3E, 0xFFFE, 0x634B,
	0x6724, 0xFFFE, 0x6725, 0x672A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x6723, 0x672C, 0x672E, 0x6727, 0x6729, 0x672B, 0x6728, 0x672F,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x697C, 0xFFFE, 0xFFFE,
	0x697A, 0xFFFE, 0xFFFE, 0x697E, 0xFFFE, 0x6A21, 0xFFFE, 0x6A22,
	0x697D, 0xFFFE, 0x697B, 0xFFFE, 0xFFFE, 0x6A23, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x6C3D, 0x6C3C, 0x6C3F, 0x6C40, 0xFFFE, 0xFFFE, 0x6E25, 0x6E2A,
	0xFFFE, 0xFFFE, 0x6E27, 0xFFFE, 0x6E26, 0x6E29, 0x6E28, 0xFFFE,
	0x6F51, 0xFFFE, 0xFFFE, 0x6F50, 0x6F4E, 0xFFFE, 0x6F4F, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x704F, 0x7050, 0xFFFE, 0xFFFE,
	0x713C, 0x713D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7177, 0x7236,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_8C = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x3950, 0xFFFE, 0x3951, 0x4758, 0x4E38, 0x544E, 0xFFFE,
	0xFFFE, 0xFFFE, 0x6359, 0x6730, 0xFFFE, 0x6F52, 0xFFFE, 0x3322,
	0xFFFE, 0xFFFE, 0x475A, 0x4759, 0xFFFE, 0x544F, 0xFFFE, 0x5F5D,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x286B, 0x3323,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3952, 0x3953, 0xFFFE, 0x404B,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x475C, 0x475B, 0x475D, 0xFFFE,
	0x4E39, 0x4E3A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5F61,
	0x5F5E, 0x5F60, 0x5F5F, 0xFFFE, 0xFFFE, 0x635A, 0x6732, 0x6731,
	0x2524, 0xFFFE, 0xFFFE, 0x3324, 0xFFFE, 0x3954, 0xFFFE, 0xFFFE,
	0x404D, 0x404C, 0xFFFE, 0xFFFE, 0x475F, 0x4760, 0x475E, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5450,
	0x5A5F, 0x5A5D, 0x5A5E, 0xFFFE, 0x5F63, 0x5F62, 0xFFFE, 0x635D,
	0x635C, 0x635B, 0x6733, 0xFFFE, 0x7178, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x3326, 0x3325, 0x3955, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x4050, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4052, 0xFFFE, 0xFFFE,
	0xFFFE, 0x4051, 0x404E, 0xFFFE, 0xFFFE, 0xFFFE, 0x404F, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4761, 0xFFFE, 0xFFFE, 0x4E3C,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4E3B, 0xFFFE, 0x4E3D,
	0xFFFE, 0x5453, 0x5455, 0xFFFE, 0xFFFE, 0x5456, 0xFFFE, 0x5452,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5451, 0xFFFE, 0x5457,
	0x5454, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5A61, 0xFFFE,
	0x5A63, 0x5A62, 0xFFFE, 0x5A64, 0xFFFE, 0x5A60, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5F64, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x635E, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_8D = { {
	0x6361, 0xFFFE, 0x6360, 0xFFFE, 0x635F, 0xFFFE, 0x6734, 0x6735,
	0xFFFE, 0x6736, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x6C41, 0xFFFE, 0xFFFE, 0xFFFE, 0x6C42, 0x6E2B, 0xFFFE, 0xFFFE,
	0xFFFE, 0x6F53, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x4762, 0x4763, 0xFFFE, 0xFFFE, 0x5A65, 0xFFFE, 0x5A66, 0x5F65,
	0xFFFE, 0xFFFE, 0x2D53, 0xFFFE, 0xFFFE, 0xFFFE, 0x3327, 0xFFFE,
	0x3328, 0x3958, 0xFFFE, 0x3957, 0xFFFE, 0x3956, 0xFFFE, 0xFFFE,
	0x4054, 0xFFFE, 0xFFFE, 0xFFFE, 0x4053, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x4055, 0xFFFE, 0xFFFE, 0x4765, 0x4768, 0x4766, 0x4767,
	0x476B, 0x4764, 0x476C, 0x4769, 0x476A, 0xFFFE, 0x4E3E, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x545B, 0x5459, 0xFFFE, 0xFFFE, 0xFFFE,
	0x5458, 0x545A, 0xFFFE, 0xFFFE, 0xFFFE, 0x5A67, 0xFFFE, 0x5A68,
	0xFFFE, 0xFFFE, 0x6738, 0x673A, 0x6737, 0x6739, 0x6A24, 0x6C43,
	0xFFFE, 0xFFFE, 0x715E, 0xFFFE, 0xFFFE, 0x3329, 0x332B, 0x332A,
	0xFFFE, 0x395B, 0xFFFE, 0xFFFE, 0x3959, 0xFFFE, 0xFFFE, 0x395C,
	0xFFFE, 0x395D, 0x395A, 0xFFFE, 0xFFFE, 0x4061, 0xFFFE, 0x4059,
	0x405F, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4058, 0xFFFE, 0x405C,
	0x4772, 0xFFFE, 0xFFFE, 0x4057, 0xFFFE, 0x405D, 0x405A, 0x4060,
	0x4056, 0x405E, 0xFFFE, 0xFFFE, 0x405B, 0xFFFE, 0xFFFE, 0xFFFE,
	0x476E, 0xFFFE, 0x4775, 0x4774, 0xFFFE, 0xFFFE, 0xFFFE, 0x4776,
	0xFFFE, 0x4773, 0xFFFE, 0x4778, 0x476F, 0xFFFE, 0x4771, 0xFFFE,
	0x476D, 0x4770, 0x4777, 0xFFFE, 0x4779, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4E43, 0x4E49, 0x4E41
} };

static const iconv_ccs_convtable_8bit from_ucs_8E = { {
	0x4E4A, 0xFFFE, 0x4E40, 0x4E45, 0x4E4B, 0x4E48, 0x4E47, 0x4E46,
	0xFFFE, 0x4E3F, 0x4E44, 0xFFFE, 0xFFFE, 0x4E42, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5464, 0x5469, 0x546B, 0x5468, 0x5461, 0x5463, 0x546D,
	0x546A, 0x5465, 0x546E, 0x5462, 0x546C, 0xFFFE, 0xFFFE, 0xFFFE,
	0x545C, 0xFFFE, 0xFFFE, 0x545D, 0x545F, 0x545E, 0x5466, 0x5467,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5460, 0xFFFE,
	0x5A72, 0xFFFE, 0xFFFE, 0x5A69, 0xFFFE, 0xFFFE, 0x5A6E, 0xFFFE,
	0x5A6B, 0xFFFE, 0xFFFE, 0xFFFE, 0x5A6F, 0x5A70, 0x5A6A, 0x5A73,
	0x5A6C, 0x5A71, 0xFFFE, 0xFFFE, 0xFFFE, 0x5A6D, 0xFFFE, 0x5F6B,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5F6A, 0x5F67, 0x5F66, 0xFFFE,
	0x5F69, 0xFFFE, 0xFFFE, 0x5F68, 0x636F, 0xFFFE, 0x6366, 0x6365,
	0xFFFE, 0xFFFE, 0x636B, 0x636A, 0x6362, 0x636D, 0x6367, 0xFFFE,
	0x6364, 0x636C, 0x6363, 0xFFFE, 0xFFFE, 0x6368, 0xFFFE, 0x6369,
	0xFFFE, 0x636E, 0x673E, 0xFFFE, 0xFFFE, 0x673B, 0xFFFE, 0x673F,
	0xFFFE, 0xFFFE, 0xFFFE, 0x673D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x673C, 0xFFFE, 0xFFFE, 0x6740, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6A27, 0xFFFE, 0x6A25, 0xFFFE,
	0x6A26, 0xFFFE, 0xFFFE, 0xFFFE, 0x6C45, 0xFFFE, 0x6C44, 0xFFFE,
	0x6E30, 0xFFFE, 0x6E2F, 0xFFFE, 0x6E2D, 0x6E2C, 0x6E31, 0x6E32,
	0x6F54, 0xFFFE, 0x6E2E, 0xFFFE, 0xFFFE, 0x7054, 0x7051, 0x7052,
	0x7053, 0xFFFE, 0xFFFE, 0x7140, 0x713F, 0x713E, 0x715F, 0xFFFE,
	0x722E, 0x7179, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5A74, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x6741, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x717A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x332C, 0xFFFE, 0x332D, 0xFFFE, 0xFFFE, 0xFFFE, 0x3962,
	0x395E, 0xFFFE, 0xFFFE, 0xFFFE, 0x3961, 0x3960, 0x395F, 0xFFFE,
	0x3963, 0x3964, 0xFFFE, 0xFFFE, 0xFFFE, 0x4068, 0x4066, 0x406A,
	0x406B, 0x4071, 0xFFFE, 0x406D, 0x406F, 0xFFFE, 0x4067, 0x4062,
	0xFFFE, 0x406E, 0xFFFE, 0xFFFE, 0x4070, 0x4069, 0x406C, 0x4063,
	0xFFFE, 0x4065, 0x4064, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x477B
} };

static const iconv_ccs_convtable_8bit from_ucs_8F = { {
	0x477D, 0x477C, 0x4823, 0xFFFE, 0xFFFE, 0x477E, 0x477A, 0x4821,
	0x4822, 0xFFFE, 0xFFFE, 0x4824, 0xFFFE, 0x4E4F, 0x4E4E, 0xFFFE,
	0x4E4C, 0x4E4D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5475, 0x5476,
	0x5471, 0xFFFE, 0x5472, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x5473, 0xFFFE, 0xFFFE, 0x5474, 0x5470, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x546F, 0xFFFE, 0x5A76, 0xFFFE,
	0xFFFE, 0xFFFE, 0x5A78, 0xFFFE, 0x5A7B, 0x5A77, 0x5A75, 0x5A7A,
	0xFFFE, 0x5A79, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x5F6D, 0xFFFE, 0xFFFE, 0x5F6C, 0xFFFE, 0xFFFE, 0x6370, 0x6371,
	0x6372, 0xFFFE, 0xFFFE, 0x6373, 0xFFFE, 0xFFFE, 0xFFFE, 0x6744,
	0x6745, 0x6743, 0x6742, 0x6746, 0xFFFE, 0x6A2B, 0x6A29, 0x6A2A,
	0x6A2C, 0x6A28, 0x6A2D, 0x6C47, 0xFFFE, 0x6C48, 0x6C46, 0xFFFE,
	0x6E33, 0xFFFE, 0x6E34, 0x6F56, 0x6F55, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6747, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2526,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x2525, 0xFFFE, 0x286D, 0xFFFE, 0x286F, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x286C, 0x286E, 0xFFFE, 0x2871, 0x2870, 0x2872,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x2D57, 0x2D55, 0xFFFE, 0x2D54, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2D56, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x332F, 0x3335, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x3332, 0x3334, 0xFFFE, 0x332E, 0x3331
} };

static const iconv_ccs_convtable_8bit from_ucs_90 = { {
	0xFFFE, 0xFFFE, 0x3330, 0xFFFE, 0x3333, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x3966, 0x3969, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x3967, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3968, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x396A, 0xFFFE, 0xFFFE, 0x3965, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4072, 0xFFFE, 0x4074,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4073, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4829, 0xFFFE, 0x4826,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4827, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x4828, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x4825, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x547A,
	0xFFFE, 0xFFFE, 0xFFFE, 0x547B, 0xFFFE, 0xFFFE, 0xFFFE, 0x5479,
	0x5478, 0xFFFE, 0xFFFE, 0x5477, 0xFFFE, 0xFFFE, 0x5A7C, 0xFFFE,
	0xFFFE, 0x5A7D, 0xFFFE, 0x5A7E, 0xFFFE, 0xFFFE, 0x5F6F, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5F6E, 0x5B21, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6A2E, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2275, 0xFFFE, 0xFFFE, 0x2272,
	0x2273, 0x2271, 0xFFFE, 0x2274, 0xFFFE, 0xFFFE, 0x252A, 0x2527,
	0x252C, 0x2528, 0xFFFE, 0xFFFE, 0xFFFE, 0x2529, 0xFFFE, 0x252B,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2875,
	0x2877, 0xFFFE, 0x2873, 0x2876, 0x2874, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2D59, 0x2D5D, 0x2D5A,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2D5C, 0xFFFE, 0x2D5E,
	0x2D60, 0xFFFE, 0xFFFE, 0x2D5F, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3971, 0x2D5B, 0x3336, 0x333F,
	0x333D, 0x3338, 0x3339, 0x333E, 0x3340, 0xFFFE, 0xFFFE, 0x333B,
	0x3337, 0xFFFE, 0xFFFE, 0x333A, 0x3341, 0x333C, 0xFFFE, 0xFFFE,
	0xFFFE, 0x3974, 0x396C, 0x3972, 0x3973, 0xFFFE, 0xFFFE, 0x396B,
	0x396D, 0x2D58, 0x396F, 0x3970, 0x396E, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x407B, 0x5B22, 0x407C, 0x4079, 0xFFFE, 0xFFFE, 0x4078
} };

static const iconv_ccs_convtable_8bit from_ucs_91 = { {
	0x407E, 0x407D, 0xFFFE, 0x4123, 0x4077, 0x4122, 0x4075, 0x4121,
	0x407A, 0xFFFE, 0xFFFE, 0x4830, 0xFFFE, 0x482B, 0x4831, 0x482C,
	0x482A, 0x482D, 0xFFFE, 0xFFFE, 0x482F, 0xFFFE, 0x482E, 0xFFFE,
	0xFFFE, 0xFFFE, 0x4E56, 0x4E59, 0x4E51, 0x4E55, 0xFFFE, 0x4E54,
	0x4E52, 0x4E58, 0x4E53, 0x4E50, 0x4E57, 0xFFFE, 0x5523, 0xFFFE,
	0x6374, 0x547E, 0x5521, 0x547D, 0x4076, 0xFFFE, 0x5524, 0x547C,
	0xFFFE, 0xFFFE, 0x5522, 0x5B23, 0xFFFE, 0x5B24, 0x5B25, 0xFFFE,
	0x5F70, 0xFFFE, 0x6375, 0x6376, 0xFFFE, 0xFFFE, 0x6377, 0x6749,
	0x6748, 0x6A30, 0xFFFE, 0x6A2F, 0x6C4A, 0x6C4B, 0x6C49, 0x6E35,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3343, 0x3344,
	0x3342, 0xFFFE, 0xFFFE, 0x3978, 0xFFFE, 0x3979, 0x3975, 0xFFFE,
	0x3976, 0xFFFE, 0x3977, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4126,
	0x4128, 0x4124, 0x4127, 0xFFFE, 0x4125, 0xFFFE, 0xFFFE, 0xFFFE,
	0x4279, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4832, 0x4833,
	0xFFFE, 0xFFFE, 0x4E5B, 0x4E5D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x4E5C, 0x4E5A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x552B, 0x5528, 0x5529, 0xFFFE, 0x552A, 0x5525, 0x5526, 0xFFFE,
	0xFFFE, 0xFFFE, 0x5527, 0xFFFE, 0xFFFE, 0x5B29, 0xFFFE, 0x5B2A,
	0x5B27, 0x5B28, 0xFFFE, 0x5B26, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5F74, 0x5F71, 0x5F73, 0xFFFE, 0x5F77, 0xFFFE, 0x5F75,
	0x5F78, 0x5F76, 0x5F72, 0xFFFE, 0xFFFE, 0x6379, 0xFFFE, 0x637A,
	0x6378, 0xFFFE, 0x637C, 0xFFFE, 0xFFFE, 0x674B, 0xFFFE, 0x637B,
	0x674A, 0xFFFE, 0x6A33, 0x6A34, 0xFFFE, 0x6A32, 0xFFFE, 0x6A31,
	0xFFFE, 0x6C4C, 0xFFFE, 0xFFFE, 0x6F57, 0x7056, 0x7055, 0xFFFE,
	0xFFFE, 0xFFFE, 0x7057, 0x7160, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x2D62, 0x2D61, 0x3345, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x3347, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x3346, 0xFFFE, 0x3A21, 0xFFFE, 0xFFFE, 0xFFFE,
	0x3A26, 0xFFFE, 0x3A23, 0x3A24, 0x397A, 0xFFFE, 0x3A27, 0xFFFE,
	0xFFFE, 0x397C, 0xFFFE, 0x397D, 0x397B, 0xFFFE, 0xFFFE, 0x3A25,
	0x397E, 0x3A22, 0xFFFE, 0xFFFE, 0xFFFE, 0x4134, 0xFFFE, 0x4133
} };

static const iconv_ccs_convtable_8bit from_ucs_92 = { {
	0x4131, 0x4129, 0x4138, 0x412C, 0x4136, 0x413D, 0x4135, 0xFFFE,
	0xFFFE, 0xFFFE, 0x412A, 0xFFFE, 0x4130, 0xFFFE, 0xFFFE, 0x412F,
	0xFFFE, 0xFFFE, 0x4132, 0xFFFE, 0xFFFE, 0xFFFE, 0x413E, 0x413C,
	0xFFFE, 0x413B, 0x412D, 0xFFFE, 0x4139, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x413A, 0x412B, 0x412E, 0x4137,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4F22, 0x483D, 0xFFFE,
	0x4836, 0x4849, 0x4852, 0x4839, 0xFFFE, 0xFFFE, 0x4846, 0xFFFE,
	0xFFFE, 0xFFFE, 0x4837, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x483F, 0xFFFE,
	0x4834, 0xFFFE, 0x483E, 0xFFFE, 0x4850, 0xFFFE, 0x484E, 0x4842,
	0x484C, 0xFFFE, 0x4835, 0x484F, 0x484A, 0xFFFE, 0x4851, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x483B, 0xFFFE,
	0x4843, 0x4847, 0xFFFE, 0x484B, 0xFFFE, 0x483A, 0x4838, 0x4844,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4841, 0x4840, 0xFFFE, 0x4845,
	0x4848, 0xFFFE, 0x484D, 0xFFFE, 0xFFFE, 0xFFFE, 0x4E60, 0xFFFE,
	0xFFFE, 0x4E6A, 0x4E62, 0xFFFE, 0xFFFE, 0x4E73, 0x4E7B, 0x4E6C,
	0xFFFE, 0xFFFE, 0x4E70, 0x483C, 0xFFFE, 0xFFFE, 0x4E77, 0x4E7C,
	0x4E74, 0xFFFE, 0x4E76, 0x4F21, 0x4E78, 0x4E66, 0x4E6F, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4E64, 0x4E71, 0xFFFE, 0x4E6B,
	0xFFFE, 0x4E79, 0x4E68, 0x4E61, 0xFFFE, 0x4E7E, 0xFFFE, 0xFFFE,
	0x4E63, 0x4E75, 0x4E72, 0x4E6D, 0x4E5F, 0x4E5E, 0x4E67, 0x4E7A,
	0xFFFE, 0x4E7D, 0x4E65, 0x4E69, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x554D, 0x5549, 0x5531, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x552F, 0xFFFE, 0x553B, 0x552D, 0x552E, 0xFFFE, 0x554C, 0xFFFE,
	0x553E, 0x5543, 0x553D, 0x5B3C, 0x5539, 0x5541, 0x553F, 0x5532,
	0x552C, 0x5547, 0xFFFE, 0x5548, 0xFFFE, 0x5542, 0xFFFE, 0x5537,
	0x5535, 0x5530, 0xFFFE, 0xFFFE, 0xFFFE, 0x5538, 0x5545, 0x5534,
	0x5544, 0x554A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5540, 0x5546,
	0x553C, 0x5536, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4E6E, 0x553A,
	0xFFFE, 0x5533, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5B41,
	0xFFFE, 0x5B40, 0x5B3E, 0x5B50, 0xFFFE, 0xFFFE, 0x5B4D, 0x5B45
} };

static const iconv_ccs_convtable_8bit from_ucs_93 = { {
	0x5B4F, 0x5B37, 0x5B43, 0xFFFE, 0xFFFE, 0xFFFE, 0x5B2F, 0xFFFE,
	0x5B2D, 0x5B4E, 0xFFFE, 0x5B4C, 0x5B4B, 0x5B3B, 0x5B3A, 0x5B30,
	0xFFFE, 0xFFFE, 0x5B36, 0x5B3F, 0x5B4A, 0xFFFE, 0x5B51, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x5B34, 0xFFFE, 0x5B3D, 0x5B2C, 0x5B2E,
	0xFFFE, 0xFFFE, 0xFFFE, 0x5B35, 0x5B44, 0x554B, 0xFFFE, 0x5B2B,
	0xFFFE, 0x5B46, 0x5B49, 0xFFFE, 0xFFFE, 0x5B39, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5B42, 0x5B48, 0xFFFE, 0xFFFE,
	0x5B32, 0x5B47, 0xFFFE, 0xFFFE, 0x5B33, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5B38, 0x5F7E,
	0xFFFE, 0x6025, 0xFFFE, 0xFFFE, 0x602B, 0xFFFE, 0x6039, 0x6031,
	0x6026, 0x6027, 0x6030, 0xFFFE, 0xFFFE, 0x602F, 0x5F7D, 0x602E,
	0x6022, 0x603A, 0xFFFE, 0xFFFE, 0x6023, 0xFFFE, 0x6036, 0xFFFE,
	0x6028, 0x6035, 0xFFFE, 0x6037, 0x5F7C, 0xFFFE, 0xFFFE, 0x6038,
	0xFFFE, 0xFFFE, 0x602C, 0xFFFE, 0xFFFE, 0x6029, 0xFFFE, 0xFFFE,
	0xFFFE, 0x6032, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6024, 0x6033,
	0xFFFE, 0x602D, 0x5B31, 0x6034, 0x6021, 0xFFFE, 0xFFFE, 0xFFFE,
	0x642F, 0xFFFE, 0xFFFE, 0x5F7A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x642C, 0x6425, 0xFFFE, 0xFFFE, 0x637E, 0x6430, 0x6427, 0x602A,
	0xFFFE, 0x6432, 0x6421, 0xFFFE, 0xFFFE, 0x642B, 0xFFFE, 0xFFFE,
	0xFFFE, 0x642D, 0xFFFE, 0x6423, 0xFFFE, 0x6424, 0x6429, 0x642E,
	0xFFFE, 0x5F79, 0xFFFE, 0x6437, 0x6434, 0x6761, 0x642A, 0x6426,
	0x6435, 0x6756, 0x6428, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5F7B,
	0xFFFE, 0x6431, 0x6433, 0xFFFE, 0x6436, 0x637D, 0xFFFE, 0x6422,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x675F, 0xFFFE, 0x674F, 0xFFFE, 0x675D, 0xFFFE, 0xFFFE, 0x674D,
	0xFFFE, 0xFFFE, 0x6758, 0xFFFE, 0x6754, 0xFFFE, 0x675E, 0x674E,
	0x6751, 0xFFFE, 0x6760, 0xFFFE, 0x6759, 0x675C, 0xFFFE, 0xFFFE,
	0xFFFE, 0x6755, 0x6750, 0xFFFE, 0xFFFE, 0xFFFE, 0x674C, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x675B, 0xFFFE, 0xFFFE, 0x6757, 0x6762,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6753, 0xFFFE, 0x675A, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6A41, 0x6A50, 0x6A43,
	0x6A4A, 0x6752, 0x6A48, 0x6A37, 0x6A4E, 0xFFFE, 0x6A3B, 0x6A4D
} };

static const iconv_ccs_convtable_8bit from_ucs_94 = { {
	0x6A42, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6A52, 0x6A44,
	0xFFFE, 0x6A49, 0x6A4C, 0x6A35, 0x6A4F, 0x6A40, 0x6A45, 0x6A39,
	0x6A3D, 0x6A51, 0x6A47, 0x6A36, 0x6A3A, 0x6A3C, 0x6A46, 0xFFFE,
	0xFFFE, 0x6A3F, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x6A38, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x6A3E, 0x6C50, 0x6C54, 0xFFFE, 0x6C56, 0xFFFE, 0xFFFE, 0xFFFE,
	0x6C52, 0x6C58, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6C4F, 0x6C55,
	0xFFFE, 0x6C53, 0xFFFE, 0x6C4E, 0x6A4B, 0x6C51, 0xFFFE, 0x6C4D,
	0x6C57, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6E3C, 0x6E3F, 0x6E3B,
	0x6E3D, 0x6E3E, 0x6E38, 0x6E39, 0x6E36, 0xFFFE, 0xFFFE, 0x6E3A,
	0x6E37, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6F59, 0xFFFE, 0x6F5B,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6F5A, 0x6F5C, 0xFFFE,
	0xFFFE, 0xFFFE, 0x6F58, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x7059, 0x705A, 0xFFFE, 0x7058, 0xFFFE, 0x7142, 0x7141, 0x7143,
	0xFFFE, 0x7144, 0xFFFE, 0x7145, 0x7161, 0x7164, 0x7163, 0xFFFE,
	0x7162, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x7230, 0x7231, 0x722F, 0x7237, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_95 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x3A28, 0x413F, 0x554E, 0x6763, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3A29, 0xFFFE,
	0x3A2A, 0xFFFE, 0xFFFE, 0xFFFE, 0x4141, 0x4140, 0xFFFE, 0xFFFE,
	0x4142, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x4856, 0x4854, 0xFFFE, 0x4855, 0x4853,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x5550, 0x554F, 0xFFFE, 0x5551, 0xFFFE,
	0x5552, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5B59, 0x5B57, 0x6040,
	0xFFFE, 0x5B55, 0x5B56, 0xFFFE, 0x5B52, 0x5B5A, 0x5B54, 0x5B58,
	0x603C, 0xFFFE, 0xFFFE, 0x603E, 0xFFFE, 0x603F, 0xFFFE, 0x603B,
	0xFFFE, 0x603D, 0xFFFE, 0xFFFE, 0xFFFE, 0x5B53, 0xFFFE, 0xFFFE,
	0xFFFE, 0x643A, 0x6438, 0x6439, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x6764, 0x6765, 0xFFFE, 0xFFFE, 0x6A53, 0x6A55,
	0x6A54, 0xFFFE, 0xFFFE, 0x6C5B, 0x6C5A, 0x6C59, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_96 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2169, 0xFFFE,
	0x2278, 0xFFFE, 0x2276, 0x2279, 0x2277, 0xFFFE, 0xFFFE, 0xFFFE,
	0x252E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2530, 0xFFFE, 0x252F,
	0x252D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x2878, 0x287B, 0xFFFE, 0x287A, 0x2879, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x287C, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x2D67, 0xFFFE, 0xFFFE, 0xFFFE, 0x2D68, 0x2D64,
	0xFFFE, 0x2D65, 0xFFFE, 0x2D66, 0x2D63, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3348, 0xFFFE, 0xFFFE, 0x3349,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x3A2D, 0xFFFE, 0x3A2C, 0xFFFE, 0x3A2F,
	0xFFFE, 0x3A2E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3A2B, 0xFFFE, 0x4144, 0xFFFE,
	0x4148, 0xFFFE, 0xFFFE, 0x4147, 0xFFFE, 0xFFFE, 0xFFFE, 0x4143,
	0x4145, 0x4146, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x4859, 0x4857, 0x4858, 0xFFFE, 0xFFFE, 0xFFFE, 0x485A,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4F23, 0xFFFE,
	0xFFFE, 0x4F24, 0x5554, 0xFFFE, 0x5553, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5B5B, 0xFFFE, 0xFFFE, 0x6043, 0xFFFE, 0x6041, 0xFFFE,
	0x6042, 0xFFFE, 0xFFFE, 0x643B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x334A, 0xFFFE, 0xFFFE, 0x3A30,
	0xFFFE, 0xFFFE, 0x4149, 0x414B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x414A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x485B, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x5555, 0x5B5C, 0xFFFE, 0xFFFE, 0x643C,
	0x6440, 0xFFFE, 0x643D, 0xFFFE, 0xFFFE, 0x6441, 0xFFFE, 0x643F,
	0xFFFE, 0x6766, 0xFFFE, 0xFFFE, 0xFFFE, 0x705B, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x414D, 0x414C, 0xFFFE, 0xFFFE, 0xFFFE, 0x485F, 0xFFFE, 0xFFFE,
	0x485E, 0xFFFE, 0x485C, 0xFFFE, 0xFFFE, 0x485D, 0xFFFE, 0x4F25
} };

static const iconv_ccs_convtable_8bit from_ucs_97 = { {
	0xFFFE, 0xFFFE, 0x5558, 0xFFFE, 0xFFFE, 0x5556, 0xFFFE, 0xFFFE,
	0x5557, 0xFFFE, 0xFFFE, 0x5B5D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x5B5F, 0xFFFE, 0x5B5E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x6046, 0x6048, 0xFFFE, 0xFFFE, 0xFFFE, 0x6047, 0xFFFE, 0x6045,
	0x6044, 0xFFFE, 0x6443, 0x6442, 0xFFFE, 0x6444, 0x676B, 0xFFFE,
	0x676A, 0x6767, 0xFFFE, 0x6768, 0x6769, 0xFFFE, 0x6A56, 0x6A57,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6C5C, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x6C5D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6E40,
	0xFFFE, 0xFFFE, 0xFFFE, 0x705D, 0xFFFE, 0xFFFE, 0x705C, 0x705E,
	0xFFFE, 0x7146, 0xFFFE, 0x717B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x4F26, 0xFFFE, 0x5559, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x3A31, 0xFFFE, 0x414E, 0xFFFE, 0x4150, 0xFFFE,
	0x414F, 0xFFFE, 0x4863, 0x4860, 0xFFFE, 0xFFFE, 0xFFFE, 0x4861,
	0x4862, 0xFFFE, 0x4F28, 0x4F2D, 0xFFFE, 0x4F27, 0x4F29, 0x4F30,
	0x4F2B, 0x4F2F, 0x4F2C, 0x4F2A, 0x4F2E, 0xFFFE, 0xFFFE, 0xFFFE,
	0x555C, 0xFFFE, 0x555A, 0xFFFE, 0xFFFE, 0xFFFE, 0x555B, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5B62, 0xFFFE, 0xFFFE, 0x5B61,
	0xFFFE, 0x5B60, 0x6049, 0xFFFE, 0x604B, 0x604D, 0x604C, 0xFFFE,
	0xFFFE, 0x604A, 0x644B, 0xFFFE, 0x6449, 0x644C, 0xFFFE, 0xFFFE,
	0x6447, 0xFFFE, 0x644A, 0x6448, 0x6445, 0xFFFE, 0x6446, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x676C, 0xFFFE, 0xFFFE, 0x676E, 0x676D,
	0xFFFE, 0x6A58, 0xFFFE, 0x6A59, 0xFFFE, 0xFFFE, 0xFFFE, 0x6C5E,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6F5D, 0x6F5E, 0xFFFE, 0x705F,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4F32, 0x4F31, 0x555E,
	0x555D, 0xFFFE, 0xFFFE, 0xFFFE, 0x604F, 0x604E, 0x644F, 0x644D,
	0x6450, 0x644E, 0xFFFE, 0xFFFE, 0xFFFE, 0x676F, 0x6770, 0x6771,
	0xFFFE, 0x6C5F, 0xFFFE, 0x6E41, 0xFFFE, 0x7060, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x5B63, 0x6050, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x5B64, 0xFFFE, 0x6451, 0xFFFE, 0xFFFE, 0x6A5A, 0x6A5B, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_98 = { {
	0x6F5F, 0xFFFE, 0xFFFE, 0xFFFE, 0x3A32, 0xFFFE, 0xFFFE, 0x4151,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4865, 0x4866, 0x4864,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4F33, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x5565, 0xFFFE, 0x5560, 0x555F, 0xFFFE,
	0x5564, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5561, 0x5566,
	0x5563, 0x5562, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5B66,
	0xFFFE, 0xFFFE, 0x5B67, 0xFFFE, 0xFFFE, 0x5B65, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x6051, 0xFFFE, 0x6056, 0x6052, 0x6055, 0xFFFE, 0xFFFE,
	0x5E41, 0x6054, 0x6053, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x6452, 0x6453, 0x6454, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6775,
	0xFFFE, 0x6773, 0xFFFE, 0xFFFE, 0x6772, 0x6774, 0xFFFE, 0x6A5F,
	0x6A5C, 0xFFFE, 0x6A5D, 0x6A5E, 0x6C60, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x6E43, 0x6E42, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x7147, 0x717C, 0x717D, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x4152, 0xFFFE, 0xFFFE, 0x4867, 0x4F34, 0x4F35, 0xFFFE,
	0xFFFE, 0xFFFE, 0x5567, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x6455, 0xFFFE, 0xFFFE, 0x6778, 0xFFFE, 0x6777, 0x6779, 0x6776,
	0x6C63, 0x6A60, 0x6A61, 0xFFFE, 0xFFFE, 0xFFFE, 0x6C62, 0xFFFE,
	0xFFFE, 0x6C61, 0xFFFE, 0x6E44, 0x717E, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x334B, 0xFFFE, 0x3A33, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x4153, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4868, 0xFFFE,
	0xFFFE, 0x4869, 0x5569, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_99 = { {
	0x4F37, 0xFFFE, 0x4F36, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4F38,
	0x5568, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x556A, 0xFFFE, 0xFFFE, 0x556B, 0x556E, 0x556C, 0x556D,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5B69,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5B68, 0x6057, 0xFFFE, 0x5B6A,
	0xFFFE, 0x5B6B, 0x605A, 0x6058, 0x6059, 0x605E, 0xFFFE, 0x605D,
	0x6060, 0x605F, 0x605C, 0x605B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x6458, 0xFFFE, 0x6457, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x6456, 0xFFFE, 0x677C, 0xFFFE, 0xFFFE, 0xFFFE, 0x677B,
	0x677A, 0xFFFE, 0xFFFE, 0x6A66, 0x6A65, 0xFFFE, 0x6A63, 0xFFFE,
	0x6A62, 0xFFFE, 0xFFFE, 0x6A67, 0x6E45, 0xFFFE, 0x6C65, 0xFFFE,
	0x6C64, 0x6A64, 0xFFFE, 0x6E46, 0xFFFE, 0xFFFE, 0xFFFE, 0x7148,
	0xFFFE, 0x7221, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3A34,
	0x6061, 0xFFFE, 0xFFFE, 0xFFFE, 0x4F3A, 0x4F39, 0x5B6C, 0xFFFE,
	0xFFFE, 0x6063, 0xFFFE, 0x6062, 0xFFFE, 0xFFFE, 0x677D, 0x677E,
	0xFFFE, 0xFFFE, 0xFFFE, 0x7222, 0xFFFE, 0xFFFE, 0xFFFE, 0x486A,
	0x486C, 0xFFFE, 0x486B, 0xFFFE, 0xFFFE, 0x486D, 0xFFFE, 0xFFFE,
	0xFFFE, 0x4F3C, 0x4F3E, 0x4F3D, 0xFFFE, 0x4F40, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x4F3F, 0x4F3B, 0xFFFE, 0xFFFE, 0xFFFE, 0x4F41,
	0xFFFE, 0x5575, 0xFFFE, 0x5578, 0x557A, 0x5570, 0x5574, 0x5571,
	0xFFFE, 0xFFFE, 0xFFFE, 0x5572, 0x5573, 0xFFFE, 0x5576, 0x5579,
	0x5577, 0xFFFE, 0xFFFE, 0xFFFE, 0x556F, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x5B72, 0x5B70, 0x5B6F, 0xFFFE, 0x5B75,
	0xFFFE, 0x5B74, 0x5B73, 0xFFFE, 0x5B6E, 0xFFFE, 0x5B6D, 0xFFFE,
	0x5B71, 0xFFFE, 0xFFFE, 0xFFFE, 0x6066, 0xFFFE, 0x606A, 0x6067,
	0x6069, 0x6068, 0x6065, 0x606B, 0x606E, 0x606C, 0x606D, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_9A = { {
	0xFFFE, 0xFFFE, 0x6064, 0x606F, 0x645D, 0x6460, 0x6462, 0x6461,
	0xFFFE, 0x645B, 0x645F, 0x645A, 0xFFFE, 0x645C, 0xFFFE, 0x6459,
	0xFFFE, 0x645E, 0xFFFE, 0xFFFE, 0x682D, 0x6822, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x6821, 0x6826, 0x682C, 0x6824, 0x682B, 0xFFFE,
	0x6828, 0xFFFE, 0x6827, 0x682A, 0x6825, 0x6823, 0xFFFE, 0x6829,
	0xFFFE, 0x6A6E, 0x6A6C, 0xFFFE, 0x6A6B, 0x6A71, 0x6A6F, 0xFFFE,
	0xFFFE, 0x6A6A, 0x6A68, 0xFFFE, 0x6A69, 0xFFFE, 0x6A6D, 0xFFFE,
	0x6A70, 0x6C66, 0x6C6C, 0xFFFE, 0xFFFE, 0x6C67, 0xFFFE, 0x6C6D,
	0xFFFE, 0x6C6B, 0x6C6A, 0xFFFE, 0x6C69, 0xFFFE, 0x6C68, 0xFFFE,
	0x6E4C, 0x6E4E, 0x6E4D, 0xFFFE, 0x6E4A, 0xFFFE, 0x6E47, 0x6E4B,
	0x6E50, 0xFFFE, 0x6E4F, 0x6E48, 0x6E49, 0xFFFE, 0x6F60, 0xFFFE,
	0xFFFE, 0x6F61, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7061, 0xFFFE,
	0x7165, 0xFFFE, 0xFFFE, 0xFFFE, 0x7223, 0xFFFE, 0x7224, 0x7225,
	0x7233, 0x7232, 0xFFFE, 0x723B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x486F, 0xFFFE, 0x486E, 0xFFFE, 0xFFFE,
	0xFFFE, 0x4F42, 0xFFFE, 0x557B, 0x5B78, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5B76, 0xFFFE, 0x5B79, 0xFFFE, 0xFFFE, 0x6070, 0x5B77,
	0x6463, 0xFFFE, 0x682E, 0xFFFE, 0xFFFE, 0xFFFE, 0x6A74, 0x6A72,
	0xFFFE, 0xFFFE, 0x6A73, 0xFFFE, 0xFFFE, 0x6C6E, 0xFFFE, 0xFFFE,
	0x6E51, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7062, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6464, 0xFFFE, 0xFFFE, 0x334C,
	0xFFFE, 0xFFFE, 0xFFFE, 0x4F43, 0xFFFE, 0xFFFE, 0xFFFE, 0x4F44,
	0xFFFE, 0xFFFE, 0xFFFE, 0x557D, 0x557C, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5622, 0x5621, 0x557E, 0xFFFE, 0xFFFE, 0x5B7A, 0x5B7D,
	0xFFFE, 0x5B7C, 0x5B7B, 0xFFFE, 0x6074, 0x6072, 0x6071, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_9B = { {
	0xFFFE, 0x6073, 0xFFFE, 0xFFFE, 0x6466, 0x6467, 0xFFFE, 0xFFFE,
	0x6465, 0xFFFE, 0x6830, 0x682F, 0x6832, 0xFFFE, 0x6831, 0xFFFE,
	0x6A75, 0x6A77, 0x6A76, 0xFFFE, 0xFFFE, 0x6C6F, 0x6C72, 0x6C70,
	0x6C71, 0x6E52, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6F62, 0x6F63,
	0x6F64, 0xFFFE, 0xFFFE, 0xFFFE, 0x7226, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x6468, 0xFFFE, 0x6E53, 0xFFFE, 0xFFFE, 0x7166, 0x334D,
	0xFFFE, 0xFFFE, 0xFFFE, 0x5B7E, 0xFFFE, 0x6469, 0xFFFE, 0x6833,
	0xFFFE, 0xFFFE, 0x6C73, 0x6E54, 0xFFFE, 0xFFFE, 0x4F45, 0x4F46,
	0xFFFE, 0xFFFE, 0xFFFE, 0x5624, 0xFFFE, 0xFFFE, 0x5623, 0xFFFE,
	0x6075, 0xFFFE, 0x646A, 0x646C, 0x646B, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x6C74, 0xFFFE, 0xFFFE, 0x6E56, 0x6E55, 0xFFFE,
	0xFFFE, 0x7063, 0xFFFE, 0x4870, 0xFFFE, 0xFFFE, 0xFFFE, 0x4F49,
	0x4F47, 0x4F48, 0xFFFE, 0xFFFE, 0x562D, 0xFFFE, 0x5628, 0x5625,
	0x562C, 0xFFFE, 0xFFFE, 0xFFFE, 0x562E, 0xFFFE, 0xFFFE, 0xFFFE,
	0x562B, 0x5627, 0xFFFE, 0xFFFE, 0x5626, 0x562A, 0x5629, 0xFFFE,
	0xFFFE, 0xFFFE, 0x5C2B, 0x5C26, 0x5C24, 0x5C2D, 0x5C25, 0xFFFE,
	0x5C21, 0xFFFE, 0x5C27, 0xFFFE, 0xFFFE, 0x5C22, 0x607E, 0x5C23,
	0x5C2E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x5C2A, 0xFFFE, 0x5C29, 0x5C28, 0xFFFE, 0x5C2C, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x6076, 0x6079, 0xFFFE, 0xFFFE, 0x6078, 0xFFFE,
	0x6122, 0x607B, 0x6121, 0xFFFE, 0x607D, 0x607C, 0x607A, 0xFFFE,
	0x6077, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6123,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6472, 0x6475, 0xFFFE,
	0x6473, 0x6477, 0xFFFE, 0xFFFE, 0xFFFE, 0x6478, 0xFFFE, 0x6470,
	0xFFFE, 0x6471, 0xFFFE, 0x646F, 0x6476, 0xFFFE, 0x646E, 0x646D,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x6474, 0x683C, 0x6842, 0xFFFE, 0x683D,
	0xFFFE, 0x6840, 0x6844, 0xFFFE, 0x683F, 0xFFFE, 0x6837, 0xFFFE,
	0x6836, 0x6843, 0x683A, 0xFFFE, 0x6838, 0x6841, 0x6839, 0xFFFE,
	0xFFFE, 0xFFFE, 0x6834, 0x6835, 0x683E, 0xFFFE, 0xFFFE, 0xFFFE,
	0x683B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6A7A,
	0x6A7D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_9C = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6A7B, 0x6B23, 0x6B21,
	0x6A79, 0x6B26, 0xFFFE, 0x6A78, 0xFFFE, 0xFFFE, 0x6B22, 0xFFFE,
	0xFFFE, 0xFFFE, 0x6A7C, 0xFFFE, 0x6B25, 0xFFFE, 0xFFFE, 0x6B24,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6C77, 0x6C76, 0xFFFE, 0xFFFE,
	0xFFFE, 0x6C7D, 0xFFFE, 0x6C79, 0x6C7C, 0xFFFE, 0xFFFE, 0xFFFE,
	0x6C7A, 0x6C7B, 0xFFFE, 0x6C75, 0x6C78, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x6E61, 0x6E5C, 0x6E60, 0xFFFE, 0x6E63, 0x6E5F,
	0xFFFE, 0x6E5B, 0xFFFE, 0xFFFE, 0x6E5E, 0x6E62, 0xFFFE, 0x6E59,
	0x6A7E, 0x6E5D, 0xFFFE, 0xFFFE, 0x6E5A, 0xFFFE, 0x6E57, 0xFFFE,
	0x6E58, 0xFFFE, 0x6F68, 0x6F6A, 0x6F6D, 0x6F69, 0x6F6E, 0xFFFE,
	0x6F67, 0xFFFE, 0x6F65, 0xFFFE, 0xFFFE, 0x6F6B, 0xFFFE, 0xFFFE,
	0x6F66, 0x6F6C, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7068, 0xFFFE,
	0x7069, 0xFFFE, 0x7067, 0x7064, 0xFFFE, 0xFFFE, 0x7066, 0x7065,
	0x7149, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x714B, 0x714A, 0xFFFE,
	0xFFFE, 0x7169, 0xFFFE, 0x7168, 0x7167, 0x716A, 0xFFFE, 0xFFFE,
	0xFFFE, 0x7238, 0x723C, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4154, 0x4873,
	0xFFFE, 0xFFFE, 0x4871, 0xFFFE, 0xFFFE, 0x4872, 0xFFFE, 0xFFFE,
	0xFFFE, 0x4F4A, 0x4F4B, 0xFFFE, 0xFFFE, 0x4F4C, 0xFFFE, 0x5633,
	0xFFFE, 0x5636, 0x5630, 0x5637, 0x562F, 0x5631, 0xFFFE, 0x5632
} };

static const iconv_ccs_convtable_8bit from_ucs_9D = { {
	0x5635, 0xFFFE, 0xFFFE, 0xFFFE, 0x563A, 0x5639, 0xFFFE, 0x5634,
	0x5638, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x5C38, 0xFFFE, 0xFFFE, 0xFFFE, 0x5C33, 0xFFFE, 0xFFFE, 0x5C30,
	0x5C36, 0x5C39, 0xFFFE, 0xFFFE, 0xFFFE, 0x5C35, 0x5C32, 0x5C3A,
	0x5C31, 0xFFFE, 0x5C37, 0xFFFE, 0xFFFE, 0x5C2F, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5C34, 0xFFFE, 0xFFFE, 0xFFFE, 0x6135, 0x6128, 0x6129,
	0x612C, 0x612A, 0xFFFE, 0x6124, 0xFFFE, 0xFFFE, 0x6127, 0x6131,
	0x612B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6133, 0x6130, 0xFFFE,
	0x6132, 0x6125, 0x612E, 0x612F, 0xFFFE, 0x612D, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x647C, 0x647E, 0x6523, 0xFFFE, 0xFFFE, 0x647B,
	0xFFFE, 0xFFFE, 0x6525, 0x647A, 0x6526, 0xFFFE, 0x6522, 0x6524,
	0x6528, 0x6521, 0x6529, 0x647D, 0x6479, 0xFFFE, 0xFFFE, 0x6527,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6126,
	0x685E, 0x6855, 0xFFFE, 0x6851, 0xFFFE, 0xFFFE, 0xFFFE, 0x685A,
	0x6854, 0x684A, 0xFFFE, 0x6857, 0x6852, 0x6853, 0xFFFE, 0x6845,
	0x684C, 0x685B, 0xFFFE, 0x6858, 0xFFFE, 0x6850, 0xFFFE, 0x685C,
	0x684B, 0x6846, 0x6859, 0xFFFE, 0x6848, 0x6856, 0x684D, 0x685D,
	0x6849, 0xFFFE, 0x6847, 0x684E, 0x684F, 0xFFFE, 0xFFFE, 0xFFFE,
	0x6B2D, 0xFFFE, 0x6B2B, 0xFFFE, 0x6B30, 0xFFFE, 0x6B3C, 0x6B33,
	0x6B2C, 0x6B28, 0x6B35, 0x6B2E, 0x6B31, 0x6B2A, 0x6B38, 0x6B27,
	0x6B2F, 0x6B34, 0x6B36, 0x6B39, 0x6B29, 0xFFFE, 0x6B3D, 0x6B3E,
	0x6B37, 0x6B3B, 0x6B32, 0xFFFE, 0x6D2F, 0x6D32, 0xFFFE, 0xFFFE,
	0xFFFE, 0x6D31, 0x6D36, 0x6D34, 0xFFFE, 0x6D2B, 0x6D21, 0x6C7E,
	0xFFFE, 0x6D2D, 0x6D2E, 0x6D2A, 0x6D22, 0xFFFE, 0x6D27, 0x6B3A,
	0xFFFE, 0x6D23, 0xFFFE, 0x6D29, 0xFFFE, 0x6D28, 0xFFFE, 0x6D24,
	0x6D30, 0xFFFE, 0x6D25, 0x6E68, 0x6D33, 0x6D35, 0x6D2C, 0x6D26,
	0x6E69, 0x6E6B, 0x6E65, 0xFFFE, 0xFFFE, 0x6E72, 0x6E70, 0xFFFE,
	0x6E6F, 0x6E6E, 0x6E67, 0x6E64, 0x6E6A, 0x6E73, 0x6E66, 0x6E6C,
	0xFFFE, 0x6F77, 0x6F7C, 0x6F72, 0x6F75, 0xFFFE, 0x6F79, 0xFFFE,
	0x7022, 0x6E6D, 0xFFFE, 0x6F73, 0x6F7D, 0x7023, 0x6F78, 0x6F71,
	0x6F7B, 0xFFFE, 0x6F7A, 0x7021, 0x6F7E, 0x6E71, 0x6F76, 0x6F70,
	0x6F74, 0xFFFE, 0xFFFE, 0x6F6F, 0xFFFE, 0x7074, 0x706B, 0x7073
} };

static const iconv_ccs_convtable_8bit from_ucs_9E = { {
	0x7070, 0x7071, 0x706A, 0x706D, 0x7075, 0x706F, 0x706E, 0x706C,
	0xFFFE, 0x7072, 0xFFFE, 0x714C, 0xFFFE, 0x714D, 0xFFFE, 0x714F,
	0x714E, 0x7151, 0x7150, 0x716C, 0x716B, 0x7227, 0xFFFE, 0x7228,
	0xFFFE, 0x7234, 0xFFFE, 0xFFFE, 0xFFFE, 0x723D, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x6D37, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x4874, 0xFFFE, 0xFFFE, 0x563B, 0xFFFE, 0xFFFE, 0x5C3C, 0x5C3D,
	0x5C3B, 0x6137, 0x6136, 0xFFFE, 0x652B, 0x6138, 0x652A, 0xFFFE,
	0xFFFE, 0x6860, 0xFFFE, 0xFFFE, 0x685F, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x6B3F, 0x6B41, 0x6B40, 0x6D38, 0xFFFE, 0xFFFE, 0xFFFE,
	0x7076, 0x7152, 0xFFFE, 0xFFFE, 0x7241, 0xFFFE, 0xFFFE, 0x4F4D,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5C3F, 0x5C3E, 0xFFFE,
	0x6139, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6E74, 0x7239,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x6861, 0xFFFE, 0x7024, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x613A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x7025, 0xFFFE, 0xFFFE, 0x563C, 0xFFFE, 0x5C40, 0x5C41, 0xFFFE,
	0xFFFE, 0xFFFE, 0x613B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x652C,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6B43, 0x6B42, 0x6B45, 0x6B44,
	0xFFFE, 0xFFFE, 0xFFFE, 0x6D39, 0xFFFE, 0x6D3B, 0x6D3A, 0xFFFE,
	0x6E75, 0xFFFE, 0x7026, 0x7027, 0xFFFE, 0x7153, 0x716D, 0xFFFE,
	0xFFFE, 0x4155, 0x5C42, 0x613C, 0x6862, 0x4875, 0xFFFE, 0x613D
} };

static const iconv_ccs_convtable_8bit from_ucs_9F = { {
	0x652E, 0x652D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7028, 0xFFFE,
	0xFFFE, 0x7154, 0x716E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x563D,
	0x563E, 0xFFFE, 0x5C43, 0xFFFE, 0xFFFE, 0xFFFE, 0x652F, 0xFFFE,
	0x6D3D, 0xFFFE, 0x6D3E, 0x6D3C, 0x7029, 0xFFFE, 0x7077, 0xFFFE,
	0xFFFE, 0xFFFE, 0x6140, 0x613F, 0x613E, 0x6530, 0xFFFE, 0xFFFE,
	0x6534, 0x6533, 0x6532, 0x6531, 0xFFFE, 0x6863, 0x6B47, 0xFFFE,
	0x6B46, 0x6D3F, 0x6E78, 0x6E77, 0xFFFE, 0x6E76, 0x702C, 0x702B,
	0x702A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5C44, 0xFFFE, 0xFFFE,
	0x6864, 0x6865, 0x6E79, 0x702D, 0xFFFE, 0xFFFE, 0x7078, 0x7155,
	0x7229, 0x7243, 0xFFFE, 0xFFFE, 0x6535, 0x6866, 0x6D40, 0x702E,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6141, 0x6536, 0x6867, 0x6868,
	0x6869, 0x6B4C, 0xFFFE, 0x6B48, 0xFFFE, 0x6B4B, 0x6B4A, 0xFFFE,
	0x6B49, 0xFFFE, 0xFFFE, 0xFFFE, 0x6D42, 0x6D41, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x6E7A, 0xFFFE, 0xFFFE, 0x7031, 0x7032,
	0x7030, 0x702F, 0xFFFE, 0xFFFE, 0x7079, 0x707A, 0x707B, 0xFFFE,
	0x7156, 0x7159, 0x7158, 0x7157, 0xFFFE, 0xFFFE, 0x7242, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x6B4D, 0x6D43, 0xFFFE, 0xFFFE, 0x6E7B, 0xFFFE, 0xFFFE,
	0x7244, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x6142, 0xFFFE, 0x6E7C, 0xFFFE, 0x716F, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_16bit from_ucs = { {
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	NULL, NULL, NULL, NULL, NULL, NULL, &from_ucs_4E, &from_ucs_4F,
	&from_ucs_50, &from_ucs_51, &from_ucs_52, &from_ucs_53, &from_ucs_54, &from_ucs_55, &from_ucs_56, &from_ucs_57,
	&from_ucs_58, &from_ucs_59, &from_ucs_5A, &from_ucs_5B, &from_ucs_5C, &from_ucs_5D, &from_ucs_5E, &from_ucs_5F,
	&from_ucs_60, &from_ucs_61, &from_ucs_62, &from_ucs_63, &from_ucs_64, &from_ucs_65, &from_ucs_66, &from_ucs_67,
	&from_ucs_68, &from_ucs_69, &from_ucs_6A, &from_ucs_6B, &from_ucs_6C, &from_ucs_6D, &from_ucs_6E, &from_ucs_6F,
	&from_ucs_70, &from_ucs_71, &from_ucs_72, &from_ucs_73, &from_ucs_74, &from_ucs_75, &from_ucs_76, &from_ucs_77,
	&from_ucs_78, &from_ucs_79, &from_ucs_7A, &from_ucs_7B, &from_ucs_7C, &from_ucs_7D, &from_ucs_7E, &from_ucs_7F,
	&from_ucs_80, &from_ucs_81, &from_ucs_82, &from_ucs_83, &from_ucs_84, &from_ucs_85, &from_ucs_86, &from_ucs_87,
	&from_ucs_88, &from_ucs_89, &from_ucs_8A, &from_ucs_8B, &from_ucs_8C, &from_ucs_8D, &from_ucs_8E, &from_ucs_8F,
	&from_ucs_90, &from_ucs_91, &from_ucs_92, &from_ucs_93, &from_ucs_94, &from_ucs_95, &from_ucs_96, &from_ucs_97,
	&from_ucs_98, &from_ucs_99, &from_ucs_9A, &from_ucs_9B, &from_ucs_9C, &from_ucs_9D, &from_ucs_9E, &from_ucs_9F,
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL
} };

#define NBITS 14

static ucs2_t convert_from_ucs(ucs2_t ch)
{
	return iconv_ccs_convert_16bit((const iconv_ccs_convtable *)&from_ucs, ch);
}

static ucs2_t convert_to_ucs(ucs2_t ch)
{
	return iconv_ccs_convert_14bit((const iconv_ccs_convtable *)&to_ucs, ch);
}

static const char * const names[] = {
	"cns11643-plane2", NULL
};

static const struct iconv_ccs_desc iconv_ccs_desc = {
	names, NBITS,
	(const iconv_ccs_convtable *)&from_ucs,
	(const iconv_ccs_convtable *)&to_ucs,
	convert_from_ucs, convert_to_ucs,
};

struct iconv_module_desc iconv_module = {
	ICMOD_UC_CCS,
	apr_iconv_mod_noevent,
	NULL,
	&iconv_ccs_desc
};
