/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.aries.blueprint.mutable;

import org.apache.aries.blueprint.ExtendedBeanMetadata;
import org.osgi.service.blueprint.reflect.BeanArgument;
import org.osgi.service.blueprint.reflect.BeanProperty;
import org.osgi.service.blueprint.reflect.Metadata;
import org.osgi.service.blueprint.reflect.Target;

/**
 * A mutable version of the <code>BeanMetadata</code> that allows modifications.
 *
 * @version $Rev: 910448 $, $Date: 2010-02-16 09:50:18 +0000 (Tue, 16 Feb 2010) $
 */
public interface MutableBeanMetadata extends ExtendedBeanMetadata, MutableComponentMetadata {

    void setClassName(String className);

    void setInitMethod(String initMethodName);

    void setDestroyMethod(String destroyMethodName);

    void addArgument(BeanArgument argument);

    BeanArgument addArgument(Metadata value, String valueType, int index);

    void removeArgument(BeanArgument argument);

    void addProperty(BeanProperty property);

    BeanProperty addProperty(String name, Metadata value);

    void removeProperty(BeanProperty property);

    void setFactoryMethod(String factoryMethodName);

    void setFactoryComponent(Target factoryComponent);

    void setScope(String scope);

    void setRuntimeClass(Class runtimeClass);

    void setProcessor(boolean processor);
    
    void setFieldInjection(boolean allowFieldInjection);

}
