/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.application.impl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.aries.application.ApplicationMetadata;
import org.apache.aries.application.Content;
import org.apache.aries.application.ServiceDeclaration;
import org.apache.aries.application.impl.ContentImpl;
import org.apache.aries.application.utils.manifest.ManifestProcessor;
import org.osgi.framework.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ApplicationMetadataImpl
implements ApplicationMetadata {
    private String appSymbolicName;
    private Version appVersion;
    private String appName;
    private String appScope;
    private List<Content> appContents = new ArrayList<Content>();
    private List<ServiceDeclaration> importServices = new ArrayList<ServiceDeclaration>();
    private List<ServiceDeclaration> exportServices = new ArrayList<ServiceDeclaration>();
    private Manifest manifest;

    public ApplicationMetadataImpl(Manifest appManifest) {
        this.setup(appManifest);
        this.manifest = appManifest;
    }

    private void setup(Manifest appManifest) {
        Map<String, String> appMap = this.readManifestIntoMap(appManifest);
        this.appSymbolicName = appMap.get("Application-SymbolicName");
        this.appVersion = new Version(appMap.get("Application-Version"));
        this.appName = appMap.get("Application-Name");
        this.appScope = this.appSymbolicName + "_" + this.appVersion.toString();
        if (this.appSymbolicName == null || this.appVersion == null) {
            throw new IllegalArgumentException("Failed to create ApplicationMetadataImpl object from Manifest " + appManifest);
        }
        String applicationContents = appMap.get("Application-Content");
        List<String> appContentsArray = ManifestProcessor.split(applicationContents, ",");
        for (String content : appContentsArray) {
            this.appContents.add(new ContentImpl(content));
        }
    }

    private Map<String, String> readManifestIntoMap(Manifest mf) {
        Set<Map.Entry<Object, Object>> attributeSet;
        HashMap<String, String> props = new HashMap<String, String>();
        Attributes mainAttrs = mf.getMainAttributes();
        if (mainAttrs != null && (attributeSet = mainAttrs.entrySet()) != null) {
            for (Map.Entry<Object, Object> entry : attributeSet) {
                props.put(String.valueOf(entry.getKey()), String.valueOf(entry.getValue()));
            }
        }
        return props;
    }

    @Override
    public List<Content> getApplicationContents() {
        return Collections.unmodifiableList(this.appContents);
    }

    @Override
    public List<ServiceDeclaration> getApplicationExportServices() {
        return Collections.unmodifiableList(this.exportServices);
    }

    @Override
    public List<ServiceDeclaration> getApplicationImportServices() {
        return Collections.unmodifiableList(this.importServices);
    }

    @Override
    public String getApplicationSymbolicName() {
        return this.appSymbolicName;
    }

    @Override
    public Version getApplicationVersion() {
        return this.appVersion;
    }

    @Override
    public String getApplicationName() {
        return this.appName;
    }

    @Override
    public String getApplicationScope() {
        return this.appScope;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (other instanceof ApplicationMetadataImpl) {
            return this.appScope.equals(((ApplicationMetadataImpl)other).appScope);
        }
        return false;
    }

    public int hashCode() {
        return this.appScope.hashCode();
    }

    @Override
    public void store(File f) throws IOException {
        FileOutputStream fos = new FileOutputStream(f);
        this.store(fos);
        fos.close();
    }

    @Override
    public void store(OutputStream out) throws IOException {
        if (this.manifest != null) {
            Attributes att = this.manifest.getMainAttributes();
            if (att.getValue(Attributes.Name.MANIFEST_VERSION.toString()) == null) {
                att.putValue(Attributes.Name.MANIFEST_VERSION.toString(), "1.0");
            }
            this.manifest.write(out);
        }
    }
}

