/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.application.impl;

import java.util.Map;
import org.apache.aries.application.DeploymentContent;
import org.apache.aries.application.VersionRange;
import org.apache.aries.application.impl.ContentImpl;
import org.apache.aries.application.utils.manifest.ManifestHeaderProcessor;
import org.osgi.framework.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DeploymentContentImpl
implements DeploymentContent {
    private ContentImpl _content;

    public DeploymentContentImpl(String bundleSymbolicName, Version version) {
        ManifestHeaderProcessor.NameValueMap<String, String> nvMap = new ManifestHeaderProcessor.NameValueMap<String, String>();
        nvMap.put("deployed-version", version.toString());
        this._content = new ContentImpl(bundleSymbolicName, nvMap);
    }

    public DeploymentContentImpl(String deployedContent) {
        this._content = new ContentImpl(deployedContent);
    }

    @Override
    public Version getExactVersion() {
        return this.getVersion().getExactVersion();
    }

    @Override
    public String getAttribute(String key) {
        return this._content.getAttribute(key);
    }

    @Override
    public Map<String, String> getAttributes() {
        return this._content.getAttributes();
    }

    @Override
    public String getContentName() {
        return this._content.getContentName();
    }

    @Override
    public String getDirective(String key) {
        return this._content.getDirective(key);
    }

    @Override
    public Map<String, String> getDirectives() {
        return this._content.getDirectives();
    }

    @Override
    public VersionRange getVersion() {
        String deployedVersion = this._content.getAttribute("deployed-version");
        VersionRange vr = null;
        if (deployedVersion != null && deployedVersion.length() > 0) {
            vr = ManifestHeaderProcessor.parseVersionRange(deployedVersion, true);
        }
        return vr;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (other instanceof DeploymentContentImpl) {
            return this._content.equals(((DeploymentContentImpl)other)._content);
        }
        return false;
    }

    public int hashCode() {
        return this._content.hashCode();
    }

    @Override
    public Map<String, String> getNameValueMap() {
        return this._content.getNameValueMap();
    }

    public String toString() {
        return this._content.toString();
    }
}

