/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.application.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import java.util.jar.Manifest;
import org.apache.aries.application.DeploymentMetadata;
import org.apache.aries.application.DeploymentMetadataFactory;
import org.apache.aries.application.filesystem.IFile;
import org.apache.aries.application.impl.DeploymentMetadataImpl;
import org.apache.aries.application.management.AriesApplication;
import org.apache.aries.application.management.BundleInfo;
import org.apache.aries.application.management.ResolverException;
import org.apache.aries.application.utils.manifest.ManifestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeploymentMetadataFactoryImpl
implements DeploymentMetadataFactory {
    @Override
    public DeploymentMetadata createDeploymentMetadata(AriesApplication app, Set<BundleInfo> additionalBundlesRequired) throws ResolverException {
        return new DeploymentMetadataImpl(app, additionalBundlesRequired);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeploymentMetadata createDeploymentMetadata(IFile src) throws IOException {
        InputStream is = src.open();
        try {
            DeploymentMetadata deploymentMetadata = this.createDeploymentMetadata(is);
            return deploymentMetadata;
        }
        finally {
            is.close();
        }
    }

    @Override
    public DeploymentMetadata createDeploymentMetadata(InputStream in) throws IOException {
        return this.createDeploymentMetadata(ManifestProcessor.parseManifest(in));
    }

    @Override
    public DeploymentMetadata createDeploymentMetadata(Manifest manifest) throws IOException {
        return new DeploymentMetadataImpl(manifest);
    }
}

