/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.application.management.impl;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.Set;
import org.apache.aries.application.ApplicationMetadata;
import org.apache.aries.application.DeploymentMetadata;
import org.apache.aries.application.management.AriesApplication;
import org.apache.aries.application.management.BundleConversion;
import org.apache.aries.application.management.BundleInfo;
import org.apache.aries.application.management.LocalPlatform;
import org.apache.aries.application.utils.filesystem.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AriesApplicationImpl
implements AriesApplication {
    private static final Logger _logger = LoggerFactory.getLogger((String)"org.apache.aries.application.management");
    private Set<BundleInfo> _bundleInfo;
    private ApplicationMetadata _applicationMetadata;
    private DeploymentMetadata _deploymentMetadata;
    private LocalPlatform _localPlatform;
    private Map<String, BundleConversion> _modifiedBundles = null;

    public AriesApplicationImpl(ApplicationMetadata meta, Set<BundleInfo> bundleInfo, LocalPlatform lp) {
        this._applicationMetadata = meta;
        this._bundleInfo = bundleInfo;
        this._deploymentMetadata = null;
        this._localPlatform = lp;
    }

    public AriesApplicationImpl(ApplicationMetadata meta, DeploymentMetadata dep, Set<BundleInfo> bundleInfo, LocalPlatform lp) {
        this._applicationMetadata = meta;
        this._bundleInfo = bundleInfo;
        this._deploymentMetadata = dep;
        this._localPlatform = lp;
    }

    @Override
    public ApplicationMetadata getApplicationMetadata() {
        return this._applicationMetadata;
    }

    @Override
    public Set<BundleInfo> getBundleInfo() {
        return this._bundleInfo;
    }

    @Override
    public DeploymentMetadata getDeploymentMetadata() {
        return this._deploymentMetadata;
    }

    public void setDeploymentMetadata(DeploymentMetadata dm) {
        this._deploymentMetadata = dm;
    }

    public Map<String, BundleConversion> getModifiedBundles() {
        return this._modifiedBundles;
    }

    public void setModifiedBundles(Map<String, BundleConversion> modifiedBundles) {
        this._modifiedBundles = modifiedBundles;
    }

    public void setLocalPlatform(LocalPlatform lp) {
        this._localPlatform = lp;
    }

    @Override
    public boolean isResolved() {
        return this.getDeploymentMetadata() != null;
    }

    @Override
    public void store(File f) throws FileNotFoundException, IOException {
        if (f.isDirectory()) {
            this.storeInDirectory(f);
        } else {
            FileOutputStream os = new FileOutputStream(f);
            this.store(os);
            ((OutputStream)os).close();
        }
    }

    @Override
    public void store(OutputStream targetStream) throws FileNotFoundException, IOException {
        File tempDir = this._localPlatform.getTemporaryDirectory();
        this.storeInDirectory(tempDir);
        IOUtils.zipUp(tempDir, targetStream);
        if (!IOUtils.deleteRecursive(tempDir)) {
            _logger.warn("APPMANAGEMENT0001E", (Object)tempDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeInDirectory(File dir) throws IOException, MalformedURLException {
        OutputStream out = null;
        Closeable in = null;
        try {
            out = IOUtils.getOutputStream(dir, "META-INF/APPLICATION.MF");
            this._applicationMetadata.store(out);
        }
        finally {
            IOUtils.close(out);
        }
        if (this._deploymentMetadata != null) {
            try {
                out = IOUtils.getOutputStream(dir, "META-INF/DEPLOYMENT.MF");
                this._deploymentMetadata.store(out);
            }
            finally {
                IOUtils.close(out);
            }
        }
        for (BundleInfo bundleInfo : this._bundleInfo) {
            String bundleLocation = bundleInfo.getLocation();
            String bundleFileName = bundleLocation.substring(bundleLocation.lastIndexOf(47) + 1);
            try {
                out = IOUtils.getOutputStream(dir, bundleFileName);
                URL bundleURL = new URL(bundleLocation);
                InputStream is = bundleURL.openStream();
                IOUtils.copy(is, out);
            }
            finally {
                IOUtils.close(out);
                IOUtils.close(in);
            }
        }
        if (this._modifiedBundles != null) {
            for (Map.Entry entry : this._modifiedBundles.entrySet()) {
                try {
                    out = IOUtils.getOutputStream(dir, (String)entry.getKey());
                    IOUtils.copy(((BundleConversion)entry.getValue()).getInputStream(), out);
                }
                finally {
                    IOUtils.close(out);
                }
            }
        }
    }
}

