/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.application.utils.filesystem.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.aries.application.filesystem.IDirectory;
import org.apache.aries.application.filesystem.IFile;
import org.apache.aries.application.utils.filesystem.impl.FileImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectoryImpl
extends FileImpl
implements IDirectory {
    public DirectoryImpl(File dir, File rootFile) {
        super(dir, rootFile);
    }

    @Override
    public IFile getFile(String name) {
        File desiredFile = new File(this.file, name);
        FileImpl result = null;
        if (desiredFile.exists()) {
            result = !desiredFile.isDirectory() ? new FileImpl(desiredFile, this.rootDirFile) : new DirectoryImpl(desiredFile, this.rootDirFile);
        }
        return result;
    }

    @Override
    public boolean isRoot() {
        boolean result = this.rootDirFile == this.file;
        return result;
    }

    @Override
    public List<IFile> listFiles() {
        ArrayList<IFile> files = new ArrayList<IFile>();
        File[] filesInDir = this.file.listFiles();
        if (filesInDir != null) {
            for (File f : filesInDir) {
                if (f.isFile()) {
                    files.add(new FileImpl(f, this.rootDirFile));
                    continue;
                }
                if (!f.isDirectory()) continue;
                files.add(new DirectoryImpl(f, this.rootDirFile));
            }
        }
        return files;
    }

    @Override
    public Iterator<IFile> iterator() {
        Iterator<IFile> result = this.listFiles().iterator();
        return result;
    }

    @Override
    public IDirectory getParent() {
        IDirectory result = this.isRoot() ? null : super.getParent();
        return result;
    }

    @Override
    public IDirectory convert() {
        return this;
    }

    @Override
    public InputStream open() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getLastModified() {
        long result = super.getLastModified();
        for (IFile aFile : this) {
            long tmpLastModified = aFile.getLastModified();
            if (tmpLastModified <= result) continue;
            result = tmpLastModified;
        }
        return result;
    }
}

