/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.application.utils.manifest;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.aries.application.VersionRange;
import org.apache.aries.application.impl.VersionRangeImpl;
import org.apache.aries.application.utils.internal.MessageUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManifestHeaderProcessor {
    public static final String NESTED_FILTER_ATTRIBUTE = "org.apache.aries.application.filter.attribute";
    private static final Pattern FILTER_ATTR = Pattern.compile("(\\(!)?\\((.*?)([<>]?=)(.*?)\\)\\)?");
    private static final String LESS_EQ_OP = "<=";
    private static final String GREATER_EQ_OP = ">=";

    public static List<String> split(String value, String delimiter) {
        ArrayList<String> result = new ArrayList<String>();
        if (value != null) {
            String[] packages = value.split(delimiter);
            int i = 0;
            while (i < packages.length) {
                String tmp = packages[i++].trim();
                while (ManifestHeaderProcessor.count(tmp, "\"") % 2 != 0) {
                    if (i < packages.length) {
                        tmp = tmp + delimiter + packages[i++].trim();
                        continue;
                    }
                    throw new IllegalArgumentException(MessageUtil.getMessage("APPUTILS0008E", tmp));
                }
                result.add(tmp);
            }
        }
        return result;
    }

    private static int count(String parent, String subString) {
        int count = 0;
        int i = parent.indexOf(subString);
        while (i > -1) {
            if (parent.length() >= i + 1) {
                parent = parent.substring(i + 1);
            }
            ++count;
            i = parent.indexOf(subString);
        }
        return count;
    }

    private static List<NameValuePair<String, NameValueMap<String, String>>> genericNameWithNameValuePairProcess(String s) {
        String name;
        NameValueMap<Object, Object> params = null;
        ArrayList<NameValuePair<String, NameValueMap<String, String>>> nameValues = new ArrayList<NameValuePair<String, NameValueMap<String, String>>>();
        ArrayList<String> pkgs = new ArrayList<String>();
        int index = s.indexOf(";");
        if (index == -1) {
            name = s;
            params = new NameValueMap();
            pkgs.add(name);
        } else {
            name = s.substring(0, index).trim();
            String tail = s.substring(index + 1).trim();
            pkgs.add(name);
            StringBuilder parameters = new StringBuilder();
            List<String> tailParts = ManifestHeaderProcessor.split(tail, ";");
            boolean firstParameter = false;
            for (String part : tailParts) {
                if (!part.contains("=")) {
                    if (firstParameter) continue;
                    pkgs.add(part);
                    continue;
                }
                if (!firstParameter) {
                    firstParameter = true;
                }
                parameters.append(part + ";");
            }
            if (parameters.length() != 0) {
                if (parameters.toString().endsWith(";")) {
                    parameters = parameters.deleteCharAt(parameters.length() - 1);
                }
                params = ManifestHeaderProcessor.genericNameValueProcess(parameters.toString());
            }
        }
        for (String pkg : pkgs) {
            nameValues.add(new NameValuePair(pkg, params));
        }
        return nameValues;
    }

    private static NameValueMap<String, String> genericNameValueProcess(String s) {
        NameValueMap<String, String> params = new NameValueMap<String, String>();
        List<String> parameters = ManifestHeaderProcessor.split(s, ";");
        for (String parameter : parameters) {
            List<String> parts = ManifestHeaderProcessor.split(parameter, "=");
            if (parts.size() != 2) continue;
            String second = parts.get(1).trim();
            if (second.startsWith("\"") && second.endsWith("\"")) {
                second = second.substring(1, second.length() - 1);
            }
            params.put(parts.get(0).trim(), second);
        }
        return params;
    }

    private static void genericImportExportProcess(NameValueCollection<String, NameValueMap<String, String>> out, String s) {
        List<String> packages = ManifestHeaderProcessor.split(s, ",");
        for (String pkg : packages) {
            List<NameValuePair<String, NameValueMap<String, String>>> ps = ManifestHeaderProcessor.genericNameWithNameValuePairProcess(pkg);
            for (NameValuePair<String, NameValueMap<String, String>> p : ps) {
                out.addToCollection(p.getName(), p.getValue());
            }
        }
    }

    public static List<NameValuePair<String, NameValueMap<String, String>>> parseExportString(String s) {
        NameValueList<String, NameValueMap<String, String>> retval = new NameValueList<String, NameValueMap<String, String>>();
        ManifestHeaderProcessor.genericImportExportProcess(retval, s);
        return retval;
    }

    public static List<NameValuePair<String, NameValueMap<String, String>>> parseExportList(List<String> list) {
        NameValueList<String, NameValueMap<String, String>> retval = new NameValueList<String, NameValueMap<String, String>>();
        for (String pkg : list) {
            List<NameValuePair<String, NameValueMap<String, String>>> ps = ManifestHeaderProcessor.genericNameWithNameValuePairProcess(pkg);
            for (NameValuePair<String, NameValueMap<String, String>> p : ps) {
                retval.addToCollection(p.getName(), p.getValue());
            }
        }
        return retval;
    }

    public static Map<String, NameValueMap<String, String>> parseImportString(String s) {
        NameValueMap<String, NameValueMap<String, String>> retval = new NameValueMap<String, NameValueMap<String, String>>();
        ManifestHeaderProcessor.genericImportExportProcess(retval, s);
        return retval;
    }

    public static NameValuePair<String, NameValueMap<String, String>> parseBundleSymbolicName(String s) {
        return ManifestHeaderProcessor.genericNameWithNameValuePairProcess(s).get(0);
    }

    public static VersionRange parseVersionRange(String s) throws IllegalArgumentException {
        return new VersionRangeImpl(s);
    }

    public static VersionRange parseVersionRange(String s, boolean exactVersion) throws IllegalArgumentException {
        return new VersionRangeImpl(s, exactVersion);
    }

    public static String generateFilter(Map<String, String> attribs) {
        StringBuilder filter = new StringBuilder("(&");
        boolean realAttrib = false;
        StringBuffer realAttribs = new StringBuffer();
        if (attribs == null) {
            attribs = new HashMap<String, String>();
        }
        for (Map.Entry<String, String> attrib : attribs.entrySet()) {
            String attribName = attrib.getKey();
            if (attribName.endsWith(":")) continue;
            if ("version".equals(attribName) || "bundle-version".equals(attribName)) {
                realAttrib = true;
                VersionRange vr = ManifestHeaderProcessor.parseVersionRange(attrib.getValue());
                String versionAttribName = "version";
                filter.append("(" + versionAttribName + GREATER_EQ_OP + vr.getMinimumVersion());
                if (vr.getMaximumVersion() != null) {
                    filter.append(")(" + versionAttribName + LESS_EQ_OP);
                    filter.append(vr.getMaximumVersion());
                }
                if (vr.getMaximumVersion() != null && vr.isMinimumExclusive()) {
                    filter.append(")(!(" + versionAttribName + "=");
                    filter.append(vr.getMinimumVersion());
                    filter.append(")");
                }
                if (vr.getMaximumVersion() != null && vr.isMaximumExclusive()) {
                    filter.append(")(!(" + versionAttribName + "=");
                    filter.append(vr.getMaximumVersion());
                    filter.append(")");
                }
                filter.append(")");
                continue;
            }
            if (NESTED_FILTER_ATTRIBUTE.equals(attribName)) {
                realAttrib = true;
                filter.append(attrib.getValue());
                continue;
            }
            if ("objectClass".equals(attribName)) {
                String[] values;
                realAttrib = true;
                for (String s : values = attrib.getValue().split(",")) {
                    filter.append("(objectClass=" + s + ")");
                }
                continue;
            }
            realAttrib = true;
            filter.append("(" + attribName + "=" + attrib.getValue() + ")");
            if ("bundle-symbolic-name".equals(attribName)) continue;
            realAttribs.append(attribName);
            realAttribs.append(", ");
        }
        if (realAttribs.length() > 0) {
            String attribStr = realAttribs.toString().trim();
            if (attribStr.length() > 0 && attribStr.endsWith(",")) {
                attribStr = attribStr.substring(0, attribStr.length() - 1);
            }
            filter.append("(mandatory:<*" + attribStr + ")");
        }
        String filterString = filter.toString();
        int openBraces = 0;
        int i = 0;
        while (openBraces < 3 && (i = filterString.indexOf(40, i)) != -1) {
            ++openBraces;
            ++i;
        }
        if (openBraces < 3 && filterString.length() > 2) {
            filter.delete(0, 2);
        } else {
            filter.append(")");
        }
        String result = "";
        if (realAttrib) {
            result = filter.toString();
        }
        return result;
    }

    public static String generateFilter(String type, String name, Map<String, String> attribs) {
        StringBuffer filter = new StringBuffer();
        if (attribs == null || attribs.isEmpty()) {
            filter.append("(" + type + "=" + name + ")");
        } else {
            filter.append("(&(" + type + "=" + name + ")");
            String filterString = ManifestHeaderProcessor.generateFilter(attribs);
            int start = 0;
            int end = filterString.length();
            if (filterString.startsWith("(&")) {
                start = 2;
                --end;
            }
            if ("".equals(filterString)) {
                filter.delete(0, 2);
            } else {
                filter.append(filterString, start, end);
                filter.append(")");
            }
        }
        String result = filter.toString();
        return result;
    }

    private static Map<String, String> parseFilterList(String filter) {
        HashMap<String, String> result = new HashMap<String, String>();
        HashSet<String> negatedVersions = new HashSet<String>();
        HashSet<String> negatedBundleVersions = new HashSet<String>();
        String lowerVersion = null;
        String upperVersion = null;
        String lowerBundleVersion = null;
        String upperBundleVersion = null;
        Matcher m = FILTER_ATTR.matcher(filter);
        while (m.find()) {
            boolean negation = m.group(1) != null;
            String attr = m.group(2);
            String op = m.group(3);
            String value = m.group(4);
            if ("version".equals(attr)) {
                if (negation) {
                    negatedVersions.add(value);
                    continue;
                }
                if (GREATER_EQ_OP.equals(op)) {
                    lowerVersion = value;
                    continue;
                }
                if (LESS_EQ_OP.equals(op)) {
                    upperVersion = value;
                    continue;
                }
                throw new IllegalArgumentException();
            }
            if ("bundle-version".equals(attr)) {
                if (negation) {
                    negatedBundleVersions.add(value);
                    continue;
                }
                if (GREATER_EQ_OP.equals(op)) {
                    lowerBundleVersion = value;
                    continue;
                }
                if (LESS_EQ_OP.equals(op)) {
                    upperBundleVersion = value;
                    continue;
                }
                throw new IllegalArgumentException();
            }
            result.put(attr, value);
        }
        if (lowerVersion != null) {
            StringBuilder versionAttr = new StringBuilder(lowerVersion);
            if (upperVersion != null) {
                versionAttr.append(",").append(upperVersion).insert(0, negatedVersions.contains(lowerVersion) ? (char)'(' : '[').append(negatedVersions.contains(upperVersion) ? (char)')' : ']');
            }
            result.put("version", versionAttr.toString());
        }
        if (lowerBundleVersion != null) {
            StringBuilder versionAttr = new StringBuilder(lowerBundleVersion);
            if (upperBundleVersion != null) {
                versionAttr.append(",").append(upperBundleVersion).insert(0, negatedBundleVersions.contains(lowerBundleVersion) ? (char)'(' : '[').append(negatedBundleVersions.contains(upperBundleVersion) ? (char)')' : ']');
            }
            result.put("bundle-version", versionAttr.toString());
        }
        return result;
    }

    public static Map<String, String> parseFilter(String filter) {
        Map<String, String> result = filter.startsWith("(&") ? ManifestHeaderProcessor.parseFilterList(filter.substring(2, filter.length() - 1)) : ManifestHeaderProcessor.parseFilterList(filter);
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NameValueList<N, V>
    extends ArrayList<NameValuePair<N, V>>
    implements NameValueCollection<N, V>,
    List<NameValuePair<N, V>> {
        @Override
        public void addToCollection(N n, V v) {
            this.add(new NameValuePair<N, V>(n, v));
        }

        @Override
        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("{");
            boolean first = true;
            for (NameValuePair nvp : this) {
                if (!first) {
                    sb.append(",");
                }
                first = false;
                sb.append(nvp.toString());
            }
            sb.append("}");
            return sb.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NameValueMap<N, V>
    extends HashMap<N, V>
    implements NameValueCollection<N, V>,
    Map<N, V> {
        @Override
        public void addToCollection(N n, V v) {
            this.put(n, v);
        }

        @Override
        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("{");
            boolean first = true;
            for (Map.Entry entry : this.entrySet()) {
                if (!first) {
                    sb.append(",");
                }
                first = false;
                sb.append(entry.getKey() + "->" + entry.getValue());
            }
            sb.append("}");
            return sb.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface NameValueCollection<N, V> {
        public void addToCollection(N var1, V var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NameValuePair<N, V> {
        private N name;
        private V value;

        public NameValuePair(N name, V value) {
            this.name = name;
            this.value = value;
        }

        public N getName() {
            return this.name;
        }

        public void setName(N name) {
            this.name = name;
        }

        public V getValue() {
            return this.value;
        }

        public void setValue(V value) {
            this.value = value;
        }

        public String toString() {
            return "{" + this.name.toString() + "::" + this.value.toString() + "}";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NameValuePair other = (NameValuePair)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return !(this.value == null ? other.value != null : !this.value.equals(other.value));
        }
    }
}

