/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIESOR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.aries.application.management.spi.framework;

import java.util.List;

import org.apache.aries.application.management.AriesApplication;
import org.apache.aries.application.management.spi.repository.BundleRepository.BundleSuggestion;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;

public interface BundleFramework
{  
  public static final String SHARED_BUNDLE_FRAMEWORK = "shared.bundle.framework";
  
  /**
   * Initialises the framework (but does not start the framework bundle)
   * @throws BundleException
   */
  public void init() throws BundleException;
 
  /**
   * Starts the framework and the framework bundle
   * @throws BundleException
   */
  public void start() throws BundleException;

  /**
   * Closes the framework and any associated resource
   * @throws BundleException
   */
  public void close() throws BundleException;
  
  /**
   * Installs a bundle to this framework.
   * @param suggestion The information required to install the bundle
   * @param app The application with which this install is associated
   * @return the bundle that was installed
   * @throws BundleException
   */
  public Bundle install(BundleSuggestion suggestion, AriesApplication app) throws BundleException;
  
  /**
   * Removes a bundle from this framework
   * @param b The bundle to remove
   * @throws BundleException
   */
  public void uninstall(Bundle b) throws BundleException;
  
  /**
   * Start a previously installed bundle in this framework. 
   * @param b the bundle to start
   * @throws BundleException
   */
  public void start(Bundle b) throws BundleException;

  /**
   * Stop a previously installed bundle in this framework. 
   * @param b the bundle to stop
   * @throws BundleException
   */
  public void stop(Bundle b) throws BundleException;

  /**
   * Returns the bundle context for the framework.
   * @return a bundle context representing the framework
   */
  public BundleContext getIsolatedBundleContext();

  /**
   * Returns the OSGi bundle representing the framework
   * @return a bundle representing the framework
   */
  public Bundle getFrameworkBundle();
  
  /**
   * Returns a list of bundles currently installed in this framework
   * @return the bundles in the framework.
   */
  public List<Bundle> getBundles();
  
}
