/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.application.converters;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.aries.application.filesystem.IDirectory;
import org.apache.aries.application.filesystem.IFile;
import org.apache.aries.application.management.BundleInfo;
import org.apache.aries.application.management.spi.convert.BundleConversion;
import org.apache.aries.application.management.spi.convert.BundleConverter;
import org.apache.aries.application.utils.management.SimpleBundleInfo;
import org.apache.aries.application.utils.manifest.BundleManifest;
import org.apache.aries.web.converter.WabConversion;
import org.apache.aries.web.converter.WarToWabConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WabConverterService
implements BundleConverter {
    private static final String WAR_FILE_EXTENSION = ".war";
    private static final Logger LOGGER = LoggerFactory.getLogger(WabConverterService.class);
    private WarToWabConverter wabConverter;

    public WarToWabConverter getWabConverter() {
        return this.wabConverter;
    }

    public void setWabConverter(WarToWabConverter wabConverter) {
        this.wabConverter = wabConverter;
    }

    public BundleConversion convert(IDirectory parentEba, final IFile toBeConverted) {
        if (toBeConverted.getName().endsWith(WAR_FILE_EXTENSION)) {
            try {
                final WabConversion conversion = this.wabConverter.convert(new WarToWabConverter.InputStreamProvider(){

                    public InputStream getInputStream() throws IOException {
                        return toBeConverted.open();
                    }
                }, toBeConverted.getName(), new Properties());
                return new BundleConversion(){

                    public BundleInfo getBundleInfo() throws IOException {
                        return new SimpleBundleInfo(BundleManifest.fromBundle((InputStream)conversion.getWAB()), toBeConverted.toString());
                    }

                    public InputStream getInputStream() throws IOException {
                        return conversion.getWAB();
                    }
                };
            }
            catch (IOException e) {
                LOGGER.error("Encountered an exception while converting " + toBeConverted.getName() + " in " + parentEba.getName(), (Throwable)e);
            }
        }
        return null;
    }
}

