/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.application.management.impl;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.Set;
import org.apache.aries.application.ApplicationMetadata;
import org.apache.aries.application.DeploymentMetadata;
import org.apache.aries.application.management.AriesApplication;
import org.apache.aries.application.management.BundleInfo;
import org.apache.aries.application.management.spi.convert.BundleConversion;
import org.apache.aries.application.management.spi.runtime.LocalPlatform;
import org.apache.aries.util.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AriesApplicationImpl
implements AriesApplication {
    private static final Logger _logger = LoggerFactory.getLogger((String)"org.apache.aries.application.management");
    private Set<BundleInfo> _bundleInfo;
    private ApplicationMetadata _applicationMetadata;
    private DeploymentMetadata _deploymentMetadata;
    private LocalPlatform _localPlatform;
    private Map<String, BundleConversion> _modifiedBundles = null;

    public AriesApplicationImpl(ApplicationMetadata meta, Set<BundleInfo> bundleInfo, LocalPlatform lp) {
        this._applicationMetadata = meta;
        this._bundleInfo = bundleInfo;
        this._deploymentMetadata = null;
        this._localPlatform = lp;
    }

    public AriesApplicationImpl(ApplicationMetadata meta, DeploymentMetadata dep, Set<BundleInfo> bundleInfo, LocalPlatform lp) {
        this._applicationMetadata = meta;
        this._bundleInfo = bundleInfo;
        this._deploymentMetadata = dep;
        this._localPlatform = lp;
    }

    public ApplicationMetadata getApplicationMetadata() {
        return this._applicationMetadata;
    }

    public Set<BundleInfo> getBundleInfo() {
        return this._bundleInfo;
    }

    public DeploymentMetadata getDeploymentMetadata() {
        return this._deploymentMetadata;
    }

    public void setDeploymentMetadata(DeploymentMetadata dm) {
        this._deploymentMetadata = dm;
    }

    public Map<String, BundleConversion> getModifiedBundles() {
        return this._modifiedBundles;
    }

    public void setModifiedBundles(Map<String, BundleConversion> modifiedBundles) {
        this._modifiedBundles = modifiedBundles;
    }

    public void setLocalPlatform(LocalPlatform lp) {
        this._localPlatform = lp;
    }

    public boolean isResolved() {
        return this.getDeploymentMetadata() != null;
    }

    public void store(File f) throws FileNotFoundException, IOException {
        if (f.isDirectory()) {
            this.storeInDirectory(f);
        } else {
            FileOutputStream os = new FileOutputStream(f);
            this.store(os);
            ((OutputStream)os).close();
        }
    }

    public void store(OutputStream targetStream) throws FileNotFoundException, IOException {
        File tempDir = this._localPlatform.getTemporaryDirectory();
        this.storeInDirectory(tempDir);
        IOUtils.zipUp((File)tempDir, (OutputStream)targetStream);
        if (!IOUtils.deleteRecursive((File)tempDir)) {
            _logger.warn("APPMANAGEMENT0001E", (Object)tempDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeInDirectory(File dir) throws IOException, MalformedURLException {
        OutputStream out = null;
        Closeable in = null;
        try {
            out = IOUtils.getOutputStream((File)dir, (String)"META-INF/APPLICATION.MF");
            this._applicationMetadata.store(out);
        }
        finally {
            IOUtils.close((Closeable)out);
        }
        if (this._deploymentMetadata != null) {
            try {
                out = IOUtils.getOutputStream((File)dir, (String)"META-INF/DEPLOYMENT.MF");
                this._deploymentMetadata.store(out);
            }
            finally {
                IOUtils.close((Closeable)out);
            }
        }
        for (BundleInfo bundleInfo : this._bundleInfo) {
            String bundleLocation = bundleInfo.getLocation();
            String bundleFileName = bundleLocation.substring(bundleLocation.lastIndexOf(47) + 1);
            try {
                out = IOUtils.getOutputStream((File)dir, (String)bundleFileName);
                URL bundleURL = new URL(bundleLocation);
                InputStream is = bundleURL.openStream();
                IOUtils.copy((InputStream)is, (OutputStream)out);
            }
            finally {
                IOUtils.close((Closeable)out);
                IOUtils.close(in);
            }
        }
        if (this._modifiedBundles != null) {
            for (Map.Entry entry : this._modifiedBundles.entrySet()) {
                try {
                    out = IOUtils.getOutputStream((File)dir, (String)((String)entry.getKey()));
                    IOUtils.copy((InputStream)((BundleConversion)entry.getValue()).getInputStream(), (OutputStream)out);
                }
                finally {
                    IOUtils.close((Closeable)out);
                }
            }
        }
    }
}

