/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.application.management.repository;

import java.util.Set;
import org.apache.aries.application.Content;
import org.apache.aries.application.DeploymentContent;
import org.apache.aries.application.management.AriesApplication;
import org.apache.aries.application.management.BundleInfo;
import org.apache.aries.application.management.spi.framework.BundleFramework;
import org.apache.aries.application.management.spi.repository.BundleRepository;
import org.apache.aries.application.management.spi.resolve.AriesApplicationResolver;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;

public class ApplicationRepository
implements BundleRepository {
    private static final int REPOSITORY_COST = 0;
    private AriesApplication app;
    AriesApplicationResolver resolver;

    public ApplicationRepository(AriesApplication app) {
        this.app = app;
    }

    public int getCost() {
        return 0;
    }

    public BundleRepository.BundleSuggestion suggestBundleToUse(DeploymentContent content) {
        BundleInfo bundleInfo = null;
        if (this.app.getBundleInfo() != null && !this.app.getBundleInfo().isEmpty()) {
            for (BundleInfo bi : this.app.getBundleInfo()) {
                if (!bi.getSymbolicName().equals(content.getContentName()) || !bi.getVersion().equals((Object)content.getVersion().getExactVersion())) continue;
                bundleInfo = bi;
                break;
            }
        }
        if (bundleInfo != null) {
            return new BundleSuggestionImpl(bundleInfo);
        }
        return null;
    }

    private class BundleSuggestionImpl
    implements BundleRepository.BundleSuggestion {
        private final BundleInfo bundleInfo;

        BundleSuggestionImpl(BundleInfo bundleInfo) {
            this.bundleInfo = bundleInfo;
        }

        public int getCost() {
            return 0;
        }

        public Set<Content> getExportPackage() {
            if (this.bundleInfo != null) {
                return this.bundleInfo.getExportPackage();
            }
            return null;
        }

        public Set<Content> getImportPackage() {
            if (this.bundleInfo != null) {
                return this.bundleInfo.getImportPackage();
            }
            return null;
        }

        public Version getVersion() {
            if (this.bundleInfo != null) {
                return this.bundleInfo.getVersion();
            }
            return null;
        }

        public Bundle install(BundleFramework framework, AriesApplication app) throws BundleException {
            if (this.bundleInfo != null) {
                return framework.getIsolatedBundleContext().installBundle(this.bundleInfo.getLocation());
            }
            throw new BundleException("Unable to install the bundle, as the BundleInfo is null.");
        }
    }
}

