/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.application.modelling.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.Attributes;
import org.apache.aries.application.InvalidAttributeException;
import org.apache.aries.application.modelling.ImportedBundle;
import org.apache.aries.application.modelling.impl.AbstractExportedBundle;
import org.apache.aries.application.modelling.internal.MessageUtil;
import org.apache.aries.application.modelling.utils.impl.ModellingHelperImpl;
import org.apache.aries.util.manifest.ManifestHeaderProcessor;
import org.osgi.framework.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportedBundleImpl
extends AbstractExportedBundle {
    private static final Logger logger = LoggerFactory.getLogger(ExportedBundleImpl.class);
    private final Map<String, Object> _attributes;
    private final ImportedBundle _fragHost;

    public ExportedBundleImpl(Attributes attrs) throws InvalidAttributeException {
        String fragmentHost;
        logger.debug("Method entry: {}, args {}", (Object)"ExportedBundleImpl", (Object)attrs);
        String symbolicName = attrs.getValue("Bundle-SymbolicName");
        Map map = ManifestHeaderProcessor.parseImportString((String)symbolicName);
        if (map.size() != 1) {
            InvalidAttributeException iax = new InvalidAttributeException(MessageUtil.getMessage("TOO_MANY_SYM_NAMES", symbolicName));
            logger.debug("Method exit: {}, returning {}", (Object)"ExportedBundleImpl", (Object)iax);
            throw iax;
        }
        Map.Entry entry = map.entrySet().iterator().next();
        symbolicName = (String)entry.getKey();
        Map bundleAttrs = (Map)entry.getValue();
        String displayName = attrs.getValue("Bundle-Name");
        String version = attrs.getValue("Bundle-Version");
        if (version == null) {
            version = Version.emptyVersion.toString();
        }
        String bmVersion = attrs.getValue("Bundle-ManifestVersion");
        if (symbolicName == null || bmVersion == null) {
            InvalidAttributeException iax = new InvalidAttributeException(MessageUtil.getMessage("INCORRECT_MANDATORY_HEADERS", symbolicName, bmVersion));
            logger.debug("Method exit: {}, returning {}", (Object)"ExportedBundleImpl", (Object)iax);
            throw iax;
        }
        this._attributes = bundleAttrs != null ? new HashMap<String, Object>((Map)entry.getValue()) : new HashMap<String, Object>();
        this._attributes.put("Bundle-ManifestVersion", bmVersion);
        this._attributes.put("symbolicname", symbolicName);
        this._attributes.put("version", version);
        if (displayName != null) {
            this._attributes.put("presentationname", displayName);
        }
        if ((fragmentHost = attrs.getValue("Fragment-Host")) != null) {
            this._fragHost = ModellingHelperImpl.buildFragmentHost_(fragmentHost);
            this._attributes.put("Fragment-Host", fragmentHost);
        } else {
            this._fragHost = null;
        }
        logger.debug("Method exit: {}, returning {}", (Object)"ExportedBundleImpl");
    }

    public ExportedBundleImpl(Map<String, String> attributes, ImportedBundle fragHost) {
        logger.debug("Method entry: {}, args {}", (Object)"ExportedBundleImpl", (Object)new Object[]{attributes, fragHost});
        this._attributes = new HashMap<String, String>(attributes);
        this._fragHost = fragHost;
        logger.debug("Method exit: {}, returning {}", (Object)"ExportedBundleImpl", (Object)new Object[]{attributes, fragHost});
    }

    @Override
    public Map<String, Object> getAttributes() {
        logger.debug("Method entry: {}, args {}", (Object)"getAttributes");
        logger.debug("Method exit: {}, returning {}", (Object)"getAttributes", (Object)new Object[]{this._attributes});
        return Collections.unmodifiableMap(this._attributes);
    }

    public String toString() {
        return this._attributes.toString();
    }

    @Override
    public ImportedBundle getFragmentHost() {
        logger.debug("Method entry: {}, args {}", (Object)"getFragmentHost");
        logger.debug("Method exit: {}, returning {}", (Object)"getFragmentHost", (Object)new Object[]{this._fragHost});
        return this._fragHost;
    }

    @Override
    public boolean isFragment() {
        logger.debug("Method entry: {}, args {}", (Object)"isFragment");
        boolean result = this._fragHost != null;
        logger.debug("Method exit: {}, returning {}", (Object)"isFragment", (Object)new Object[]{result});
        return result;
    }
}

