/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.application.modelling.impl;

import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.aries.application.InvalidAttributeException;
import org.apache.aries.application.modelling.ImportedService;
import org.apache.aries.application.modelling.Provider;
import org.apache.aries.application.modelling.ResourceType;
import org.apache.aries.application.modelling.WrappedReferenceMetadata;
import org.apache.aries.application.modelling.utils.impl.ModellingHelperImpl;
import org.apache.aries.application.utils.FilterUtils;
import org.apache.aries.util.manifest.ManifestHeaderProcessor;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportedServiceImpl
implements ImportedService {
    private static final String DEPRECATED_FILTER_ATTRIBUTE = "filter";
    private final boolean _optional;
    private final String _iface;
    private final String _componentName;
    private final String _blueprintFilter;
    private final Filter _attributeFilter;
    private final boolean _isMultiple;
    private final String _id;
    private final Map<String, String> _attributes;
    private String _toString;
    private String _attribFilterString;
    private static final Pattern SERVICE_EQUALS_SERVICE = Pattern.compile("\\(" + ResourceType.SERVICE.toString() + "=" + ResourceType.SERVICE.toString() + "\\)");
    private final Logger logger = LoggerFactory.getLogger(ImportedServiceImpl.class);

    public ImportedServiceImpl(boolean optional, String iface, String componentName, String blueprintFilter, String id, boolean isMultiple) throws InvalidAttributeException {
        this._optional = optional;
        this._iface = iface;
        this._componentName = componentName;
        this._blueprintFilter = FilterUtils.removeMandatoryFilterToken((String)blueprintFilter);
        this._id = id;
        this._isMultiple = isMultiple;
        this._attributes = new HashMap<String, String>();
        this._attributeFilter = this.generateAttributeFilter(this._attributes);
    }

    private Filter generateAttributeFilter(Map<String, String> attrsToPopulate) throws InvalidAttributeException {
        this.logger.debug("Method entry: {}, args {}", (Object)"generateAttributeFilter", (Object)new Object[]{attrsToPopulate});
        Filter result = null;
        try {
            attrsToPopulate.put("service", "service");
            if (this._blueprintFilter != null) {
                String reducedBlueprintFilter = this._blueprintFilter.startsWith("(&") ? this._blueprintFilter.substring(2, this._blueprintFilter.length() - 1) : this._blueprintFilter;
                attrsToPopulate.put("org.apache.aries.application.filter.attribute", reducedBlueprintFilter);
            }
            if (this._componentName != null) {
                attrsToPopulate.put("osgi.service.blueprint.compname", this._componentName);
            }
            if (this._iface != null) {
                attrsToPopulate.put("objectClass", this._iface);
            }
            this._attribFilterString = ManifestHeaderProcessor.generateFilter(this._attributes);
            if (!"".equals(this._attribFilterString)) {
                result = FrameworkUtil.createFilter((String)FilterUtils.removeMandatoryFilterToken((String)this._attribFilterString));
            }
        }
        catch (InvalidSyntaxException isx) {
            InvalidAttributeException iax = new InvalidAttributeException("A syntax error occurred attempting to parse the blueprint filter string '" + this._blueprintFilter + "' for element with id " + this._id + ": " + isx.getLocalizedMessage(), (Throwable)isx);
            this.logger.debug("Method exit: {}, returning {}", (Object)"generateAttributeFilter", (Object)new Object[]{isx});
            throw iax;
        }
        this.logger.debug("Method exit: {}, returning {}", (Object)"generateAttributeFilter", (Object)new Object[]{result});
        return result;
    }

    @Deprecated
    public ImportedServiceImpl(String ifaceName, Map<String, String> attributes) throws InvalidAttributeException {
        this._optional = "optional".equals(attributes.get("availability:"));
        this._iface = ifaceName;
        this._isMultiple = false;
        this._componentName = null;
        this._id = null;
        this._attributes = new HashMap<String, String>(attributes);
        this._blueprintFilter = this._attributes.remove(DEPRECATED_FILTER_ATTRIBUTE);
        this._attributeFilter = this.generateAttributeFilter(this._attributes);
    }

    public String getFilter() {
        this.logger.debug("Method entry: {}, args {}", (Object)"getFilter");
        this.logger.debug("Method exit: {}, returning {}", (Object)"getFilter", (Object)this._blueprintFilter);
        return this._blueprintFilter;
    }

    public ResourceType getType() {
        this.logger.debug("Method entry: {}, args {}", (Object)"getType");
        this.logger.debug("Method exit: {}, returning {}", (Object)"getType", (Object)ResourceType.SERVICE);
        return ResourceType.SERVICE;
    }

    public boolean isMultiple() {
        this.logger.debug("Method entry: {}, args {}", (Object)"isMultiple");
        this.logger.debug("Method exit: {}, returning {}", (Object)"isMultiple", (Object)this._isMultiple);
        return this._isMultiple;
    }

    public boolean isOptional() {
        this.logger.debug("Method entry: {}, args {}", (Object)"isOptional");
        this.logger.debug("Method exit: {}, returning {}", (Object)"isOptional", (Object)this._optional);
        return this._optional;
    }

    public boolean isSatisfied(Provider capability) {
        this.logger.debug("Method entry: {}, args {}", (Object)"isSatisfied", (Object)capability);
        if (capability.getType() != ResourceType.SERVICE) {
            this.logger.debug("Method exit: {}, returning {}", (Object)"isSatisfied", (Object)false);
            return false;
        }
        Hashtable<String, String[]> dict = new Hashtable<String, String[]>(capability.getAttributes());
        String objectClass = (String)((Dictionary)dict).get("objectClass");
        if (objectClass != null) {
            String[] split = objectClass.split(",");
            ((Dictionary)dict).put("objectClass", split);
        }
        if (this._attributeFilter == null) {
            this.logger.debug("Method exit: {}, returning {}", (Object)"isSatisfied", (Object)true);
            return true;
        }
        boolean allPresent = ModellingHelperImpl.areMandatoryAttributesPresent_(this._attributes, capability);
        boolean result = allPresent && this._attributeFilter.match(dict);
        this.logger.debug("Method exit: {}, returning {}", (Object)"isSatisfied", (Object)result);
        return result;
    }

    public String getComponentName() {
        this.logger.debug("Method entry: {}, args {}", (Object)"getComponentName");
        this.logger.debug("Method exit: {}, returning {}", (Object)"getComponentName", (Object)this._componentName);
        return this._componentName;
    }

    public String getId() {
        this.logger.debug("Method entry: {}, args {}", (Object)"getId");
        this.logger.debug("Method exit: {}, returning {}", (Object)"getId", (Object)this._id);
        return this._id;
    }

    public String getInterface() {
        this.logger.debug("Method entry: {}, args {}", (Object)"getInterface");
        this.logger.debug("Method exit: {}, returning {}", (Object)"getInterface", (Object)this._iface);
        return this._iface;
    }

    public boolean isList() {
        this.logger.debug("Method entry: {}, args {}", (Object)"isList");
        boolean result = this.isMultiple();
        this.logger.debug("Method exit: {}, returning {}", (Object)"isList", (Object)result);
        return result;
    }

    public String getAttributeFilter() {
        this.logger.debug("Method entry: {}, args {}", (Object)"getAttributeFilter");
        this.logger.debug("Method exit: {}, returning {}", (Object)"getAttributeFilter", (Object)this._attribFilterString);
        return this._attribFilterString;
    }

    public boolean equals(Object o) {
        boolean equal = false;
        equal = o == null ? false : (o == this ? true : (!(o instanceof WrappedReferenceMetadata) ? false : this.toString().equals(o.toString())));
        return equal;
    }

    public int hashCode() {
        int result = this.toString().hashCode();
        return result;
    }

    public String toString() {
        this.logger.debug("Method entry: {}, args {}", (Object)"toString");
        if (this._toString != null) {
            this.logger.debug("Method exit: {}, returning {}", (Object)"toString", (Object)this._toString);
            return this._toString;
        }
        StringBuffer buf = new StringBuffer("<reference>");
        buf.append("<componentName>" + this._componentName + "</componentName>");
        buf.append("<id>" + this._id + "</id>");
        buf.append("<interface>" + this._iface + "</interface>");
        buf.append("<isList>" + this._isMultiple + "</isList>");
        buf.append("<isOptional>" + this._optional + "</isOptional>");
        buf.append("<filter>" + this._blueprintFilter + "</filter>");
        this._toString = buf.toString();
        this.logger.debug("Method exit: {}, returning {}", (Object)"toString", (Object)this._toString);
        return this._toString;
    }

    public String toDeploymentString() {
        this.logger.debug("Method entry: {}, args {}", (Object)"toDeploymentString");
        String baseFilter = this.getAttributeFilter();
        String reducedFilter = SERVICE_EQUALS_SERVICE.matcher(baseFilter).replaceAll("");
        String result = FilterUtils.removeMandatoryFilterToken((String)reducedFilter);
        this.logger.debug("Method exit: {}, returning {}", (Object)"toDeploymentString", (Object)result);
        return result;
    }
}

