/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.application.resolve.transform.cm;

import java.util.Collection;
import java.util.Map;
import org.apache.aries.application.ApplicationMetadata;
import org.apache.aries.application.management.ResolverException;
import org.apache.aries.application.management.spi.resolve.PostResolveTransformer;
import org.apache.aries.application.modelling.DeployedBundles;
import org.apache.aries.application.modelling.ImportedPackage;
import org.apache.aries.application.modelling.ModelledResource;

public class ConfigurationPostResolveTransformerImpl
implements PostResolveTransformer {
    public DeployedBundles postResolveProcess(ApplicationMetadata appMetaData, DeployedBundles deployedBundles) throws ResolverException {
        return new ConfigAwareDeployedBundles(deployedBundles);
    }

    private static class ConfigAwareDeployedBundles
    implements DeployedBundles {
        private static final String CONFIG_PACKAGE = "org.osgi.service.cm";
        private DeployedBundles deployedBundles;

        public ConfigAwareDeployedBundles(DeployedBundles deployedBundles) {
            this.deployedBundles = deployedBundles;
        }

        public void addBundle(ModelledResource resource) {
            this.deployedBundles.addBundle(resource);
        }

        public String getContent() {
            return this.deployedBundles.getContent();
        }

        public Collection<ModelledResource> getDeployedContent() {
            return this.deployedBundles.getDeployedContent();
        }

        public String getDeployedImportService() {
            return this.deployedBundles.getDeployedImportService();
        }

        public Collection<ModelledResource> getDeployedProvisionBundle() {
            return this.deployedBundles.getDeployedProvisionBundle();
        }

        public Map<String, String> getExtraHeaders() {
            return this.deployedBundles.getExtraHeaders();
        }

        public String getImportPackage() throws ResolverException {
            Collection deployedContent;
            String currentImportPackage = this.deployedBundles.getImportPackage();
            StringBuffer rawImportPackage = new StringBuffer(currentImportPackage != null ? currentImportPackage : "");
            if (!rawImportPackage.toString().contains(CONFIG_PACKAGE) && (deployedContent = this.deployedBundles.getDeployedContent()) != null) {
                block0: for (ModelledResource mr : deployedContent) {
                    Collection importedPackages = mr.getImportedPackages();
                    if (importedPackages == null) continue;
                    for (ImportedPackage importedPackage : importedPackages) {
                        if (!CONFIG_PACKAGE.equals(importedPackage.getPackageName())) continue;
                        if (rawImportPackage.length() > 0) {
                            rawImportPackage.append(",");
                        }
                        rawImportPackage.append(importedPackage.toDeploymentString());
                        break block0;
                    }
                }
            }
            return rawImportPackage.length() > 0 ? rawImportPackage.toString() : currentImportPackage;
        }

        public String getProvisionBundle() {
            return this.deployedBundles.getProvisionBundle();
        }

        public Collection<ModelledResource> getRequiredUseBundle() throws ResolverException {
            return this.deployedBundles.getRequiredUseBundle();
        }

        public String getUseBundle() {
            return this.deployedBundles.getUseBundle();
        }
    }
}

