/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.application.runtime.framework;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.aries.application.management.AriesApplication;
import org.apache.aries.application.management.spi.framework.BundleFramework;
import org.apache.aries.application.management.spi.repository.BundleRepository;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.launch.Framework;
import org.osgi.service.framework.CompositeBundle;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.service.startlevel.StartLevel;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BundleFrameworkImpl
implements BundleFramework {
    private static final Logger LOGGER = LoggerFactory.getLogger(BundleFrameworkImpl.class);
    List<Bundle> _bundles;
    CompositeBundle _compositeBundle;
    Framework _framework;
    ServiceTracker _packageAdminTracker;
    private final AtomicBoolean startLevelIncreased = new AtomicBoolean(false);

    BundleFrameworkImpl(CompositeBundle cb) {
        this._compositeBundle = cb;
        this._framework = cb.getCompositeFramework();
        this._bundles = new ArrayList<Bundle>();
    }

    public void start() throws BundleException {
        this._compositeBundle.getCompositeFramework().init();
        this._compositeBundle.start(2);
        if (this._packageAdminTracker == null) {
            this._packageAdminTracker = new ServiceTracker(this._compositeBundle.getCompositeFramework().getBundleContext(), PackageAdmin.class.getName(), null);
            this._packageAdminTracker.open();
        }
        if (this.startLevelIncreased.compareAndSet(false, true)) {
            this.increaseStartLevel(this._compositeBundle.getCompositeFramework().getBundleContext());
        }
    }

    public void init() throws BundleException {
        if (this._compositeBundle.getCompositeFramework().getState() != 32) {
            this._compositeBundle.getCompositeFramework().start();
            this._packageAdminTracker = new ServiceTracker(this._compositeBundle.getCompositeFramework().getBundleContext(), PackageAdmin.class.getName(), null);
            this._packageAdminTracker.open();
            this.setupStartLevelToPreventAutostart(this._compositeBundle.getCompositeFramework().getBundleContext());
        }
    }

    private void setupStartLevelToPreventAutostart(BundleContext frameworkBundleContext) {
        StartLevel sl;
        ServiceReference ref = frameworkBundleContext.getServiceReference(StartLevel.class.getName());
        if (ref != null && (sl = (StartLevel)frameworkBundleContext.getService(ref)) != null) {
            sl.setInitialBundleStartLevel(sl.getStartLevel() + 1);
            frameworkBundleContext.ungetService(ref);
        }
    }

    private void increaseStartLevel(BundleContext context) {
        ServiceReference ref = context.getServiceReference(StartLevel.class.getName());
        if (ref != null) {
            StartLevel sl = (StartLevel)context.getService(ref);
            if (sl != null) {
                final Semaphore waitForStartLevelChangedEventToOccur = new Semaphore(0);
                FrameworkListener listener = new FrameworkListener(){

                    public void frameworkEvent(FrameworkEvent event) {
                        if (event.getType() == 8) {
                            waitForStartLevelChangedEventToOccur.release();
                        }
                    }
                };
                context.addFrameworkListener(listener);
                sl.setStartLevel(sl.getStartLevel() + 1);
                try {
                    if (!waitForStartLevelChangedEventToOccur.tryAcquire(60L, TimeUnit.SECONDS)) {
                        LOGGER.debug("Starting CBA child bundles took longer than 60 seconds");
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                context.removeFrameworkListener(listener);
            }
            context.ungetService(ref);
        }
    }

    public void close() throws BundleException {
        if (this._packageAdminTracker != null) {
            try {
                this._packageAdminTracker.close();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        this._compositeBundle.uninstall();
    }

    public void start(Bundle b) throws BundleException {
        if (b.getState() != 32 && !this.isFragment(b)) {
            b.start(2);
        }
    }

    public void stop(Bundle b) throws BundleException {
        if (!this.isFragment(b)) {
            b.stop();
        }
    }

    public Bundle getFrameworkBundle() {
        return this._compositeBundle;
    }

    public BundleContext getIsolatedBundleContext() {
        return this._compositeBundle.getCompositeFramework().getBundleContext();
    }

    public List<Bundle> getBundles() {
        ArrayList<Bundle> latestBundles = new ArrayList<Bundle>();
        for (Bundle appBundle : this._framework.getBundleContext().getBundles()) {
            for (Bundle cachedBundle : this._bundles) {
                if (!cachedBundle.getSymbolicName().equals(appBundle.getSymbolicName()) || !cachedBundle.getVersion().equals((Object)appBundle.getVersion())) continue;
                if (!cachedBundle.equals(appBundle)) {
                    latestBundles.add(appBundle);
                    continue;
                }
                latestBundles.add(cachedBundle);
            }
        }
        this._bundles = latestBundles;
        return this._bundles;
    }

    private boolean isFragment(Bundle b) {
        LOGGER.debug("Method entry: {}, args {}", (Object)"isFragment", (Object)new Object[]{b});
        PackageAdmin admin = null;
        boolean isFragment = false;
        try {
            if (this._packageAdminTracker != null && (admin = (PackageAdmin)this._packageAdminTracker.getService()) != null) {
                isFragment = admin.getBundleType(b) == 1;
            }
        }
        catch (RuntimeException re) {
            LOGGER.debug("Caught exception", (Throwable)re);
        }
        LOGGER.debug("Method exit: {}, returning {}", (Object)"isFragment", (Object)new Object[]{isFragment});
        return isFragment;
    }

    public Bundle install(BundleRepository.BundleSuggestion suggestion, AriesApplication app) throws BundleException {
        Bundle installedBundle = suggestion.install((BundleFramework)this, app);
        this._bundles.add(installedBundle);
        return installedBundle;
    }

    public void uninstall(Bundle b) throws BundleException {
        b.uninstall();
        this._bundles.remove(b);
    }
}

