/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.application.runtime.framework.config;

import java.util.Collection;
import java.util.Properties;
import org.apache.aries.application.Content;
import org.apache.aries.application.DeploymentMetadata;
import org.apache.aries.application.management.AriesApplication;
import org.apache.aries.application.management.spi.framework.BundleFrameworkConfiguration;
import org.apache.aries.application.management.spi.framework.BundleFrameworkConfigurationFactory;
import org.apache.aries.application.runtime.framework.config.BundleFrameworkConfigurationImpl;
import org.apache.aries.application.runtime.framework.utils.EquinoxFrameworkUtils;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;

public class BundleFrameworkConfigurationFactoryImpl
implements BundleFrameworkConfigurationFactory {
    public BundleFrameworkConfiguration createBundleFrameworkConfig(String frameworkId, BundleContext parentCtx, AriesApplication app) {
        BundleFrameworkConfigurationImpl config = null;
        DeploymentMetadata metadata = app.getDeploymentMetadata();
        Properties frameworkConfig = new Properties();
        frameworkConfig.put("osgi.console", "none");
        String flowedSystemPackages = EquinoxFrameworkUtils.calculateSystemPackagesToFlow(EquinoxFrameworkUtils.getSystemExtraPkgs(parentCtx), metadata.getImportPackage());
        frameworkConfig.put("org.osgi.framework.system.packages.extra", flowedSystemPackages);
        Properties frameworkBundleManifest = new Properties();
        frameworkBundleManifest.put("Bundle-SymbolicName", metadata.getApplicationSymbolicName());
        frameworkBundleManifest.put("Bundle-Version", metadata.getApplicationVersion().toString());
        Collection<Content> imports = EquinoxFrameworkUtils.calculateImports(metadata.getImportPackage(), EquinoxFrameworkUtils.getExportPackages(parentCtx));
        if (imports != null && !imports.isEmpty()) {
            StringBuffer buffer = new StringBuffer();
            for (Content i : imports) {
                buffer.append(EquinoxFrameworkUtils.contentToString(i) + ",");
            }
            frameworkBundleManifest.put("Import-Package", buffer.substring(0, buffer.length() - 1));
        }
        StringBuilder serviceImportFilter = new StringBuilder();
        String txRegsitryImport = "(objectClass=javax.transaction.TransactionSynchronizationRegistry)";
        Collection deployedServiceImports = metadata.getDeployedServiceImport();
        if (deployedServiceImports.size() > 0) {
            serviceImportFilter.append("(|");
        }
        for (Filter importFilter : metadata.getDeployedServiceImport()) {
            serviceImportFilter.append(importFilter.toString());
        }
        serviceImportFilter.append(txRegsitryImport);
        if (deployedServiceImports.size() > 0) {
            serviceImportFilter.append(")");
        }
        frameworkBundleManifest.put("CompositeServiceFilter-Import", serviceImportFilter.toString());
        config = new BundleFrameworkConfigurationImpl(frameworkId, frameworkConfig, frameworkBundleManifest);
        return config;
    }

    public BundleFrameworkConfiguration createBundleFrameworkConfig(String frameworkId, BundleContext parentCtx) {
        BundleFrameworkConfigurationImpl config = null;
        Properties frameworkConfig = new Properties();
        frameworkConfig.put("osgi.console", "none");
        if (parentCtx.getProperty("org.osgi.framework.system.packages.extra") != null) {
            frameworkConfig.put("org.osgi.framework.system.packages.extra", parentCtx.getProperty("org.osgi.framework.system.packages.extra"));
        }
        Properties frameworkBundleManifest = new Properties();
        StringBuffer serviceImportFilter = new StringBuffer("(objectClass=javax.transaction.TransactionSynchronizationRegistry)");
        frameworkBundleManifest.put("CompositeServiceFilter-Import", serviceImportFilter.toString());
        config = new BundleFrameworkConfigurationImpl(frameworkId, frameworkConfig, frameworkBundleManifest);
        return config;
    }
}

