/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.application.runtime.framework.utils;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.aries.application.Content;
import org.apache.aries.application.utils.manifest.ContentFactory;
import org.apache.aries.util.VersionRange;
import org.apache.aries.util.manifest.ManifestHeaderProcessor;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Version;

public class EquinoxFrameworkUtils {
    public static Collection<Content> getExportPackages(BundleContext isolatedBundleContext) {
        String exportString;
        HashSet<Content> exports = new HashSet<Content>();
        Bundle sysBundle = isolatedBundleContext.getBundle(0L);
        if (sysBundle != null && sysBundle.getHeaders() != null && (exportString = (String)sysBundle.getHeaders().get("Export-Package")) != null) {
            for (ManifestHeaderProcessor.NameValuePair nvp : ManifestHeaderProcessor.parseExportString((String)exportString)) {
                exports.add(ContentFactory.parseContent((String)nvp.getName(), (Map)nvp.getAttributes()));
            }
        }
        return Collections.unmodifiableSet(exports);
    }

    public static Collection<Content> getSystemExtraPkgs(BundleContext context) {
        HashSet<Content> extraPkgs = new HashSet<Content>();
        String exportString = context.getProperty("org.osgi.framework.system.packages.extra");
        if (exportString != null) {
            for (ManifestHeaderProcessor.NameValuePair nvp : ManifestHeaderProcessor.parseExportString((String)exportString)) {
                extraPkgs.add(ContentFactory.parseContent((String)nvp.getName(), (Map)nvp.getAttributes()));
            }
        }
        return Collections.unmodifiableSet(extraPkgs);
    }

    public static Collection<Content> calculateImports(Collection<Content> importPackage, Collection<Content> exportPackages) {
        HashSet<Content> results = new HashSet<Content>();
        if (importPackage != null && !importPackage.isEmpty()) {
            for (Content exportPkg : exportPackages) {
                for (Content importPkg : importPackage) {
                    if (importPkg.getContentName().equals(exportPkg.getContentName()) && importPkg.getVersion().equals((Object)exportPkg.getVersion())) continue;
                    results.add(importPkg);
                }
            }
        }
        return Collections.unmodifiableSet(results);
    }

    public static String contentToString(Content content) {
        StringBuffer value = new StringBuffer();
        value.append(content.getContentName());
        Map nvm = content.getNameValueMap();
        for (Map.Entry entry : nvm.entrySet()) {
            if (((String)entry.getKey()).equalsIgnoreCase("version") || ((String)entry.getKey()).equalsIgnoreCase("bundle-version")) {
                value.append(";" + (String)entry.getKey() + "=\"" + (String)entry.getValue() + "\"");
                continue;
            }
            value.append(";" + (String)entry.getKey() + "=" + (String)entry.getValue());
        }
        return value.toString();
    }

    public static String calculateSystemPackagesToFlow(Collection<Content> systemExports, Collection<Content> imports) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("javax.transaction", "1.1.0");
        HashMap<String, Map<String, String>> resultMap = new HashMap<String, Map<String, String>>();
        resultMap.put("javax.transaction", map);
        for (Content nvp : imports) {
            String name = nvp.getContentName().trim();
            if (!EquinoxFrameworkUtils.existInExports(name, nvp.getNameValueMap(), systemExports)) continue;
            for (Content nvpp : systemExports) {
                if (!nvpp.getContentName().trim().equals(name)) continue;
                Map frameworkVersion = nvpp.getNameValueMap();
                resultMap.put(name, frameworkVersion);
            }
        }
        StringBuffer result = new StringBuffer();
        for (String key : resultMap.keySet()) {
            result.append(EquinoxFrameworkUtils.getString(key, resultMap) + ",");
        }
        String toReturn = EquinoxFrameworkUtils.trimEndString(result.toString().trim(), ",");
        return toReturn;
    }

    private static boolean existInExports(String key, Map<String, String> nvm, Collection<Content> exports) {
        boolean value = false;
        for (Content nvp : exports) {
            if (!nvp.getContentName().trim().equals(key.trim())) continue;
            String vi = nvm.get("version");
            String ve = (String)nvp.getNameValueMap().get("version");
            if (vi == null || vi.length() == 0) {
                vi = "0.0.0";
            }
            if (ve == null || ve.length() == 0) {
                ve = "0.0.0";
            }
            if (vi.indexOf(",") == -1) {
                if (new Version(vi).compareTo((Object)new Version(ve)) > 0) continue;
                value = true;
                continue;
            }
            VersionRange vri = ManifestHeaderProcessor.parseVersionRange((String)vi);
            Version minV = vri.getMinimumVersion();
            Version maxV = vri.getMaximumVersion();
            if (minV.compareTo((Object)new Version(ve)) < 0 && maxV.compareTo((Object)new Version(ve)) > 0) {
                value = true;
                continue;
            }
            if (minV.compareTo((Object)new Version(ve)) == 0 && !vri.isMinimumExclusive()) {
                value = true;
                continue;
            }
            if (maxV.compareTo((Object)new Version(ve)) != 0 || vri.isMaximumExclusive()) continue;
            value = true;
        }
        return value;
    }

    private static String trimEndString(String s, String trim) {
        if (s.startsWith(trim)) {
            s = s.substring(trim.length());
        }
        if (s.endsWith(trim)) {
            s = s.substring(0, s.length() - trim.length());
        }
        return s;
    }

    private static String getString(String key, Map<String, Map<String, String>> imports) {
        StringBuffer value = new StringBuffer();
        value.append(key);
        Map<String, String> nvm = imports.get(key);
        for (Map.Entry<String, String> entry : nvm.entrySet()) {
            if (entry.getKey().equalsIgnoreCase("version") || entry.getKey().equalsIgnoreCase("bundle-version")) {
                value.append(";" + entry.getKey() + "=\"" + entry.getValue() + "\"");
                continue;
            }
            value.append(";" + entry.getKey() + "=" + entry.getValue());
        }
        return value.toString();
    }
}

