/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.application.runtime.framework.management;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.apache.aries.application.DeploymentContent;
import org.apache.aries.application.DeploymentMetadata;
import org.apache.aries.application.management.AriesApplication;
import org.apache.aries.application.management.UpdateException;
import org.apache.aries.application.management.spi.framework.BundleFramework;
import org.apache.aries.application.management.spi.framework.BundleFrameworkConfiguration;
import org.apache.aries.application.management.spi.framework.BundleFrameworkConfigurationFactory;
import org.apache.aries.application.management.spi.framework.BundleFrameworkFactory;
import org.apache.aries.application.management.spi.framework.BundleFrameworkManager;
import org.apache.aries.application.management.spi.repository.BundleRepository;
import org.apache.aries.application.management.spi.repository.ContextException;
import org.apache.aries.application.management.spi.update.UpdateStrategy;
import org.apache.aries.application.runtime.framework.management.SharedBundleFramework;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BundleFrameworkManagerImpl
implements BundleFrameworkManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(BundleFrameworkManagerImpl.class);
    BundleContext _ctx;
    BundleFramework _sharedBundleFramework;
    BundleFrameworkFactory _bundleFrameworkFactory;
    BundleFrameworkConfigurationFactory _bundleFrameworkConfigurationFactory;
    Map<Bundle, BundleFramework> _frameworks = new HashMap<Bundle, BundleFramework>();
    Map<String, BundleFramework> _frameworksByAppScope = new HashMap<String, BundleFramework>();
    private List<UpdateStrategy> _updateStrategies = Collections.emptyList();

    public void setUpdateStrategies(List<UpdateStrategy> updateStrategies) {
        this._updateStrategies = updateStrategies;
    }

    public void setBundleContext(BundleContext ctx) {
        this._ctx = ctx;
    }

    public void setBundleFrameworkFactory(BundleFrameworkFactory bff) {
        this._bundleFrameworkFactory = bff;
    }

    public void setBundleFrameworkConfigurationFactory(BundleFrameworkConfigurationFactory bfcf) {
        this._bundleFrameworkConfigurationFactory = bfcf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        Object object = BundleFrameworkManager.SHARED_FRAMEWORK_LOCK;
        synchronized (object) {
            try {
                this._sharedBundleFramework = SharedBundleFramework.getSharedBundleFramework(this._ctx, this._bundleFrameworkConfigurationFactory, this._bundleFrameworkFactory);
                this._frameworks.put(this._sharedBundleFramework.getFrameworkBundle(), this._sharedBundleFramework);
            }
            catch (ContextException e) {
                LOGGER.error("Caught exception", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = BundleFrameworkManager.SHARED_FRAMEWORK_LOCK;
        synchronized (object) {
            try {
                this._sharedBundleFramework.close();
            }
            catch (BundleException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BundleFramework getBundleFramework(Bundle frameworkBundle) {
        BundleFramework framework = null;
        Object object = BundleFrameworkManager.SHARED_FRAMEWORK_LOCK;
        synchronized (object) {
            framework = this._frameworks.get(frameworkBundle);
        }
        return framework;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bundle installIsolatedBundles(Collection<BundleRepository.BundleSuggestion> bundlesToInstall, AriesApplication app) throws BundleException {
        Bundle frameworkBundle = null;
        Object object = BundleFrameworkManager.SHARED_FRAMEWORK_LOCK;
        synchronized (object) {
            BundleFramework isolatedFramework = this.isolatedInstall(bundlesToInstall, this._sharedBundleFramework.getIsolatedBundleContext(), app);
            this._frameworks.put(isolatedFramework.getFrameworkBundle(), isolatedFramework);
            this._frameworksByAppScope.put(app.getApplicationMetadata().getApplicationScope(), isolatedFramework);
            frameworkBundle = isolatedFramework.getFrameworkBundle();
        }
        return frameworkBundle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Bundle> installSharedBundles(Collection<BundleRepository.BundleSuggestion> bundlesToInstall, AriesApplication app) throws BundleException {
        ArrayList<Bundle> installedBundles = new ArrayList<Bundle>();
        Object object = BundleFrameworkManager.SHARED_FRAMEWORK_LOCK;
        synchronized (object) {
            for (BundleRepository.BundleSuggestion suggestion : bundlesToInstall) {
                installedBundles.add(this._sharedBundleFramework.install(suggestion, app));
            }
        }
        return installedBundles;
    }

    private BundleFramework isolatedInstall(Collection<BundleRepository.BundleSuggestion> bundlesToBeInstalled, BundleContext parentCtx, AriesApplication app) throws BundleException {
        LOGGER.debug("Method entry: {}, args {}", (Object)"isolatedInstall", (Object)new Object[]{bundlesToBeInstalled, app});
        BundleFrameworkConfiguration config = this._bundleFrameworkConfigurationFactory.createBundleFrameworkConfig(app.getApplicationMetadata().getApplicationScope(), parentCtx, app);
        BundleFramework bundleFramework = this._bundleFrameworkFactory.createBundleFramework(parentCtx, config);
        if (bundleFramework != null) {
            try {
                bundleFramework.init();
                BundleContext frameworkBundleContext = bundleFramework.getIsolatedBundleContext();
                if (frameworkBundleContext != null) {
                    for (BundleRepository.BundleSuggestion suggestion : bundlesToBeInstalled) {
                        bundleFramework.install(suggestion, app);
                    }
                }
            }
            catch (BundleException be) {
                bundleFramework.close();
                throw be;
            }
            catch (RuntimeException re) {
                bundleFramework.close();
                throw re;
            }
        }
        LOGGER.debug("Method exit: {}, returning {}", (Object)"isolatedInstall", (Object)bundleFramework);
        return bundleFramework;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BundleFramework getSharedBundleFramework() {
        Object object = BundleFrameworkManager.SHARED_FRAMEWORK_LOCK;
        synchronized (object) {
            return this._sharedBundleFramework;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uninstallBundle(Bundle b) throws BundleException {
        Object object = BundleFrameworkManager.SHARED_FRAMEWORK_LOCK;
        synchronized (object) {
            BundleFramework framework = this.getBundleFramework(b);
            if (framework != null) {
                block12: {
                    for (Bundle bundle : new ArrayList(framework.getBundles())) {
                        framework.uninstall(bundle);
                    }
                    BundleContext ctx = framework.getIsolatedBundleContext();
                    ServiceReference ref = ctx.getServiceReference(PackageAdmin.class.getName());
                    if (ref != null) {
                        try {
                            PackageAdmin pa = (PackageAdmin)ctx.getService(ref);
                            if (pa == null) break block12;
                            final Semaphore sem = new Semaphore(0);
                            FrameworkListener listener = new FrameworkListener(){

                                public void frameworkEvent(FrameworkEvent event) {
                                    if (event.getType() == 4) {
                                        sem.release();
                                    }
                                }
                            };
                            ctx.addFrameworkListener(listener);
                            pa.refreshPackages(null);
                            try {
                                sem.tryAcquire(60L, TimeUnit.SECONDS);
                            }
                            catch (InterruptedException ie) {
                                // empty catch block
                            }
                            ctx.removeFrameworkListener(listener);
                        }
                        finally {
                            ctx.ungetService(ref);
                        }
                    }
                }
                framework.close();
                this._frameworks.remove(b);
                Iterator<BundleFramework> it = this._frameworksByAppScope.values().iterator();
                while (it.hasNext()) {
                    if (!it.next().equals(framework)) continue;
                    it.remove();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startBundle(Bundle b) throws BundleException {
        Object object = BundleFrameworkManager.SHARED_FRAMEWORK_LOCK;
        synchronized (object) {
            BundleFramework framework = this.getBundleFramework(b);
            if (framework != null) {
                framework.start();
                for (Bundle bundle : framework.getBundles()) {
                    framework.start(bundle);
                }
            } else {
                this._sharedBundleFramework.start(b);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopBundle(Bundle b) throws BundleException {
        Object object = BundleFrameworkManager.SHARED_FRAMEWORK_LOCK;
        synchronized (object) {
            BundleFramework framework = this.getBundleFramework(b);
            if (framework != null) {
                for (Bundle bundle : new ArrayList(framework.getBundles())) {
                    framework.stop(bundle);
                }
            }
        }
    }

    public boolean allowsUpdate(DeploymentMetadata newMetadata, DeploymentMetadata oldMetadata) {
        for (UpdateStrategy strategy : this._updateStrategies) {
            if (!strategy.allowsUpdate(newMetadata, oldMetadata)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBundles(final DeploymentMetadata newMetadata, final DeploymentMetadata oldMetadata, final AriesApplication app, final BundleFrameworkManager.BundleLocator locator, final Set<Bundle> bundles, final boolean startBundles) throws UpdateException {
        UpdateStrategy strategy = null;
        for (UpdateStrategy us : this._updateStrategies) {
            if (!us.allowsUpdate(newMetadata, oldMetadata)) continue;
            strategy = us;
            break;
        }
        if (strategy == null) {
            throw new IllegalArgumentException("No UpdateStrategy supports the supplied DeploymentMetadata changes.");
        }
        Object object = BundleFrameworkManager.SHARED_FRAMEWORK_LOCK;
        synchronized (object) {
            final BundleFramework appFwk = this._frameworksByAppScope.get(app.getApplicationMetadata().getApplicationScope());
            strategy.update(new UpdateStrategy.UpdateInfo(){

                public void register(Bundle bundle) {
                    bundles.add(bundle);
                }

                public void unregister(Bundle bundle) {
                    bundles.remove(bundle);
                }

                public Map<DeploymentContent, BundleRepository.BundleSuggestion> suggestBundle(Collection<DeploymentContent> bundles2) throws BundleException {
                    return locator.suggestBundle(bundles2);
                }

                public boolean startBundles() {
                    return startBundles;
                }

                public BundleFramework getSharedFramework() {
                    return BundleFrameworkManagerImpl.this._sharedBundleFramework;
                }

                public DeploymentMetadata getOldMetadata() {
                    return oldMetadata;
                }

                public DeploymentMetadata getNewMetadata() {
                    return newMetadata;
                }

                public AriesApplication getApplication() {
                    return app;
                }

                public BundleFramework getAppFramework() {
                    return appFwk;
                }
            });
        }
    }
}

