/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.application.runtime.framework.management;

import java.util.Properties;
import org.apache.aries.application.management.spi.framework.BundleFramework;
import org.apache.aries.application.management.spi.framework.BundleFrameworkConfiguration;
import org.apache.aries.application.management.spi.framework.BundleFrameworkConfigurationFactory;
import org.apache.aries.application.management.spi.framework.BundleFrameworkFactory;
import org.apache.aries.application.management.spi.repository.ContextException;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SharedBundleFramework {
    private static final Logger LOGGER = LoggerFactory.getLogger(SharedBundleFramework.class);
    private static BundleFramework sharedFramework;
    private static final String RUNTIME_PACKAGES = "org.osgi.service.blueprint,org.osgi.service.blueprint.container;version=\"[1.0.0,1.0.1]\",org.osgi.service.blueprint.reflect;version=\"[1.0.0,1.0.1]\",org.apache.aries.transaction.exception;version=\"[1.0.0,2.0.0)\",org.osgi.service.cm;resolution:=optional";

    private static void createSharedBundleFramework(BundleContext bc, BundleFrameworkConfigurationFactory bundleFrameworkConfigFactory, BundleFrameworkFactory bundleFrameworkFactory) throws ContextException {
        LOGGER.debug("Method entry: {}, args {}", (Object)"createSharedBundleFramework", (Object)new Object[]{bc, bundleFrameworkFactory});
        try {
            SharedBundleFrameworkConfiguration config = new SharedBundleFrameworkConfiguration(bundleFrameworkConfigFactory.createBundleFrameworkConfig("shared.bundle.framework", bc));
            sharedFramework = bundleFrameworkFactory.createBundleFramework(bc, (BundleFrameworkConfiguration)config);
            sharedFramework.start();
        }
        catch (BundleException e) {
            LOGGER.debug("Method exit: {}, returning {}", (Object)"createSharedBundleFramework", (Object)e);
            throw new ContextException("Unable to create or start the shared framework composite bundle " + sharedFramework, (Exception)((Object)e));
        }
        LOGGER.debug("Method exit: {}, returning {}", (Object)"createSharedBundleFramework");
    }

    public static synchronized BundleFramework getSharedBundleFramework(BundleContext bc, BundleFrameworkConfigurationFactory bfcf, BundleFrameworkFactory bff) throws ContextException {
        LOGGER.debug("Method entry: {}, args {}", (Object)"getSharedBundleFramework", (Object)new Object[]{bc, bff});
        if (sharedFramework == null) {
            SharedBundleFramework.createSharedBundleFramework(bc, bfcf, bff);
        }
        LOGGER.debug("Method exit: {}, returning {}", (Object)"getSharedBundleFramework", (Object)sharedFramework);
        return sharedFramework;
    }

    private static class SharedBundleFrameworkConfiguration
    implements BundleFrameworkConfiguration {
        BundleFrameworkConfiguration basicConfig = null;

        public SharedBundleFrameworkConfiguration(BundleFrameworkConfiguration basicConfig) {
            this.basicConfig = basicConfig;
        }

        public String getFrameworkID() {
            return this.basicConfig.getFrameworkID();
        }

        public Properties getFrameworkManifest() {
            Properties compositeManifest = this.basicConfig.getFrameworkManifest();
            compositeManifest.put("Bundle-SymbolicName", "shared.bundle.framework");
            String existingImports = (String)compositeManifest.get("Import-Package");
            if (existingImports == null) {
                compositeManifest.put("Import-Package", SharedBundleFramework.RUNTIME_PACKAGES);
            }
            return compositeManifest;
        }

        public Properties getFrameworkProperties() {
            return this.basicConfig.getFrameworkProperties();
        }
    }
}

