/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.application.runtime.framework.management;

import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import org.apache.aries.application.Content;
import org.apache.aries.application.InvalidAttributeException;
import org.apache.aries.application.management.BundleInfo;
import org.apache.aries.application.management.spi.framework.BundleFrameworkManager;
import org.apache.aries.application.management.spi.resolve.PreResolveHook;
import org.apache.aries.application.modelling.ModelledResource;
import org.apache.aries.application.modelling.ModellingManager;
import org.apache.aries.application.utils.manifest.ContentFactory;
import org.apache.aries.util.manifest.ManifestHeaderProcessor;
import org.apache.aries.util.manifest.ManifestProcessor;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

public class SharedFrameworkPreResolveHook
implements PreResolveHook {
    private BundleFrameworkManager fwMgr;
    private ModellingManager mgr;

    public void collectFakeResources(Collection<ModelledResource> resources) {
        Bundle b = this.fwMgr.getSharedBundleFramework().getIsolatedBundleContext().getBundle(1L);
        BundleInfoImpl info = new BundleInfoImpl(b);
        Set serviceImports = Collections.emptySet();
        Set serviceExports = Collections.emptySet();
        try {
            resources.add(this.mgr.getModelledResource(info.getLocation(), (BundleInfo)info, serviceImports, serviceExports));
        }
        catch (InvalidAttributeException e) {
            e.printStackTrace();
        }
    }

    public void setBundleFrameworkManager(BundleFrameworkManager bfm) {
        this.fwMgr = bfm;
    }

    public void setModellingManager(ModellingManager manager) {
        this.mgr = manager;
    }

    private static final class BundleInfoImpl
    implements BundleInfo {
        private final Bundle compositeBundle;

        public BundleInfoImpl(Bundle bundle) {
            this.compositeBundle = bundle;
        }

        public String getSymbolicName() {
            return this.compositeBundle.getSymbolicName();
        }

        public Map<String, String> getBundleDirectives() {
            return Collections.emptyMap();
        }

        public Map<String, String> getBundleAttributes() {
            return Collections.emptyMap();
        }

        public Version getVersion() {
            return this.compositeBundle.getVersion();
        }

        public String getLocation() {
            return this.compositeBundle.getLocation();
        }

        public Set<Content> getImportPackage() {
            return Collections.emptySet();
        }

        public Set<Content> getRequireBundle() {
            return Collections.emptySet();
        }

        public Set<Content> getExportPackage() {
            String imports = (String)this.compositeBundle.getHeaders().get("Import-Package");
            HashSet<Content> exports = new HashSet<Content>();
            Map parsedImports = ManifestHeaderProcessor.parseImportString((String)imports);
            for (Map.Entry anImport : parsedImports.entrySet()) {
                exports.add(ContentFactory.parseContent((String)((String)anImport.getKey()), (Map)((Map)anImport.getValue())));
            }
            return exports;
        }

        public Set<Content> getImportService() {
            return Collections.emptySet();
        }

        public Set<Content> getExportService() {
            return Collections.emptySet();
        }

        public Map<String, String> getHeaders() {
            HashMap<String, String> result = new HashMap<String, String>();
            Dictionary headers = this.compositeBundle.getHeaders();
            Enumeration keys = headers.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                String value = (String)headers.get(key);
                result.put(key, value);
            }
            return result;
        }

        public Attributes getRawAttributes() {
            return ManifestProcessor.mapToManifest(this.getHeaders()).getMainAttributes();
        }
    }
}

