/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.application.runtime.isolated.impl;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.aries.application.DeploymentMetadata;
import org.apache.aries.application.management.AriesApplication;
import org.apache.aries.application.management.AriesApplicationContext;
import org.apache.aries.application.management.ManagementException;
import org.apache.aries.application.management.UpdateException;
import org.apache.aries.application.management.spi.framework.BundleFrameworkManager;
import org.apache.aries.application.management.spi.repository.BundleRepositoryManager;
import org.apache.aries.application.management.spi.runtime.AriesApplicationContextManager;
import org.apache.aries.application.runtime.isolated.impl.ApplicationContextImpl;
import org.osgi.framework.BundleException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationContextManagerImpl
implements AriesApplicationContextManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApplicationContextManagerImpl.class);
    private ConcurrentMap<AriesApplication, AriesApplicationContext> _appToContextMap;
    private BundleFrameworkManager _bundleFrameworkManager;
    private BundleRepositoryManager _bundleRepositoryManager;

    public ApplicationContextManagerImpl() {
        LOGGER.debug("Method entry: {}, args {}", (Object)"ApplicationContextImpl");
        this._appToContextMap = new ConcurrentHashMap<AriesApplication, AriesApplicationContext>();
        LOGGER.debug("Method exit: {}, returning {}", (Object)"ApplicationContextImpl", (Object)this);
    }

    public void setBundleFrameworkManager(BundleFrameworkManager bfm) {
        LOGGER.debug("Method entry: {}, args {}", (Object)"setBundleFrameworkManager", (Object)bfm);
        LOGGER.debug("Method exit: {}, returning {}", (Object)"setBundleFrameworkManager");
        this._bundleFrameworkManager = bfm;
    }

    public void setBundleRepositoryManager(BundleRepositoryManager brm) {
        LOGGER.debug("Method entry: {}, args {}", (Object)"setBundleRepositoryManager", (Object)brm);
        LOGGER.debug("Method exit: {}, returning {}", (Object)"setBundleRepositoryManager");
        this._bundleRepositoryManager = brm;
    }

    public BundleRepositoryManager getBundleRepositoryManager() {
        LOGGER.debug("Method entry: {}, args {}", (Object)"getBundleRepositoryManager");
        LOGGER.debug("Method exit: {}, returning {}", (Object)"getBundleRepositoryManager", (Object)this._bundleRepositoryManager);
        return this._bundleRepositoryManager;
    }

    public synchronized AriesApplicationContext getApplicationContext(AriesApplication app) throws BundleException, ManagementException {
        AriesApplicationContext result;
        LOGGER.debug("Method entry: {}, args {}", (Object)"getApplicationContext", (Object)app);
        if (this._appToContextMap.containsKey(app)) {
            result = (AriesApplicationContext)this._appToContextMap.get(app);
        } else {
            result = new ApplicationContextImpl(app, this);
            AriesApplicationContext previous = this._appToContextMap.putIfAbsent(app, result);
            if (previous != null) {
                result = previous;
            }
        }
        LOGGER.debug("Method exit: {}, returning {}", (Object)"getApplicationContext", (Object)result);
        return result;
    }

    public synchronized Set<AriesApplicationContext> getApplicationContexts() {
        LOGGER.debug("Method entry: {}, args {}", (Object)"getApplicationContexts");
        HashSet<AriesApplicationContext> result = new HashSet<AriesApplicationContext>();
        for (Map.Entry entry : this._appToContextMap.entrySet()) {
            result.add((AriesApplicationContext)entry.getValue());
        }
        LOGGER.debug("Method exit: {}, returning {}", (Object)"getApplicationContexts", result);
        return result;
    }

    public synchronized void remove(AriesApplicationContext app) throws BundleException {
        LOGGER.debug("Method entry: {}, args {}", (Object)"remove", (Object)app);
        Iterator it = this._appToContextMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            ApplicationContextImpl potentialMatch = (ApplicationContextImpl)entry.getValue();
            if (potentialMatch != app) continue;
            it.remove();
            potentialMatch.uninstall();
            break;
        }
        LOGGER.debug("Method exit: {}, returning {}", (Object)"remove");
    }

    public synchronized void close() {
        LOGGER.debug("Method entry: {}, args {}", (Object)"close");
        Iterator it = this._appToContextMap.values().iterator();
        while (it.hasNext()) {
            try {
                ApplicationContextImpl ctx = (ApplicationContextImpl)it.next();
                ctx.uninstall();
                it.remove();
            }
            catch (BundleException e) {
                LOGGER.debug("Caught exception", (Throwable)e);
            }
        }
        LOGGER.debug("Method exit: {}, returning {}", (Object)"close");
    }

    protected BundleFrameworkManager getBundleFrameworkManager() {
        LOGGER.debug("Method entry: {}, args {}", (Object)"getBundleFrameworkManager");
        LOGGER.debug("Method exit: {}, returning {}", (Object)"getBundleFrameworkManager", (Object)this._bundleFrameworkManager);
        return this._bundleFrameworkManager;
    }

    public AriesApplicationContext update(AriesApplication app, DeploymentMetadata oldMetadata) throws UpdateException {
        ApplicationContextImpl ctx = (ApplicationContextImpl)this._appToContextMap.get(app);
        if (ctx == null) {
            throw new IllegalArgumentException("AriesApplication " + app.getApplicationMetadata().getApplicationSymbolicName() + "/" + app.getApplicationMetadata().getApplicationVersion() + " cannot be updated because it is not installed");
        }
        ctx.update(app.getDeploymentMetadata(), oldMetadata);
        return ctx;
    }
}

