/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.application.runtime.isolated.impl;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.aries.application.ApplicationMetadata;
import org.apache.aries.application.DeploymentContent;
import org.apache.aries.application.DeploymentMetadata;
import org.apache.aries.application.management.AriesApplication;
import org.apache.aries.application.management.AriesApplicationContext;
import org.apache.aries.application.management.BundleInfo;
import org.apache.aries.application.management.UpdateException;
import org.apache.aries.application.management.spi.framework.BundleFrameworkManager;
import org.apache.aries.application.management.spi.repository.BundleRepository;
import org.apache.aries.application.management.spi.repository.BundleRepositoryManager;
import org.apache.aries.application.management.spi.repository.ContextException;
import org.apache.aries.application.runtime.isolated.impl.ApplicationContextManagerImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationContextImpl
implements AriesApplicationContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApplicationContextImpl.class);
    private final AriesApplication _application;
    private final Set<Bundle> _bundles;
    private AriesApplicationContext.ApplicationState _state = AriesApplicationContext.ApplicationState.UNINSTALLED;
    private boolean _closed;
    private final BundleRepositoryManager _bundleRepositoryManager;
    private final BundleFrameworkManager _bundleFrameworkManager;
    private DeploymentMetadata _deploymentMF;

    public ApplicationContextImpl(AriesApplication app, ApplicationContextManagerImpl acm) throws BundleException {
        LOGGER.debug("Method entry: {}, args {}", (Object)"ApplicationContextImpl", (Object)new Object[]{app, acm});
        this._bundleFrameworkManager = acm.getBundleFrameworkManager();
        this._bundleRepositoryManager = acm.getBundleRepositoryManager();
        this._bundles = new LinkedHashSet<Bundle>();
        this._application = app;
        this._deploymentMF = this._application.getDeploymentMetadata();
        if (this._deploymentMF.getApplicationDeploymentContents() != null && !this._deploymentMF.getApplicationDeploymentContents().isEmpty()) {
            this.install();
        }
        LOGGER.debug("Method exit: {}, returning {}", (Object)"ApplicationContextImpl", (Object)this);
    }

    private void install() throws BundleException {
        LOGGER.debug("Method entry: {}, args {}", (Object)"install");
        ArrayList<DeploymentContent> bundlesToFind = new ArrayList<DeploymentContent>(this._deploymentMF.getApplicationDeploymentContents());
        ArrayList<DeploymentContent> useBundlesToFind = new ArrayList<DeploymentContent>(this._deploymentMF.getDeployedUseBundle());
        ArrayList<DeploymentContent> provisionBundlesToFind = new ArrayList<DeploymentContent>(this._deploymentMF.getApplicationProvisionBundles());
        try {
            this.installBundles(provisionBundlesToFind, true);
            this.installBundles(useBundlesToFind, true);
            this.installBundles(bundlesToFind, false);
            this._state = AriesApplicationContext.ApplicationState.INSTALLED;
            LOGGER.debug("Successfully installed application " + this._application.getApplicationMetadata().getApplicationSymbolicName());
        }
        catch (BundleException e) {
            LOGGER.debug("Caught exception", (Object)("Failed to install application " + this._application.getApplicationMetadata().getApplicationSymbolicName()));
            this.uninstall();
            throw e;
        }
        LOGGER.debug("Method exit: {}, returning {}", (Object)"install");
    }

    protected synchronized void uninstall() throws BundleException {
        LOGGER.debug("Method entry: {}, args {}", (Object)"uninstall");
        if (this._state != AriesApplicationContext.ApplicationState.UNINSTALLED) {
            Iterator<Bundle> bundleIter = this._bundles.iterator();
            while (bundleIter.hasNext()) {
                Bundle bundleToRemove = bundleIter.next();
                if (bundleToRemove.getState() != 1) {
                    try {
                        if (bundleToRemove.getState() == 32) {
                            this._bundleFrameworkManager.stopBundle(bundleToRemove);
                        }
                    }
                    catch (BundleException be) {
                        LOGGER.debug("Caught exception", (Throwable)be);
                    }
                    try {
                        this._bundleFrameworkManager.uninstallBundle(bundleToRemove);
                    }
                    catch (BundleException be) {
                        LOGGER.debug("Caught exception", (Throwable)be);
                    }
                }
                bundleIter.remove();
            }
            this._state = AriesApplicationContext.ApplicationState.UNINSTALLED;
        }
        LOGGER.debug("Method exit: {}, returning {}", (Object)"uninstall");
    }

    private void installBundles(List<DeploymentContent> bundlesToFind, boolean shared) throws BundleException {
        LOGGER.debug("Method entry: {}, args {}", (Object)"install", (Object)new Object[]{bundlesToFind, shared});
        if (!bundlesToFind.isEmpty() || !shared) {
            Iterator<DeploymentContent> it = bundlesToFind.iterator();
            Bundle[] sharedBundles = this._bundleFrameworkManager.getSharedBundleFramework().getIsolatedBundleContext().getBundles();
            if (shared && sharedBundles.length > 0) {
                block2: while (it.hasNext()) {
                    DeploymentContent bundleToFind = it.next();
                    for (Bundle b : sharedBundles) {
                        if (!bundleToFind.getContentName().equals(b.getSymbolicName()) || !bundleToFind.getExactVersion().equals((Object)b.getVersion())) continue;
                        it.remove();
                        this._bundles.add(b);
                        continue block2;
                    }
                }
            }
            Map<DeploymentContent, BundleRepository.BundleSuggestion> bundlesToBeInstalled = this.findBundleSuggestions(bundlesToFind);
            try {
                if (shared) {
                    this._bundles.addAll(this._bundleFrameworkManager.installSharedBundles(new ArrayList<BundleRepository.BundleSuggestion>(bundlesToBeInstalled.values()), this.makeAppProxy()));
                } else {
                    this._bundles.add(this._bundleFrameworkManager.installIsolatedBundles(new ArrayList<BundleRepository.BundleSuggestion>(bundlesToBeInstalled.values()), this.makeAppProxy()));
                }
            }
            catch (BundleException e) {
                LOGGER.debug("Caught exception", (Throwable)e);
                throw e;
            }
        }
        LOGGER.debug("Method exit: {}, returning {}", (Object)"install");
    }

    private AriesApplication makeAppProxy() {
        return new AriesApplication(){

            public void store(OutputStream out) throws FileNotFoundException, IOException {
                throw new UnsupportedOperationException();
            }

            public void store(File f) throws FileNotFoundException, IOException {
                throw new UnsupportedOperationException();
            }

            public boolean isResolved() {
                return true;
            }

            public DeploymentMetadata getDeploymentMetadata() {
                return ApplicationContextImpl.this._deploymentMF;
            }

            public Set<BundleInfo> getBundleInfo() {
                return ApplicationContextImpl.this._application.getBundleInfo();
            }

            public ApplicationMetadata getApplicationMetadata() {
                return ApplicationContextImpl.this._application.getApplicationMetadata();
            }
        };
    }

    private Map<DeploymentContent, BundleRepository.BundleSuggestion> findBundleSuggestions(Collection<DeploymentContent> bundlesToFind) throws BundleException {
        Map suggestions = null;
        try {
            suggestions = this._bundleRepositoryManager.getBundleSuggestions(this._application.getApplicationMetadata().getApplicationSymbolicName(), this._application.getApplicationMetadata().getApplicationVersion().toString(), bundlesToFind);
        }
        catch (ContextException e) {
            LOGGER.debug("Caught exception", (Throwable)e);
            throw new BundleException("Failed to locate bundle suggestions", (Throwable)e);
        }
        return suggestions;
    }

    public AriesApplication getApplication() {
        LOGGER.debug("Method entry: {}, args {}", (Object)"getApplication");
        LOGGER.debug("Method exit: {}, returning {}", (Object)"getApplication", (Object)new Object[]{this._application});
        return this._application;
    }

    public synchronized Set<Bundle> getApplicationContent() {
        LOGGER.debug("Method entry: {}, args {}", (Object)"getApplicationContent");
        LOGGER.debug("Method exit: {}, returning {}", (Object)"getApplicationContent", (Object)new Object[]{this._bundles});
        return this._bundles;
    }

    public synchronized AriesApplicationContext.ApplicationState getApplicationState() {
        LOGGER.debug("Method entry: {}, args {}", (Object)"getApplicationState");
        LOGGER.debug("Method exit: {}, returning {}", (Object)"getApplicationState", (Object)new Object[]{this._state});
        return this._state;
    }

    public synchronized void start() throws BundleException, IllegalStateException {
        LOGGER.debug("Method entry: {}, args {}", (Object)"start");
        if (this._state != AriesApplicationContext.ApplicationState.INSTALLED && this._state != AriesApplicationContext.ApplicationState.RESOLVED) {
            throw new IllegalStateException("Appication is in incorrect state " + this._state + " expected " + AriesApplicationContext.ApplicationState.INSTALLED + " or " + AriesApplicationContext.ApplicationState.RESOLVED);
        }
        ArrayList<Bundle> bundlesWeStarted = new ArrayList<Bundle>();
        try {
            for (Bundle b : this._bundles) {
                this._bundleFrameworkManager.startBundle(b);
                bundlesWeStarted.add(b);
            }
        }
        catch (BundleException be) {
            for (Bundle b : bundlesWeStarted) {
                try {
                    this._bundleFrameworkManager.stopBundle(b);
                }
                catch (BundleException be2) {
                    LOGGER.debug("Caught exception", (Throwable)be2);
                }
            }
            LOGGER.debug("Caught exception", (Throwable)be);
            LOGGER.debug("Method exit: {}, returning {}", (Object)"start", (Object)new Object[]{be});
            throw be;
        }
        this._state = AriesApplicationContext.ApplicationState.ACTIVE;
        LOGGER.debug("Method exit: {}, returning {}", (Object)"start");
    }

    public synchronized void stop() throws BundleException, IllegalStateException {
        LOGGER.debug("Method entry: {}, args {}", (Object)"stop");
        if (this._state != AriesApplicationContext.ApplicationState.ACTIVE) {
            throw new IllegalStateException("Appication is in incorrect state " + this._state + " expected " + AriesApplicationContext.ApplicationState.ACTIVE);
        }
        Iterator<Bundle> i$ = this._bundles.iterator();
        while (i$.hasNext()) {
            Bundle entry;
            Bundle b = entry = i$.next();
            this._bundleFrameworkManager.stopBundle(b);
        }
        this._state = AriesApplicationContext.ApplicationState.RESOLVED;
        LOGGER.debug("Method exit: {}, returning {}", (Object)"stop");
    }

    public synchronized void update(DeploymentMetadata newMetadata, DeploymentMetadata oldMetadata) throws UpdateException {
        boolean toStart;
        boolean bl = toStart = this.getApplicationState() == AriesApplicationContext.ApplicationState.ACTIVE;
        if (this._bundleFrameworkManager.allowsUpdate(newMetadata, oldMetadata)) {
            this._bundleFrameworkManager.updateBundles(newMetadata, oldMetadata, this._application, new BundleFrameworkManager.BundleLocator(){

                public Map<DeploymentContent, BundleRepository.BundleSuggestion> suggestBundle(Collection<DeploymentContent> bundles) throws BundleException {
                    return ApplicationContextImpl.this.findBundleSuggestions(bundles);
                }
            }, this._bundles, toStart);
        } else {
            try {
                this.uninstall();
                this._deploymentMF = newMetadata;
                try {
                    this.install();
                    if (toStart) {
                        this.start();
                    }
                }
                catch (BundleException e) {
                    try {
                        this.uninstall();
                        this._deploymentMF = oldMetadata;
                        this.install();
                        if (toStart) {
                            this.start();
                        }
                        throw new UpdateException("Could not install updated application", (Exception)((Object)e), true, null);
                    }
                    catch (BundleException e2) {
                        throw new UpdateException("Could not install updated application", (Exception)((Object)e), false, (Exception)((Object)e2));
                    }
                }
            }
            catch (BundleException e) {
                try {
                    this._deploymentMF = oldMetadata;
                    this.install();
                    if (toStart) {
                        this.start();
                    }
                    throw new UpdateException("Could not install updated application", (Exception)((Object)e), true, null);
                }
                catch (BundleException e2) {
                    throw new UpdateException("Could not install updated application", (Exception)((Object)e), false, (Exception)((Object)e2));
                }
            }
        }
    }

    public synchronized void close() throws BundleException {
        this.uninstall();
        this._closed = true;
    }

    public synchronized void open() throws BundleException {
        if (this._closed) {
            this.install();
            this._closed = false;
        }
    }
}

