/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.application.runtime.repository;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.aries.application.DeploymentContent;
import org.apache.aries.application.management.spi.repository.BundleRepository;
import org.apache.aries.application.management.spi.repository.BundleRepositoryManager;
import org.apache.aries.application.management.spi.repository.ContextException;
import org.apache.aries.application.utils.service.ArrayServiceList;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundleRepositoryManagerImpl
implements BundleRepositoryManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(BundleRepositoryManagerImpl.class);
    private BundleContext bc;

    public void setBundleContext(BundleContext bc) {
        LOGGER.debug("Method entry: {}, args {}", (Object)"setBundleContext");
        this.bc = bc;
        LOGGER.debug("Method exit: {}, returning {}", (Object)"setBundleContext");
    }

    public Collection<BundleRepository> getAllBundleRepositories() {
        LOGGER.debug("Method entry: {}, args {}", (Object)"getAllBundleRepositories");
        ArrayServiceList providers = new ArrayServiceList(this.bc);
        try {
            ServiceReference[] refs = this.bc.getServiceReferences(BundleRepository.class.getName(), null);
            if (refs != null) {
                for (ServiceReference ref : refs) {
                    providers.addService(ref);
                }
            }
        }
        catch (InvalidSyntaxException e) {
            LOGGER.error("Caught exception", (Throwable)e);
        }
        LOGGER.debug("Method exit: {}, returning {}", (Object)"getAllBundleRepositories");
        return providers;
    }

    public Collection<BundleRepository> getBundleRepositoryCollection(String appName, String appVersion) {
        LOGGER.debug("Method entry: {}, args {}", (Object)"getBundleRepositoryCollection", (Object)new Object[]{appName, appVersion});
        ArrayServiceList providers = new ArrayServiceList(this.bc);
        String appScope = appName + "_" + appVersion;
        String filter = "(|(repositoryScope=global)(repositoryScope=" + appScope + "))";
        try {
            ServiceReference[] refs = this.bc.getServiceReferences(BundleRepository.class.getName(), filter);
            if (refs != null) {
                for (ServiceReference ref : refs) {
                    providers.addService(ref);
                }
            }
        }
        catch (InvalidSyntaxException e) {
            LOGGER.error("Caught exception", (Throwable)e);
        }
        LOGGER.debug("Method exit: {}, returning {}", (Object)"getBundleRepositoryCollection");
        return providers;
    }

    public Map<DeploymentContent, BundleRepository.BundleSuggestion> getBundleSuggestions(Collection<BundleRepository> providers, Collection<DeploymentContent> content) throws ContextException {
        LOGGER.debug("Method entry: {}, args {}", (Object)"getBundleSuggestions", (Object)new Object[]{content, providers});
        HashMap<DeploymentContent, BundleRepository.BundleSuggestion> urlToBeInstalled = new HashMap<DeploymentContent, BundleRepository.BundleSuggestion>();
        for (DeploymentContent bundleToFind : content) {
            List thoughts;
            HashMap<Version, ArrayList<BundleRepository.BundleSuggestion>> bundlesuggestions = new HashMap<Version, ArrayList<BundleRepository.BundleSuggestion>>();
            for (BundleRepository obj : providers) {
                BundleRepository.BundleSuggestion suggestion = obj.suggestBundleToUse(bundleToFind);
                if (suggestion == null) continue;
                ArrayList<BundleRepository.BundleSuggestion> suggestions = (ArrayList<BundleRepository.BundleSuggestion>)bundlesuggestions.get(suggestion.getVersion());
                if (suggestions == null) {
                    suggestions = new ArrayList<BundleRepository.BundleSuggestion>();
                    bundlesuggestions.put(suggestion.getVersion(), suggestions);
                }
                suggestions.add(suggestion);
            }
            BundleRepository.BundleSuggestion suggestion = null;
            if (!bundlesuggestions.isEmpty() && (thoughts = (List)bundlesuggestions.get(bundleToFind.getExactVersion())) != null) {
                Collections.sort(thoughts, new Comparator<BundleRepository.BundleSuggestion>(){

                    @Override
                    public int compare(BundleRepository.BundleSuggestion o1, BundleRepository.BundleSuggestion o2) {
                        return o1.getCost() - o2.getCost();
                    }
                });
                suggestion = (BundleRepository.BundleSuggestion)thoughts.get(0);
            }
            if (suggestion != null) {
                urlToBeInstalled.put(bundleToFind, suggestion);
                continue;
            }
            throw new ContextException("Unable to find bundle " + bundleToFind.getContentName() + "/" + bundleToFind.getExactVersion());
        }
        LOGGER.debug("Method exit: {}, returning {}", (Object)"getBundleSuggestions", (Object)new Object[]{urlToBeInstalled});
        return urlToBeInstalled;
    }

    public Map<DeploymentContent, BundleRepository.BundleSuggestion> getBundleSuggestions(String applicationName, String applicationVersion, Collection<DeploymentContent> content) throws ContextException {
        return this.getBundleSuggestions(this.getBundleRepositoryCollection(applicationName, applicationVersion), content);
    }

    public Map<DeploymentContent, BundleRepository.BundleSuggestion> getBundleSuggestions(Collection<DeploymentContent> content) throws ContextException {
        return this.getBundleSuggestions(this.getAllBundleRepositories(), content);
    }
}

