/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.application.repository.generator;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import org.apache.aries.application.management.spi.repository.RepositoryGenerator;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.launch.Framework;
import org.osgi.framework.launch.FrameworkFactory;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.util.tracker.ServiceTracker;

public class AriesRepositoryGenerator {
    private Framework framework = null;
    private List<String> ignoreList = new ArrayList<String>();
    private List<ServiceTracker> srs = new ArrayList<ServiceTracker>();
    public static final long DEFAULT_TIMEOUT = 60000L;
    public static final String ERROR_LEVEL = "ERROR";
    public static final String DEFAULT_REPO_NAME = "repository.xml";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BundleContext startFramework() throws BundleException {
        ServiceLoader<FrameworkFactory> factoryLoader = ServiceLoader.load(FrameworkFactory.class, this.getClass().getClassLoader());
        Iterator<FrameworkFactory> factoryIterator = factoryLoader.iterator();
        if (!factoryIterator.hasNext()) {
            System.out.println("Unable to locate the osgi jar");
        }
        try {
            FrameworkFactory frameworkFactory = factoryIterator.next();
            this.framework = frameworkFactory.newFramework(Collections.EMPTY_MAP);
        }
        catch (ServiceConfigurationError sce) {
            sce.printStackTrace();
        }
        this.framework.init();
        this.framework.start();
        ArrayList<Bundle> installedBundles = new ArrayList<Bundle>();
        File bundleDir = new File(".");
        File[] jars = bundleDir.listFiles();
        try {
            for (File jar : jars) {
                String location;
                if (!jar.isFile() || !jar.getName().endsWith(".jar") || !this.shouldInstall(location = URLDecoder.decode(jar.toURI().toURL().toExternalForm(), "UTF-8"), this.getIgnoreList())) continue;
                installedBundles.add(this.framework.getBundleContext().installBundle("reference:" + location));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ServiceReference paRef = this.framework.getBundleContext().getServiceReference(PackageAdmin.class.getCanonicalName());
        if (paRef != null) {
            try {
                PackageAdmin admin = (PackageAdmin)this.framework.getBundleContext().getService(paRef);
                admin.resolveBundles(installedBundles.toArray(new Bundle[installedBundles.size()]));
            }
            finally {
                this.framework.getBundleContext().ungetService(paRef);
            }
        } else {
            System.out.println("Unable to find the service reference for package admin");
        }
        for (Bundle bundle : installedBundles) {
            try {
                if (bundle.getHeaders().get("Fragment-Host") != null) continue;
                bundle.start(2);
            }
            catch (BundleException e) {
                e.printStackTrace();
            }
        }
        return this.framework.getBundleContext();
    }

    private void stopFramework() throws Exception {
        for (ServiceTracker st : this.srs) {
            if (st == null) continue;
            st.close();
        }
        if (this.framework != null) {
            this.framework.stop();
        }
    }

    private Object getOsgiService(BundleContext bc, String className) {
        ServiceTracker tracker = null;
        try {
            String flt = "(objectClass=" + className + ")";
            Filter osgiFilter = FrameworkUtil.createFilter((String)flt);
            tracker = new ServiceTracker(bc, osgiFilter, null);
            tracker.open();
            this.srs.add(tracker);
            Object x = tracker.waitForService(60000L);
            if (x == null) {
                throw new RuntimeException("Gave up waiting for service " + flt);
            }
            return x;
        }
        catch (InvalidSyntaxException e) {
            throw new IllegalArgumentException("Invalid filter", e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public static void usage() {
        System.out.println("Invalid parameter specifed. See program usage below.");
        System.out.println("========================= Usage ===============================");
        System.out.println("Parameter list:  [Reporsitory File Location] url1 [url2 url3 ...]");
        System.out.println();
        System.out.println("The parameter of the repository file location is the location for the genenerated reporsitory xml, e.g. /test/rep/repo.xml. It must end with .xml. If the parameter is not present, it will generate a repository.xml in the current directory.");
        System.out.println();
        System.out.println("The paremater of url1 [url2 url 3 ...] is a list of urls. If the url starts with file:, it can be a directory, which means all jar or war files in that directory to be included in the reposiotry.");
        System.out.println("===============================================================");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        String[] urlArray = args;
        if (args.length == 0) {
            AriesRepositoryGenerator.usage();
            System.exit(0);
        } else {
            AriesRepositoryGenerator generator = new AriesRepositoryGenerator();
            String loggerLevelProp = "org.ops4j.pax.logging.DefaultServiceLog.level";
            if (System.getProperty(loggerLevelProp) == null) {
                System.setProperty(loggerLevelProp, ERROR_LEVEL);
            }
            FileOutputStream fout = null;
            try {
                BundleContext ctx = generator.startFramework();
                File xmlFile = new File(DEFAULT_REPO_NAME);
                if (args[0].endsWith(".xml")) {
                    xmlFile = new File(args[0]);
                    File parentDir = xmlFile.getAbsoluteFile().getParentFile();
                    if (!parentDir.exists()) {
                        parentDir.mkdirs();
                    }
                    if (args.length > 1) {
                        urlArray = Arrays.copyOfRange(args, 1, args.length);
                    } else {
                        AriesRepositoryGenerator.usage();
                        System.exit(0);
                    }
                }
                fout = new FileOutputStream(xmlFile);
                Object repoGen = generator.getOsgiService(ctx, RepositoryGenerator.class.getName());
                Class<?> gen = repoGen.getClass();
                Method m = gen.getDeclaredMethod("generateRepository", String[].class, OutputStream.class);
                m.invoke(repoGen, urlArray, fout);
                generator.stopFramework();
                System.out.println("The reporsitory xml was generated successfully under " + xmlFile.getAbsolutePath() + ".");
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(0);
            }
            finally {
                try {
                    if (fout != null) {
                        fout.close();
                    }
                }
                catch (IOException e) {
                    fout = null;
                }
            }
        }
    }

    private boolean shouldInstall(String location, List<String> ignoreList) {
        String name = location.substring(location.lastIndexOf(47) + 1);
        boolean inIgnoreList = false;
        for (String prefix : ignoreList) {
            if (!name.startsWith(prefix + "-") && !name.startsWith(prefix + ".jar")) continue;
            inIgnoreList = true;
            break;
        }
        return !inIgnoreList;
    }

    private List<String> getIgnoreList() {
        this.ignoreList.add("osgi");
        this.ignoreList.add("org.apache.aries.application.obr.generator");
        return this.ignoreList;
    }
}

