/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.blueprint.compendium.cm;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.aries.blueprint.BeanProcessor;
import org.apache.aries.blueprint.ServiceProcessor;
import org.apache.aries.blueprint.compendium.cm.CmManagedProperties;
import org.apache.aries.blueprint.compendium.cm.CmProperties;
import org.apache.aries.blueprint.services.ExtendedBlueprintContainer;
import org.apache.aries.blueprint.utils.JavaUtils;
import org.apache.aries.blueprint.utils.ReflectionUtils;
import org.apache.aries.blueprint.utils.ServiceListener;
import org.apache.aries.util.AriesFrameworkUtil;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedServiceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmManagedServiceFactory {
    static final int CONFIGURATION_ADMIN_OBJECT_DELETED = 1;
    static final int BUNDLE_STOPPING = 2;
    private static final Logger LOGGER = LoggerFactory.getLogger(CmManagedServiceFactory.class);
    private ExtendedBlueprintContainer blueprintContainer;
    private ConfigurationAdmin configAdmin;
    private String id;
    private String factoryPid;
    private List<String> interfaces;
    private int autoExport;
    private int ranking;
    private Map serviceProperties;
    private String managedComponentName;
    private String componentDestroyMethod;
    private List<ServiceListener> listeners;
    private final Object lock = new Object();
    private ServiceRegistration registration;
    private Map<String, ServiceRegistration> pids = new ConcurrentHashMap<String, ServiceRegistration>();
    private Map<ServiceRegistration, Object> services = new ConcurrentHashMap<ServiceRegistration, Object>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws Exception {
        LOGGER.debug("Initializing CmManagedServiceFactory for factoryPid={}", (Object)this.factoryPid);
        Properties props = new Properties();
        props.put("service.pid", this.factoryPid);
        Bundle bundle = this.blueprintContainer.getBundleContext().getBundle();
        props.put("Bundle-SymbolicName", bundle.getSymbolicName());
        props.put("Bundle-Version", bundle.getHeaders().get("Bundle-Version"));
        Object object = this.lock;
        synchronized (object) {
            this.registration = this.blueprintContainer.getBundleContext().registerService(ManagedServiceFactory.class.getName(), (Object)new ConfigurationWatcher(), (Dictionary)props);
            String filter = "(service.factoryPid=" + this.factoryPid + ')';
            Configuration[] configs = this.configAdmin.listConfigurations(filter);
            if (configs != null) {
                for (Configuration config : configs) {
                    this.updated(config.getPid(), config.getProperties());
                }
            }
        }
    }

    public void destroy() {
        AriesFrameworkUtil.safeUnregisterService((ServiceRegistration)this.registration);
        for (Map.Entry<ServiceRegistration, Object> entry : this.services.entrySet()) {
            this.destroy(entry.getValue(), entry.getKey(), 2);
        }
        this.services.clear();
        this.pids.clear();
    }

    private void destroy(Object component, ServiceRegistration registration, int code) {
        if (this.listeners != null) {
            ServiceReference ref = registration.getReference();
            for (ServiceListener listener : this.listeners) {
                Hashtable props = JavaUtils.getProperties((ServiceReference)ref);
                listener.unregister(component, (Map)props);
            }
        }
        this.destroyComponent(component, code);
        AriesFrameworkUtil.safeUnregisterService((ServiceRegistration)registration);
    }

    public Map<ServiceRegistration, Object> getServiceMap() {
        return Collections.unmodifiableMap(this.services);
    }

    public void setBlueprintContainer(ExtendedBlueprintContainer blueprintContainer) {
        this.blueprintContainer = blueprintContainer;
    }

    public void setConfigAdmin(ConfigurationAdmin configAdmin) {
        this.configAdmin = configAdmin;
    }

    public void setListeners(List<ServiceListener> listeners) {
        this.listeners = listeners;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setFactoryPid(String factoryPid) {
        this.factoryPid = factoryPid;
    }

    public void setInterfaces(List<String> interfaces) {
        this.interfaces = interfaces;
    }

    public void setAutoExport(int autoExport) {
        this.autoExport = autoExport;
    }

    public void setRanking(int ranking) {
        this.ranking = ranking;
    }

    public void setServiceProperties(Map serviceProperties) {
        this.serviceProperties = serviceProperties;
    }

    public void setManagedComponentName(String managedComponentName) {
        this.managedComponentName = managedComponentName;
    }

    public void setComponentDestroyMethod(String componentDestroyMethod) {
        this.componentDestroyMethod = componentDestroyMethod;
    }

    protected void updated(String pid, Dictionary props) {
        LOGGER.debug("Updated configuration {} with props {}", (Object)pid, (Object)props);
        ServiceRegistration reg = this.pids.get(pid);
        if (reg == null) {
            this.updateComponentProperties(props);
            Object component = this.blueprintContainer.getComponentInstance(this.managedComponentName);
            Hashtable regProps = this.getRegistrationProperties(pid);
            CmProperties cm = this.findServiceProcessor();
            if (cm != null) {
                if ("".equals(cm.getPersistentId())) {
                    JavaUtils.copy((Dictionary)regProps, (Dictionary)props);
                }
                cm.updateProperties(new PropertiesUpdater(pid), regProps);
            }
            Set<String> classes = this.getClasses(component);
            String[] classArray = classes.toArray(new String[classes.size()]);
            reg = this.blueprintContainer.getBundleContext().registerService(classArray, component, (Dictionary)regProps);
            LOGGER.debug("Service {} registered with interfaces {} and properties {}", new Object[]{component, classes, regProps});
            this.services.put(reg, component);
            this.pids.put(pid, reg);
            if (this.listeners != null) {
                for (ServiceListener listener : this.listeners) {
                    listener.register(component, (Map)regProps);
                }
            }
        } else {
            this.updateComponentProperties(props);
            CmProperties cm = this.findServiceProcessor();
            if (cm != null && "".equals(cm.getPersistentId())) {
                Hashtable regProps = this.getRegistrationProperties(pid);
                JavaUtils.copy((Dictionary)regProps, (Dictionary)props);
                cm.updated(regProps);
            }
        }
    }

    private Hashtable getRegistrationProperties(String pid) {
        Hashtable<String, Object> regProps = new Hashtable<String, Object>();
        if (this.serviceProperties != null) {
            regProps.putAll(this.serviceProperties);
        }
        regProps.put("service.pid", pid);
        regProps.put("service.ranking", this.ranking);
        return regProps;
    }

    private void updateComponentProperties(Dictionary props) {
        CmManagedProperties cm = this.findBeanProcessor();
        if (cm != null) {
            cm.updated(props);
        }
    }

    private CmManagedProperties findBeanProcessor() {
        for (BeanProcessor beanProcessor : this.blueprintContainer.getProcessors(BeanProcessor.class)) {
            CmManagedProperties cm;
            if (!(beanProcessor instanceof CmManagedProperties) || !this.managedComponentName.equals((cm = (CmManagedProperties)beanProcessor).getBeanName()) || !"".equals(cm.getPersistentId())) continue;
            return cm;
        }
        return null;
    }

    private CmProperties findServiceProcessor() {
        for (ServiceProcessor processor : this.blueprintContainer.getProcessors(ServiceProcessor.class)) {
            CmProperties cm;
            if (!(processor instanceof CmProperties) || !this.id.equals((cm = (CmProperties)processor).getServiceId())) continue;
            return cm;
        }
        return null;
    }

    private void destroyComponent(Object instance, int reason) {
        Method method = this.findDestroyMethod(instance.getClass());
        if (method != null) {
            try {
                method.invoke(instance, reason);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private Method findDestroyMethod(Class clazz) {
        List methods;
        Method method = null;
        if (this.componentDestroyMethod != null && this.componentDestroyMethod.length() > 0 && (methods = ReflectionUtils.findCompatibleMethods((Class)clazz, (String)this.componentDestroyMethod, (Class[])new Class[]{Integer.TYPE})) != null && !methods.isEmpty()) {
            method = (Method)methods.get(0);
        }
        return method;
    }

    protected void deleted(String pid) {
        LOGGER.debug("Deleted configuration {}", (Object)pid);
        ServiceRegistration reg = this.pids.remove(pid);
        if (reg != null) {
            Object component = this.services.remove(reg);
            this.destroy(component, reg, 1);
        }
    }

    private Set<String> getClasses(Object service) {
        Set<String> classes;
        Class<?> serviceClass = service.getClass();
        switch (this.autoExport) {
            case 2: {
                classes = ReflectionUtils.getImplementedInterfaces(new HashSet(), serviceClass);
                break;
            }
            case 3: {
                classes = ReflectionUtils.getSuperClasses(new HashSet(), serviceClass);
                break;
            }
            case 4: {
                classes = ReflectionUtils.getSuperClasses(new HashSet(), serviceClass);
                classes = ReflectionUtils.getImplementedInterfaces(classes, serviceClass);
                break;
            }
            default: {
                classes = new HashSet<String>(this.interfaces);
            }
        }
        return classes;
    }

    private class PropertiesUpdater
    implements ServiceProcessor.ServicePropertiesUpdater {
        private String pid;

        public PropertiesUpdater(String pid) {
            this.pid = pid;
        }

        public String getId() {
            return CmManagedServiceFactory.this.id;
        }

        public void updateProperties(Dictionary properties) {
            ServiceReference ref;
            ServiceRegistration reg = (ServiceRegistration)CmManagedServiceFactory.this.pids.get(this.pid);
            if (reg != null && (ref = reg.getReference()) != null) {
                Hashtable table = JavaUtils.getProperties((ServiceReference)ref);
                JavaUtils.copy((Dictionary)table, (Dictionary)properties);
                reg.setProperties((Dictionary)table);
            }
        }
    }

    private class ConfigurationWatcher
    implements ManagedServiceFactory {
        private ConfigurationWatcher() {
        }

        public String getName() {
            return null;
        }

        public void updated(String pid, Dictionary props) throws ConfigurationException {
            CmManagedServiceFactory.this.updated(pid, props);
        }

        public void deleted(String pid) {
            CmManagedServiceFactory.this.deleted(pid);
        }
    }
}

