/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.blueprint.container;

import java.io.FileNotFoundException;
import java.net.URI;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.DomainCombiner;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.aries.blueprint.ComponentDefinitionRegistryProcessor;
import org.apache.aries.blueprint.ExtendedBeanMetadata;
import org.apache.aries.blueprint.ExtendedBlueprintContainer;
import org.apache.aries.blueprint.NamespaceHandler;
import org.apache.aries.blueprint.Processor;
import org.apache.aries.blueprint.container.AggregateConverter;
import org.apache.aries.blueprint.container.BlueprintRepository;
import org.apache.aries.blueprint.container.IdSpace;
import org.apache.aries.blueprint.container.NamespaceHandlerRegistry;
import org.apache.aries.blueprint.container.Parser;
import org.apache.aries.blueprint.container.RecipeBuilder;
import org.apache.aries.blueprint.container.SatisfiableRecipe;
import org.apache.aries.blueprint.container.ServiceRecipe;
import org.apache.aries.blueprint.di.Recipe;
import org.apache.aries.blueprint.namespace.ComponentDefinitionRegistryImpl;
import org.apache.aries.blueprint.reflect.MetadataUtil;
import org.apache.aries.blueprint.reflect.PassThroughMetadataImpl;
import org.apache.aries.blueprint.utils.HeaderParser;
import org.apache.aries.blueprint.utils.JavaUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.blueprint.container.BlueprintContainer;
import org.osgi.service.blueprint.container.BlueprintEvent;
import org.osgi.service.blueprint.container.BlueprintListener;
import org.osgi.service.blueprint.container.ComponentDefinitionException;
import org.osgi.service.blueprint.container.Converter;
import org.osgi.service.blueprint.container.NoSuchComponentException;
import org.osgi.service.blueprint.reflect.BeanArgument;
import org.osgi.service.blueprint.reflect.BeanMetadata;
import org.osgi.service.blueprint.reflect.BeanProperty;
import org.osgi.service.blueprint.reflect.CollectionMetadata;
import org.osgi.service.blueprint.reflect.ComponentMetadata;
import org.osgi.service.blueprint.reflect.MapMetadata;
import org.osgi.service.blueprint.reflect.Metadata;
import org.osgi.service.blueprint.reflect.PropsMetadata;
import org.osgi.service.blueprint.reflect.RefMetadata;
import org.osgi.service.blueprint.reflect.ReferenceListener;
import org.osgi.service.blueprint.reflect.ServiceMetadata;
import org.osgi.service.blueprint.reflect.ServiceReferenceMetadata;
import org.osgi.service.blueprint.reflect.Target;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlueprintContainerImpl
implements ExtendedBlueprintContainer,
NamespaceHandlerRegistry.Listener,
Runnable,
SatisfiableRecipe.SatisfactionListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(BlueprintContainerImpl.class);
    private final BundleContext bundleContext;
    private final Bundle extenderBundle;
    private final BlueprintListener eventDispatcher;
    private final NamespaceHandlerRegistry handlers;
    private final List<Object> pathList;
    private final ComponentDefinitionRegistryImpl componentDefinitionRegistry;
    private final AggregateConverter converter;
    private final ScheduledExecutorService executors;
    private Set<URI> namespaces;
    private State state = State.Unknown;
    private NamespaceHandlerRegistry.NamespaceHandlerSet handlerSet;
    private boolean destroyed;
    private Parser parser;
    private BlueprintRepository repository;
    private ServiceRegistration registration;
    private List<Processor> processors;
    private final Object satisfiablesLock = new Object();
    private Map<String, List<SatisfiableRecipe>> satisfiables;
    private long timeout = 300000L;
    private boolean waitForDependencies = true;
    private boolean xmlValidation = true;
    private ScheduledFuture timeoutFuture;
    private final AtomicBoolean scheduled = new AtomicBoolean();
    private final AtomicBoolean running = new AtomicBoolean();
    private List<ServiceRecipe> services;
    private AccessControlContext accessControlContext;
    private final IdSpace tempRecipeIdSpace = new IdSpace();

    public BlueprintContainerImpl(BundleContext bundleContext, Bundle extenderBundle, BlueprintListener eventDispatcher, NamespaceHandlerRegistry handlers, ScheduledExecutorService executors, List<Object> pathList) {
        this.bundleContext = bundleContext;
        this.extenderBundle = extenderBundle;
        this.eventDispatcher = eventDispatcher;
        this.handlers = handlers;
        this.pathList = pathList;
        this.converter = new AggregateConverter(this);
        this.componentDefinitionRegistry = new ComponentDefinitionRegistryImpl();
        this.executors = executors;
        this.processors = new ArrayList<Processor>();
        if (System.getSecurityManager() != null) {
            this.accessControlContext = this.createAccessControlContext();
        }
    }

    @Override
    public Bundle getExtenderBundle() {
        return this.extenderBundle;
    }

    @Override
    public <T extends Processor> List<T> getProcessors(Class<T> clazz) {
        ArrayList<T> p = new ArrayList<T>();
        for (Processor processor : this.processors) {
            if (!clazz.isInstance(processor)) continue;
            p.add(clazz.cast(processor));
        }
        return p;
    }

    @Override
    public BlueprintListener getEventDispatcher() {
        return this.eventDispatcher;
    }

    private void checkDirectives() {
        String xmlValidationDirective;
        String graceperiod;
        Bundle bundle = this.bundleContext.getBundle();
        Dictionary headers = bundle.getHeaders();
        String symbolicName = (String)headers.get("Bundle-SymbolicName");
        List<HeaderParser.PathElement> paths = HeaderParser.parseHeader(symbolicName);
        String timeoutDirective = paths.get(0).getDirective("blueprint.timeout");
        if (timeoutDirective != null) {
            LOGGER.debug("Timeout directive: {}", (Object)timeoutDirective);
            this.timeout = Integer.parseInt(timeoutDirective);
        }
        if ((graceperiod = paths.get(0).getDirective("blueprint.graceperiod")) != null) {
            LOGGER.debug("Grace-period directive: {}", (Object)graceperiod);
            this.waitForDependencies = Boolean.parseBoolean(graceperiod);
        }
        if ((xmlValidationDirective = paths.get(0).getDirective("blueprint.aries.xml-validation")) != null) {
            LOGGER.debug("Xml-validation directive: {}", (Object)xmlValidationDirective);
            this.xmlValidation = Boolean.parseBoolean(xmlValidationDirective);
        }
    }

    public void schedule() {
        if (this.scheduled.compareAndSet(false, true)) {
            this.executors.submit(this);
        }
    }

    @Override
    public void reload() {
        this.unregisterServices();
        this.untrackServiceReferences();
        this.destroyComponents();
        this.componentDefinitionRegistry.reset();
        this.repository = null;
        this.processors = new ArrayList<Processor>();
        this.timeout = 300000L;
        this.waitForDependencies = true;
        this.xmlValidation = true;
        this.state = State.Unknown;
        this.schedule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.scheduled.set(false);
        AtomicBoolean atomicBoolean = this.scheduled;
        synchronized (atomicBoolean) {
            AtomicBoolean atomicBoolean2 = this.running;
            synchronized (atomicBoolean2) {
                this.running.set(true);
                try {
                    this.doRun();
                }
                finally {
                    this.running.set(false);
                    this.running.notifyAll();
                }
            }
        }
    }

    private void doRun() {
        try {
            while (true) {
                if (this.destroyed) {
                    return;
                }
                LOGGER.debug("Running blueprint container for bundle {} in state {}", (Object)this.bundleContext.getBundle().getSymbolicName(), (Object)this.state);
                switch (this.state) {
                    case Unknown: {
                        this.checkDirectives();
                        this.eventDispatcher.blueprintEvent(new BlueprintEvent(1, this.getBundleContext().getBundle(), this.getExtenderBundle()));
                        this.parser = new Parser();
                        this.parser.parse(this.getResources());
                        this.namespaces = this.parser.getNamespaces();
                        this.handlerSet = this.handlers.getNamespaceHandlers(this.namespaces, this.getBundleContext().getBundle());
                        this.handlerSet.addListener(this);
                        this.state = State.WaitForNamespaceHandlers;
                        break;
                    }
                    case WaitForNamespaceHandlers: {
                        ArrayList<String> missing = new ArrayList<String>();
                        for (URI ns : this.namespaces) {
                            if (this.handlerSet.getNamespaceHandler(ns) != null) continue;
                            missing.add("(&(objectClass=" + NamespaceHandler.class.getName() + ")(" + "osgi.service.blueprint.namespace" + "=" + ns + "))");
                        }
                        if (missing.size() > 0) {
                            LOGGER.info("Bundle {} is waiting for namespace handlers ", (Object)this.bundleContext.getBundle().getSymbolicName(), missing);
                            this.eventDispatcher.blueprintEvent(new BlueprintEvent(6, this.getBundleContext().getBundle(), this.getExtenderBundle(), missing.toArray(new String[missing.size()])));
                            return;
                        }
                        this.componentDefinitionRegistry.registerComponentDefinition(new PassThroughMetadataImpl("blueprintContainer", this));
                        this.componentDefinitionRegistry.registerComponentDefinition(new PassThroughMetadataImpl("blueprintBundle", this.bundleContext.getBundle()));
                        this.componentDefinitionRegistry.registerComponentDefinition(new PassThroughMetadataImpl("blueprintBundleContext", this.bundleContext));
                        this.componentDefinitionRegistry.registerComponentDefinition(new PassThroughMetadataImpl("blueprintConverter", this.converter));
                        if (this.xmlValidation) {
                            this.parser.validate(this.handlerSet.getSchema());
                        }
                        this.parser.populate(this.handlerSet, this.componentDefinitionRegistry);
                        this.state = State.Populated;
                        break;
                    }
                    case Populated: {
                        this.getRepository();
                        this.trackServiceReferences();
                        Runnable r = new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void run() {
                                AtomicBoolean atomicBoolean = BlueprintContainerImpl.this.scheduled;
                                synchronized (atomicBoolean) {
                                    TimeoutException t = new TimeoutException();
                                    BlueprintContainerImpl.this.state = State.Failed;
                                    BlueprintContainerImpl.this.unregisterServices();
                                    BlueprintContainerImpl.this.untrackServiceReferences();
                                    BlueprintContainerImpl.this.destroyComponents();
                                    String[] missingDependecies = BlueprintContainerImpl.this.getMissingDependencies();
                                    LOGGER.error("Unable to start blueprint container for bundle " + BlueprintContainerImpl.this.bundleContext.getBundle().getSymbolicName() + " due to unresolved dependencies " + Arrays.asList(missingDependecies), (Throwable)t);
                                    BlueprintContainerImpl.this.eventDispatcher.blueprintEvent(new BlueprintEvent(5, BlueprintContainerImpl.this.getBundleContext().getBundle(), BlueprintContainerImpl.this.getExtenderBundle(), missingDependecies, (Throwable)t));
                                }
                            }
                        };
                        this.timeoutFuture = this.executors.schedule(r, this.timeout, TimeUnit.MILLISECONDS);
                        this.state = State.WaitForInitialReferences;
                        break;
                    }
                    case WaitForInitialReferences: {
                        String[] missingDependencies;
                        if (this.waitForDependencies && (missingDependencies = this.getMissingDependencies()).length > 0) {
                            LOGGER.info("Bundle {} is waiting for dependencies {}", (Object)this.bundleContext.getBundle().getSymbolicName(), Arrays.asList(missingDependencies));
                            this.eventDispatcher.blueprintEvent(new BlueprintEvent(6, this.getBundleContext().getBundle(), this.getExtenderBundle(), missingDependencies));
                            return;
                        }
                        this.state = State.InitialReferencesSatisfied;
                        break;
                    }
                    case InitialReferencesSatisfied: {
                        this.processTypeConverters();
                        this.processProcessors();
                        this.state = State.WaitForInitialReferences2;
                        break;
                    }
                    case WaitForInitialReferences2: {
                        String[] missingDependencies;
                        if (this.waitForDependencies && (missingDependencies = this.getMissingDependencies()).length > 0) {
                            LOGGER.info("Bundle {} is waiting for dependencies {}", (Object)this.bundleContext.getBundle().getSymbolicName(), Arrays.asList(missingDependencies));
                            this.eventDispatcher.blueprintEvent(new BlueprintEvent(6, this.getBundleContext().getBundle(), this.getExtenderBundle(), missingDependencies));
                            return;
                        }
                        this.state = State.Create;
                        break;
                    }
                    case Create: {
                        this.timeoutFuture.cancel(false);
                        this.registerServices();
                        this.instantiateEagerComponents();
                        int bs = this.bundleContext.getBundle().getState();
                        if (this.registration == null && (bs == 32 || bs == 8)) {
                            Properties props = new Properties();
                            props.put("osgi.blueprint.container.symbolicname", this.bundleContext.getBundle().getSymbolicName());
                            props.put("osgi.blueprint.container.version", JavaUtils.getBundleVersion(this.bundleContext.getBundle()));
                            this.registration = this.registerService(new String[]{BlueprintContainer.class.getName()}, this, props);
                        }
                        this.eventDispatcher.blueprintEvent(new BlueprintEvent(2, this.getBundleContext().getBundle(), this.getExtenderBundle()));
                        this.state = State.Created;
                        break;
                    }
                    case Created: 
                    case Failed: {
                        return;
                    }
                }
            }
        }
        catch (Throwable t) {
            this.state = State.Failed;
            if (this.timeoutFuture != null) {
                this.timeoutFuture.cancel(false);
            }
            this.unregisterServices();
            this.untrackServiceReferences();
            this.destroyComponents();
            LOGGER.error("Unable to start blueprint container for bundle " + this.bundleContext.getBundle().getSymbolicName(), t);
            this.eventDispatcher.blueprintEvent(new BlueprintEvent(5, this.getBundleContext().getBundle(), this.getExtenderBundle(), t));
            return;
        }
    }

    private List<URL> getResources() throws FileNotFoundException {
        ArrayList<URL> resources = new ArrayList<URL>();
        for (Object path : this.pathList) {
            if (path instanceof URL) {
                resources.add((URL)path);
                continue;
            }
            if (path instanceof String) {
                URL url = this.bundleContext.getBundle().getEntry((String)path);
                if (url == null) {
                    throw new FileNotFoundException("Unable to find configuration file for " + path);
                }
                resources.add(url);
                continue;
            }
            throw new IllegalArgumentException("Unexpected path type: " + path.getClass());
        }
        return resources;
    }

    @Override
    public Class loadClass(final String name) throws ClassNotFoundException {
        if (this.accessControlContext == null) {
            return this.bundleContext.getBundle().loadClass(name);
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Class>(){

                @Override
                public Class run() throws Exception {
                    return BlueprintContainerImpl.this.bundleContext.getBundle().loadClass(name);
                }
            }, this.accessControlContext);
        }
        catch (PrivilegedActionException e) {
            Exception cause = e.getException();
            if (cause instanceof ClassNotFoundException) {
                throw (ClassNotFoundException)cause;
            }
            throw new IllegalStateException("Unexpected checked exception", cause);
        }
    }

    @Override
    public ServiceRegistration registerService(final String[] classes, final Object service, final Dictionary properties) {
        if (this.accessControlContext == null) {
            return this.bundleContext.registerService(classes, service, properties);
        }
        return AccessController.doPrivileged(new PrivilegedAction<ServiceRegistration>(){

            @Override
            public ServiceRegistration run() {
                return BlueprintContainerImpl.this.bundleContext.registerService(classes, service, properties);
            }
        }, this.accessControlContext);
    }

    @Override
    public Object getService(final ServiceReference reference) {
        if (this.accessControlContext == null) {
            return this.bundleContext.getService(reference);
        }
        return AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return BlueprintContainerImpl.this.bundleContext.getService(reference);
            }
        }, this.accessControlContext);
    }

    private AccessControlContext createAccessControlContext() {
        return new AccessControlContext(AccessController.getContext(), new DomainCombiner(){

            public ProtectionDomain[] combine(ProtectionDomain[] arg0, ProtectionDomain[] arg1) {
                return new ProtectionDomain[]{new ProtectionDomain(null, null){

                    public boolean implies(Permission permission) {
                        return BlueprintContainerImpl.this.bundleContext.getBundle().hasPermission((Object)permission);
                    }
                }};
            }
        });
    }

    @Override
    public AccessControlContext getAccessControlContext() {
        return this.accessControlContext;
    }

    @Override
    public BlueprintRepository getRepository() {
        if (this.repository == null) {
            this.repository = new RecipeBuilder(this, this.tempRecipeIdSpace).createRepository();
        }
        return this.repository;
    }

    private void processTypeConverters() throws Exception {
        ArrayList<String> typeConverters = new ArrayList<String>();
        for (Target target : this.componentDefinitionRegistry.getTypeConverters()) {
            if (target instanceof ComponentMetadata) {
                typeConverters.add(((ComponentMetadata)target).getId());
                continue;
            }
            if (target instanceof RefMetadata) {
                typeConverters.add(((RefMetadata)target).getComponentId());
                continue;
            }
            throw new ComponentDefinitionException("Unexpected metadata for type converter: " + target);
        }
        Map<String, Object> objects = this.repository.createAll(typeConverters);
        for (String name : typeConverters) {
            Object obj = objects.get(name);
            if (obj instanceof Converter) {
                this.converter.registerConverter((Converter)obj);
                continue;
            }
            throw new ComponentDefinitionException("Type converter " + obj + " does not implement the " + Converter.class.getName() + " interface");
        }
    }

    private void processProcessors() throws Exception {
        for (BeanMetadata bean : this.getMetadata(BeanMetadata.class)) {
            Object obj;
            if (bean instanceof ExtendedBeanMetadata && !((ExtendedBeanMetadata)bean).isProcessor()) continue;
            Class clazz = null;
            if (bean instanceof ExtendedBeanMetadata) {
                clazz = ((ExtendedBeanMetadata)bean).getRuntimeClass();
            }
            if (clazz == null && bean.getClassName() != null) {
                clazz = this.loadClass(bean.getClassName());
            }
            if (clazz == null) continue;
            if (ComponentDefinitionRegistryProcessor.class.isAssignableFrom(clazz)) {
                obj = this.repository.create(bean.getId());
                ((ComponentDefinitionRegistryProcessor)obj).process(this.componentDefinitionRegistry);
            } else {
                if (!Processor.class.isAssignableFrom(clazz)) continue;
                obj = this.repository.create(bean.getId());
                this.processors.add((Processor)obj);
            }
            this.untrackServiceReferences();
            BlueprintRepository tmpRepo = new RecipeBuilder(this, this.tempRecipeIdSpace).createRepository();
            LOGGER.debug("Updating blueprint repository");
            for (String name : this.repository.getNames()) {
                if (this.repository.getInstance(name) == null) {
                    LOGGER.debug("Removing uninstantiated recipe {}", new Object[]{name});
                    this.repository.removeRecipe(name);
                    continue;
                }
                LOGGER.debug("Recipe {} is already instantiated", new Object[]{name});
            }
            for (String name : tmpRepo.getNames()) {
                if (this.repository.getInstance(name) == null) {
                    LOGGER.debug("Adding new recipe {}", new Object[]{name});
                    Recipe r = tmpRepo.getRecipe(name);
                    if (r == null) continue;
                    this.repository.putRecipe(name, r);
                    continue;
                }
                LOGGER.debug("Recipe {} is already instantiated and cannot be updated", new Object[]{name});
            }
            this.getSatisfiableDependenciesMap(true);
            this.trackServiceReferences();
        }
    }

    private Map<String, List<SatisfiableRecipe>> getSatisfiableDependenciesMap() {
        return this.getSatisfiableDependenciesMap(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, List<SatisfiableRecipe>> getSatisfiableDependenciesMap(boolean recompute) {
        Object object = this.satisfiablesLock;
        synchronized (object) {
            if ((recompute || this.satisfiables == null) && this.repository != null) {
                this.satisfiables = new HashMap<String, List<SatisfiableRecipe>>();
                for (Recipe r : this.repository.getAllRecipes(new String[0])) {
                    List<SatisfiableRecipe> recipes = this.repository.getAllRecipes(SatisfiableRecipe.class, r.getName());
                    if (recipes.isEmpty()) continue;
                    this.satisfiables.put(r.getName(), recipes);
                }
            }
            return this.satisfiables;
        }
    }

    private void trackServiceReferences() {
        Map<String, List<SatisfiableRecipe>> dependencies = this.getSatisfiableDependenciesMap();
        HashSet<String> satisfiables = new HashSet<String>();
        for (List<SatisfiableRecipe> recipes : dependencies.values()) {
            for (SatisfiableRecipe satisfiable : recipes) {
                if (!satisfiables.add(satisfiable.getName())) continue;
                satisfiable.start(this);
            }
        }
        LOGGER.debug("Tracking service references: {}", satisfiables);
    }

    private void untrackServiceReferences() {
        Map<String, List<SatisfiableRecipe>> dependencies = this.getSatisfiableDependenciesMap();
        if (dependencies != null) {
            HashSet<String> stopped = new HashSet<String>();
            for (List<SatisfiableRecipe> recipes : dependencies.values()) {
                for (SatisfiableRecipe satisfiable : recipes) {
                    this.untrackServiceReference(satisfiable, stopped, dependencies);
                }
            }
        }
    }

    private void untrackServiceReference(SatisfiableRecipe recipe, Set<String> stopped, Map<String, List<SatisfiableRecipe>> dependencies) {
        if (stopped.add(recipe.getName())) {
            for (Map.Entry<String, List<SatisfiableRecipe>> entry : dependencies.entrySet()) {
                Recipe r;
                if (!entry.getValue().contains(recipe) || !((r = this.getRepository().getRecipe(entry.getKey())) instanceof SatisfiableRecipe)) continue;
                this.untrackServiceReference((SatisfiableRecipe)r, stopped, dependencies);
            }
            recipe.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifySatisfaction(SatisfiableRecipe satisfiable) {
        LOGGER.debug("Notified satisfaction {} in bundle {}: {}", new Object[]{satisfiable.getName(), this.bundleContext.getBundle().getSymbolicName(), satisfiable.isSatisfied()});
        if (this.state == State.Create || this.state == State.Created) {
            Map<String, List<SatisfiableRecipe>> dependencies = this.getSatisfiableDependenciesMap();
            for (Map.Entry<String, List<SatisfiableRecipe>> entry : dependencies.entrySet()) {
                ServiceRecipe reg;
                String name = entry.getKey();
                ComponentMetadata metadata = this.componentDefinitionRegistry.getComponentDefinition(name);
                if (!(metadata instanceof ServiceMetadata)) continue;
                ServiceRecipe serviceRecipe = reg = (ServiceRecipe)this.repository.getRecipe(name);
                synchronized (serviceRecipe) {
                    boolean satisfied = true;
                    for (SatisfiableRecipe recipe : entry.getValue()) {
                        if (recipe.isSatisfied()) continue;
                        satisfied = false;
                        break;
                    }
                    if (satisfied && !reg.isRegistered()) {
                        LOGGER.debug("Registering service {} due to satisfied references", (Object)name);
                        reg.register();
                    } else if (!satisfied && reg.isRegistered()) {
                        LOGGER.debug("Unregistering service {} due to unsatisfied references", (Object)name);
                        reg.unregister();
                    }
                }
            }
        } else {
            this.schedule();
        }
    }

    private void instantiateEagerComponents() {
        ArrayList<String> components = new ArrayList<String>();
        for (String name : this.componentDefinitionRegistry.getComponentDefinitionNames()) {
            boolean eager;
            ComponentMetadata component = this.componentDefinitionRegistry.getComponentDefinition(name);
            boolean bl = eager = component.getActivation() == 1;
            if (component instanceof BeanMetadata) {
                BeanMetadata local = (BeanMetadata)component;
                eager &= MetadataUtil.isSingletonScope(local);
            }
            if (!eager) continue;
            components.add(name);
        }
        LOGGER.debug("Instantiating components: {}", components);
        try {
            this.repository.createAll(components);
        }
        catch (ComponentDefinitionException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new ComponentDefinitionException("Unable to instantiate components", t);
        }
    }

    private void registerServices() {
        this.services = this.repository.getAllRecipes(ServiceRecipe.class, new String[0]);
        for (ServiceRecipe r : this.services) {
            List<SatisfiableRecipe> dependencies = this.getSatisfiableDependenciesMap().get(r.getName());
            boolean enabled = true;
            if (dependencies != null) {
                for (SatisfiableRecipe recipe : dependencies) {
                    if (recipe.isSatisfied()) continue;
                    enabled = false;
                    break;
                }
            }
            if (!enabled) continue;
            r.register();
        }
    }

    protected void unregisterServices() {
        if (this.repository != null) {
            List<ServiceRecipe> recipes = this.services;
            this.services = null;
            if (recipes != null) {
                for (ServiceRecipe r : recipes) {
                    r.unregister();
                }
            }
        }
    }

    private void destroyComponents() {
        if (this.repository != null) {
            this.repository.destroy();
        }
    }

    private String[] getMissingDependencies() {
        ArrayList<String> missing = new ArrayList<String>();
        Map<String, List<SatisfiableRecipe>> dependencies = this.getSatisfiableDependenciesMap();
        HashSet<SatisfiableRecipe> recipes = new HashSet<SatisfiableRecipe>();
        for (List<SatisfiableRecipe> deps : dependencies.values()) {
            for (SatisfiableRecipe recipe : deps) {
                if (recipe.isSatisfied()) continue;
                recipes.add(recipe);
            }
        }
        for (SatisfiableRecipe recipe : recipes) {
            missing.add(recipe.getOsgiFilter());
        }
        return missing.toArray(new String[missing.size()]);
    }

    public Set<String> getComponentIds() {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        set.addAll(this.componentDefinitionRegistry.getComponentDefinitionNames());
        set.add("blueprintContainer");
        set.add("blueprintBundle");
        set.add("blueprintBundleContext");
        set.add("blueprintConverter");
        return set;
    }

    public Object getComponentInstance(String id) throws NoSuchComponentException {
        if (this.repository == null) {
            throw new NoSuchComponentException(id);
        }
        try {
            LOGGER.debug("Instantiating component {}", (Object)id);
            return this.repository.create(id);
        }
        catch (NoSuchComponentException e) {
            throw e;
        }
        catch (ComponentDefinitionException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new ComponentDefinitionException("Cound not create component instance for " + id, t);
        }
    }

    public ComponentMetadata getComponentMetadata(String id) {
        ComponentMetadata metadata = this.componentDefinitionRegistry.getComponentDefinition(id);
        if (metadata == null) {
            throw new NoSuchComponentException(id);
        }
        return metadata;
    }

    public <T extends ComponentMetadata> Collection<T> getMetadata(Class<T> clazz) {
        Collection metadatas = new ArrayList();
        for (String name : this.componentDefinitionRegistry.getComponentDefinitionNames()) {
            ComponentMetadata component = this.componentDefinitionRegistry.getComponentDefinition(name);
            this.getMetadata(clazz, (Metadata)component, metadatas);
        }
        metadatas = Collections.unmodifiableCollection(metadatas);
        return metadatas;
    }

    private <T extends ComponentMetadata> void getMetadata(Class<T> clazz, Metadata component, Collection<T> metadatas) {
        if (component == null) {
            return;
        }
        if (clazz.isInstance(component)) {
            metadatas.add(clazz.cast(component));
        }
        if (component instanceof BeanMetadata) {
            this.getMetadata(clazz, (Metadata)((BeanMetadata)component).getFactoryComponent(), metadatas);
            for (BeanArgument arg : ((BeanMetadata)component).getArguments()) {
                this.getMetadata(clazz, arg.getValue(), metadatas);
            }
            for (BeanProperty prop : ((BeanMetadata)component).getProperties()) {
                this.getMetadata(clazz, prop.getValue(), metadatas);
            }
        }
        if (component instanceof CollectionMetadata) {
            for (Metadata m : ((CollectionMetadata)component).getValues()) {
                this.getMetadata(clazz, m, metadatas);
            }
        }
        if (component instanceof MapMetadata) {
            for (Metadata m : ((MapMetadata)component).getEntries()) {
                this.getMetadata(clazz, (Metadata)m.getKey(), metadatas);
                this.getMetadata(clazz, m.getValue(), metadatas);
            }
        }
        if (component instanceof PropsMetadata) {
            for (Metadata m : ((PropsMetadata)component).getEntries()) {
                this.getMetadata(clazz, (Metadata)m.getKey(), metadatas);
                this.getMetadata(clazz, m.getValue(), metadatas);
            }
        }
        if (component instanceof ServiceReferenceMetadata) {
            for (ReferenceListener l : ((ServiceReferenceMetadata)component).getReferenceListeners()) {
                this.getMetadata(clazz, (Metadata)l.getListenerComponent(), metadatas);
            }
        }
        if (component instanceof ServiceMetadata) {
            this.getMetadata(clazz, (Metadata)((ServiceMetadata)component).getServiceComponent(), metadatas);
            for (Metadata m : ((ServiceMetadata)component).getServiceProperties()) {
                this.getMetadata(clazz, (Metadata)m.getKey(), metadatas);
                this.getMetadata(clazz, m.getValue(), metadatas);
            }
            for (ReferenceListener l : ((ServiceMetadata)component).getRegistrationListeners()) {
                this.getMetadata(clazz, (Metadata)l.getListenerComponent(), metadatas);
            }
        }
    }

    @Override
    public Converter getConverter() {
        return this.converter;
    }

    @Override
    public ComponentDefinitionRegistryImpl getComponentDefinitionRegistry() {
        return this.componentDefinitionRegistry;
    }

    @Override
    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        this.destroyed = true;
        this.eventDispatcher.blueprintEvent(new BlueprintEvent(3, this.getBundleContext().getBundle(), this.getExtenderBundle()));
        if (this.timeoutFuture != null) {
            this.timeoutFuture.cancel(false);
        }
        if (this.registration != null) {
            this.registration.unregister();
        }
        if (this.handlerSet != null) {
            this.handlerSet.removeListener(this);
            this.handlerSet.destroy();
        }
        this.unregisterServices();
        this.untrackServiceReferences();
        AtomicBoolean atomicBoolean = this.running;
        synchronized (atomicBoolean) {
            while (this.running.get()) {
                try {
                    this.running.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        this.destroyComponents();
        this.eventDispatcher.blueprintEvent(new BlueprintEvent(4, this.getBundleContext().getBundle(), this.getExtenderBundle()));
        LOGGER.debug("Blueprint container destroyed: {}", (Object)this.bundleContext);
    }

    protected void quiesce() {
        this.destroyed = true;
        this.eventDispatcher.blueprintEvent(new BlueprintEvent(3, this.getBundleContext().getBundle(), this.getExtenderBundle()));
        if (this.timeoutFuture != null) {
            this.timeoutFuture.cancel(false);
        }
        if (this.registration != null) {
            this.registration.unregister();
        }
        if (this.handlerSet != null) {
            this.handlerSet.removeListener(this);
            this.handlerSet.destroy();
        }
        LOGGER.debug("Blueprint container quiesced: {}", (Object)this.bundleContext);
    }

    @Override
    public void namespaceHandlerRegistered(URI uri) {
        if (this.namespaces != null && this.namespaces.contains(uri)) {
            this.schedule();
        }
    }

    @Override
    public void namespaceHandlerUnregistered(URI uri) {
        if (this.namespaces != null && this.namespaces.contains(uri)) {
            this.unregisterServices();
            this.untrackServiceReferences();
            this.destroyComponents();
            this.state = State.WaitForNamespaceHandlers;
            this.schedule();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        Unknown,
        WaitForNamespaceHandlers,
        Populated,
        WaitForInitialReferences,
        InitialReferencesSatisfied,
        WaitForInitialReferences2,
        Create,
        Created,
        Failed;

    }
}

