/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.blueprint.di;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.aries.blueprint.di.AbstractRecipe;
import org.apache.aries.blueprint.di.Recipe;
import org.apache.aries.blueprint.utils.ReflectionUtils;
import org.osgi.service.blueprint.container.ComponentDefinitionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionRecipe
extends AbstractRecipe {
    private final List<Recipe> list;
    private final Class typeClass;

    public CollectionRecipe(String name, Class type) {
        super(name);
        if (type == null) {
            throw new NullPointerException("type is null");
        }
        this.typeClass = type;
        this.list = new ArrayList<Recipe>();
    }

    @Override
    public List<Recipe> getDependencies() {
        ArrayList<Recipe> nestedRecipes = new ArrayList<Recipe>(this.list.size());
        for (Recipe recipe : this.list) {
            if (recipe == null) continue;
            nestedRecipes.add(recipe);
        }
        return nestedRecipes;
    }

    @Override
    protected Object internalCreate() throws ComponentDefinitionException {
        Object o;
        Class type = CollectionRecipe.getCollection(this.typeClass);
        if (!ReflectionUtils.hasDefaultConstructor(type)) {
            throw new ComponentDefinitionException("Type does not have a default constructor " + type.getName());
        }
        try {
            o = type.newInstance();
        }
        catch (Exception e) {
            throw new ComponentDefinitionException("Error while creating collection instance: " + type.getName());
        }
        if (!(o instanceof Collection)) {
            throw new ComponentDefinitionException("Specified collection type does not implement the Collection interface: " + type.getName());
        }
        Collection instance = (Collection)o;
        for (Recipe recipe : this.list) {
            Object value;
            if (recipe != null) {
                try {
                    value = recipe.create();
                }
                catch (Exception e) {
                    throw new ComponentDefinitionException("Unable to convert value " + recipe + " to type " + type, (Throwable)e);
                }
            } else {
                value = null;
            }
            instance.add(value);
        }
        return instance;
    }

    public void add(Recipe value) {
        this.list.add(value);
    }

    public static Class getCollection(Class type) {
        if (ReflectionUtils.hasDefaultConstructor(type)) {
            return type;
        }
        if (SortedSet.class.isAssignableFrom(type)) {
            return TreeSet.class;
        }
        if (Set.class.isAssignableFrom(type)) {
            return LinkedHashSet.class;
        }
        if (List.class.isAssignableFrom(type)) {
            return ArrayList.class;
        }
        if (Queue.class.isAssignableFrom(type)) {
            return LinkedList.class;
        }
        return ArrayList.class;
    }
}

