/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.blueprint.ext;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.aries.blueprint.NamespaceHandler;
import org.apache.aries.blueprint.ParserContext;
import org.apache.aries.blueprint.ext.PlaceholdersUtils;
import org.apache.aries.blueprint.ext.PropertyPlaceholder;
import org.apache.aries.blueprint.mutable.MutableBeanMetadata;
import org.apache.aries.blueprint.mutable.MutableCollectionMetadata;
import org.apache.aries.blueprint.mutable.MutableComponentMetadata;
import org.apache.aries.blueprint.mutable.MutableIdRefMetadata;
import org.apache.aries.blueprint.mutable.MutableMapMetadata;
import org.apache.aries.blueprint.mutable.MutableRefMetadata;
import org.apache.aries.blueprint.mutable.MutableServiceReferenceMetadata;
import org.apache.aries.blueprint.mutable.MutableValueMetadata;
import org.osgi.service.blueprint.container.ComponentDefinitionException;
import org.osgi.service.blueprint.reflect.BeanMetadata;
import org.osgi.service.blueprint.reflect.BeanProperty;
import org.osgi.service.blueprint.reflect.CollectionMetadata;
import org.osgi.service.blueprint.reflect.ComponentMetadata;
import org.osgi.service.blueprint.reflect.IdRefMetadata;
import org.osgi.service.blueprint.reflect.Metadata;
import org.osgi.service.blueprint.reflect.NonNullMetadata;
import org.osgi.service.blueprint.reflect.RefMetadata;
import org.osgi.service.blueprint.reflect.ReferenceListMetadata;
import org.osgi.service.blueprint.reflect.ServiceReferenceMetadata;
import org.osgi.service.blueprint.reflect.ValueMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Comment;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtNamespaceHandler
implements NamespaceHandler {
    public static final String BLUEPRINT_NAMESPACE = "http://www.osgi.org/xmlns/blueprint/v1.0.0";
    public static final String BLUEPRINT_EXT_NAMESPACE = "http://aries.apache.org/blueprint/xmlns/blueprint-ext/v1.0.0";
    public static final String PROPERTY_PLACEHOLDER_ELEMENT = "property-placeholder";
    public static final String DEFAULT_PROPERTIES_ELEMENT = "default-properties";
    public static final String PROPERTY_ELEMENT = "property";
    public static final String VALUE_ELEMENT = "value";
    public static final String LOCATION_ELEMENT = "location";
    public static final String ID_ATTRIBUTE = "id";
    public static final String PLACEHOLDER_PREFIX_ATTRIBUTE = "placeholder-prefix";
    public static final String PLACEHOLDER_SUFFIX_ATTRIBUTE = "placeholder-suffix";
    public static final String DEFAULTS_REF_ATTRIBUTE = "defaults-ref";
    public static final String IGNORE_MISSING_LOCATIONS_ATTRIBUTE = "ignore-missing-locations";
    public static final String SYSTEM_PROPERTIES_ATTRIBUTE = "system-properties";
    public static final String SYSTEM_PROPERTIES_NEVER = "never";
    public static final String SYSTEM_PROPERTIES_FALLBACK = "fallback";
    public static final String SYSTEM_PROPERTIES_OVERRIDE = "override";
    public static final String PROXY_METHOD_ATTRIBUTE = "proxy-method";
    public static final String PROXY_METHOD_DEFAULT = "default";
    public static final String PROXY_METHOD_CLASSES = "classes";
    public static final String PROXY_METHOD_GREEDY = "greedy";
    public static final String ROLE_ATTRIBUTE = "role";
    public static final String ROLE_PROCESSOR = "processor";
    public static final String FIELD_INJECTION_ATTRIBUTE = "field-injection";
    private static final Logger LOGGER = LoggerFactory.getLogger(ExtNamespaceHandler.class);
    private int idCounter;

    @Override
    public URL getSchemaLocation(String namespace) {
        return this.getClass().getResource("blueprint-ext.xsd");
    }

    @Override
    public Set<Class> getManagedClasses() {
        return new HashSet<Class>(Arrays.asList(PropertyPlaceholder.class));
    }

    @Override
    public Metadata parse(Element element, ParserContext context) {
        LOGGER.debug("Parsing element {{}}{}", (Object)element.getNamespaceURI(), (Object)element.getLocalName());
        if (ExtNamespaceHandler.nodeNameEquals(element, PROPERTY_PLACEHOLDER_ELEMENT)) {
            return this.parsePropertyPlaceholder(context, element);
        }
        throw new ComponentDefinitionException("Unsupported element: " + element.getNodeName());
    }

    @Override
    public ComponentMetadata decorate(Node node, ComponentMetadata component, ParserContext context) {
        if (node instanceof Attr && ExtNamespaceHandler.nodeNameEquals(node, PROXY_METHOD_ATTRIBUTE)) {
            return this.decorateProxyMethod(node, component, context);
        }
        if (node instanceof Attr && ExtNamespaceHandler.nodeNameEquals(node, ROLE_ATTRIBUTE)) {
            return this.decorateRole(node, component, context);
        }
        if (node instanceof Attr && ExtNamespaceHandler.nodeNameEquals(node, FIELD_INJECTION_ATTRIBUTE)) {
            return this.decorateFieldInjection(node, component, context);
        }
        throw new ComponentDefinitionException("Unsupported node: " + node.getNodeName());
    }

    private ComponentMetadata decorateFieldInjection(Node node, ComponentMetadata component, ParserContext context) {
        if (!(component instanceof BeanMetadata)) {
            throw new ComponentDefinitionException("Attribute " + node.getNodeName() + " can only be used on a <bean> element");
        }
        if (!(component instanceof MutableBeanMetadata)) {
            throw new ComponentDefinitionException("Expected an instanceof MutableBeanMetadata");
        }
        String value = ((Attr)node).getValue();
        ((MutableBeanMetadata)component).setFieldInjection("true".equals(value) || "1".equals(value));
        return component;
    }

    private ComponentMetadata decorateRole(Node node, ComponentMetadata component, ParserContext context) {
        String[] flags;
        if (!(component instanceof BeanMetadata)) {
            throw new ComponentDefinitionException("Attribute " + node.getNodeName() + " can only be used on a <bean> element");
        }
        if (!(component instanceof MutableBeanMetadata)) {
            throw new ComponentDefinitionException("Expected an instance of MutableBeanMetadata");
        }
        boolean processor = false;
        String value = ((Attr)node).getValue();
        for (String flag : flags = value.trim().split(" ")) {
            if (!ROLE_PROCESSOR.equals(flag)) {
                throw new ComponentDefinitionException("Unknown proxy method: " + flag);
            }
            processor = true;
        }
        ((MutableBeanMetadata)component).setProcessor(processor);
        return component;
    }

    private ComponentMetadata decorateProxyMethod(Node node, ComponentMetadata component, ParserContext context) {
        String[] flags;
        if (!(component instanceof ServiceReferenceMetadata)) {
            throw new ComponentDefinitionException("Attribute " + node.getNodeName() + " can only be used on a <reference> or <reference-list> element");
        }
        if (!(component instanceof MutableServiceReferenceMetadata)) {
            throw new ComponentDefinitionException("Expected an instance of MutableServiceReferenceMetadata");
        }
        int method = 0;
        String value = ((Attr)node).getValue();
        for (String flag : flags = value.trim().split(" ")) {
            if (PROXY_METHOD_DEFAULT.equals(flag)) {
                method += 0;
                continue;
            }
            if (PROXY_METHOD_CLASSES.equals(flag)) {
                ++method;
                continue;
            }
            if (PROXY_METHOD_GREEDY.equals(flag)) {
                method += 2;
                continue;
            }
            throw new ComponentDefinitionException("Unknown proxy method: " + flag);
        }
        if ((method & 2) != 0 && !(component instanceof ReferenceListMetadata)) {
            throw new ComponentDefinitionException("Greedy proxying is only available for <reference-list> element");
        }
        ((MutableServiceReferenceMetadata)component).setProxyMethod(method);
        return component;
    }

    private Metadata parsePropertyPlaceholder(ParserContext context, Element element) {
        String systemProperties;
        String ignoreMissingLocations;
        String defaultsRef;
        MutableBeanMetadata metadata = context.createMetadata(MutableBeanMetadata.class);
        metadata.setProcessor(true);
        metadata.setId(this.getId(context, element));
        metadata.setScope("singleton");
        metadata.setRuntimeClass(PropertyPlaceholder.class);
        metadata.setInitMethod("init");
        String prefix = element.hasAttribute(PLACEHOLDER_PREFIX_ATTRIBUTE) ? element.getAttribute(PLACEHOLDER_PREFIX_ATTRIBUTE) : "${";
        metadata.addProperty("placeholderPrefix", (Metadata)ExtNamespaceHandler.createValue(context, prefix));
        String suffix = element.hasAttribute(PLACEHOLDER_SUFFIX_ATTRIBUTE) ? element.getAttribute(PLACEHOLDER_SUFFIX_ATTRIBUTE) : "}";
        metadata.addProperty("placeholderSuffix", (Metadata)ExtNamespaceHandler.createValue(context, suffix));
        String string = defaultsRef = element.hasAttribute(DEFAULTS_REF_ATTRIBUTE) ? element.getAttribute(DEFAULTS_REF_ATTRIBUTE) : null;
        if (defaultsRef != null) {
            metadata.addProperty("defaultProperties", (Metadata)ExtNamespaceHandler.createRef(context, defaultsRef));
        }
        String string2 = ignoreMissingLocations = element.hasAttribute(IGNORE_MISSING_LOCATIONS_ATTRIBUTE) ? element.getAttribute(IGNORE_MISSING_LOCATIONS_ATTRIBUTE) : null;
        if (ignoreMissingLocations != null) {
            metadata.addProperty("ignoreMissingLocations", (Metadata)ExtNamespaceHandler.createValue(context, ignoreMissingLocations));
        }
        String string3 = systemProperties = element.hasAttribute(SYSTEM_PROPERTIES_ATTRIBUTE) ? element.getAttribute(SYSTEM_PROPERTIES_ATTRIBUTE) : null;
        if (systemProperties != null) {
            metadata.addProperty("systemProperties", (Metadata)ExtNamespaceHandler.createValue(context, systemProperties));
        }
        ArrayList<String> locations = new ArrayList<String>();
        NodeList nl = element.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Element e;
            Node node = nl.item(i);
            if (!(node instanceof Element) || !BLUEPRINT_EXT_NAMESPACE.equals((e = (Element)node).getNamespaceURI())) continue;
            if (ExtNamespaceHandler.nodeNameEquals(e, DEFAULT_PROPERTIES_ELEMENT)) {
                if (defaultsRef != null) {
                    throw new ComponentDefinitionException("Only one of defaults-ref attribute or default-properties element is allowed");
                }
                Metadata props = this.parseDefaultProperties(context, metadata, e);
                metadata.addProperty("defaultProperties", props);
                continue;
            }
            if (!ExtNamespaceHandler.nodeNameEquals(e, LOCATION_ELEMENT)) continue;
            locations.add(ExtNamespaceHandler.getTextValue(e));
        }
        if (!locations.isEmpty()) {
            metadata.addProperty("locations", (Metadata)ExtNamespaceHandler.createList(context, locations));
        }
        PlaceholdersUtils.validatePlaceholder(metadata, context.getComponentDefinitionRegistry());
        return metadata;
    }

    private Metadata parseDefaultProperties(ParserContext context, MutableBeanMetadata enclosingComponent, Element element) {
        MutableMapMetadata props = context.createMetadata(MutableMapMetadata.class);
        NodeList nl = element.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Element e;
            Node node = nl.item(i);
            if (!(node instanceof Element) || !BLUEPRINT_EXT_NAMESPACE.equals((e = (Element)node).getNamespaceURI()) || !ExtNamespaceHandler.nodeNameEquals(e, PROPERTY_ELEMENT)) continue;
            BeanProperty prop = context.parseElement(BeanProperty.class, enclosingComponent, e);
            props.addEntry((NonNullMetadata)ExtNamespaceHandler.createValue(context, prop.getName(), String.class.getName()), prop.getValue());
        }
        return props;
    }

    public String getId(ParserContext context, Element element) {
        if (element.hasAttribute(ID_ATTRIBUTE)) {
            return element.getAttribute(ID_ATTRIBUTE);
        }
        return this.generateId(context);
    }

    public void generateIdIfNeeded(ParserContext context, MutableComponentMetadata metadata) {
        if (metadata.getId() == null) {
            metadata.setId(this.generateId(context));
        }
    }

    private String generateId(ParserContext context) {
        String id;
        do {
            id = ".ext-" + ++this.idCounter;
        } while (context.getComponentDefinitionRegistry().containsComponentDefinition(id));
        return id;
    }

    private static ValueMetadata createValue(ParserContext context, String value) {
        return ExtNamespaceHandler.createValue(context, value, null);
    }

    private static ValueMetadata createValue(ParserContext context, String value, String type) {
        MutableValueMetadata m = context.createMetadata(MutableValueMetadata.class);
        m.setStringValue(value);
        m.setType(type);
        return m;
    }

    private static RefMetadata createRef(ParserContext context, String value) {
        MutableRefMetadata m = context.createMetadata(MutableRefMetadata.class);
        m.setComponentId(value);
        return m;
    }

    private static IdRefMetadata createIdRef(ParserContext context, String value) {
        MutableIdRefMetadata m = context.createMetadata(MutableIdRefMetadata.class);
        m.setComponentId(value);
        return m;
    }

    private static CollectionMetadata createList(ParserContext context, List<String> list) {
        MutableCollectionMetadata m = context.createMetadata(MutableCollectionMetadata.class);
        m.setCollectionClass(List.class);
        m.setValueType(String.class.getName());
        for (String v : list) {
            m.addValue((Metadata)ExtNamespaceHandler.createValue(context, v, String.class.getName()));
        }
        return m;
    }

    private static String getTextValue(Element element) {
        StringBuffer value = new StringBuffer();
        NodeList nl = element.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node item = nl.item(i);
            if ((!(item instanceof CharacterData) || item instanceof Comment) && !(item instanceof EntityReference)) continue;
            value.append(item.getNodeValue());
        }
        return value.toString();
    }

    private static boolean nodeNameEquals(Node node, String name) {
        return name.equals(node.getNodeName()) || name.equals(node.getLocalName());
    }

    public static boolean isBlueprintNamespace(String ns) {
        return BLUEPRINT_NAMESPACE.equals(ns);
    }
}

