/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.blueprint.container;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.aries.blueprint.ExtendedServiceReferenceMetadata;
import org.apache.aries.blueprint.container.BlueprintExtender;
import org.apache.aries.blueprint.container.GenericType;
import org.apache.aries.blueprint.container.SatisfiableRecipe;
import org.apache.aries.blueprint.di.AbstractRecipe;
import org.apache.aries.blueprint.di.CollectionRecipe;
import org.apache.aries.blueprint.di.Recipe;
import org.apache.aries.blueprint.services.ExtendedBlueprintContainer;
import org.apache.aries.blueprint.utils.ReflectionUtils;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.service.blueprint.container.ComponentDefinitionException;
import org.osgi.service.blueprint.container.ReifiedType;
import org.osgi.service.blueprint.reflect.ReferenceListener;
import org.osgi.service.blueprint.reflect.ServiceReferenceMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractServiceReferenceRecipe
extends AbstractRecipe
implements ServiceListener,
SatisfiableRecipe {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractServiceReferenceRecipe.class);
    protected final ExtendedBlueprintContainer blueprintContainer;
    protected final ServiceReferenceMetadata metadata;
    protected final CollectionRecipe listenersRecipe;
    protected final List<Recipe> explicitDependencies;
    protected final boolean optional;
    protected final String filter;
    protected List<Listener> listeners;
    private final List<ServiceReference> references = new ArrayList<ServiceReference>();
    private final AtomicBoolean started = new AtomicBoolean();
    private final AtomicBoolean satisfied = new AtomicBoolean();
    private SatisfiableRecipe.SatisfactionListener satisfactionListener;

    protected AbstractServiceReferenceRecipe(String name, ExtendedBlueprintContainer blueprintContainer, ServiceReferenceMetadata metadata, CollectionRecipe listenersRecipe, List<Recipe> explicitDependencies) {
        super(name);
        this.prototype = false;
        this.blueprintContainer = blueprintContainer;
        this.metadata = metadata;
        this.listenersRecipe = listenersRecipe;
        this.explicitDependencies = explicitDependencies;
        this.optional = metadata.getAvailability() == 2;
        this.filter = AbstractServiceReferenceRecipe.createOsgiFilter(metadata);
    }

    public CollectionRecipe getListenersRecipe() {
        return this.listenersRecipe;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(SatisfiableRecipe.SatisfactionListener listener) {
        if (listener == null) {
            throw new NullPointerException("satisfactionListener is null");
        }
        if (this.started.compareAndSet(false, true)) {
            try {
                this.satisfactionListener = listener;
                this.satisfied.set(this.optional);
                List<ServiceReference> list = this.references;
                synchronized (list) {
                    this.getBundleContextForServiceLookup().addServiceListener((ServiceListener)this, this.getOsgiFilter());
                    ServiceReference[] references = this.getBundleContextForServiceLookup().getServiceReferences(null, this.getOsgiFilter());
                    if (references != null) {
                        for (ServiceReference reference : references) {
                            this.references.add(reference);
                            this.track(reference);
                        }
                        this.satisfied.set(this.optional || !this.references.isEmpty());
                    }
                    LOGGER.debug("Found initial references {} for OSGi service {}", (Object)references, (Object)this.getOsgiFilter());
                }
            }
            catch (InvalidSyntaxException e) {
                throw new ComponentDefinitionException((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        if (this.started.compareAndSet(true, false)) {
            List<ServiceReference> list = this.references;
            synchronized (list) {
                this.getBundleContextForServiceLookup().removeServiceListener((ServiceListener)this);
                this.doStop();
                Iterator<ServiceReference> it = this.references.iterator();
                while (it.hasNext()) {
                    ServiceReference ref = it.next();
                    it.remove();
                    this.untrack(ref);
                }
                this.satisfied.set(false);
            }
        }
    }

    protected void doStop() {
    }

    protected boolean isStarted() {
        return this.started.get();
    }

    @Override
    public boolean isSatisfied() {
        return this.satisfied.get();
    }

    @Override
    public List<Recipe> getConstructorDependencies() {
        ArrayList<Recipe> recipes = new ArrayList<Recipe>();
        if (this.explicitDependencies != null) {
            recipes.addAll(this.explicitDependencies);
        }
        return recipes;
    }

    @Override
    public List<Recipe> getDependencies() {
        ArrayList<Recipe> recipes = new ArrayList<Recipe>();
        if (this.listenersRecipe != null) {
            recipes.add(this.listenersRecipe);
        }
        recipes.addAll(this.getConstructorDependencies());
        return recipes;
    }

    @Override
    public String getOsgiFilter() {
        return this.filter;
    }

    protected void createListeners() {
        if (this.listenersRecipe != null) {
            List listeners = (List)this.listenersRecipe.create();
            for (Listener listener : listeners) {
                ArrayList<Class> classList = new ArrayList<Class>();
                Class clz = this.getInterfaceClass();
                if (clz != null) {
                    classList.add(clz);
                } else {
                    classList.add(Object.class);
                }
                listener.init(classList);
            }
            this.listeners = listeners;
        } else {
            this.listeners = Collections.emptyList();
        }
    }

    protected List<Class<?>> loadAllClasses(Iterable<String> interfaceNames) {
        ArrayList classes = new ArrayList();
        for (String name : interfaceNames) {
            Class clazz = this.loadClass(name);
            classes.add(clazz);
        }
        return classes;
    }

    @Override
    protected ReifiedType loadType(String typeName, ClassLoader fromClassLoader) {
        if (typeName == null) {
            return null;
        }
        try {
            return GenericType.parse(typeName, fromClassLoader != null ? fromClassLoader : this.blueprintContainer);
        }
        catch (ClassNotFoundException e) {
            throw new ComponentDefinitionException("Unable to load class " + typeName + " from recipe " + this, (Throwable)e);
        }
    }

    protected Object createProxy(Callable<Object> dispatcher, Set<Class<?>> interfaces) throws Exception {
        if (!interfaces.iterator().hasNext()) {
            return new Object();
        }
        return BlueprintExtender.getProxyManager().createDelegatingProxy(this.blueprintContainer.getBundleContext().getBundle(), interfaces, dispatcher, null);
    }

    public void serviceChanged(ServiceEvent event) {
        int eventType = event.getType();
        ServiceReference ref = event.getServiceReference();
        switch (eventType) {
            case 1: {
                this.serviceAdded(ref);
                break;
            }
            case 2: {
                this.serviceModified(ref);
                break;
            }
            case 4: {
                this.serviceRemoved(ref);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serviceAdded(ServiceReference ref) {
        LOGGER.debug("Tracking reference {} for OSGi service {}", (Object)ref, (Object)this.getOsgiFilter());
        List<ServiceReference> list = this.references;
        synchronized (list) {
            this.references.add(ref);
        }
        this.track(ref);
        this.setSatisfied(true);
    }

    private void serviceModified(ServiceReference ref) {
        this.track(ref);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serviceRemoved(ServiceReference ref) {
        boolean satisfied;
        boolean removed;
        LOGGER.debug("Untracking reference {} for OSGi service {}", (Object)ref, (Object)this.getOsgiFilter());
        List<ServiceReference> list = this.references;
        synchronized (list) {
            removed = this.references.remove(ref);
            satisfied = this.optional || !this.references.isEmpty();
        }
        if (removed) {
            this.untrack(ref);
        }
        this.setSatisfied(satisfied);
    }

    protected Class getInterfaceClass() {
        Class clz = AbstractServiceReferenceRecipe.getRuntimeClass(this.metadata);
        if (clz != null) {
            return clz;
        }
        if (this.metadata.getInterface() != null) {
            return this.loadClass(this.metadata.getInterface());
        }
        return null;
    }

    protected static Class getRuntimeClass(ServiceReferenceMetadata metadata) {
        if (metadata instanceof ExtendedServiceReferenceMetadata && ((ExtendedServiceReferenceMetadata)metadata).getRuntimeInterface() != null) {
            return ((ExtendedServiceReferenceMetadata)metadata).getRuntimeInterface();
        }
        return null;
    }

    protected BundleContext getBundleContextForServiceLookup() {
        BundleContext context;
        if (this.metadata instanceof ExtendedServiceReferenceMetadata && ((ExtendedServiceReferenceMetadata)this.metadata).getRuntimeInterface() != null && (context = ((ExtendedServiceReferenceMetadata)this.metadata).getBundleContext()) != null) {
            return context;
        }
        return this.blueprintContainer.getBundleContext();
    }

    protected void setSatisfied(boolean s) {
        if (this.satisfied.getAndSet(s) != s) {
            LOGGER.debug("Service reference with filter {} satisfied {}", (Object)this.getOsgiFilter(), (Object)this.satisfied);
            this.satisfactionListener.notifySatisfaction(this);
        }
    }

    protected abstract void track(ServiceReference var1);

    protected abstract void untrack(ServiceReference var1);

    protected abstract void retrack();

    protected void updateListeners() {
        if (this.references.isEmpty()) {
            this.unbind(null, null);
        } else {
            this.retrack();
        }
    }

    protected void bind(ServiceReference reference, Object service) {
        if (this.listeners != null) {
            for (Listener listener : this.listeners) {
                if (listener == null) continue;
                listener.bind(reference, service);
            }
        }
    }

    protected void unbind(ServiceReference reference, Object service) {
        if (this.listeners != null) {
            for (Listener listener : this.listeners) {
                if (listener == null) continue;
                listener.unbind(reference, service);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ServiceReference> getServiceReferences() {
        List<ServiceReference> list = this.references;
        synchronized (list) {
            return new ArrayList<ServiceReference>(this.references);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceReference getBestServiceReference() {
        List<ServiceReference> list = this.references;
        synchronized (list) {
            int length = this.references.size();
            if (length == 0) {
                return null;
            }
            int index = 0;
            if (length > 1) {
                int maxRanking = Integer.MIN_VALUE;
                long minId = Long.MAX_VALUE;
                for (int i = 0; i < length; ++i) {
                    Object property = this.references.get(i).getProperty("service.ranking");
                    int ranking = property instanceof Integer ? (Integer)property : 0;
                    long id = (Long)this.references.get(i).getProperty("service.id");
                    if (ranking <= maxRanking && (ranking != maxRanking || id >= minId)) continue;
                    index = i;
                    maxRanking = ranking;
                    minId = id;
                }
            }
            return this.references.get(index);
        }
    }

    private static String createOsgiFilter(ServiceReferenceMetadata metadata) {
        String componentName;
        ArrayList<String> members = new ArrayList<String>();
        String flt = metadata.getFilter();
        if (flt != null && flt.length() > 0) {
            if (!flt.startsWith("(")) {
                flt = "(" + flt + ")";
            }
            members.add(flt);
        }
        String interfaceName = metadata.getInterface();
        Class runtimeClass = AbstractServiceReferenceRecipe.getRuntimeClass(metadata);
        if (runtimeClass != null) {
            interfaceName = runtimeClass.getName();
        }
        if (interfaceName != null && interfaceName.length() > 0) {
            members.add("(objectClass=" + interfaceName + ")");
        }
        if ((componentName = metadata.getComponentName()) != null && componentName.length() > 0) {
            members.add("(osgi.service.blueprint.compname=" + componentName + ")");
        }
        if (members.isEmpty()) {
            throw new IllegalStateException("No constraints were specified on the service reference");
        }
        if (members.size() == 1) {
            return (String)members.get(0);
        }
        StringBuilder sb = new StringBuilder("(&");
        for (String member : members) {
            sb.append(member);
        }
        sb.append(")");
        return sb.toString();
    }

    private static Class[] getInterfaces(Class[] classes) {
        HashSet<Class> interfaces = new HashSet<Class>();
        for (Class clazz : classes) {
            if (!clazz.isInterface()) continue;
            interfaces.add(clazz);
        }
        return AbstractServiceReferenceRecipe.toClassArray(interfaces);
    }

    private static Class[] toClassArray(Set<Class> classes) {
        return classes.toArray(new Class[classes.size()]);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Listener {
        private static final Logger LOGGER = LoggerFactory.getLogger(Listener.class);
        private Object listener;
        private ReferenceListener metadata;
        private ExtendedBlueprintContainer blueprintContainer;
        private Set<Method> bindMethodsReference = new HashSet<Method>();
        private Set<Method> bindMethodsObjectProp = new HashSet<Method>();
        private Set<Method> bindMethodsObject = new HashSet<Method>();
        private Set<Method> unbindMethodsReference = new HashSet<Method>();
        private Set<Method> unbindMethodsObject = new HashSet<Method>();
        private Set<Method> unbindMethodsObjectProp = new HashSet<Method>();

        public void setListener(Object listener) {
            this.listener = listener;
        }

        public void setMetadata(ReferenceListener metadata) {
            this.metadata = metadata;
        }

        public void setBlueprintContainer(ExtendedBlueprintContainer blueprintContainer) {
            this.blueprintContainer = blueprintContainer;
        }

        public void init(Collection<Class> classes) {
            String unbindName;
            HashSet<Class> clazzes = new HashSet<Class>(classes);
            clazzes.add(Object.class);
            Class<?> listenerClass = this.listener.getClass();
            String bindName = this.metadata.getBindMethod();
            if (bindName != null) {
                this.bindMethodsReference.addAll(ReflectionUtils.findCompatibleMethods(listenerClass, bindName, new Class[]{ServiceReference.class}));
                for (Class clazz : clazzes) {
                    this.bindMethodsObject.addAll(ReflectionUtils.findCompatibleMethods(listenerClass, bindName, new Class[]{clazz}));
                    this.bindMethodsObjectProp.addAll(ReflectionUtils.findCompatibleMethods(listenerClass, bindName, new Class[]{clazz, Map.class}));
                }
                if (this.bindMethodsReference.size() + this.bindMethodsObject.size() + this.bindMethodsObjectProp.size() == 0) {
                    throw new ComponentDefinitionException("No matching methods found for listener bind method: " + bindName);
                }
            }
            if ((unbindName = this.metadata.getUnbindMethod()) != null) {
                this.unbindMethodsReference.addAll(ReflectionUtils.findCompatibleMethods(listenerClass, unbindName, new Class[]{ServiceReference.class}));
                for (Class clazz : clazzes) {
                    this.unbindMethodsObject.addAll(ReflectionUtils.findCompatibleMethods(listenerClass, unbindName, new Class[]{clazz}));
                    this.unbindMethodsObjectProp.addAll(ReflectionUtils.findCompatibleMethods(listenerClass, unbindName, new Class[]{clazz, Map.class}));
                }
                if (this.unbindMethodsReference.size() + this.unbindMethodsObject.size() + this.unbindMethodsObjectProp.size() == 0) {
                    throw new ComponentDefinitionException("No matching methods found for listener unbind method: " + unbindName);
                }
            }
        }

        public void bind(ServiceReference reference, Object service) {
            this.invokeMethods(this.bindMethodsReference, this.bindMethodsObject, this.bindMethodsObjectProp, reference, service);
        }

        public void unbind(ServiceReference reference, Object service) {
            this.invokeMethods(this.unbindMethodsReference, this.unbindMethodsObject, this.unbindMethodsObjectProp, reference, service);
        }

        private void invokeMethods(Set<Method> referenceMethods, Set<Method> objectMethods, Set<Method> objectPropMethods, ServiceReference reference, Object service) {
            for (Method method : referenceMethods) {
                try {
                    ReflectionUtils.invoke(this.blueprintContainer.getAccessControlContext(), method, this.listener, reference);
                }
                catch (Exception e) {
                    LOGGER.error("Error calling listener method " + method, (Throwable)e);
                }
            }
            for (Method method : objectMethods) {
                try {
                    ReflectionUtils.invoke(this.blueprintContainer.getAccessControlContext(), method, this.listener, service);
                }
                catch (Exception e) {
                    LOGGER.error("Error calling listener method " + method, (Throwable)e);
                }
            }
            HashMap<String, Object> props = null;
            for (Method method : objectPropMethods) {
                if (props == null) {
                    props = new HashMap<String, Object>();
                    if (reference != null) {
                        for (String name : reference.getPropertyKeys()) {
                            props.put(name, reference.getProperty(name));
                        }
                    }
                }
                try {
                    ReflectionUtils.invoke(this.blueprintContainer.getAccessControlContext(), method, this.listener, service, props);
                }
                catch (Exception e) {
                    LOGGER.error("Error calling listener method " + method, (Throwable)e);
                }
            }
        }
    }
}

