/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.blueprint.container;

import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.aries.blueprint.BeanProcessor;
import org.apache.aries.blueprint.ComponentDefinitionRegistry;
import org.apache.aries.blueprint.Interceptor;
import org.apache.aries.blueprint.container.AggregateConverter;
import org.apache.aries.blueprint.container.BlueprintExtender;
import org.apache.aries.blueprint.container.GenericType;
import org.apache.aries.blueprint.container.ReferenceRecipe;
import org.apache.aries.blueprint.di.AbstractRecipe;
import org.apache.aries.blueprint.di.Recipe;
import org.apache.aries.blueprint.proxy.Collaborator;
import org.apache.aries.blueprint.proxy.ProxyUtils;
import org.apache.aries.blueprint.services.ExtendedBlueprintContainer;
import org.apache.aries.blueprint.utils.ReflectionUtils;
import org.apache.aries.proxy.InvocationListener;
import org.apache.aries.proxy.UnableToProxyException;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.service.blueprint.container.ComponentDefinitionException;
import org.osgi.service.blueprint.container.ReifiedType;
import org.osgi.service.blueprint.reflect.BeanMetadata;
import org.osgi.service.blueprint.reflect.ComponentMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanRecipe
extends AbstractRecipe {
    private static final Logger LOGGER = LoggerFactory.getLogger(BeanRecipe.class);
    private final ExtendedBlueprintContainer blueprintContainer;
    private final LinkedHashMap<String, Object> properties = new LinkedHashMap();
    private final Object type;
    private String initMethod;
    private String destroyMethod;
    private List<Recipe> explicitDependencies;
    private Recipe factory;
    private String factoryMethod;
    private List<Object> arguments;
    private List<String> argTypes;
    private boolean reorderArguments;
    private final boolean allowsFieldInjection;
    private BeanMetadata interceptorLookupKey;
    private static Object UNMATCHED = new Object();

    public BeanRecipe(String name, ExtendedBlueprintContainer blueprintContainer, Object type, boolean allowsFieldInjection) {
        super(name);
        this.blueprintContainer = blueprintContainer;
        this.type = type;
        this.allowsFieldInjection = allowsFieldInjection;
    }

    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    public Map<String, Object> getProperties() {
        return new LinkedHashMap<String, Object>(this.properties);
    }

    public void setProperty(String name, Object value) {
        this.properties.put(name, value);
    }

    public void setFactoryMethod(String method) {
        this.factoryMethod = method;
    }

    public void setFactoryComponent(Recipe factory) {
        this.factory = factory;
    }

    public void setArgTypes(List<String> argTypes) {
        this.argTypes = argTypes;
    }

    public void setArguments(List<Object> arguments) {
        this.arguments = arguments;
    }

    public void setReorderArguments(boolean reorder) {
        this.reorderArguments = reorder;
    }

    public void setInitMethod(String initMethod) {
        this.initMethod = initMethod;
    }

    public String getInitMethod() {
        return this.initMethod;
    }

    public void setDestroyMethod(String destroyMethod) {
        this.destroyMethod = destroyMethod;
    }

    public String getDestroyMethod() {
        return this.destroyMethod;
    }

    public List<Recipe> getExplicitDependencies() {
        return this.explicitDependencies;
    }

    public void setExplicitDependencies(List<Recipe> explicitDependencies) {
        this.explicitDependencies = explicitDependencies;
    }

    public void setInterceptorLookupKey(BeanMetadata metadata) {
        this.interceptorLookupKey = metadata;
    }

    @Override
    public List<Recipe> getConstructorDependencies() {
        ArrayList<Recipe> recipes = new ArrayList<Recipe>();
        if (this.explicitDependencies != null) {
            recipes.addAll(this.explicitDependencies);
        }
        if (this.arguments != null) {
            for (Object argument : this.arguments) {
                if (!(argument instanceof Recipe)) continue;
                recipes.add((Recipe)argument);
            }
        }
        return recipes;
    }

    @Override
    public List<Recipe> getDependencies() {
        ArrayList<Recipe> recipes = new ArrayList<Recipe>();
        for (Object o : this.properties.values()) {
            if (!(o instanceof Recipe)) continue;
            Recipe recipe = (Recipe)o;
            recipes.add(recipe);
        }
        recipes.addAll(this.getConstructorDependencies());
        return recipes;
    }

    private void instantiateExplicitDependencies() {
        if (this.explicitDependencies != null) {
            for (Recipe recipe : this.explicitDependencies) {
                recipe.create();
            }
        }
    }

    @Override
    protected Class loadClass(String className) {
        ClassLoader loader = this.type instanceof Class ? ((Class)this.type).getClassLoader() : null;
        ReifiedType t = this.loadType(className, loader);
        return t != null ? t.getRawClass() : null;
    }

    @Override
    protected ReifiedType loadType(String className) {
        return this.loadType(className, this.type instanceof Class ? ((Class)this.type).getClassLoader() : null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object getInstance() throws ComponentDefinitionException {
        Map.Entry<Executable, List<Object>> match;
        ArrayList<Object> args = new ArrayList<Object>();
        ArrayList<ReifiedType> argTypes = new ArrayList<ReifiedType>();
        if (this.arguments != null) {
            for (int i = 0; i < this.arguments.size(); ++i) {
                Object arg = this.arguments.get(i);
                if (arg instanceof Recipe) {
                    args.add(((Recipe)arg).create());
                } else {
                    args.add(arg);
                }
                if (this.argTypes == null) continue;
                argTypes.add(this.argTypes.get(i) != null ? this.loadType(this.argTypes.get(i)) : null);
            }
        }
        if (this.factory != null) {
            Map<Method, List<Object>> matches;
            Object factoryObj = this.factory.create();
            if (factoryObj instanceof ReferenceRecipe.ServiceProxyWrapper) {
                try {
                    factoryObj = ((ReferenceRecipe.ServiceProxyWrapper)factoryObj).convert(new ReifiedType(Object.class));
                }
                catch (Exception e) {
                    throw new ComponentDefinitionException("Error when instantiating bean " + this.getName() + " of class " + this.getType(), ReflectionUtils.getRealCause(e));
                }
            }
            if ((matches = this.findMatchingMethods(factoryObj.getClass(), this.factoryMethod, true, args, argTypes)).size() == 1) {
                try {
                    Map.Entry<Method, List<Object>> match2 = matches.entrySet().iterator().next();
                    return this.invoke(match2.getKey(), factoryObj, match2.getValue().toArray());
                }
                catch (Throwable e) {
                    throw new ComponentDefinitionException("Error when instantiating bean " + this.getName() + " of class " + this.getType(), ReflectionUtils.getRealCause(e));
                }
            }
            if (matches.size() != 0) throw new ComponentDefinitionException("Multiple matching factory methods " + this.factoryMethod + " found on class " + factoryObj.getClass().getName() + " for arguments " + args + " when instanciating bean " + this.getName() + ": " + matches.keySet());
            throw new ComponentDefinitionException("Unable to find a matching factory method " + this.factoryMethod + " on class " + factoryObj.getClass().getName() + " for arguments " + args + " when instanciating bean " + this.getName());
        }
        if (this.factoryMethod != null) {
            Map<Method, List<Object>> matches = this.findMatchingMethods(this.getType(), this.factoryMethod, false, args, argTypes);
            if (matches.size() == 1) {
                try {
                    match = matches.entrySet().iterator().next();
                    return this.invoke((Method)match.getKey(), null, match.getValue().toArray());
                }
                catch (Throwable e) {
                    throw new ComponentDefinitionException("Error when instanciating bean " + this.getName() + " of class " + this.getType(), ReflectionUtils.getRealCause(e));
                }
            }
            if (matches.size() != 0) throw new ComponentDefinitionException("Multiple matching factory methods " + this.factoryMethod + " found on class " + this.getType().getName() + " for arguments " + args + " when instanciating bean " + this.getName() + ": " + matches.keySet());
            throw new ComponentDefinitionException("Unable to find a matching factory method " + this.factoryMethod + " on class " + this.getType().getName() + " for arguments " + args + " when instanciating bean " + this.getName());
        }
        if (this.getType() == null) {
            throw new ComponentDefinitionException("No factoryMethod nor class is defined for this bean");
        }
        Map<Constructor, List<Object>> matches = this.findMatchingConstructors(this.getType(), args, argTypes);
        if (matches.size() == 1) {
            try {
                match = matches.entrySet().iterator().next();
                return this.newInstance((Constructor)match.getKey(), match.getValue().toArray());
            }
            catch (Throwable e) {
                throw new ComponentDefinitionException("Error when instanciating bean " + this.getName() + " of class " + this.getType(), ReflectionUtils.getRealCause(e));
            }
        }
        if (matches.size() != 0) throw new ComponentDefinitionException("Multiple matching constructors found on class " + this.getType().getName() + " for arguments " + args + " when instanciating bean " + this.getName() + ": " + matches.keySet());
        throw new ComponentDefinitionException("Unable to find a matching constructor on class " + this.getType().getName() + " for arguments " + args + " when instanciating bean " + this.getName());
    }

    private Map<Method, List<Object>> findMatchingMethods(Class type, String name, boolean instance, List<Object> args, List<ReifiedType> types) {
        GenericType argType;
        int i;
        List<Object> match;
        boolean found;
        HashMap<Method, List<Object>> nmatches;
        HashMap<Method, List<Object>> matches = new HashMap<Method, List<Object>>();
        List<Method> methods = new ArrayList<Method>(Arrays.asList(type.getMethods()));
        Iterator it = methods.iterator();
        while (it.hasNext()) {
            Method mth = (Method)it.next();
            if (!mth.getName().equals(name)) {
                it.remove();
                continue;
            }
            if (mth.getParameterTypes().length != args.size()) {
                it.remove();
                continue;
            }
            if (instance ^ !Modifier.isStatic(mth.getModifiers())) {
                it.remove();
                continue;
            }
            if (!mth.isBridge()) continue;
            it.remove();
        }
        if (!instance) {
            methods = BeanRecipe.applyStaticHidingRules(methods);
        }
        if (matches.size() != 1) {
            nmatches = new HashMap<Method, List<Object>>();
            for (Method mth : methods) {
                found = true;
                match = new ArrayList();
                for (i = 0; i < args.size(); ++i) {
                    argType = new GenericType(mth.getGenericParameterTypes()[i]);
                    if (types.get(i) != null && !argType.getRawClass().equals(types.get(i).getRawClass())) {
                        found = false;
                        break;
                    }
                    if (!AggregateConverter.isAssignable(args.get(i), argType)) {
                        found = false;
                        break;
                    }
                    try {
                        match.add(this.convert(args.get(i), mth.getGenericParameterTypes()[i]));
                        continue;
                    }
                    catch (Throwable t) {
                        found = false;
                        break;
                    }
                }
                if (!found) continue;
                nmatches.put(mth, match);
            }
            if (nmatches.size() > 0) {
                matches = nmatches;
            }
        }
        if (matches.size() != 1) {
            nmatches = new HashMap();
            for (Method mth : methods) {
                found = true;
                match = new ArrayList();
                for (i = 0; i < args.size(); ++i) {
                    argType = new GenericType(mth.getGenericParameterTypes()[i]);
                    if (types.get(i) != null && !argType.getRawClass().equals(types.get(i).getRawClass())) {
                        found = false;
                        break;
                    }
                    try {
                        Object val = this.convert(args.get(i), argType);
                        match.add(val);
                        continue;
                    }
                    catch (Throwable t) {
                        found = false;
                        break;
                    }
                }
                if (!found) continue;
                nmatches.put(mth, match);
            }
            if (nmatches.size() > 0) {
                matches = nmatches;
            }
        }
        if (matches.size() != 1 && this.reorderArguments && args.size() > 1) {
            nmatches = new HashMap();
            for (Method mth : methods) {
                ArgumentMatcher matcher = new ArgumentMatcher(mth.getGenericParameterTypes(), false);
                match = matcher.match(args, types);
                if (match == null) continue;
                nmatches.put(mth, match);
            }
            if (nmatches.size() > 0) {
                matches = nmatches;
            }
        }
        if (matches.size() != 1 && this.reorderArguments && args.size() > 1) {
            nmatches = new HashMap();
            for (Method mth : methods) {
                ArgumentMatcher matcher = new ArgumentMatcher(mth.getGenericParameterTypes(), true);
                match = matcher.match(args, types);
                if (match == null) continue;
                nmatches.put(mth, match);
            }
            if (nmatches.size() > 0) {
                matches = nmatches;
            }
        }
        return matches;
    }

    private static List<Method> applyStaticHidingRules(Collection<Method> methods) {
        ArrayList<Method> result = new ArrayList<Method>(methods.size());
        for (Method m : methods) {
            boolean toBeAdded = true;
            Iterator it = result.iterator();
            while (it.hasNext()) {
                Class<?> otherClass;
                Method other = (Method)it.next();
                if (!BeanRecipe.hasIdenticalParameters(m, other)) continue;
                Class<?> mClass = m.getDeclaringClass();
                if (mClass.isAssignableFrom(otherClass = other.getDeclaringClass())) {
                    toBeAdded = false;
                    break;
                }
                if (!otherClass.isAssignableFrom(mClass)) continue;
                it.remove();
            }
            if (!toBeAdded) continue;
            result.add(m);
        }
        return result;
    }

    private static boolean hasIdenticalParameters(Method one, Method two) {
        Class<?>[] twoTypes;
        Class<?>[] oneTypes = one.getParameterTypes();
        if (oneTypes.length != (twoTypes = two.getParameterTypes()).length) {
            return false;
        }
        for (int i = 0; i < oneTypes.length; ++i) {
            if (oneTypes[i].equals(twoTypes[i])) continue;
            return false;
        }
        return true;
    }

    private Map<Constructor, List<Object>> findMatchingConstructors(Class type, List<Object> args, List<ReifiedType> types) {
        GenericType argType;
        int i;
        List<Object> match;
        boolean found;
        HashMap<Constructor, List<Object>> nmatches;
        HashMap<Constructor, List<Object>> matches = new HashMap<Constructor, List<Object>>();
        ArrayList constructors = new ArrayList(Arrays.asList(type.getConstructors()));
        Iterator it = constructors.iterator();
        while (it.hasNext()) {
            if (((Constructor)it.next()).getParameterTypes().length == args.size()) continue;
            it.remove();
        }
        if (matches.size() != 1) {
            nmatches = new HashMap<Constructor, List<Object>>();
            for (Constructor constructor : constructors) {
                found = true;
                match = new ArrayList();
                for (i = 0; i < args.size(); ++i) {
                    argType = new GenericType(constructor.getGenericParameterTypes()[i]);
                    if (types.get(i) != null && !argType.getRawClass().equals(types.get(i).getRawClass())) {
                        found = false;
                        break;
                    }
                    if (!AggregateConverter.isAssignable(args.get(i), argType)) {
                        found = false;
                        break;
                    }
                    try {
                        match.add(this.convert(args.get(i), constructor.getGenericParameterTypes()[i]));
                        continue;
                    }
                    catch (Throwable t) {
                        found = false;
                        break;
                    }
                }
                if (!found) continue;
                nmatches.put(constructor, match);
            }
            if (nmatches.size() > 0) {
                matches = nmatches;
            }
        }
        if (matches.size() != 1) {
            nmatches = new HashMap();
            for (Constructor constructor : constructors) {
                found = true;
                match = new ArrayList();
                for (i = 0; i < args.size(); ++i) {
                    argType = new GenericType(constructor.getGenericParameterTypes()[i]);
                    if (types.get(i) != null && !argType.getRawClass().equals(types.get(i).getRawClass())) {
                        found = false;
                        break;
                    }
                    try {
                        Object val = this.convert(args.get(i), argType);
                        match.add(val);
                        continue;
                    }
                    catch (Throwable t) {
                        found = false;
                        break;
                    }
                }
                if (!found) continue;
                nmatches.put(constructor, match);
            }
            if (nmatches.size() > 0) {
                matches = nmatches;
            }
        }
        if (matches.size() != 1 && this.reorderArguments && this.arguments.size() > 1) {
            nmatches = new HashMap();
            for (Constructor constructor : constructors) {
                ArgumentMatcher matcher = new ArgumentMatcher(constructor.getGenericParameterTypes(), false);
                match = matcher.match(args, types);
                if (match == null) continue;
                nmatches.put(constructor, match);
            }
            if (nmatches.size() > 0) {
                matches = nmatches;
            }
        }
        if (matches.size() != 1 && this.reorderArguments && this.arguments.size() > 1) {
            nmatches = new HashMap();
            for (Constructor constructor : constructors) {
                ArgumentMatcher matcher = new ArgumentMatcher(constructor.getGenericParameterTypes(), true);
                match = matcher.match(args, types);
                if (match == null) continue;
                nmatches.put(constructor, match);
            }
            if (nmatches.size() > 0) {
                matches = nmatches;
            }
        }
        return matches;
    }

    protected Method getInitMethod(Object instance) throws ComponentDefinitionException {
        Method method = null;
        if (this.initMethod != null && this.initMethod.length() > 0 && (method = ReflectionUtils.getLifecycleMethod(instance.getClass(), this.initMethod)) == null) {
            throw new ComponentDefinitionException("Component '" + this.getName() + "' does not have init-method: " + this.initMethod);
        }
        return method;
    }

    public Method getDestroyMethod(Object instance) throws ComponentDefinitionException {
        Method method = null;
        if (instance != null && this.destroyMethod != null && this.destroyMethod.length() > 0 && (method = ReflectionUtils.getLifecycleMethod(instance.getClass(), this.destroyMethod)) == null) {
            throw new ComponentDefinitionException("Component '" + this.getName() + "' does not have destroy-method: " + this.destroyMethod);
        }
        return method;
    }

    private Object runBeanProcPreInit(Object obj) {
        BeanProcessor.BeanCreator initialBeanCreator;
        String beanName = this.getName();
        BeanMetadata beanData = (BeanMetadata)this.blueprintContainer.getComponentDefinitionRegistry().getComponentDefinition(beanName);
        List<BeanProcessor> processors = this.blueprintContainer.getProcessors(BeanProcessor.class);
        BeanProcessor.BeanCreator currentCreator = initialBeanCreator = new BeanProcessor.BeanCreator(){

            public Object getBean() {
                Object obj = BeanRecipe.this.getInstance();
                BeanRecipe.this.setProperties(obj);
                return obj;
            }
        };
        for (BeanProcessor processor : processors) {
            obj = processor.beforeInit(obj, this.getName(), currentCreator, beanData);
            currentCreator = new BeanCreatorChain(currentCreator, processor, beanData, beanName, BeanCreatorChain.ChainType.Before);
        }
        return obj;
    }

    private void runBeanProcInit(Method initMethod, Object obj) {
        if (initMethod != null) {
            try {
                this.invoke(initMethod, obj, null);
            }
            catch (Throwable t) {
                throw new ComponentDefinitionException("Unable to intialize bean " + this.getName(), ReflectionUtils.getRealCause(t));
            }
        }
    }

    private Object runBeanProcPostInit(Object obj) {
        BeanProcessor.BeanCreator initialBeanCreator;
        String beanName = this.getName();
        BeanMetadata beanData = (BeanMetadata)this.blueprintContainer.getComponentDefinitionRegistry().getComponentDefinition(beanName);
        List<BeanProcessor> processors = this.blueprintContainer.getProcessors(BeanProcessor.class);
        BeanProcessor.BeanCreator currentCreator = initialBeanCreator = new BeanProcessor.BeanCreator(){

            public Object getBean() {
                Object obj = BeanRecipe.this.getInstance();
                BeanRecipe.this.setProperties(obj);
                obj = BeanRecipe.this.runBeanProcPreInit(obj);
                BeanRecipe.this.runBeanProcInit(BeanRecipe.this.getInitMethod(obj), obj);
                return obj;
            }
        };
        for (BeanProcessor processor : processors) {
            obj = processor.afterInit(obj, this.getName(), currentCreator, beanData);
            currentCreator = new BeanCreatorChain(currentCreator, processor, beanData, beanName, BeanCreatorChain.ChainType.After);
        }
        return obj;
    }

    private Object addInterceptors(Object original) throws ComponentDefinitionException {
        Object intercepted = null;
        ComponentDefinitionRegistry reg = this.blueprintContainer.getComponentDefinitionRegistry();
        List<Interceptor> interceptors = reg.getInterceptors((ComponentMetadata)this.interceptorLookupKey);
        if (interceptors != null && interceptors.size() > 0) {
            try {
                Bundle b = FrameworkUtil.getBundle(original.getClass());
                if (b == null) {
                    b = this.blueprintContainer.getBundleContext().getBundle();
                }
                intercepted = BlueprintExtender.getProxyManager().createInterceptingProxy(b, ProxyUtils.asList(original.getClass()), original, (InvocationListener)new Collaborator((ComponentMetadata)this.interceptorLookupKey, interceptors));
            }
            catch (UnableToProxyException e) {
                Bundle b = this.blueprintContainer.getBundleContext().getBundle();
                throw new ComponentDefinitionException("Unable to create proxy for bean " + this.name + " in bundle " + b.getSymbolicName() + " version " + b.getVersion(), (Throwable)e);
            }
        } else {
            intercepted = original;
        }
        return intercepted;
    }

    @Override
    protected Object internalCreate() throws ComponentDefinitionException {
        this.instantiateExplicitDependencies();
        Object obj = this.getInstance();
        Method initMethod = this.getInitMethod(obj);
        this.getDestroyMethod(obj);
        this.addPartialObject(obj);
        this.setProperties(obj);
        obj = this.runBeanProcPreInit(obj);
        this.runBeanProcInit(initMethod, obj);
        obj = this.runBeanProcPostInit(obj);
        obj = this.addInterceptors(obj);
        return obj;
    }

    @Override
    public void destroy(Object obj) {
        for (BeanProcessor processor : this.blueprintContainer.getProcessors(BeanProcessor.class)) {
            processor.beforeDestroy(obj, this.getName());
        }
        try {
            Method method = this.getDestroyMethod(obj);
            if (method != null) {
                this.invoke(method, obj, null);
            }
        }
        catch (ComponentDefinitionException e) {
            LOGGER.error(e.getMessage());
        }
        catch (InvocationTargetException ite) {
            Throwable t = ite.getTargetException();
            BundleContext ctx = this.blueprintContainer.getBundleContext();
            Bundle b = ctx.getBundle();
            String bundleIdentifier = b.getSymbolicName() + '/' + b.getVersion();
            LOGGER.error("The blueprint bean " + this.getName() + " in bundle " + bundleIdentifier + " incorrectly threw an exception from its destroy method.", t);
        }
        catch (Exception e) {
            BundleContext ctx = this.blueprintContainer.getBundleContext();
            Bundle b = ctx.getBundle();
            String bundleIdentifier = b.getSymbolicName() + '/' + b.getVersion();
            LOGGER.error("An exception occurred while calling the destroy method of the blueprint bean " + this.getName() + " in bundle " + bundleIdentifier + ".", ReflectionUtils.getRealCause(e));
        }
        for (BeanProcessor processor : this.blueprintContainer.getProcessors(BeanProcessor.class)) {
            processor.afterDestroy(obj, this.getName());
        }
    }

    public void setProperties(Object instance) throws ComponentDefinitionException {
        LinkedHashMap<String, Object> propertyValues = new LinkedHashMap<String, Object>(this.properties);
        this.setProperties(propertyValues, instance, instance.getClass());
    }

    public Class getType() {
        if (this.type instanceof Class) {
            return (Class)this.type;
        }
        if (this.type instanceof String) {
            return this.loadClass((String)this.type);
        }
        return null;
    }

    private void setProperties(Map<String, Object> propertyValues, Object instance, Class clazz) {
        for (Map.Entry<String, Object> entry : propertyValues.entrySet()) {
            String propertyName = entry.getKey();
            Object propertyValue = entry.getValue();
            this.setProperty(instance, clazz, propertyName, propertyValue);
        }
    }

    private void setProperty(Object instance, Class clazz, String propertyName, Object propertyValue) {
        ReflectionUtils.PropertyDescriptor pd;
        String[] names = propertyName.split("\\.");
        for (int i = 0; i < names.length - 1; ++i) {
            ReflectionUtils.PropertyDescriptor pd2 = this.getPropertyDescriptor(clazz, names[i]);
            if (pd2.allowsGet()) {
                try {
                    instance = pd2.get(instance, this.blueprintContainer);
                }
                catch (Exception e) {
                    throw new ComponentDefinitionException("Error getting property: " + names[i] + " on bean " + this.getName() + " when setting property " + propertyName + " on class " + clazz.getName(), ReflectionUtils.getRealCause(e));
                }
                if (instance == null) {
                    throw new ComponentDefinitionException("Error setting compound property " + propertyName + " on bean " + this.getName() + ". Property " + names[i] + " is null");
                }
            } else {
                throw new ComponentDefinitionException("No getter for " + names[i] + " property on bean " + this.getName() + " when setting property " + propertyName + " on class " + clazz.getName());
            }
            clazz = instance.getClass();
        }
        if (propertyValue instanceof Recipe) {
            propertyValue = ((Recipe)propertyValue).create();
        }
        if ((pd = this.getPropertyDescriptor(clazz, names[names.length - 1])).allowsSet()) {
            try {
                pd.set(instance, propertyValue, this.blueprintContainer);
            }
            catch (Exception e) {
                throw new ComponentDefinitionException("Error setting property: " + pd, ReflectionUtils.getRealCause(e));
            }
        } else {
            throw new ComponentDefinitionException("No setter for " + names[names.length - 1] + " property");
        }
    }

    private ReflectionUtils.PropertyDescriptor getPropertyDescriptor(Class<?> clazz, String name) {
        for (ReflectionUtils.PropertyDescriptor pd : ReflectionUtils.getPropertyDescriptors(clazz, this.allowsFieldInjection)) {
            if (!pd.getName().equals(name)) continue;
            return pd;
        }
        throw new ComponentDefinitionException("Unable to find property descriptor " + name + " on class " + clazz.getName());
    }

    private Object invoke(Method method, Object instance, Object ... args) throws Exception {
        return ReflectionUtils.invoke(this.blueprintContainer.getAccessControlContext(), method, instance, args);
    }

    private Object newInstance(Constructor constructor, Object ... args) throws Exception {
        return ReflectionUtils.newInstance(this.blueprintContainer.getAccessControlContext(), constructor, args);
    }

    private static class TypeEntry {
        private final ReifiedType type;
        private Object argument;

        public TypeEntry(ReifiedType type) {
            this.type = type;
            this.argument = UNMATCHED;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ArgumentMatcher {
        private final List<TypeEntry> entries = new ArrayList<TypeEntry>();
        private final boolean convert;

        public ArgumentMatcher(Type[] types, boolean convert) {
            for (Type type : types) {
                this.entries.add(new TypeEntry(new GenericType(type)));
            }
            this.convert = convert;
        }

        public List<Object> match(List<Object> arguments, List<ReifiedType> forcedTypes) {
            if (this.find(arguments, forcedTypes)) {
                return this.getArguments();
            }
            return null;
        }

        private List<Object> getArguments() {
            ArrayList<Object> list = new ArrayList<Object>();
            for (TypeEntry entry : this.entries) {
                if (entry.argument == UNMATCHED) {
                    throw new RuntimeException("There are unmatched types");
                }
                list.add(entry.argument);
            }
            return list;
        }

        private boolean find(List<Object> arguments, List<ReifiedType> forcedTypes) {
            if (this.entries.size() == arguments.size()) {
                boolean matched = true;
                for (int i = 0; i < arguments.size() && matched; ++i) {
                    matched = this.find(arguments.get(i), forcedTypes.get(i));
                }
                return matched;
            }
            return false;
        }

        private boolean find(Object arg, ReifiedType forcedType) {
            for (TypeEntry entry : this.entries) {
                Object val;
                block8: {
                    val = arg;
                    if (entry.argument != UNMATCHED) continue;
                    if (forcedType != null) {
                        if (!forcedType.equals(entry.type)) {
                            continue;
                        }
                    } else if (arg != null) {
                        if (this.convert) {
                            try {
                                val = BeanRecipe.this.convert(arg, entry.type);
                                break block8;
                            }
                            catch (Throwable t) {
                                continue;
                            }
                        }
                        if (!AggregateConverter.isAssignable(arg, entry.type)) continue;
                    }
                }
                entry.argument = val;
                return true;
            }
            return false;
        }
    }

    private static class BeanCreatorChain
    implements BeanProcessor.BeanCreator {
        private final BeanProcessor.BeanCreator parentBeanCreator;
        private final BeanProcessor parentBeanProcessor;
        private final BeanMetadata beanData;
        private final String beanName;
        private final ChainType when;

        public BeanCreatorChain(BeanProcessor.BeanCreator parentBeanCreator, BeanProcessor parentBeanProcessor, BeanMetadata beanData, String beanName, ChainType when) {
            this.parentBeanCreator = parentBeanCreator;
            this.parentBeanProcessor = parentBeanProcessor;
            this.beanData = beanData;
            this.beanName = beanName;
            this.when = when;
        }

        public Object getBean() {
            Object previousBean = this.parentBeanCreator.getBean();
            Object processed = null;
            switch (this.when) {
                case Before: {
                    processed = this.parentBeanProcessor.beforeInit(previousBean, this.beanName, this.parentBeanCreator, this.beanData);
                    break;
                }
                case After: {
                    processed = this.parentBeanProcessor.afterInit(previousBean, this.beanName, this.parentBeanCreator, this.beanData);
                }
            }
            return processed;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum ChainType {
            Before,
            After;

        }
    }
}

