/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.blueprint.di;

import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import org.apache.aries.blueprint.container.GenericType;
import org.apache.aries.blueprint.di.ExecutionContext;
import org.apache.aries.blueprint.di.Recipe;
import org.osgi.service.blueprint.container.ComponentDefinitionException;
import org.osgi.service.blueprint.container.ReifiedType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRecipe
implements Recipe {
    protected final String name;
    protected boolean prototype = true;

    protected AbstractRecipe(String name) {
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public boolean isPrototype() {
        return this.prototype;
    }

    public void setPrototype(boolean prototype) {
        this.prototype = prototype;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Object create() throws ComponentDefinitionException {
        Object result;
        block13: {
            ExecutionContext context = ExecutionContext.Holder.getContext();
            result = context.getPartialObject(this.name);
            if (result != null) {
                return result;
            }
            context.push(this);
            boolean didCreate = false;
            try {
                if (!this.prototype) {
                    FutureTask<Object> objectCreation = new FutureTask<Object>(new Callable<Object>(){

                        @Override
                        public Object call() throws ComponentDefinitionException {
                            return AbstractRecipe.this.internalCreate();
                        }
                    });
                    Future<Object> resultFuture = context.addFullObject(this.name, objectCreation);
                    if (resultFuture == null) {
                        didCreate = true;
                        objectCreation.run();
                        resultFuture = objectCreation;
                    }
                    try {
                        result = resultFuture.get();
                        break block13;
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                        break block13;
                    }
                    catch (ExecutionException ee) {
                        if (ee.getCause() instanceof ComponentDefinitionException) {
                            throw (ComponentDefinitionException)ee.getCause();
                        }
                        if (ee.getCause() instanceof RuntimeException) {
                            throw (RuntimeException)ee.getCause();
                        }
                        throw (Error)ee.getCause();
                    }
                }
                result = this.internalCreate();
            }
            finally {
                Recipe popped;
                if (didCreate) {
                    context.removePartialObject(this.name);
                }
                if ((popped = context.pop()) != this) {
                    throw new IllegalStateException("Internal Error: recipe stack is corrupt: Expected " + this + " to be popped of the stack but was " + popped);
                }
            }
        }
        return result;
    }

    protected abstract Object internalCreate() throws ComponentDefinitionException;

    protected void addPartialObject(Object obj) {
        if (!this.prototype) {
            ExecutionContext.Holder.getContext().addPartialObject(this.name, obj);
        }
    }

    protected Object convert(Object obj, ReifiedType type) throws Exception {
        return ExecutionContext.Holder.getContext().convert(obj, type);
    }

    protected Object convert(Object obj, Type type) throws Exception {
        return ExecutionContext.Holder.getContext().convert(obj, new GenericType(type));
    }

    protected Class loadClass(String className) {
        ReifiedType t = this.loadType(className, null);
        return t != null ? t.getRawClass() : null;
    }

    protected ReifiedType loadType(String typeName) {
        return this.loadType(typeName, null);
    }

    protected ReifiedType loadType(String typeName, ClassLoader fromClassLoader) {
        if (typeName == null) {
            return null;
        }
        try {
            return GenericType.parse(typeName, fromClassLoader != null ? fromClassLoader : ExecutionContext.Holder.getContext());
        }
        catch (ClassNotFoundException e) {
            throw new ComponentDefinitionException("Unable to load class " + typeName + " from recipe " + this, (Throwable)e);
        }
    }

    @Override
    public void destroy(Object instance) {
    }

    @Override
    public List<Recipe> getConstructorDependencies() {
        return Collections.emptyList();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + "name='" + this.name + '\'' + ']';
    }
}

