/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.blueprint.jexl.evaluator;

import java.util.Collection;
import java.util.Dictionary;
import java.util.Map;
import java.util.Set;
import org.apache.aries.blueprint.ext.evaluator.PropertyEvaluator;
import org.apache.aries.blueprint.jexl.evaluator.JexlExpressionParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JexlPropertyEvaluator
implements PropertyEvaluator {
    private static final Logger LOGGER = LoggerFactory.getLogger(JexlPropertyEvaluator.class);
    private JexlExpressionParser jexlParser;
    private Dictionary<String, String> properties;

    public String evaluate(String expression, Dictionary<String, String> properties) {
        JexlExpressionParser parser = this.getJexlParser();
        this.properties = properties;
        try {
            Object obj = parser.evaluate(expression);
            if (obj != null) {
                return obj.toString();
            }
        }
        catch (Exception e) {
            LOGGER.info("Could not evaluate expression: {}", (Object)expression);
            LOGGER.info("Exception:", (Throwable)e);
        }
        return null;
    }

    private synchronized JexlExpressionParser getJexlParser() {
        if (this.jexlParser == null) {
            this.jexlParser = new JexlExpressionParser(this.toMap());
        }
        return this.jexlParser;
    }

    private Map<String, Object> toMap() {
        return new Map<String, Object>(){

            @Override
            public boolean containsKey(Object o) {
                return JexlPropertyEvaluator.this.properties.get(o) != null;
            }

            @Override
            public Object get(Object o) {
                return JexlPropertyEvaluator.this.properties.get(o);
            }

            @Override
            public Object put(String s, Object o) {
                throw new UnsupportedOperationException();
            }

            @Override
            public int size() {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean isEmpty() {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean containsValue(Object o) {
                throw new UnsupportedOperationException();
            }

            @Override
            public Object remove(Object o) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void putAll(Map<? extends String, ? extends Object> map) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void clear() {
                throw new UnsupportedOperationException();
            }

            @Override
            public Set<String> keySet() {
                throw new UnsupportedOperationException();
            }

            @Override
            public Collection<Object> values() {
                throw new UnsupportedOperationException();
            }

            @Override
            public Set<Map.Entry<String, Object>> entrySet() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

