/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.cdi.container.internal.bean;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionPoint;
import org.apache.aries.cdi.container.internal.container.ComponentContext;
import org.apache.aries.cdi.container.internal.container.ContainerState;
import org.apache.aries.cdi.container.internal.container.Mark;
import org.apache.aries.cdi.container.internal.model.ExtendedActivationDTO;
import org.apache.aries.cdi.container.internal.model.ExtendedConfigurationTemplateDTO;
import org.apache.aries.cdi.container.internal.util.Conversions;
import org.apache.aries.cdi.container.internal.util.Sets;
import org.osgi.service.cdi.ConfigurationPolicy;
import org.osgi.service.cdi.annotations.ComponentProperties;
import org.osgi.service.cdi.annotations.ComponentScoped;
import org.osgi.service.cdi.annotations.PID;
import org.osgi.service.cdi.runtime.dto.ComponentDTO;
import org.osgi.service.cdi.runtime.dto.ComponentInstanceDTO;
import org.osgi.service.cdi.runtime.dto.template.ComponentTemplateDTO;

public class ComponentPropertiesBean
implements Bean<Object> {
    private final ComponentTemplateDTO _component;
    private final ContainerState _containerState;
    private final Set<Annotation> _qualifiers;
    private final ExtendedConfigurationTemplateDTO _template;
    private final Set<Type> _types;
    private volatile String _string;
    private volatile InjectionPoint _injectionPoint;

    public ComponentPropertiesBean(ContainerState containerState, ComponentTemplateDTO component, ExtendedConfigurationTemplateDTO template) {
        this._containerState = containerState;
        this._component = component;
        this._template = template;
        this._qualifiers = Sets.hashSet(ComponentProperties.Literal.INSTANCE, Default.Literal.INSTANCE);
        this._types = Sets.hashSet(this._template.injectionPointType, Object.class);
        if (this._template.pid != null) {
            this._qualifiers.add((Annotation)PID.Literal.of((String)this._template.pid, (ConfigurationPolicy)this._template.policy));
        }
    }

    public Object create(CreationalContext<Object> creationalContext) {
        ExtendedActivationDTO current = ComponentContext.With.current();
        Map properties = current == null ? ((ComponentInstanceDTO)((ComponentDTO)this._containerState.containerDTO().components.get((int)0)).instances.get((int)0)).properties : current.instance.properties;
        Objects.requireNonNull(properties);
        if (this._injectionPoint != null) {
            return Conversions.convert(properties).to(this._injectionPoint.getType());
        }
        return Conversions.convert(properties).to(this._template.injectionPointType);
    }

    public void destroy(Object instance, CreationalContext<Object> creationalContext) {
    }

    public Set<Type> getTypes() {
        return this._types;
    }

    public Set<Annotation> getQualifiers() {
        return this._qualifiers;
    }

    public Class<? extends Annotation> getScope() {
        ExtendedActivationDTO current = ComponentContext.With.current();
        if (current == null) {
            return ApplicationScoped.class;
        }
        return ComponentScoped.class;
    }

    public String getName() {
        return null;
    }

    public Set<Class<? extends Annotation>> getStereotypes() {
        return Collections.emptySet();
    }

    public boolean isAlternative() {
        return false;
    }

    public Class<?> getBeanClass() {
        return this._template.beanClass;
    }

    public Set<InjectionPoint> getInjectionPoints() {
        return Collections.emptySet();
    }

    public boolean isNullable() {
        return false;
    }

    public void setInjectionPoint(InjectionPoint injectionPoint) {
        this._injectionPoint = injectionPoint;
    }

    public void setMark(Mark mark) {
        this._qualifiers.add(mark);
    }

    public String toString() {
        if (this._string == null) {
            this._string = "ConfigurationBean[" + (this._template.pid == null ? this._component.name : this._template.pid) + "]";
        }
        return this._string;
    }
}

