/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.cdi.container.internal.container;

import java.util.concurrent.CopyOnWriteArrayList;
import javax.enterprise.inject.spi.Extension;
import org.apache.aries.cdi.container.internal.container.BundleContextExtension;
import org.apache.aries.cdi.container.internal.container.ConfigurationListener;
import org.apache.aries.cdi.container.internal.container.ContainerDeployment;
import org.apache.aries.cdi.container.internal.container.ContainerDeploymentArchive;
import org.apache.aries.cdi.container.internal.container.ContainerEnvironment;
import org.apache.aries.cdi.container.internal.container.ContainerState;
import org.apache.aries.cdi.container.internal.container.ExtensionMetadata;
import org.apache.aries.cdi.container.internal.container.LoggerExtension;
import org.apache.aries.cdi.container.internal.container.Op;
import org.apache.aries.cdi.container.internal.container.Phase;
import org.apache.aries.cdi.container.internal.container.RuntimeExtension;
import org.apache.aries.cdi.container.internal.model.ExtendedExtensionDTO;
import org.apache.aries.cdi.container.internal.model.FactoryComponent;
import org.apache.aries.cdi.container.internal.model.SingleComponent;
import org.apache.aries.cdi.container.internal.util.Syncro;
import org.jboss.weld.bootstrap.WeldBootstrap;
import org.jboss.weld.bootstrap.api.Environment;
import org.jboss.weld.bootstrap.spi.Deployment;
import org.jboss.weld.bootstrap.spi.Metadata;
import org.jboss.weld.util.ServiceLoader;
import org.osgi.service.log.Logger;

public class ContainerBootstrap
extends Phase {
    private volatile WeldBootstrap _bootstrap;
    private final ConfigurationListener.Builder _configurationBuilder;
    private final FactoryComponent.Builder _factoryBuilder;
    private final SingleComponent.Builder _singleBuilder;
    private final Syncro _lock = new Syncro(true);
    private final Logger _log;

    public ContainerBootstrap(ContainerState containerState, ConfigurationListener.Builder configurationBuilder, SingleComponent.Builder singleBuilder, FactoryComponent.Builder factoryBuilder) {
        super(containerState, null);
        this._configurationBuilder = configurationBuilder;
        this._singleBuilder = singleBuilder;
        this._factoryBuilder = factoryBuilder;
        this._log = containerState.containerLogs().getLogger(this.getClass());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean close() {
        try (Syncro syncro = this._lock.open();){
            if (this._bootstrap != null) {
                this._log.debug(l -> l.debug("CCR container bootstrap shutdown on {}", (Object)this._bootstrap));
                this._bootstrap.shutdown();
                this._bootstrap = null;
            }
            boolean bl = true;
            return bl;
        }
        catch (Throwable t) {
            this._log.error(l -> l.error("CCR Failure in container bootstrap shutdown on {}", (Object)this._bootstrap, (Object)t));
            return false;
        }
    }

    @Override
    public Op closeOp() {
        return Op.of(Op.Mode.CLOSE, Op.Type.CONTAINER_BOOTSTRAP, this.containerState.id());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean open() {
        try (Syncro syncro = this._lock.open();){
            if (this.containerState.bundleContext() == null) {
                boolean bl = false;
                return bl;
            }
            if (this._bootstrap != null) {
                boolean bl = true;
                return bl;
            }
            if (this.containerState.containerDTO().components.isEmpty()) {
                boolean bl = false;
                return bl;
            }
            CopyOnWriteArrayList<Metadata<Extension>> extensions = new CopyOnWriteArrayList<Metadata<Extension>>();
            extensions.add(new ExtensionMetadata(new BundleContextExtension(this.containerState.bundleContext()), this.containerState.id()));
            extensions.add(new ExtensionMetadata(new RuntimeExtension(this.containerState, this._configurationBuilder, this._singleBuilder, this._factoryBuilder), this.containerState.id()));
            extensions.add(new ExtensionMetadata(new LoggerExtension(this.containerState), this.containerState.id()));
            Thread currentThread = Thread.currentThread();
            ClassLoader current = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(this.containerState.classLoader());
                ServiceLoader.load(Extension.class, (ClassLoader)this.containerState.classLoader()).forEach(extensions::add);
                this.containerState.containerDTO().extensions.stream().map(ExtendedExtensionDTO.class::cast).map(e -> new ExtensionMetadata((Extension)e.extension.getService(), e.template.serviceFilter)).forEach(extensions::add);
                this._bootstrap = new WeldBootstrap();
                ContainerDeploymentArchive beanDeploymentArchive = new ContainerDeploymentArchive(this.containerState.loader(), this.containerState.id(), this.containerState.beansModel().getBeanClassNames(), this.containerState.beansModel().getBeansXml());
                ContainerDeployment deployment = new ContainerDeployment(extensions, beanDeploymentArchive);
                this._bootstrap.startExtensions(extensions);
                this._bootstrap.startContainer(this.containerState.id(), (Environment)new ContainerEnvironment(), (Deployment)deployment);
                this._bootstrap.startInitialization();
                this._bootstrap.deployBeans();
                this._bootstrap.validateBeans();
                this._bootstrap.endInitialization();
            }
            finally {
                currentThread.setContextClassLoader(current);
            }
            boolean bl = true;
            return bl;
        }
    }

    @Override
    public Op openOp() {
        return Op.of(Op.Mode.OPEN, Op.Type.CONTAINER_BOOTSTRAP, this.containerState.id());
    }
}

