/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.cdi.container.internal.container;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.DefinitionException;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.ProcessBean;
import javax.enterprise.inject.spi.ProcessInjectionPoint;
import javax.enterprise.inject.spi.ProcessProducerField;
import javax.enterprise.inject.spi.ProcessProducerMethod;
import org.apache.aries.cdi.container.internal.container.ContainerState;
import org.apache.aries.cdi.container.internal.model.BeansModel;
import org.apache.aries.cdi.container.internal.model.ComponentPropertiesModel;
import org.apache.aries.cdi.container.internal.model.ExtendedActivationTemplateDTO;
import org.apache.aries.cdi.container.internal.model.ExtendedComponentTemplateDTO;
import org.apache.aries.cdi.container.internal.model.ExtendedConfigurationTemplateDTO;
import org.apache.aries.cdi.container.internal.model.OSGiBean;
import org.apache.aries.cdi.container.internal.model.ReferenceModel;
import org.apache.aries.cdi.container.internal.util.Annotates;
import org.osgi.service.cdi.ComponentType;
import org.osgi.service.cdi.ConfigurationPolicy;
import org.osgi.service.cdi.MaximumCardinality;
import org.osgi.service.cdi.ServiceScope;
import org.osgi.service.cdi.annotations.ComponentProperties;
import org.osgi.service.cdi.annotations.ComponentScoped;
import org.osgi.service.cdi.annotations.FactoryComponent;
import org.osgi.service.cdi.annotations.PID;
import org.osgi.service.cdi.annotations.Reference;
import org.osgi.service.cdi.annotations.SingleComponent;
import org.osgi.service.cdi.reference.BindBeanServiceObjects;
import org.osgi.service.cdi.reference.BindService;
import org.osgi.service.cdi.reference.BindServiceReference;
import org.osgi.service.cdi.runtime.dto.template.ComponentTemplateDTO;

public class DiscoveryExtension
implements Extension {
    private final BeansModel _beansModel;
    private final ComponentTemplateDTO _containerTemplate;
    private final ContainerState _containerState;

    public DiscoveryExtension(ContainerState containerState) {
        this._containerState = containerState;
        this._beansModel = this._containerState.beansModel();
        this._containerTemplate = (ComponentTemplateDTO)this._containerState.containerDTO().template.components.get(0);
    }

    <X> void processAnnotatedType(@Observes ProcessAnnotatedType<X> pat) {
        Class declaringClass = Annotates.declaringClass(pat.getAnnotatedType());
        String className = declaringClass.getName();
        OSGiBean osgiBean = this._beansModel.getOSGiBean(className);
        if (osgiBean == null) {
            return;
        }
        osgiBean.found(true);
    }

    <X> void processBindObject(@Observes ProcessInjectionPoint<X, BindService<?>> pip) {
        this.processInjectionPoint0(pip, true);
    }

    <X> void processBindServiceObjects(@Observes ProcessInjectionPoint<X, BindBeanServiceObjects<?>> pip) {
        this.processInjectionPoint0(pip, true);
    }

    <X> void processBindServiceReference(@Observes ProcessInjectionPoint<X, BindServiceReference<?>> pip) {
        this.processInjectionPoint0(pip, true);
    }

    <X, T> void processInjectionPoint(@Observes ProcessInjectionPoint<X, T> pip) {
        this.processInjectionPoint0(pip, false);
    }

    <X, T> void processInjectionPoint0(ProcessInjectionPoint<X, T> pip, boolean special) {
        InjectionPoint injectionPoint = pip.getInjectionPoint();
        Annotated annotated = injectionPoint.getAnnotated();
        Class declaringClass = Annotates.declaringClass(annotated);
        String className = declaringClass.getName();
        OSGiBean osgiBean = this._beansModel.getOSGiBean(className);
        if (osgiBean == null) {
            return;
        }
        if (special) {
            this.doSpecial(osgiBean, annotated, injectionPoint.getType());
        } else {
            this.doOther(osgiBean, declaringClass, annotated, injectionPoint);
        }
    }

    <X> void processBean(@Observes ProcessBean<X> pb) {
        Class declaringClass = Annotates.declaringClass(pb);
        String className = declaringClass.getName();
        OSGiBean osgiBean = this._beansModel.getOSGiBean(className);
        if (osgiBean == null) {
            return;
        }
        osgiBean.found(true);
        Annotated annotated = pb.getAnnotated();
        try {
            List<String> serviceTypes = Annotates.serviceClassNames(annotated);
            Map<String, Object> componentProperties = Annotates.componentProperties(annotated);
            ServiceScope serviceScope = Annotates.serviceScope(annotated);
            if (annotated.isAnnotationPresent(SingleComponent.class)) {
                this.doSingleComponent(osgiBean, declaringClass, annotated, pb.getBean(), serviceTypes, serviceScope, componentProperties);
            } else if (annotated.isAnnotationPresent(FactoryComponent.class)) {
                this.doFactoryComponent(osgiBean, declaringClass, annotated, pb.getBean(), serviceTypes, serviceScope, componentProperties);
            } else if (!annotated.isAnnotationPresent(ComponentScoped.class)) {
                this.doContainerBean(osgiBean, declaringClass, annotated, pb, pb.getBean().getScope(), serviceTypes, serviceScope, componentProperties);
            }
        }
        catch (Exception e) {
            pb.addDefinitionError((Throwable)e);
        }
    }

    void afterBeanDiscovery(@Observes AfterBeanDiscovery abd, BeanManager beanManager) {
        this._containerState.containerDTO().template.components.stream().filter(template -> template.type != ComponentType.CONTAINER).map(template -> (ExtendedComponentTemplateDTO)((Object)template)).forEach(template -> {
            HashSet visited = new HashSet();
            this.scanComponentBean((ExtendedComponentTemplateDTO)((Object)template), template.bean, beanManager, visited);
        });
        this._beansModel.getOSGiBeans().stream().forEach(osgiBean -> {
            if (!osgiBean.found()) {
                abd.addDefinitionError((Throwable)new DefinitionException(String.format("Did not find bean for %s", osgiBean.getBeanClass())));
            }
        });
    }

    void doComponentProperties(OSGiBean osgiBean, Class<?> declaringClass, InjectionPoint injectionPoint) {
        try {
            ComponentPropertiesModel configurationModel = new ComponentPropertiesModel.Builder(injectionPoint.getType()).declaringClass(declaringClass).injectionPoint(injectionPoint).build();
            osgiBean.addConfiguration(this._containerState, configurationModel.toDTO());
        }
        catch (Exception e) {
            this._containerState.error(e);
        }
    }

    void doContainerBean(OSGiBean osgiBean, Class<?> declaringClass, Annotated annotated, ProcessBean<?> pb, Class<? extends Annotation> scope, List<String> serviceTypeNames, ServiceScope serviceScope, Map<String, Object> componentProperties) {
        String className = declaringClass.getName();
        if (!this._containerTemplate.beans.contains(className)) {
            this._containerTemplate.beans.add(className);
        }
        if (!serviceTypeNames.isEmpty()) {
            if (!scope.equals(ApplicationScoped.class) && !scope.equals(Dependent.class)) {
                pb.addDefinitionError((Throwable)new IllegalStateException(String.format("@Service can only be used on @ApplicationScoped, @Dependent, @SingleComponent, and @FactoryComponent: %s", pb.getBean())));
                return;
            }
            ExtendedActivationTemplateDTO activationTemplate = new ExtendedActivationTemplateDTO();
            activationTemplate.cdiScope = scope;
            activationTemplate.declaringClass = declaringClass;
            if (pb instanceof ProcessProducerField) {
                activationTemplate.producer = ((ProcessProducerField)pb).getAnnotatedProducerField();
            } else if (pb instanceof ProcessProducerMethod) {
                activationTemplate.producer = ((ProcessProducerMethod)pb).getAnnotatedProducerMethod();
            }
            activationTemplate.properties = componentProperties;
            activationTemplate.scope = serviceScope;
            activationTemplate.serviceClasses = serviceTypeNames;
            this._containerTemplate.activations.add(activationTemplate);
        }
        osgiBean.setComponent(this._containerState, this._containerTemplate);
    }

    void doFactoryComponent(OSGiBean osgiBean, Class<?> declaringClass, Annotated annotated, Bean<?> bean, List<String> serviceTypeNames, ServiceScope serviceScope, Map<String, Object> componentProperties) {
        ExtendedComponentTemplateDTO componentTemplate = new ExtendedComponentTemplateDTO();
        componentTemplate.activations = new CopyOnWriteArrayList();
        ExtendedActivationTemplateDTO activationTemplate = new ExtendedActivationTemplateDTO();
        activationTemplate.declaringClass = declaringClass;
        activationTemplate.properties = Collections.emptyMap();
        activationTemplate.scope = serviceScope;
        activationTemplate.serviceClasses = serviceTypeNames;
        componentTemplate.activations.add(activationTemplate);
        componentTemplate.bean = bean;
        componentTemplate.beans = new CopyOnWriteArrayList();
        componentTemplate.configurations = new CopyOnWriteArrayList();
        componentTemplate.name = bean.getName();
        componentTemplate.properties = componentProperties;
        componentTemplate.references = new CopyOnWriteArrayList();
        componentTemplate.type = ComponentType.FACTORY;
        annotated.getAnnotations(PID.class).stream().forEach(PID2 -> {
            ExtendedConfigurationTemplateDTO configurationTemplate = new ExtendedConfigurationTemplateDTO();
            configurationTemplate.declaringClass = declaringClass;
            configurationTemplate.maximumCardinality = MaximumCardinality.ONE;
            configurationTemplate.pid = Optional.of(PID2.value()).map(s -> {
                if (s.equals("$") || s.equals("")) {
                    return componentTemplate.name;
                }
                return s;
            }).orElse(componentTemplate.name);
            configurationTemplate.policy = PID2.policy();
            componentTemplate.configurations.add(configurationTemplate);
        });
        ExtendedConfigurationTemplateDTO configurationTemplate = new ExtendedConfigurationTemplateDTO();
        configurationTemplate.declaringClass = declaringClass;
        configurationTemplate.maximumCardinality = MaximumCardinality.MANY;
        configurationTemplate.pid = Optional.ofNullable(annotated.getAnnotation(FactoryComponent.class)).map(fc -> {
            if (fc.value().equals("$") || fc.value().equals("")) {
                return componentTemplate.name;
            }
            return fc.value();
        }).orElse(componentTemplate.name);
        configurationTemplate.policy = ConfigurationPolicy.REQUIRED;
        componentTemplate.configurations.add(configurationTemplate);
        componentTemplate.beans.add(declaringClass.getName());
        this._containerState.containerDTO().template.components.add(componentTemplate);
        osgiBean.setComponent(this._containerState, componentTemplate);
    }

    void doOther(OSGiBean osgiBean, Class<?> declaringClass, Annotated annotated, InjectionPoint injectionPoint) {
        Reference reference = (Reference)annotated.getAnnotation(Reference.class);
        ComponentProperties componentProperties = (ComponentProperties)annotated.getAnnotation(ComponentProperties.class);
        if (reference != null) {
            this.doReference(osgiBean, annotated, injectionPoint, reference, componentProperties);
        } else if (componentProperties != null) {
            this.doComponentProperties(osgiBean, declaringClass, injectionPoint);
        }
    }

    void doReference(OSGiBean osgiBean, Annotated annotated, InjectionPoint injectionPoint, Reference reference, ComponentProperties componentProperties) {
        if (componentProperties != null) {
            this._containerState.error(new IllegalArgumentException(String.format("Cannot use @Reference and @Configuration on the same injection point {}", injectionPoint)));
            return;
        }
        ReferenceModel.Builder builder = null;
        builder = annotated instanceof AnnotatedParameter ? new ReferenceModel.Builder((AnnotatedParameter)annotated) : new ReferenceModel.Builder((AnnotatedField)annotated);
        try {
            ReferenceModel referenceModel = builder.type(injectionPoint.getType()).build();
            osgiBean.addReference(referenceModel.toDTO());
        }
        catch (Exception e) {
            this._containerState.error(e);
        }
    }

    void doSingleComponent(OSGiBean osgiBean, Class<?> declaringClass, Annotated annotated, Bean<?> bean, List<String> serviceTypes, ServiceScope serviceScope, Map<String, Object> componentProperties) {
        ExtendedComponentTemplateDTO componentTemplate = new ExtendedComponentTemplateDTO();
        componentTemplate.activations = new CopyOnWriteArrayList();
        ExtendedActivationTemplateDTO activationTemplate = new ExtendedActivationTemplateDTO();
        activationTemplate.declaringClass = declaringClass;
        activationTemplate.properties = Collections.emptyMap();
        activationTemplate.scope = serviceScope;
        activationTemplate.serviceClasses = serviceTypes;
        componentTemplate.activations.add(activationTemplate);
        componentTemplate.bean = bean;
        componentTemplate.beans = new CopyOnWriteArrayList();
        componentTemplate.configurations = new CopyOnWriteArrayList();
        componentTemplate.name = bean.getName();
        componentTemplate.properties = componentProperties;
        componentTemplate.references = new CopyOnWriteArrayList();
        componentTemplate.type = ComponentType.SINGLE;
        annotated.getAnnotations(PID.class).stream().forEach(PID2 -> {
            ExtendedConfigurationTemplateDTO configurationTemplate = new ExtendedConfigurationTemplateDTO();
            configurationTemplate.declaringClass = declaringClass;
            configurationTemplate.maximumCardinality = MaximumCardinality.ONE;
            configurationTemplate.pid = Optional.of(PID2.value()).map(s -> {
                if (s.equals("$") || s.equals("")) {
                    return componentTemplate.name;
                }
                return s;
            }).orElse(componentTemplate.name);
            configurationTemplate.pid = PID2.value().equals("$") || PID2.value().equals("") ? componentTemplate.name : PID2.value();
            configurationTemplate.policy = PID2.policy();
            componentTemplate.configurations.add(configurationTemplate);
        });
        if (componentTemplate.configurations.isEmpty()) {
            ExtendedConfigurationTemplateDTO configurationTemplate = new ExtendedConfigurationTemplateDTO();
            configurationTemplate.declaringClass = declaringClass;
            configurationTemplate.maximumCardinality = MaximumCardinality.ONE;
            configurationTemplate.pid = componentTemplate.name;
            configurationTemplate.policy = ConfigurationPolicy.OPTIONAL;
            componentTemplate.configurations.add(configurationTemplate);
        }
        componentTemplate.beans.add(declaringClass.getName());
        this._containerState.containerDTO().template.components.add(componentTemplate);
        osgiBean.setComponent(this._containerState, componentTemplate);
    }

    void doSpecial(OSGiBean osgiBean, Annotated annotated, Type injectionPointType) {
        ReferenceModel.Builder builder = null;
        builder = annotated instanceof AnnotatedParameter ? new ReferenceModel.Builder((AnnotatedParameter)annotated) : new ReferenceModel.Builder((AnnotatedField)annotated);
        try {
            ReferenceModel referenceModel = builder.type(injectionPointType).build();
            osgiBean.addReference(referenceModel.toDTO());
        }
        catch (Exception e) {
            this._containerState.error(e);
        }
    }

    void scanComponentBean(ExtendedComponentTemplateDTO template, Bean<?> bean, BeanManager beanManager, Set<Bean<?>> visited) {
        if (visited.contains(bean)) {
            return;
        }
        visited.add(bean);
        Class beanClass = bean.getBeanClass();
        String className = beanClass.getName();
        OSGiBean osgiBean = this._beansModel.getOSGiBean(className);
        ComponentTemplateDTO currentTemplate = osgiBean.getComponent();
        if (currentTemplate == null) {
            osgiBean.setComponent(this._containerState, template);
        } else if (!currentTemplate.equals((Object)template)) {
            throw new IllegalStateException("Something is wrong here");
        }
        if (!template.beans.contains(className)) {
            template.beans.add(className);
        }
        for (InjectionPoint injectionPoint : bean.getInjectionPoints()) {
            Set beans;
            Bean next;
            if (injectionPoint.getAnnotated().isAnnotationPresent(ComponentProperties.class) || injectionPoint.getAnnotated().isAnnotationPresent(Reference.class) || (next = beanManager.resolve(beans = beanManager.getBeans(injectionPoint.getType(), injectionPoint.getQualifiers().toArray(new Annotation[0])))) == null || next.getScope() != ComponentScoped.class) continue;
            this.scanComponentBean(template, next, beanManager, visited);
        }
    }
}

