/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.cdi.container.internal.container;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import javax.annotation.Priority;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.BeforeShutdown;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.ProcessBean;
import javax.enterprise.inject.spi.ProcessInjectionPoint;
import javax.enterprise.inject.spi.ProcessProducerField;
import javax.enterprise.inject.spi.ProcessProducerMethod;
import javax.enterprise.inject.spi.Producer;
import javax.enterprise.inject.spi.ProducerFactory;
import org.apache.aries.cdi.container.internal.bean.ComponentPropertiesBean;
import org.apache.aries.cdi.container.internal.bean.ReferenceBean;
import org.apache.aries.cdi.container.internal.container.ConfigurationListener;
import org.apache.aries.cdi.container.internal.container.ContainerState;
import org.apache.aries.cdi.container.internal.container.MarkedInjectionPoint;
import org.apache.aries.cdi.container.internal.container.Op;
import org.apache.aries.cdi.container.internal.model.ComponentPropertiesModel;
import org.apache.aries.cdi.container.internal.model.ExtendedActivationDTO;
import org.apache.aries.cdi.container.internal.model.ExtendedActivationTemplateDTO;
import org.apache.aries.cdi.container.internal.model.ExtendedComponentInstanceDTO;
import org.apache.aries.cdi.container.internal.model.ExtendedComponentTemplateDTO;
import org.apache.aries.cdi.container.internal.model.ExtendedConfigurationTemplateDTO;
import org.apache.aries.cdi.container.internal.model.ExtendedReferenceDTO;
import org.apache.aries.cdi.container.internal.model.ExtendedReferenceTemplateDTO;
import org.apache.aries.cdi.container.internal.model.FactoryComponent;
import org.apache.aries.cdi.container.internal.model.OSGiBean;
import org.apache.aries.cdi.container.internal.model.ReferenceModel;
import org.apache.aries.cdi.container.internal.model.SingleComponent;
import org.apache.aries.cdi.container.internal.util.Annotates;
import org.apache.aries.cdi.container.internal.util.Perms;
import org.apache.aries.cdi.container.internal.util.SRs;
import org.osgi.framework.Bundle;
import org.osgi.framework.PrototypeServiceFactory;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cdi.ComponentType;
import org.osgi.service.cdi.ServiceScope;
import org.osgi.service.cdi.annotations.ComponentProperties;
import org.osgi.service.cdi.annotations.ComponentScoped;
import org.osgi.service.cdi.annotations.FactoryComponent;
import org.osgi.service.cdi.annotations.MinimumCardinality;
import org.osgi.service.cdi.annotations.PID;
import org.osgi.service.cdi.annotations.PrototypeRequired;
import org.osgi.service.cdi.annotations.Reference;
import org.osgi.service.cdi.annotations.Reluctant;
import org.osgi.service.cdi.annotations.Service;
import org.osgi.service.cdi.annotations.ServiceInstance;
import org.osgi.service.cdi.annotations.SingleComponent;
import org.osgi.service.cdi.reference.BindBeanServiceObjects;
import org.osgi.service.cdi.reference.BindService;
import org.osgi.service.cdi.reference.BindServiceReference;
import org.osgi.service.cdi.runtime.dto.ComponentDTO;
import org.osgi.service.cdi.runtime.dto.ComponentInstanceDTO;
import org.osgi.service.cdi.runtime.dto.template.ActivationTemplateDTO;
import org.osgi.service.cdi.runtime.dto.template.ComponentTemplateDTO;
import org.osgi.service.cdi.runtime.dto.template.ConfigurationTemplateDTO;
import org.osgi.service.log.Logger;
import org.osgi.util.promise.Promise;

public class RuntimeExtension
implements Extension {
    private final ConfigurationListener.Builder _configurationBuilder;
    private final List<ConfigurationListener> _configurationListeners = new CopyOnWriteArrayList<ConfigurationListener>();
    private final ContainerState _containerState;
    private final ComponentTemplateDTO _containerTemplate;
    private final FactoryComponent.Builder _factoryBuilder;
    private final Logger _log;
    private final List<ServiceRegistration<?>> _registrations = new CopyOnWriteArrayList();
    private final SingleComponent.Builder _singleBuilder;

    public RuntimeExtension(ContainerState containerState, ConfigurationListener.Builder configurationBuilder, SingleComponent.Builder singleBuilder, FactoryComponent.Builder factoryBuilder) {
        this._containerState = containerState;
        this._log = this._containerState.containerLogs().getLogger(this.getClass());
        this._log.debug(l -> l.debug("CCR RuntimeExtension {}", (Object)containerState.bundle()));
        this._configurationBuilder = configurationBuilder;
        this._singleBuilder = singleBuilder;
        this._factoryBuilder = factoryBuilder;
        this._containerTemplate = (ComponentTemplateDTO)this._containerState.containerDTO().template.components.get(0);
    }

    void beforeBeanDiscovery(@Observes BeforeBeanDiscovery bbd) {
        bbd.addQualifier(ComponentProperties.class);
        bbd.addQualifier(MinimumCardinality.class);
        bbd.addQualifier(PID.class);
        bbd.addQualifier(PrototypeRequired.class);
        bbd.addQualifier(Reference.class);
        bbd.addQualifier(Reluctant.class);
        bbd.addQualifier(Service.class);
        bbd.addQualifier(ServiceInstance.class);
        bbd.addScope(ComponentScoped.class, false, false);
        bbd.addStereotype(FactoryComponent.class, new Annotation[0]);
        bbd.addStereotype(SingleComponent.class, new Annotation[0]);
    }

    void processBindObject(@Observes ProcessInjectionPoint<?, BindService<?>> pip) {
        this.processInjectionPoint0(pip, true);
    }

    void processBindServiceObjects(@Observes ProcessInjectionPoint<?, BindBeanServiceObjects<?>> pip) {
        this.processInjectionPoint0(pip, true);
    }

    void processBindServiceReference(@Observes ProcessInjectionPoint<?, BindServiceReference<?>> pip) {
        this.processInjectionPoint0(pip, true);
    }

    void processInjectionPoint(@Observes ProcessInjectionPoint<?, ?> pip) {
        this.processInjectionPoint0(pip, false);
    }

    <X> void processBean(@Observes ProcessBean<X> pb) {
        Class declaringClass = Annotates.declaringClass(pb);
        String className = declaringClass.getName();
        OSGiBean osgiBean = this._containerState.beansModel().getOSGiBean(className);
        if (osgiBean == null) {
            return;
        }
        Annotated annotated = pb.getAnnotated();
        try {
            List<String> serviceTypes = Annotates.serviceClassNames(annotated);
            Map<String, Object> componentProperties = Annotates.componentProperties(annotated);
            ServiceScope serviceScope = Annotates.serviceScope(annotated);
            if (annotated.isAnnotationPresent(SingleComponent.class) || annotated.isAnnotationPresent(FactoryComponent.class)) {
                ActivationTemplateDTO activationTemplate = (ActivationTemplateDTO)osgiBean.getComponent().activations.get(0);
                activationTemplate.scope = serviceScope;
                activationTemplate.serviceClasses = serviceTypes;
                osgiBean.getComponent().properties = componentProperties;
            } else if (!annotated.isAnnotationPresent(ComponentScoped.class) && !serviceTypes.isEmpty()) {
                AnnotatedField producer = null;
                if (pb instanceof ProcessProducerField) {
                    producer = ((ProcessProducerField)pb).getAnnotatedProducerField();
                } else if (pb instanceof ProcessProducerMethod) {
                    producer = ((ProcessProducerMethod)pb).getAnnotatedProducerMethod();
                }
                ExtendedActivationTemplateDTO activationTemplate = null;
                for (ActivationTemplateDTO at : this._containerTemplate.activations) {
                    ExtendedActivationTemplateDTO extended = (ExtendedActivationTemplateDTO)at;
                    if (!extended.declaringClass.equals(declaringClass) || !Objects.equals(extended.producer, producer)) continue;
                    activationTemplate = extended;
                    break;
                }
                if (activationTemplate == null) {
                    activationTemplate = new ExtendedActivationTemplateDTO();
                    activationTemplate.cdiScope = pb.getBean().getScope();
                    activationTemplate.declaringClass = declaringClass;
                    activationTemplate.producer = producer;
                    this._containerTemplate.activations.add(activationTemplate);
                }
                activationTemplate.properties = componentProperties;
                activationTemplate.scope = serviceScope;
                activationTemplate.serviceClasses = serviceTypes;
            }
        }
        catch (Exception e) {
            pb.addDefinitionError((Throwable)e);
        }
    }

    void afterBeanDiscovery(@Observes AfterBeanDiscovery abd, BeanManager bm) {
        abd.addContext((Context)this._containerState.componentContext());
        this._containerState.containerDTO().template.components.forEach(ct -> this.addBeans((ComponentTemplateDTO)ct, abd, bm));
    }

    void afterDeploymentValidation(@Observes @Priority(value=4100) AfterDeploymentValidation adv, BeanManager bm) {
        this._log.debug(l -> l.debug("CCR AfterDeploymentValidation on {}", (Object)this._containerState.bundle()));
        this._containerState.beanManager(bm);
        ComponentDTO componentDTO = (ComponentDTO)this._containerState.containerDTO().components.get(0);
        this._containerState.submit(Op.of(Op.Mode.OPEN, Op.Type.CONTAINER_PUBLISH_SERVICES, this._containerState.id()), () -> this.registerServices(componentDTO, bm)).then(s -> this.initComponents()).then(s -> {
            Hashtable<String, Object> properties = new Hashtable<String, Object>();
            ((Dictionary)properties).put("container.id", this._containerState.id());
            ((Dictionary)properties).put("service.description", "Aries CDI - BeanManager for " + this._containerState.bundle());
            ((Dictionary)properties).put("service.vendor", "Apache Software Foundation");
            ArrayList<String> serviceTypes = new ArrayList<String>();
            serviceTypes.add(BeanManager.class.getName());
            this.registerService(serviceTypes, bm, properties);
            return s;
        });
    }

    void beforeShutdown(@Observes BeforeShutdown bs) {
        this._log.debug(l -> l.debug("CCR BeforeShutdown on {}", (Object)this._containerState.bundle()));
        this._containerState.beanManager(null);
        this._configurationListeners.removeIf(cl -> {
            this._containerState.submit(cl.closeOp(), cl::close).onFailure(f -> this._log.error(l -> l.error("CCR Error while closing configuration listener {} on {}", new Object[]{cl, this._containerState.bundle(), f})));
            return true;
        });
        this._registrations.removeIf(r -> {
            try {
                r.unregister();
            }
            catch (Exception e) {
                this._log.error(l -> l.error("CCR Error while unregistring {} on {}", new Object[]{r, this._containerState.bundle(), e}));
            }
            return true;
        });
    }

    private void addBeans(ComponentTemplateDTO componentTemplate, AfterBeanDiscovery abd, BeanManager bm) {
        ComponentDTO componentDTO = (ComponentDTO)this._containerState.containerDTO().components.get(0);
        componentTemplate.references.stream().map(ExtendedReferenceTemplateDTO.class::cast).forEach(t -> {
            ReferenceBean bean = t.bean;
            bean.setBeanManager(bm);
            if (componentTemplate.type == ComponentType.CONTAINER) {
                ((ComponentInstanceDTO)componentDTO.instances.get((int)0)).references.stream().filter(r -> r.template == t).findFirst().map(ExtendedReferenceDTO.class::cast).ifPresent(r -> bean.setReferenceDTO((ExtendedReferenceDTO)((Object)((Object)r))));
            }
            this._log.debug(l -> l.debug("CCR Adding synthetic bean {} on {}", (Object)bean, (Object)this._containerState.bundle()));
            abd.addBean((Bean)bean);
        });
        componentTemplate.configurations.stream().map(ExtendedConfigurationTemplateDTO.class::cast).filter(t -> Objects.nonNull(t.injectionPointType)).forEach(t -> {
            ComponentPropertiesBean bean = t.bean;
            this._log.debug(l -> l.debug("CCR Adding synthetic bean {} on {}", (Object)bean, (Object)this._containerState.bundle()));
            abd.addBean((Bean)bean);
        });
    }

    private Producer<Object> createProducer(Object producerObject, Bean<Object> bean, BeanManager bm) {
        ProducerFactory producerFactory = null;
        if (producerObject instanceof AnnotatedField) {
            producerFactory = bm.getProducerFactory((AnnotatedField)producerObject, bean);
        } else if (producerObject instanceof AnnotatedMethod) {
            producerFactory = bm.getProducerFactory((AnnotatedMethod)producerObject, bean);
        }
        if (producerFactory == null) {
            return null;
        }
        return producerFactory.createProducer(bean);
    }

    private Promise<Boolean> initComponents() {
        this._containerState.containerDTO().template.components.stream().filter(t -> t.type != ComponentType.CONTAINER).map(ExtendedComponentTemplateDTO.class::cast).forEach(this::initComponent);
        return null;
    }

    private void initComponent(ExtendedComponentTemplateDTO componentTemplateDTO) {
        if (componentTemplateDTO.type == ComponentType.FACTORY) {
            this.initFactoryComponent(componentTemplateDTO);
        } else {
            this.initSingleComponent(componentTemplateDTO);
        }
    }

    private Promise<Boolean> initFactoryComponent(ExtendedComponentTemplateDTO componentTemplateDTO) {
        ConfigurationListener cl = this._configurationBuilder.component(((FactoryComponent.Builder)this._factoryBuilder.template(componentTemplateDTO)).build()).build();
        this._configurationListeners.add(cl);
        return this._containerState.submit(cl.openOp(), cl::open);
    }

    private Promise<Boolean> initSingleComponent(ExtendedComponentTemplateDTO componentTemplateDTO) {
        ConfigurationListener cl = this._configurationBuilder.component(((SingleComponent.Builder)this._singleBuilder.template(componentTemplateDTO)).build()).build();
        this._configurationListeners.add(cl);
        return this._containerState.submit(cl.openOp(), cl::open);
    }

    private boolean matchConfiguration(OSGiBean osgiBean, ProcessInjectionPoint<?, ?> pip) {
        InjectionPoint injectionPoint = pip.getInjectionPoint();
        Class declaringClass = Annotates.declaringClass(injectionPoint.getAnnotated());
        ConfigurationTemplateDTO current = new ComponentPropertiesModel.Builder(injectionPoint.getType()).declaringClass(declaringClass).injectionPoint(injectionPoint).build().toDTO();
        return osgiBean.getComponent().configurations.stream().map(t -> (ExtendedConfigurationTemplateDTO)((Object)t)).filter(t -> current.equals(t)).findFirst().map(t -> {
            MarkedInjectionPoint markedInjectionPoint = new MarkedInjectionPoint(injectionPoint);
            pip.setInjectionPoint((InjectionPoint)markedInjectionPoint);
            t.bean.setInjectionPoint(injectionPoint);
            t.bean.setMark(markedInjectionPoint.getMark());
            return true;
        }).orElse(false);
    }

    private boolean matchReference(OSGiBean osgiBean, ProcessInjectionPoint<?, ?> pip) {
        InjectionPoint injectionPoint = pip.getInjectionPoint();
        Annotated annotated = injectionPoint.getAnnotated();
        ReferenceModel.Builder builder = null;
        builder = annotated instanceof AnnotatedField ? new ReferenceModel.Builder((AnnotatedField)annotated) : (annotated instanceof AnnotatedMethod ? new ReferenceModel.Builder((AnnotatedMethod)annotated) : new ReferenceModel.Builder((AnnotatedParameter)annotated));
        ReferenceModel referenceModel = builder.injectionPoint(injectionPoint).build();
        ExtendedReferenceTemplateDTO current = referenceModel.toDTO();
        return osgiBean.getComponent().references.stream().map(t -> (ExtendedReferenceTemplateDTO)((Object)t)).filter(t -> current.equals(t)).findFirst().map(t -> {
            MarkedInjectionPoint markedInjectionPoint = new MarkedInjectionPoint(injectionPoint);
            pip.setInjectionPoint((InjectionPoint)markedInjectionPoint);
            t.bean.setMark(markedInjectionPoint.getMark());
            this._log.debug(l -> l.debug("CCR maping InjectionPoint {} to reference template {}", (Object)injectionPoint, (Object)t));
            return true;
        }).orElse(false);
    }

    private void processInjectionPoint0(ProcessInjectionPoint<?, ?> pip, boolean special) {
        InjectionPoint injectionPoint = pip.getInjectionPoint();
        Class declaringClass = Annotates.declaringClass(injectionPoint.getAnnotated());
        String className = declaringClass.getName();
        OSGiBean osgiBean = this._containerState.beansModel().getOSGiBean(className);
        if (osgiBean == null) {
            return;
        }
        Annotated annotated = injectionPoint.getAnnotated();
        ComponentProperties componentProperties = (ComponentProperties)annotated.getAnnotation(ComponentProperties.class);
        Reference reference = (Reference)annotated.getAnnotation(Reference.class);
        if ((reference != null || special) && this.matchReference(osgiBean, pip)) {
            return;
        }
        if (componentProperties != null) {
            this.matchConfiguration(osgiBean, pip);
        }
    }

    private void registerService(ExtendedComponentInstanceDTO componentInstance, ExtendedActivationTemplateDTO activationTemplate, final BeanManager bm) {
        Object serviceObject;
        ServiceScope scope = activationTemplate.scope;
        if (activationTemplate.cdiScope == ApplicationScoped.class) {
            scope = ServiceScope.SINGLETON;
        }
        final Context context = bm.getContext(activationTemplate.cdiScope);
        final Bean bean = bm.resolve(bm.getBeans(activationTemplate.declaringClass, new Annotation[]{Any.Literal.INSTANCE}));
        final Producer<Object> producer = this.createProducer(activationTemplate.producer, (Bean<Object>)bean, bm);
        if (scope == ServiceScope.PROTOTYPE) {
            serviceObject = new PrototypeServiceFactory<Object>(){

                public Object getService(Bundle bundle, ServiceRegistration<Object> registration) {
                    CreationalContext cc = bm.createCreationalContext((Contextual)bean);
                    if (producer != null) {
                        return producer.produce(cc);
                    }
                    return context.get((Contextual)bean, cc);
                }

                public void ungetService(Bundle bundle, ServiceRegistration<Object> registration, Object service) {
                }
            };
        } else if (scope == ServiceScope.BUNDLE) {
            serviceObject = new ServiceFactory<Object>(){

                public Object getService(Bundle bundle, ServiceRegistration<Object> registration) {
                    CreationalContext cc = bm.createCreationalContext((Contextual)bean);
                    if (producer != null) {
                        return producer.produce(cc);
                    }
                    return context.get((Contextual)bean, cc);
                }

                public void ungetService(Bundle bundle, ServiceRegistration<Object> registration, Object service) {
                }
            };
        } else {
            CreationalContext cc = bm.createCreationalContext((Contextual)bean);
            serviceObject = producer != null ? producer.produce(cc) : context.get((Contextual)bean, cc);
        }
        Objects.requireNonNull(serviceObject, "The service object is somehow null on " + this);
        Hashtable<String, Object> properties = new Hashtable<String, Object>(componentInstance.componentProperties(activationTemplate.properties));
        ServiceRegistration<?> serviceRegistration = this.registerService(activationTemplate.serviceClasses, serviceObject, properties);
        if (serviceRegistration != null) {
            ExtendedActivationDTO activationDTO = new ExtendedActivationDTO();
            activationDTO.errors = new CopyOnWriteArrayList();
            activationDTO.service = SRs.from(serviceRegistration.getReference());
            activationDTO.template = activationTemplate;
            componentInstance.activations.add(activationDTO);
        }
    }

    private ServiceRegistration<?> registerService(List<String> serviceTypes, Object serviceObject, Dictionary<String, Object> properties) {
        List list = serviceTypes.stream().filter(serviceType -> Perms.hasRegisterServicePermission(serviceType, this._containerState.bundleContext())).collect(Collectors.toList());
        if (list.isEmpty()) {
            return null;
        }
        ServiceRegistration serviceRegistration = this._containerState.bundleContext().registerService(serviceTypes.toArray(new String[0]), serviceObject, properties);
        this._registrations.add(serviceRegistration);
        return serviceRegistration;
    }

    private boolean registerServices(ComponentDTO componentDTO, BeanManager bm) {
        componentDTO.template.activations.stream().map(ExtendedActivationTemplateDTO.class::cast).forEach(a -> this.registerService((ExtendedComponentInstanceDTO)((Object)((Object)componentDTO.instances.get(0))), (ExtendedActivationTemplateDTO)((Object)a), bm));
        return true;
    }
}

