/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.cdi.container.internal.loader;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.aries.cdi.container.internal.loader.BundleClassLoader;
import org.jboss.weld.resources.spi.ResourceLoader;
import org.jboss.weld.resources.spi.ResourceLoadingException;
import org.jboss.weld.serialization.spi.ProxyServices;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;

public class BundleResourcesLoader
implements ProxyServices,
ResourceLoader {
    private static final String ERROR_LOADING_CLASS = "Error loading class ";
    private final ClassLoader _classLoader;

    BundleResourcesLoader(Bundle bundle, Bundle extenderBundle, List<Bundle> additionalBundles) {
        BundleWiring extenderWiring = (BundleWiring)extenderBundle.adapt(BundleWiring.class);
        ArrayList<Bundle> bundles = new ArrayList<Bundle>();
        bundles.add(bundle);
        bundles.add(extenderBundle);
        List requiredWires = extenderWiring.getRequiredWires("osgi.wiring.package");
        for (BundleWire bundleWire : requiredWires) {
            Bundle wireBundle;
            BundleCapability capability = bundleWire.getCapability();
            Map attributes = capability.getAttributes();
            String packageName = (String)attributes.get("osgi.wiring.package");
            if (!packageName.startsWith("org.jboss.weld.") || bundles.contains(wireBundle = bundleWire.getProvider().getBundle())) continue;
            bundles.add(wireBundle);
        }
        bundles.addAll(additionalBundles);
        this._classLoader = new BundleClassLoader(bundles.toArray(new Bundle[0]));
    }

    public void cleanup() {
    }

    public Class<?> classForName(String className) {
        try {
            return this._classLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new ResourceLoadingException(ERROR_LOADING_CLASS + className, (Throwable)e);
        }
        catch (LinkageError e) {
            throw new ResourceLoadingException(ERROR_LOADING_CLASS + className, (Throwable)e);
        }
        catch (TypeNotPresentException e) {
            throw new ResourceLoadingException(ERROR_LOADING_CLASS + className, (Throwable)e);
        }
    }

    public ClassLoader getClassLoader(Class<?> proxiedBeanType) {
        return this._classLoader;
    }

    public Class<?> loadBeanClass(String className) {
        return this.classForName(className);
    }

    public URL getResource(String name) {
        return this._classLoader.getResource(name);
    }

    public Collection<URL> getResources(String name) {
        try {
            return Collections.list(this._classLoader.getResources(name));
        }
        catch (IOException e) {
            return Collections.emptyList();
        }
    }

    public static class Builder {
        private final Bundle bundle;
        private final Bundle extenderBundle;
        private final List<Bundle> additionalBundles = new ArrayList<Bundle>();

        public Builder(Bundle bundle, Bundle extenderBundle) {
            this.bundle = bundle;
            this.extenderBundle = extenderBundle;
        }

        public Builder add(Bundle bundle) {
            this.additionalBundles.add(bundle);
            return this;
        }

        public BundleResourcesLoader build() {
            return new BundleResourcesLoader(this.bundle, this.extenderBundle, this.additionalBundles);
        }
    }
}

