/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.cdi.container.internal.model;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.apache.aries.cdi.container.internal.container.BeanServiceObjectsImpl;
import org.apache.aries.cdi.container.internal.container.ContainerState;
import org.apache.aries.cdi.container.internal.model.Binder;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cdi.reference.BeanServiceObjects;
import org.osgi.service.cdi.reference.BindBeanServiceObjects;
import org.osgi.service.log.Logger;

public class BindBeanServiceObjectsImpl<T>
implements Binder<T>,
BindBeanServiceObjects<T> {
    private final ContainerState _containerState;
    private final Logger _log;
    private final List<ServiceReference<T>> _queue = new CopyOnWriteArrayList<ServiceReference<T>>();
    private final AtomicBoolean _enqueue = new AtomicBoolean(true);
    private volatile Optional<Consumer<BeanServiceObjects<T>>> onAdding = Optional.empty();
    private volatile Optional<Consumer<BeanServiceObjects<T>>> onUpdate = Optional.empty();
    private volatile Optional<Consumer<BeanServiceObjects<T>>> onRemove = Optional.empty();
    private volatile BeanServiceObjects<T> serviceObjects;

    public BindBeanServiceObjectsImpl(ContainerState containerState) {
        this._containerState = containerState;
        this._log = this._containerState.containerLogs().getLogger(this.getClass());
    }

    @Override
    public BindBeanServiceObjectsImpl<T> addingService(ServiceReference<T> reference) {
        if (this._enqueue.get()) {
            this._queue.add(reference);
            return this;
        }
        BundleContext bundleContext = this._containerState.bundleContext();
        this.serviceObjects = new BeanServiceObjectsImpl(bundleContext.getServiceObjects(reference));
        this.onAdding.ifPresent(c -> {
            try {
                c.accept(this.serviceObjects);
            }
            catch (Throwable t) {
                this._log.error(l -> l.error("CCR error in {}", (Object)this, (Object)t));
            }
        });
        return this;
    }

    @Override
    public BindBeanServiceObjectsImpl<T> modifiedService(ServiceReference<T> reference) {
        if (this._enqueue.get()) {
            return this;
        }
        this.onUpdate.ifPresent(c -> {
            try {
                c.accept(this.serviceObjects);
            }
            catch (Throwable t) {
                this._log.error(l -> l.error("CCR error in {}", (Object)this, (Object)t));
            }
        });
        return this;
    }

    @Override
    public BindBeanServiceObjectsImpl<T> removedService(ServiceReference<T> reference) {
        if (this._enqueue.get()) {
            this._queue.remove(reference);
            return this;
        }
        this.onRemove.ifPresent(c -> {
            try {
                c.accept(this.serviceObjects);
            }
            catch (Throwable t) {
                this._log.error(l -> l.error("CCR error in {}", (Object)this, (Object)t));
            }
        });
        return this;
    }

    public void bind() {
        this._enqueue.set(false);
        this._queue.removeIf(reference -> {
            this.addingService((ServiceReference)reference);
            return true;
        });
    }

    public BindBeanServiceObjectsImpl<T> adding(Consumer<BeanServiceObjects<T>> action) {
        this.onAdding = Optional.ofNullable(action);
        return this;
    }

    public BindBeanServiceObjectsImpl<T> modified(Consumer<BeanServiceObjects<T>> consumer) {
        this.onUpdate = Optional.ofNullable(consumer);
        return this;
    }

    public BindBeanServiceObjectsImpl<T> removed(Consumer<BeanServiceObjects<T>> consumer) {
        this.onRemove = Optional.ofNullable(consumer);
        return this;
    }
}

