/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.cdi.container.internal.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.aries.cdi.container.internal.container.ContainerState;
import org.apache.aries.cdi.container.internal.container.Op;
import org.apache.aries.cdi.container.internal.container.ReferenceSync;
import org.apache.aries.cdi.container.internal.model.BindBeanServiceObjectsImpl;
import org.apache.aries.cdi.container.internal.model.BindServiceImpl;
import org.apache.aries.cdi.container.internal.model.BindServiceReferenceImpl;
import org.apache.aries.cdi.container.internal.model.CollectionType;
import org.apache.aries.cdi.container.internal.model.ExtendedReferenceDTO;
import org.apache.aries.cdi.container.internal.model.ExtendedReferenceTemplateDTO;
import org.apache.aries.cdi.container.internal.model.InstanceActivator;
import org.apache.aries.cdi.container.internal.util.Conversions;
import org.apache.aries.cdi.container.internal.util.Filters;
import org.apache.aries.cdi.container.internal.util.Syncro;
import org.osgi.service.cdi.ConfigurationPolicy;
import org.osgi.service.cdi.runtime.dto.ComponentDTO;
import org.osgi.service.cdi.runtime.dto.ComponentInstanceDTO;
import org.osgi.service.cdi.runtime.dto.ConfigurationDTO;
import org.osgi.service.cdi.runtime.dto.ReferenceDTO;
import org.osgi.service.cdi.runtime.dto.template.ComponentTemplateDTO;
import org.osgi.service.cdi.runtime.dto.template.ConfigurationTemplateDTO;
import org.osgi.service.cdi.runtime.dto.template.ReferenceTemplateDTO;
import org.osgi.service.log.Logger;
import org.osgi.util.converter.Converting;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class ExtendedComponentInstanceDTO
extends ComponentInstanceDTO {
    public boolean active;
    public String pid;
    public ComponentTemplateDTO template;
    private final InstanceActivator.Builder<?> _builder;
    private final Long _componentId = _componentIds.incrementAndGet();
    private final ContainerState _containerState;
    private final Logger _log;
    private final AtomicReference<InstanceActivator> _noRequiredDependenciesActivator = new AtomicReference();
    private final Syncro sync = new Syncro(true);
    private static final AtomicLong _componentIds = new AtomicLong();

    public ExtendedComponentInstanceDTO(ContainerState containerState, InstanceActivator.Builder<?> builder) {
        this._containerState = containerState;
        this._builder = builder;
        this._log = this._containerState.containerLogs().getLogger(((Object)((Object)this)).getClass());
    }

    public boolean close() {
        try (Syncro open = this.sync.open();){
            this._containerState.submit(Op.of(Op.Mode.CLOSE, Op.Type.REFERENCES, this.ident()), () -> {
                this.references.removeIf(r -> {
                    ExtendedReferenceDTO referenceDTO = (ExtendedReferenceDTO)((Object)((Object)r));
                    referenceDTO.serviceTracker.close();
                    return true;
                });
                if (this._noRequiredDependenciesActivator.get() != null) {
                    this._containerState.submit(this._noRequiredDependenciesActivator.get().closeOp(), () -> this._noRequiredDependenciesActivator.get().close()).onFailure(f -> {
                        this._log.error(l -> l.error("CCR Error in CLOSE on {}", (Object)this.ident(), f));
                        this._containerState.error((Throwable)f);
                    });
                }
                return true;
            }).onFailure(f -> this._log.error(l -> l.error("CCR Error in component instance stop on {}", (Object)this, f)));
            this.properties = null;
            boolean bl = true;
            return bl;
        }
    }

    public Op closeOp() {
        return Op.of(Op.Mode.CLOSE, this.getType(), this.ident());
    }

    public final boolean configurationsResolved() {
        for (ConfigurationTemplateDTO template : this.template.configurations) {
            if (template.policy != ConfigurationPolicy.REQUIRED) continue;
            boolean found = false;
            for (ConfigurationDTO snapshot : this.configurations) {
                if (snapshot.template != template) continue;
                found = true;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public final boolean referencesResolved() {
        for (ReferenceTemplateDTO template : this.template.references) {
            if (template.minimumCardinality <= 0) continue;
            boolean found = false;
            for (ReferenceDTO snapshot : this.references) {
                if (!snapshot.template.equals(template)) continue;
                ExtendedReferenceDTO extended = (ExtendedReferenceDTO)snapshot;
                if (extended.matches.size() < extended.minimumCardinality) continue;
                found = true;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public boolean open() {
        try (Syncro open = this.sync.open();){
            if (!this.configurationsResolved() || this.properties != null) {
                boolean bl = false;
                return bl;
            }
            ConfigurationDTO containerConfiguration = this.containerConfiguration();
            if (containerConfiguration != null) {
                Boolean enabled = (Boolean)((Converting)Conversions.convert(containerConfiguration.properties.get(this.template.name.concat(".enabled"))).defaultValue((Object)Boolean.TRUE)).to(Boolean.class);
                if (!enabled.booleanValue()) {
                    this._containerState.containerDTO().components.stream().filter(c -> c.template == this.template).forEach(c -> {
                        c.enabled = false;
                    });
                    boolean bl = false;
                    return bl;
                }
                this._containerState.containerDTO().components.stream().filter(c -> c.template == this.template).forEach(c -> {
                    c.enabled = true;
                });
            }
            this.properties = this.componentProperties(null);
            this.template.references.stream().map(ExtendedReferenceTemplateDTO.class::cast).forEach(t -> {
                ExtendedReferenceDTO referenceDTO = new ExtendedReferenceDTO();
                if (t.collectionType == CollectionType.BINDER_SERVICE) {
                    referenceDTO.binder = new BindServiceImpl<Object>(this._containerState);
                } else if (t.collectionType == CollectionType.BINDER_REFERENCE) {
                    referenceDTO.binder = new BindServiceReferenceImpl<Object>(this._containerState);
                } else if (t.collectionType == CollectionType.BINDER_BEAN_SERVICE_OBJECTS) {
                    referenceDTO.binder = new BindBeanServiceObjectsImpl<Object>(this._containerState);
                }
                referenceDTO.matches = new CopyOnWriteArrayList();
                referenceDTO.minimumCardinality = this.minimumCardinality(t.name, t.minimumCardinality);
                referenceDTO.targetFilter = this.targetFilter(t.serviceType, t.name, t.targetFilter);
                referenceDTO.template = t;
                referenceDTO.serviceTracker = new ServiceTracker(this._containerState.bundleContext(), Filters.asFilter(referenceDTO.targetFilter, new Object[0]), (ServiceTrackerCustomizer)new ReferenceSync(this._containerState, referenceDTO, this, this._builder));
                this.references.add(referenceDTO);
            });
            this._containerState.submit(Op.of(Op.Mode.OPEN, Op.Type.REFERENCES, this.ident()), () -> {
                this.references.stream().map(ExtendedReferenceDTO.class::cast).forEach(r -> r.serviceTracker.open());
                return this.referencesResolved();
            }).then(s -> {
                if (((Boolean)s.getValue()).booleanValue()) {
                    this._noRequiredDependenciesActivator.set(((InstanceActivator.Builder)this._builder.setInstance(this)).build());
                    return this._containerState.submit(this._noRequiredDependenciesActivator.get().openOp(), () -> this._noRequiredDependenciesActivator.get().open()).onFailure(f -> {
                        this._log.error(l -> l.error("CCR Error in OPEN on {}", (Object)this.ident(), f));
                        this._containerState.error((Throwable)f);
                    });
                }
                return s;
            });
            boolean bl = true;
            return bl;
        }
    }

    private ConfigurationDTO containerConfiguration() {
        List components = this._containerState.containerDTO().components;
        if (components.isEmpty()) {
            return null;
        }
        List instances = ((ComponentDTO)components.get((int)0)).instances;
        if (instances.isEmpty()) {
            return null;
        }
        List configurations = ((ComponentInstanceDTO)instances.get((int)0)).configurations;
        if (configurations.isEmpty()) {
            return null;
        }
        return (ConfigurationDTO)configurations.get(0);
    }

    public Op openOp() {
        return Op.of(Op.Mode.OPEN, this.getType(), this.ident());
    }

    public Map<String, Object> componentProperties(Map<String, Object> others) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        if (others != null) {
            props.putAll(others);
        }
        props.putAll(this.template.properties);
        ArrayList servicePids = new ArrayList();
        for (ConfigurationTemplateDTO t : this.template.configurations) {
            this.configurations.stream().filter(c -> c.template.equals(t)).findFirst().ifPresent(c -> {
                HashMap copy = new HashMap(c.properties);
                Optional.ofNullable(copy.remove("service.pid")).map(String.class::cast).ifPresent(v -> servicePids.add(v));
                props.putAll(copy);
            });
        }
        if (!servicePids.isEmpty()) {
            props.put("service.pid", servicePids);
        }
        props.put("component.id", this._componentId);
        props.put("component.name", this.template.name);
        return props;
    }

    private Op.Type getType() {
        switch (this.template.type) {
            case SINGLE: {
                return Op.Type.SINGLE_INSTANCE;
            }
            case FACTORY: {
                return Op.Type.FACTORY_INSTANCE;
            }
        }
        return Op.Type.CONTAINER_INSTANCE;
    }

    private int minimumCardinality(String componentName, int minimumCardinality) {
        Objects.requireNonNull(this.properties);
        Objects.requireNonNull(componentName);
        return Optional.ofNullable(this.properties.get(componentName.concat(".cardinality.minimum"))).map(v -> Integer.valueOf(String.valueOf(v))).filter(v -> v >= minimumCardinality).orElse(minimumCardinality);
    }

    private String targetFilter(String serviceType, String componentName, String targetFilter) {
        Objects.requireNonNull(this.properties);
        Objects.requireNonNull(serviceType);
        Objects.requireNonNull(componentName);
        Objects.requireNonNull(targetFilter);
        String base = "(objectClass=".concat(serviceType).concat(")");
        String extraFilter = Optional.ofNullable(this.properties.get(componentName.concat(".target"))).map(v -> v + targetFilter).orElse(targetFilter);
        if (extraFilter.length() == 0) {
            return base;
        }
        return "(&".concat(base).concat(extraFilter).concat(")");
    }

    public String ident() {
        return this.template.name + "[" + this._componentId + "]";
    }
}

