/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.cdi.extension.jaxrs;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.configurator.AnnotatedTypeConfigurator;
import javax.ws.rs.ApplicationPath;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.container.DynamicFeature;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Feature;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.ParamConverterProvider;
import javax.ws.rs.ext.ReaderInterceptor;
import javax.ws.rs.ext.WriterInterceptor;
import org.apache.aries.cdi.extension.jaxrs.Util;
import org.apache.aries.cdi.extension.spi.adapt.FiltersOn;
import org.apache.aries.cdi.extension.spi.adapt.MergeServiceTypes;
import org.apache.aries.cdi.extension.spi.adapt.ProcessPotentialService;
import org.apache.aries.cdi.extension.spi.adapt.RegisterExtension;
import org.apache.aries.cdi.extra.propertytypes.JaxrsApplicationBase;
import org.apache.aries.cdi.extra.propertytypes.JaxrsApplicationSelect;
import org.apache.aries.cdi.extra.propertytypes.JaxrsExtension;
import org.apache.aries.cdi.extra.propertytypes.JaxrsExtensionSelect;
import org.apache.aries.cdi.extra.propertytypes.JaxrsName;
import org.apache.aries.cdi.extra.propertytypes.JaxrsResource;
import org.apache.aries.cdi.extra.propertytypes.JaxrsWhiteboardTarget;
import org.apache.aries.cdi.spi.configuration.Configuration;
import org.osgi.service.cdi.ServiceScope;
import org.osgi.service.cdi.annotations.ServiceInstance;

public class JaxrsCDIExtension
implements Extension {
    private volatile Configuration configuration;
    private final List<AnnotatedType<?>> applications = new CopyOnWriteArrayList();

    void register(@Observes BeforeBeanDiscovery beforeBeanDiscovery, BeanManager manager) {
        manager.fireEvent((Object)new RegisterExtension((Extension)this), new Annotation[0]);
    }

    void getConfiguration(@Observes Configuration configuration) {
        this.configuration = configuration;
    }

    void application(@Observes @FiltersOn(annotations={ApplicationPath.class}) ProcessPotentialService pat, BeanManager beanManager) {
        AnnotatedType annotatedType = pat.getAnnotatedType();
        this.applications.add(annotatedType);
        this.commonProperties(pat, Application.class, true, beanManager);
        if (!annotatedType.isAnnotationPresent(JaxrsApplicationBase.class)) {
            pat.configureAnnotatedType().add((Annotation)JaxrsApplicationBase.Literal.of((String)((ApplicationPath)annotatedType.getAnnotation(ApplicationPath.class)).value()));
        }
    }

    void resource(@Observes @FiltersOn(annotations={Path.class, DELETE.class, GET.class, HEAD.class, OPTIONS.class, PATCH.class, POST.class, PUT.class}) ProcessPotentialService pat, BeanManager beanManager) {
        this.commonProperties(pat, Object.class, false, beanManager);
        if (!pat.getAnnotatedType().isAnnotationPresent(JaxrsResource.class)) {
            pat.configureAnnotatedType().add((Annotation)JaxrsResource.Literal.INSTANCE);
        }
    }

    void containerRequestFilter(@Observes @FiltersOn(types={ContainerRequestFilter.class}) ProcessPotentialService pat, BeanManager beanManager) {
        this.commonProperties(pat, ContainerRequestFilter.class, false, beanManager);
        this.addJaxRsExtension(pat);
    }

    void containerResponseFilter(@Observes @FiltersOn(types={ContainerResponseFilter.class}) ProcessPotentialService pat, BeanManager beanManager) {
        this.commonProperties(pat, ContainerResponseFilter.class, false, beanManager);
        this.addJaxRsExtension(pat);
    }

    void readerInterceptor(@Observes @FiltersOn(types={ReaderInterceptor.class}) ProcessPotentialService pat, BeanManager beanManager) {
        this.commonProperties(pat, ReaderInterceptor.class, false, beanManager);
        this.addJaxRsExtension(pat);
    }

    void writerInterceptor(@Observes @FiltersOn(types={WriterInterceptor.class}) ProcessPotentialService pat, BeanManager beanManager) {
        this.commonProperties(pat, WriterInterceptor.class, false, beanManager);
        this.addJaxRsExtension(pat);
    }

    void messageBodyReader(@Observes @FiltersOn(types={MessageBodyReader.class}) ProcessPotentialService pat, BeanManager beanManager) {
        this.commonProperties(pat, MessageBodyReader.class, false, beanManager);
        this.addJaxRsExtension(pat);
    }

    void messageBodyWriter(@Observes @FiltersOn(types={MessageBodyWriter.class}) ProcessPotentialService pat, BeanManager beanManager) {
        this.commonProperties(pat, MessageBodyWriter.class, false, beanManager);
        this.addJaxRsExtension(pat);
    }

    void contextResolver(@Observes @FiltersOn(types={ContextResolver.class}) ProcessPotentialService pat, BeanManager beanManager) {
        this.commonProperties(pat, ContextResolver.class, false, beanManager);
        this.addJaxRsExtension(pat);
    }

    void exceptionMapper(@Observes @FiltersOn(types={ExceptionMapper.class}) ProcessPotentialService pat, BeanManager beanManager) {
        this.commonProperties(pat, ExceptionMapper.class, false, beanManager);
        this.addJaxRsExtension(pat);
    }

    void paramConverterProvider(@Observes @FiltersOn(types={ParamConverterProvider.class}) ProcessPotentialService pat, BeanManager beanManager) {
        this.commonProperties(pat, ParamConverterProvider.class, false, beanManager);
        this.addJaxRsExtension(pat);
    }

    void feature(@Observes @FiltersOn(types={Feature.class}) ProcessPotentialService pat, BeanManager beanManager) {
        this.commonProperties(pat, Feature.class, false, beanManager);
        this.addJaxRsExtension(pat);
    }

    void dynamicFeature(@Observes @FiltersOn(types={DynamicFeature.class}) ProcessPotentialService pat, BeanManager beanManager) {
        this.commonProperties(pat, DynamicFeature.class, false, beanManager);
        this.addJaxRsExtension(pat);
    }

    private void addJaxRsExtension(ProcessPotentialService pat) {
        if (!pat.getAnnotatedType().isAnnotationPresent(JaxrsExtension.class)) {
            pat.configureAnnotatedType().add((Annotation)JaxrsExtension.Literal.INSTANCE);
        }
    }

    private void commonProperties(ProcessPotentialService pat, Class<?> serviceType, boolean application, BeanManager beanManager) {
        Class<? extends Annotation> beanScope;
        beanManager.fireEvent((Object)MergeServiceTypes.forEvent((ProcessPotentialService)pat).withTypes(new Class[]{serviceType}).build(), new Annotation[0]);
        AnnotatedTypeConfigurator configurator = pat.configureAnnotatedType();
        AnnotatedType annotatedType = pat.getAnnotatedType();
        if (!annotatedType.isAnnotationPresent(JaxrsName.class)) {
            if (application) {
                configurator.add((Annotation)JaxrsName.Literal.of((String)Optional.ofNullable((String)this.configuration.get((Object)"osgi.jaxrs.name")).orElse(".default")));
            } else {
                configurator.add((Annotation)JaxrsName.Literal.of((String)annotatedType.getJavaClass().getSimpleName()));
            }
        }
        if (!application && !annotatedType.isAnnotationPresent(JaxrsApplicationSelect.class)) {
            Optional.ofNullable((String)this.configuration.get((Object)"osgi.jaxrs.application.select")).ifPresent(select -> configurator.add((Annotation)JaxrsApplicationSelect.Literal.of((String)select)));
        }
        if (!annotatedType.isAnnotationPresent(JaxrsExtensionSelect.class)) {
            Optional.ofNullable((String[])this.configuration.get((Object)"osgi.jaxrs.extension.select")).ifPresent(selects -> {
                if (((String[])selects).length > 0) {
                    configurator.add((Annotation)JaxrsExtensionSelect.Literal.of((String[])selects));
                }
            });
        }
        if (!annotatedType.isAnnotationPresent(JaxrsWhiteboardTarget.class)) {
            Optional.ofNullable((String)this.configuration.get((Object)"osgi.jaxrs.whiteboard.target")).ifPresent(target -> configurator.add((Annotation)JaxrsWhiteboardTarget.Literal.of((String)target)));
        }
        if (!annotatedType.isAnnotationPresent(ServiceInstance.class) && Dependent.class.equals(beanScope = Util.beanScope((Annotated)annotatedType, Dependent.class))) {
            configurator.add((Annotation)ServiceInstance.Literal.of((ServiceScope)ServiceScope.PROTOTYPE));
        }
    }

    void afterDeploymentValidation(@Observes AfterDeploymentValidation adv) {
        if (this.applications.size() > 1) {
            // empty if block
        }
    }
}

