/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.cdi.extension.jaxrs;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import javax.enterprise.context.NormalScope;
import javax.enterprise.inject.spi.Annotated;
import javax.inject.Scope;

public class Util {
    private static final Predicate<Annotation> isScope = annotation -> annotation.annotationType().isAnnotationPresent(Scope.class) || annotation.annotationType().isAnnotationPresent(NormalScope.class);

    public static Class<? extends Annotation> beanScope(Annotated annotated, Class<? extends Annotation> defaultValue) {
        Class scope = Util.collect(annotated.getAnnotations()).stream().filter(isScope).map(Annotation::annotationType).findFirst().orElse(null);
        return scope == null ? defaultValue : scope;
    }

    private static List<Annotation> collect(Collection<Annotation> annotations) {
        ArrayList<Annotation> list = new ArrayList<Annotation>();
        for (Annotation a1 : annotations) {
            if (a1.annotationType().getName().startsWith("java.lang.annotation.")) continue;
            list.add(a1);
        }
        list.addAll(Util.inherit(list));
        return list;
    }

    private static List<Annotation> inherit(Collection<Annotation> annotations) {
        ArrayList<Annotation> list = new ArrayList<Annotation>();
        for (Annotation a1 : annotations) {
            for (Annotation a2 : Util.collect(Arrays.asList(a1.annotationType().getAnnotations()))) {
                if (list.contains(a2)) continue;
                list.add(a2);
            }
        }
        return list;
    }
}

