/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.cdi.extension.servlet.owb;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Optional;
import javax.annotation.Priority;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.BeanManager;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpSessionListener;
import org.apache.aries.cdi.extension.servlet.common.BaseServletExtension;
import org.apache.aries.cdi.owb.spi.StartObjectSupplier;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.servlet.WebBeansConfigurationListener;
import org.apache.webbeans.spi.ContainerLifecycle;
import org.apache.webbeans.web.lifecycle.test.MockServletContext;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class OWBServletExtension
extends BaseServletExtension
implements StartObjectSupplier {
    private final BundleContext bundleContext;
    private final ServletContext proxyContext;
    private final ServletContextEvent startEvent;
    private volatile ServletContext delegateContext;
    private static final String[] LISTENER_CLASSES = new String[]{ServletContextListener.class.getName(), ServletRequestListener.class.getName(), HttpSessionListener.class.getName()};

    protected OWBServletExtension() {
        this.bundleContext = null;
        this.proxyContext = null;
        this.startEvent = null;
    }

    public OWBServletExtension(Bundle bundle) {
        this.startEvent = new ServletContextEvent((ServletContext)new MockServletContext()){

            public ServletContext getServletContext() {
                return OWBServletExtension.this.proxyContext;
            }
        };
        this.bundleContext = bundle.getBundleContext();
        this.proxyContext = (ServletContext)ServletContext.class.cast(Proxy.newProxyInstance(ServletContext.class.getClassLoader(), new Class[]{ServletContext.class}, (proxy, method, args) -> {
            try {
                return method.invoke((Object)Optional.ofNullable(this.delegateContext).orElseGet(() -> ((ServletContextEvent)this.startEvent).getServletContext()), args);
            }
            catch (InvocationTargetException ite) {
                throw ite.getTargetException();
            }
        }));
    }

    public void setDelegate(ServletContext delegateContext) {
        this.delegateContext = delegateContext;
    }

    void afterDeploymentValidation(@Observes @Priority(value=3800) AfterDeploymentValidation adv, BeanManager beanManager) {
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        ((Dictionary)properties).put("service.description", "Aries CDI - HTTP Portable Extension for OpenWebBeans");
        ((Dictionary)properties).put("service.vendor", "Apache Software Foundation");
        ((Dictionary)properties).put("osgi.http.whiteboard.context.select", this.configuration.get((Object)"osgi.http.whiteboard.context.select"));
        ((Dictionary)properties).put("osgi.http.whiteboard.listener", Boolean.TRUE.toString());
        ((Dictionary)properties).put("service.ranking", 2147483547);
        this._listenerRegistration = this.bundleContext.registerService(LISTENER_CLASSES, (Object)new CdiListener(WebBeansContext.currentInstance()), properties);
    }

    public Object getStartObject() {
        return this.startEvent;
    }

    private class CdiListener
    extends WebBeansConfigurationListener {
        private final WebBeansContext webBeansContext;

        private CdiListener(WebBeansContext webBeansContext) {
            this.webBeansContext = webBeansContext;
        }

        public void contextInitialized(ServletContextEvent event) {
            ServletContext realSC = event.getServletContext();
            OWBServletExtension.this.setDelegate(realSC);
            Collections.list(OWBServletExtension.this.startEvent.getServletContext().getAttributeNames()).forEach(attr -> realSC.setAttribute(attr, OWBServletExtension.this.startEvent.getServletContext().getAttribute(attr)));
            realSC.setAttribute(BundleContext.class.getName(), (Object)OWBServletExtension.this.bundleContext);
            realSC.setAttribute(WebBeansContext.class.getName(), (Object)this.webBeansContext);
            event.getServletContext().setAttribute(((Object)((Object)this)).getClass().getName(), (Object)true);
            if (this.lifeCycle == null) {
                this.lifeCycle = (ContainerLifecycle)this.webBeansContext.getService(ContainerLifecycle.class);
            }
        }

        public void contextDestroyed(ServletContextEvent sce) {
            try {
                super.contextDestroyed(sce);
            }
            finally {
                OWBServletExtension.this.destroyed.set(true);
            }
        }
    }
}

