/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jax.rs.openapi;

import io.swagger.v3.oas.integration.SwaggerConfiguration;
import io.swagger.v3.oas.integration.api.OpenAPIConfiguration;
import io.swagger.v3.oas.models.OpenAPI;
import org.apache.aries.jax.rs.openapi.OpenApiResource;
import org.apache.aries.jax.rs.openapi.PropertyWrapper;
import org.osgi.framework.Bundle;
import org.osgi.framework.PrototypeServiceFactory;
import org.osgi.framework.ServiceRegistration;

public class OpenApiPrototypeServiceFactory
implements PrototypeServiceFactory<Object> {
    private final PropertyWrapper propertyWrapper;
    private final OpenAPI openAPI;

    public OpenApiPrototypeServiceFactory(PropertyWrapper propertyWrapper, OpenAPI openAPI) {
        this.propertyWrapper = propertyWrapper;
        this.openAPI = openAPI;
    }

    public Object getService(Bundle bundle, ServiceRegistration<Object> serviceRegistration) {
        SwaggerConfiguration swaggerConfiguration = new SwaggerConfiguration().openAPI(this.openAPI);
        this.propertyWrapper.applyLong("cache.ttl", arg_0 -> ((SwaggerConfiguration)swaggerConfiguration).setCacheTTL(arg_0));
        this.propertyWrapper.applyString("id", arg_0 -> ((SwaggerConfiguration)swaggerConfiguration).id(arg_0));
        this.propertyWrapper.applyStringCollection("ignored.routes", arg_0 -> ((SwaggerConfiguration)swaggerConfiguration).setIgnoredRoutes(arg_0));
        this.propertyWrapper.applyBoolean("pretty.print", arg_0 -> ((SwaggerConfiguration)swaggerConfiguration).setPrettyPrint(arg_0));
        this.propertyWrapper.applyBoolean("read.all.resources", arg_0 -> ((SwaggerConfiguration)swaggerConfiguration).setReadAllResources(arg_0));
        OpenApiResource openApiResource = new OpenApiResource();
        openApiResource.setOpenApiConfiguration((OpenAPIConfiguration)swaggerConfiguration);
        return openApiResource;
    }

    public void ungetService(Bundle bundle, ServiceRegistration<Object> serviceRegistration, Object object) {
    }
}

