/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jax.rs.whiteboard.activator;

import java.util.Arrays;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.ext.RuntimeDelegate;
import javax.ws.rs.sse.SseEventSource;
import org.apache.aries.component.dsl.OSGi;
import org.apache.aries.component.dsl.OSGiResult;
import org.apache.aries.jax.rs.whiteboard.internal.Whiteboard;
import org.apache.aries.jax.rs.whiteboard.internal.client.ClientBuilderFactory;
import org.apache.aries.jax.rs.whiteboard.internal.utils.LogUtils;
import org.apache.aries.jax.rs.whiteboard.internal.utils.PropertyHolder;
import org.apache.aries.jax.rs.whiteboard.internal.utils.Utils;
import org.apache.cxf.jaxrs.impl.RuntimeDelegateImpl;
import org.apache.cxf.jaxrs.sse.client.SseEventSourceBuilderImpl;
import org.osgi.annotation.bundle.Header;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.service.http.runtime.HttpServiceRuntime;
import org.osgi.service.jaxrs.client.SseEventSourceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Header(name="Bundle-Activator", value="${@class}")
public class CxfJaxrsBundleActivator
implements BundleActivator {
    private static final Logger _log = LoggerFactory.getLogger(CxfJaxrsBundleActivator.class);
    private OSGiResult _defaultOSGiResult;

    public void start(BundleContext bundleContext) throws Exception {
        RuntimeDelegate.setInstance((RuntimeDelegate)new RuntimeDelegateImpl());
        if (_log.isDebugEnabled()) {
            _log.debug("Starting the whiteboard factory");
        }
        OSGi runWhiteboards = OSGi.all(OSGi.configurations("org.apache.aries.jax.rs.whiteboard"), OSGi.coalesce(OSGi.configuration("org.apache.aries.jax.rs.whiteboard.default"), OSGi.just(() -> {
            Hashtable<String, String> properties = new Hashtable<String, String>();
            ((Dictionary)properties).put("service.pid", "org.apache.aries.jax.rs.whiteboard.default");
            return properties;
        }))).filter(c -> !Objects.equals(c.get("enabled"), "false")).effects(LogUtils.debugTracking(_log, () -> "whiteboard configuration")).flatMap(configuration -> CxfJaxrsBundleActivator.runWhiteboard(bundleContext, configuration));
        this._defaultOSGiResult = OSGi.all(OSGi.ignore(CxfJaxrsBundleActivator.registerClient()), OSGi.ignore(CxfJaxrsBundleActivator.registerSseEventSourceFactory()), OSGi.ignore(runWhiteboards)).run(bundleContext);
        if (_log.isDebugEnabled()) {
            _log.debug("Whiteboard factory started");
        }
    }

    public void stop(BundleContext context) throws Exception {
        if (_log.isDebugEnabled()) {
            _log.debug("Stopping whiteboard factory");
        }
        this._defaultOSGiResult.close();
        if (_log.isDebugEnabled()) {
            _log.debug("Stopped whiteboard factory");
        }
        RuntimeDelegate.setInstance(null);
    }

    private static String endpointFilter(PropertyHolder configuration) {
        Object whiteBoardTargetProperty = configuration.get("osgi.http.whiteboard.target");
        String targetFilter = whiteBoardTargetProperty != null ? whiteBoardTargetProperty.toString() : "(osgi.http.endpoint=*)";
        return String.format("(&(objectClass=%s)%s)", HttpServiceRuntime.class.getName(), targetFilter);
    }

    private static OSGi<?> registerClient() {
        return OSGi.register(ClientBuilder.class, new ClientBuilderFactory(), (Map<String, Object>)null).effects(LogUtils.ifInfoEnabled(_log, () -> "Registered ClientBuilder"), LogUtils.ifInfoEnabled(_log, () -> "Unregistered ClientBuilder"));
    }

    private static OSGi<?> registerSseEventSourceFactory() {
        return OSGi.register(SseEventSourceFactory.class, new SseEventSourceFactory(){

            public SseEventSource.Builder newBuilder(final WebTarget target) {
                return new SseEventSourceBuilderImpl(){
                    {
                        this.target(target);
                    }
                };
            }

            public SseEventSource newSource(WebTarget target) {
                return this.newBuilder(target).build();
            }
        }, new Hashtable<String, Object>()).effects(LogUtils.ifInfoEnabled(_log, () -> "Registered SseEventSourceFactory"), LogUtils.ifInfoEnabled(_log, () -> "Unregistered SseEventSourceFactory"));
    }

    private static OSGi<?> runWhiteboard(BundleContext bundleContext, Dictionary<String, ?> configuration) {
        OSGi<List> endpoints = OSGi.serviceReferences(CxfJaxrsBundleActivator.endpointFilter(configuration::get)).map(r -> Arrays.asList(Utils.canonicalize(r.getProperty("osgi.http.endpoint"))));
        return OSGi.once(OSGi.serviceReferences(CxfJaxrsBundleActivator.endpointFilter(configuration::get), __ -> false).then(OSGi.just(Whiteboard.createWhiteboard(configuration)).effects(LogUtils.ifInfoEnabled(_log, () -> "created whiteboard from configuration: " + configuration), LogUtils.ifInfoEnabled(_log, () -> "destroyed whiteboard from configuration: " + configuration)).flatMap(whiteboard -> {
            OSGi[] oSGiArray = new OSGi[2];
            oSGiArray[0] = OSGi.effects(() -> whiteboard.start(bundleContext), whiteboard::stop);
            oSGiArray[1] = OSGi.ignore(endpoints.effects(whiteboard::addHttpEndpoints, whiteboard::removeHttpEndpoints)).effects(LogUtils.debugTracking(_log, () -> "endpoint for whiteboard: " + whiteboard));
            return OSGi.all(oSGiArray);
        })));
    }

    static {
        RuntimeDelegate.setInstance((RuntimeDelegate)new RuntimeDelegateImpl());
    }
}

