/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jax.rs.whiteboard.internal.cxf;

import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.cxf.jaxrs.JAXRSInvoker;
import org.apache.cxf.jaxrs.impl.AsyncResponseImpl;
import org.apache.cxf.message.Message;
import org.osgi.util.promise.Promise;

public class PromiseAwareJAXRSInvoker
extends JAXRSInvoker {
    private final ConcurrentMap<Class<?>, Boolean> promises = new ConcurrentHashMap();

    @Override
    protected AsyncResponseImpl checkFutureResponse(Message inMessage, Object result) {
        if (inMessage == null || result == null) {
            return null;
        }
        if (result instanceof Promise) {
            return this.handlePromise(inMessage, (Promise)result);
        }
        Class<?> clazz = result.getClass();
        if (this.promises.computeIfAbsent(clazz, type -> Arrays.stream(type.getInterfaces()).map(Class::getName).anyMatch("org.osgi.util.promise.Promise"::equals)).booleanValue()) {
            return this.handlePromiseFromAnotherClassSpace(inMessage, result, clazz);
        }
        return super.checkFutureResponse(inMessage, result);
    }

    private AsyncResponseImpl handlePromise(Message inMessage, Promise<?> promise) {
        AsyncResponseImpl asyncResponse = new AsyncResponseImpl(inMessage);
        promise.onSuccess(asyncResponse::resume).onFailure(asyncResponse::resume);
        return asyncResponse;
    }

    private AsyncResponseImpl handlePromiseFromAnotherClassSpace(Message inMessage, Object result, Class<?> clazz) {
        AsyncResponseImpl asyncResponse = new AsyncResponseImpl(inMessage);
        try {
            clazz.getMethod("onResolve", Runnable.class).invoke(result, () -> {
                try {
                    Object failure = clazz.getMethod("getFailure", new Class[0]).invoke(result, new Object[0]);
                    if (failure != null) {
                        asyncResponse.resume((Throwable)failure);
                    } else {
                        asyncResponse.resume(clazz.getMethod("getValue", new Class[0]).invoke(result, new Object[0]));
                    }
                }
                catch (Exception e) {
                    asyncResponse.resume(e);
                }
            });
        }
        catch (Exception e) {
            asyncResponse.resume(e);
        }
        return asyncResponse;
    }
}

