/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jndi;

import java.util.Arrays;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.directory.Attributes;
import javax.naming.spi.DirObjectFactory;
import javax.naming.spi.ObjectFactory;
import javax.naming.spi.ObjectFactoryBuilder;
import org.apache.aries.jndi.ObjectFactoryHelper;
import org.apache.aries.jndi.Tuple;
import org.apache.aries.jndi.Utils;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirObjectFactoryHelper
extends ObjectFactoryHelper
implements DirObjectFactory {
    public DirObjectFactoryHelper(BundleContext defaultContext, BundleContext callerContext) {
        super(defaultContext, callerContext);
    }

    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment, Attributes attrs) throws Exception {
        Reference ref;
        String className;
        if (obj instanceof Referenceable) {
            obj = ((Referenceable)obj).getReference();
        }
        Object result = obj;
        if (obj instanceof Reference && (className = (ref = (Reference)obj).getFactoryClassName()) != null) {
            result = this.getObjectInstanceUsingClassName(obj, className, obj, name, nameCtx, environment, attrs);
        }
        if (result == null || result == obj) {
            result = this.getObjectInstanceUsingObjectFactoryBuilders(obj, name, nameCtx, environment, attrs);
        }
        if ((result == null || result == obj) && (obj instanceof Reference && ((Reference)obj).getFactoryClassName() == null || !(obj instanceof Reference))) {
            result = this.getObjectInstanceUsingObjectFactories(obj, name, nameCtx, environment, attrs);
        }
        return result == null ? obj : result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getObjectInstanceUsingObjectFactories(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment, Attributes attrs) throws Exception {
        Object result = null;
        ServiceReference[] refs = Utils.getReferencesPrivileged(this.callerContext, DirObjectFactory.class);
        if (refs != null) {
            Arrays.sort(refs, Utils.SERVICE_REFERENCE_COMPARATOR);
            for (ServiceReference ref : refs) {
                DirObjectFactory factory = (DirObjectFactory)Utils.getServicePrivileged(this.callerContext, ref);
                try {
                    result = factory.getObjectInstance(obj, name, nameCtx, environment, attrs);
                }
                finally {
                    this.callerContext.ungetService(ref);
                }
                if (result != null && result != obj) break;
            }
        }
        if (result == null) {
            result = this.getObjectInstanceUsingObjectFactories(obj, name, nameCtx, environment);
        }
        return result == null ? obj : result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getObjectInstanceUsingClassName(Object reference, String className, Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment, Attributes attrs) throws Exception {
        Tuple<ServiceReference, ObjectFactory> tuple = ObjectFactoryHelper.findObjectFactoryByClassName(this.defaultContext, className);
        Object result = null;
        if (tuple.second != null) {
            try {
                result = ((DirObjectFactory)tuple.second).getObjectInstance(reference, name, nameCtx, environment, attrs);
            }
            finally {
                this.defaultContext.ungetService((ServiceReference)tuple.first);
            }
        }
        return result == null ? obj : result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getObjectInstanceUsingObjectFactoryBuilders(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment, Attributes attrs) throws Exception {
        ObjectFactory factory = null;
        ServiceReference[] refs = Utils.getReferencesPrivileged(this.callerContext, ObjectFactoryBuilder.class);
        if (refs != null) {
            Arrays.sort(refs, Utils.SERVICE_REFERENCE_COMPARATOR);
            for (ServiceReference ref : refs) {
                ObjectFactoryBuilder builder = (ObjectFactoryBuilder)Utils.getServicePrivileged(this.callerContext, ref);
                try {
                    factory = builder.createObjectFactory(obj, environment);
                }
                catch (NamingException e) {
                }
                finally {
                    this.callerContext.ungetService(ref);
                }
                if (factory != null) break;
            }
        }
        Object result = null;
        if (factory != null) {
            result = factory instanceof DirObjectFactory ? ((DirObjectFactory)factory).getObjectInstance(obj, name, nameCtx, environment, attrs) : factory.getObjectInstance(obj, name, nameCtx, environment);
        }
        return result == null ? obj : result;
    }
}

