/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jndi;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;
import javax.naming.spi.ObjectFactoryBuilder;
import org.apache.aries.jndi.ContextHelper;
import org.apache.aries.jndi.Tuple;
import org.apache.aries.jndi.Utils;
import org.apache.aries.util.service.registry.ServicePair;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectFactoryHelper
implements ObjectFactory {
    protected BundleContext defaultContext;
    protected BundleContext callerContext;

    public ObjectFactoryHelper(BundleContext defaultContext, BundleContext callerContext) {
        this.defaultContext = defaultContext;
        this.callerContext = callerContext;
    }

    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        if (obj instanceof Referenceable) {
            obj = ((Referenceable)obj).getReference();
        }
        Object result = obj;
        if (obj instanceof Reference) {
            Reference ref = (Reference)obj;
            String className = ref.getFactoryClassName();
            result = className != null ? this.getObjectInstanceUsingClassName(obj, className, obj, name, nameCtx, environment) : this.getObjectInstanceUsingRefAddress(ref.getAll(), obj, name, nameCtx, environment);
        }
        if (result == null || result == obj) {
            result = this.getObjectInstanceUsingObjectFactoryBuilders(obj, name, nameCtx, environment);
        }
        if ((result == null || result == obj) && (obj instanceof Reference && ((Reference)obj).getFactoryClassName() == null || !(obj instanceof Reference))) {
            result = this.getObjectInstanceUsingObjectFactories(obj, name, nameCtx, environment);
        }
        return result == null ? obj : result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getObjectInstanceUsingObjectFactories(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        Object result = null;
        ServiceReference[] refs = Utils.getReferencesPrivileged(this.callerContext, ObjectFactory.class);
        if (refs != null) {
            Arrays.sort(refs, Utils.SERVICE_REFERENCE_COMPARATOR);
            for (ServiceReference ref : refs) {
                ObjectFactory factory = (ObjectFactory)Utils.getServicePrivileged(this.callerContext, ref);
                try {
                    result = factory.getObjectInstance(obj, name, nameCtx, environment);
                }
                catch (NamingException ne) {
                }
                finally {
                    this.callerContext.ungetService(ref);
                }
                if (result != null && result != obj) break;
            }
        }
        return result == null ? obj : result;
    }

    protected static String getUrlScheme(String name) {
        String scheme = name;
        int index = name.indexOf(58);
        if (index != -1) {
            scheme = name.substring(0, index);
        }
        return scheme;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getObjectInstanceUsingRefAddress(Enumeration<RefAddr> addresses, Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        Object result = null;
        while (addresses.hasMoreElements()) {
            String urlScheme;
            ServicePair<ObjectFactory> factoryService;
            RefAddr address = addresses.nextElement();
            if (!(address instanceof StringRefAddr) || !"URL".equals(address.getType()) || (factoryService = ContextHelper.getURLObjectFactory(this.callerContext, urlScheme = ObjectFactoryHelper.getUrlScheme((String)address.getContent()), environment)) == null) continue;
            ObjectFactory factory = (ObjectFactory)factoryService.get();
            String value = (String)address.getContent();
            try {
                result = factory.getObjectInstance(value, name, nameCtx, environment);
            }
            finally {
                factoryService.unget();
            }
            if (result == null || result == obj) continue;
            break;
        }
        return result == null ? obj : result;
    }

    static Tuple<ServiceReference, ObjectFactory> findObjectFactoryByClassName(final BundleContext ctx, final String className) {
        return AccessController.doPrivileged(new PrivilegedAction<Tuple<ServiceReference, ObjectFactory>>(){

            @Override
            public Tuple<ServiceReference, ObjectFactory> run() {
                ServiceReference serviceReference = null;
                try {
                    ServiceReference[] refs = ctx.getServiceReferences(className, null);
                    if (refs != null && refs.length > 0) {
                        serviceReference = refs[0];
                    }
                }
                catch (InvalidSyntaxException e) {
                    throw new RuntimeException(Utils.MESSAGES.getMessage("null.is.invalid.filter", new Object[0]), e);
                }
                ObjectFactory factory = null;
                if (serviceReference != null) {
                    factory = (ObjectFactory)ctx.getService(serviceReference);
                }
                return new Tuple<ServiceReference, Object>(serviceReference, factory);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getObjectInstanceUsingClassName(Object reference, String className, Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        Tuple<ServiceReference, ObjectFactory> tuple = ObjectFactoryHelper.findObjectFactoryByClassName(this.defaultContext, className);
        Object result = null;
        if (tuple.second != null) {
            try {
                result = ((ObjectFactory)tuple.second).getObjectInstance(reference, name, nameCtx, environment);
            }
            finally {
                this.defaultContext.ungetService((ServiceReference)tuple.first);
            }
        }
        return result == null ? obj : result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getObjectInstanceUsingObjectFactoryBuilders(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        ObjectFactory factory = null;
        ServiceReference[] refs = Utils.getReferencesPrivileged(this.callerContext, ObjectFactoryBuilder.class);
        if (refs != null) {
            Arrays.sort(refs, Utils.SERVICE_REFERENCE_COMPARATOR);
            for (ServiceReference ref : refs) {
                ObjectFactoryBuilder builder = (ObjectFactoryBuilder)Utils.getServicePrivileged(this.callerContext, ref);
                try {
                    factory = builder.createObjectFactory(obj, environment);
                }
                catch (NamingException e) {
                }
                finally {
                    this.callerContext.ungetService(ref);
                }
                if (factory != null) break;
            }
        }
        Object result = null;
        if (factory != null) {
            result = factory.getObjectInstance(obj, name, nameCtx, environment);
        }
        return result == null ? obj : result;
    }
}

