/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jndi.startup;

import java.lang.reflect.Field;
import java.util.Arrays;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;
import javax.naming.spi.InitialContextFactoryBuilder;
import javax.naming.spi.NamingManager;
import javax.naming.spi.ObjectFactory;
import javax.naming.spi.ObjectFactoryBuilder;
import org.apache.aries.jndi.ContextManagerServiceFactory;
import org.apache.aries.jndi.JREInitialContextFactoryBuilder;
import org.apache.aries.jndi.OSGiInitialContextFactoryBuilder;
import org.apache.aries.jndi.OSGiObjectFactoryBuilder;
import org.apache.aries.jndi.ProviderAdminServiceFactory;
import org.apache.aries.jndi.Utils;
import org.apache.aries.jndi.spi.EnvironmentAugmentation;
import org.apache.aries.jndi.tracker.ServiceTrackerCustomizers;
import org.apache.aries.jndi.urls.URLObjectFactoryFinder;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.jndi.JNDIContextManager;
import org.osgi.service.jndi.JNDIProviderAdmin;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Activator
implements BundleActivator {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)Activator.class.getName());
    private OSGiInitialContextFactoryBuilder icfBuilder;
    private OSGiObjectFactoryBuilder ofBuilder;
    private static ServiceTracker icfBuilders;
    private static ServiceTracker urlObjectFactoryFinders;
    private static ServiceTracker initialContextFactories;
    private static ServiceTracker objectFactories;
    private static ServiceTracker environmentAugmentors;

    public void start(BundleContext context) {
        Object builder;
        initialContextFactories = this.initServiceTracker(context, InitialContextFactory.class, ServiceTrackerCustomizers.ICF_CACHE);
        objectFactories = this.initServiceTracker(context, ObjectFactory.class, ServiceTrackerCustomizers.URL_FACTORY_CACHE);
        icfBuilders = this.initServiceTracker(context, InitialContextFactoryBuilder.class, ServiceTrackerCustomizers.LAZY);
        urlObjectFactoryFinders = this.initServiceTracker(context, URLObjectFactoryFinder.class, ServiceTrackerCustomizers.LAZY);
        environmentAugmentors = this.initServiceTracker(context, EnvironmentAugmentation.class, null);
        try {
            builder = new OSGiInitialContextFactoryBuilder();
            NamingManager.setInitialContextFactoryBuilder((InitialContextFactoryBuilder)builder);
            this.icfBuilder = builder;
        }
        catch (NamingException e) {
            LOGGER.info(Utils.MESSAGES.getMessage("unable.to.set.static.ICFB", new Object[0]), (Throwable)e);
        }
        catch (IllegalStateException e) {
            LOGGER.info(Utils.MESSAGES.getMessage("unable.to.set.static.ICFB.already.exists", new Object[]{this.getClassName(InitialContextFactoryBuilder.class)}), (Throwable)e);
        }
        try {
            builder = new OSGiObjectFactoryBuilder(context);
            NamingManager.setObjectFactoryBuilder((ObjectFactoryBuilder)builder);
            this.ofBuilder = builder;
        }
        catch (NamingException e) {
            LOGGER.info(Utils.MESSAGES.getMessage("unable.to.set.static.OFB", new Object[0]), (Throwable)e);
        }
        catch (IllegalStateException e) {
            LOGGER.info(Utils.MESSAGES.getMessage("unable.to.set.static.OFB.already.exists", new Object[]{this.getClassName(InitialContextFactoryBuilder.class)}), (Throwable)e);
        }
        context.registerService(JNDIProviderAdmin.class.getName(), (Object)new ProviderAdminServiceFactory(context), null);
        context.registerService(InitialContextFactoryBuilder.class.getName(), (Object)new JREInitialContextFactoryBuilder(), null);
        context.registerService(JNDIContextManager.class.getName(), (Object)new ContextManagerServiceFactory(), null);
    }

    private String getClassName(Class<?> expectedType) {
        try {
            for (Field field : NamingManager.class.getDeclaredFields()) {
                if (!expectedType.equals(field.getType())) continue;
                field.setAccessible(true);
                Object icf = field.get(null);
                return icf.getClass().getName();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return "";
    }

    private ServiceTracker initServiceTracker(BundleContext context, Class<?> type, ServiceTrackerCustomizer custom) {
        ServiceTracker t = new ServiceTracker(context, type.getName(), custom);
        t.open();
        return t;
    }

    public void stop(BundleContext context) {
        if (this.icfBuilder != null) {
            Activator.unsetField(InitialContextFactoryBuilder.class);
        }
        if (this.ofBuilder != null) {
            Activator.unsetField(ObjectFactoryBuilder.class);
        }
        icfBuilders.close();
        urlObjectFactoryFinders.close();
        objectFactories.close();
        initialContextFactories.close();
        environmentAugmentors.close();
    }

    private static void unsetField(Class<?> expectedType) {
        try {
            for (Field field : NamingManager.class.getDeclaredFields()) {
                if (!expectedType.equals(field.getType())) continue;
                field.setAccessible(true);
                field.set(null, null);
            }
        }
        catch (Throwable t) {
            LOGGER.debug("Error setting field.", t);
        }
    }

    public static ServiceReference[] getInitialContextFactoryBuilderServices() {
        ServiceReference[] refs = icfBuilders.getServiceReferences();
        if (refs != null) {
            Arrays.sort(refs, Utils.SERVICE_REFERENCE_COMPARATOR);
        }
        return refs;
    }

    public static ServiceReference[] getInitialContextFactoryServices() {
        ServiceReference[] refs = initialContextFactories.getServiceReferences();
        if (refs != null) {
            Arrays.sort(refs, Utils.SERVICE_REFERENCE_COMPARATOR);
        }
        return refs;
    }

    public static ServiceReference[] getURLObectFactoryFinderServices() {
        ServiceReference[] refs = urlObjectFactoryFinders.getServiceReferences();
        if (refs != null) {
            Arrays.sort(refs, Utils.SERVICE_REFERENCE_COMPARATOR);
        }
        return refs;
    }

    public static Object[] getEnvironmentAugmentors() {
        return environmentAugmentors.getServices();
    }
}

