/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jndi;

import java.security.PrivilegedExceptionAction;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.NoInitialContextException;
import javax.naming.spi.InitialContextFactory;
import javax.naming.spi.InitialContextFactoryBuilder;
import javax.naming.spi.ObjectFactory;
import org.apache.aries.jndi.ContextProvider;
import org.apache.aries.jndi.DelegateContext;
import org.apache.aries.jndi.ServicePair;
import org.apache.aries.jndi.SingleContextProvider;
import org.apache.aries.jndi.URLContextProvider;
import org.apache.aries.jndi.Utils;
import org.apache.aries.jndi.startup.Activator;
import org.apache.aries.jndi.tracker.ServiceTrackerCustomizers;
import org.apache.aries.jndi.urls.URLObjectFactoryFinder;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ContextHelper {
    private ContextHelper() {
        throw new RuntimeException();
    }

    public static ContextProvider createURLContext(final BundleContext context, final String urlScheme, final Hashtable<?, ?> env) throws NamingException {
        return Utils.doPrivilegedNaming(new PrivilegedExceptionAction<ContextProvider>(){

            @Override
            public ContextProvider run() throws Exception {
                return ContextHelper.doCreateURLContext(context, urlScheme, env);
            }
        });
    }

    private static ContextProvider doCreateURLContext(BundleContext context, String urlScheme, Hashtable<?, ?> env) throws NamingException {
        ObjectFactory factory;
        ServicePair<ObjectFactory> urlObjectFactory = ContextHelper.getURLObjectFactory(context, urlScheme, env);
        if (urlObjectFactory != null && (factory = urlObjectFactory.get()) != null) {
            return new URLContextProvider(context, urlObjectFactory.getReference(), factory, env);
        }
        return null;
    }

    public static final ServicePair<ObjectFactory> getURLObjectFactory(BundleContext ctx, String urlScheme, Hashtable<?, ?> environment) throws NamingException {
        ServicePair<ObjectFactory> result = null;
        ServiceReference ref = ServiceTrackerCustomizers.URL_FACTORY_CACHE.find(urlScheme);
        if (ref == null) {
            ServiceReference[] refs = Activator.getURLObectFactoryFinderServices();
            if (refs != null) {
                for (ServiceReference finderRef : refs) {
                    URLObjectFactoryFinder finder = (URLObjectFactoryFinder)ctx.getService(finderRef);
                    if (finder == null) continue;
                    ObjectFactory f = finder.findFactory(urlScheme, environment);
                    if (f != null) {
                        result = new ServicePair<ObjectFactory>(ctx, finderRef, f);
                        break;
                    }
                    ctx.ungetService(finderRef);
                }
            }
        } else {
            result = new ServicePair<ObjectFactory>(ctx, ref);
        }
        return result;
    }

    public static Context getInitialContext(BundleContext context, Hashtable<?, ?> environment) throws NamingException {
        ContextProvider provider = ContextHelper.getContextProvider(context, environment);
        if (provider != null) {
            return new DelegateContext(context, provider);
        }
        String contextFactoryClass = (String)environment.get("java.naming.factory.initial");
        if (contextFactoryClass == null) {
            return new DelegateContext(context, environment);
        }
        throw new NoInitialContextException("We could not find a provider for the InitialContextFactory " + contextFactoryClass);
    }

    public static ContextProvider getContextProvider(final BundleContext context, final Hashtable<?, ?> environment) throws NamingException {
        return Utils.doPrivilegedNaming(new PrivilegedExceptionAction<ContextProvider>(){

            @Override
            public ContextProvider run() throws Exception {
                return ContextHelper.doGetContextProvider(context, environment);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ContextProvider doGetContextProvider(BundleContext context, Hashtable<?, ?> environment) throws NamingException {
        ContextProvider provider = null;
        String contextFactoryClass = (String)environment.get("java.naming.factory.initial");
        if (contextFactoryClass == null) {
            ServiceReference[] references;
            provider = ContextHelper.getInitialContextUsingBuilder(context, environment);
            if (provider == null && (references = Activator.getInitialContextFactoryServices()) != null) {
                Context initialContext = null;
                for (ServiceReference reference : references) {
                    InitialContextFactory factory = (InitialContextFactory)context.getService(reference);
                    try {
                        initialContext = factory.getInitialContext(environment);
                        if (initialContext == null) continue;
                        provider = new SingleContextProvider(context, reference, initialContext);
                        break;
                    }
                    finally {
                        if (provider == null) {
                            context.ungetService(reference);
                        }
                    }
                }
            }
        } else {
            ServiceReference ref = ServiceTrackerCustomizers.ICF_CACHE.find(contextFactoryClass);
            if (ref != null) {
                Context initialContext = null;
                InitialContextFactory factory = (InitialContextFactory)context.getService(ref);
                if (factory != null) {
                    try {
                        initialContext = factory.getInitialContext(environment);
                        provider = new SingleContextProvider(context, ref, initialContext);
                    }
                    finally {
                        if (provider == null) {
                            context.ungetService(ref);
                        }
                    }
                }
            }
            if (provider == null) {
                provider = ContextHelper.getInitialContextUsingBuilder(context, environment);
            }
        }
        return provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ContextProvider getInitialContextUsingBuilder(BundleContext context, Hashtable<?, ?> environment) throws NamingException {
        SingleContextProvider provider = null;
        ServiceReference[] refs = Activator.getInitialContextFactoryBuilderServices();
        if (refs != null) {
            InitialContextFactory factory = null;
            for (ServiceReference ref : refs) {
                InitialContextFactoryBuilder builder = (InitialContextFactoryBuilder)context.getService(ref);
                try {
                    factory = builder.createInitialContextFactory(environment);
                }
                catch (NamingException ne) {
                    // empty catch block
                }
                if (factory != null) {
                    try {
                        provider = new SingleContextProvider(context, ref, factory.getInitialContext(environment));
                        break;
                    }
                    finally {
                        if (provider == null) {
                            context.ungetService(ref);
                        }
                    }
                }
                context.ungetService(ref);
            }
        }
        return provider;
    }
}

